/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sm.srm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplierPurchaseInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.scm.common.client.BDInvClientUtils;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.sm.srm.ISupplyInfo;
import com.kingdee.eas.basedata.scm.sm.srm.IsUseableEnum;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoFactory;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoInfo;
import com.kingdee.eas.basedata.scm.sm.srm.client.AbstractSupplyInfoEditUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.constants.QueryInfoConstants;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class SupplyInfoEditUI
extends AbstractSupplyInfoEditUI {
    SupplierInfo initSupplierInfo = null;
    PurchaseOrgUnitInfo initPurOrgUnitInfo = null;
    private DataChangeListener prmtPurchaseOrgUnitListener;
    private DataChangeListener prmtSupplierListener;
    private DataChangeListener prmtMaterialItemListener;
    private DataChangeListener txtPriceListener;
    private DataChangeListener txtDisCountListener;
    private DataChangeListener txtEffDateListener;
    private DataChangeListener pkUneffectualDateListener;
    private DataChangeListener prmtPurMeasureUnitListener;
    private ChangeListener cbQuantityUnCtrlListener;
    private ChangeListener cbTimeUnCtrlListener;
    private ItemListener cbIsTaxListener;
    private final BigDecimal ZERO = new BigDecimal("0.00");
    private final BigDecimal Hundrud = new BigDecimal("100.00");
    private int initChoice = 0;
    private int f7DisplayMode = 0;
    private int discountRatePrecision = 4;
    private static final Logger logger = CoreUIObject.getLogger(SupplyInfoEditUI.class);

    protected void prmtMaterialItem_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtMaterialItem.getValue() == null) {
            this.txtMateriaName.setText(null);
            this.txtMateiralRule.setText(null);
            this.prmtMeasureUnit.setData(null);
            this.prmtPurMeasureUnit.setData(null);
            this.txtPrice.setPrecision(2);
            return;
        }
        if (this.prmtPurchaseOrg.getData() == null) {
            this.prmtPurchaseOrg.requestFocus();
            MsgBox.showInfo((String)this.getResource("Msg_Need_PurOrgUnit"));
            this.prmtMaterialItem.setData(null);
            SysUtil.abort();
        }
        ObjectUuidPK iObjectPk = new ObjectUuidPK(((MaterialInfo)this.prmtMaterialItem.getValue()).getId());
        IMaterial iMaterial = MaterialFactory.getRemoteInstance();
        if (MaterialPurchasingFactory.getRemoteInstance().getPurchasingInfo(((MaterialInfo)this.prmtMaterialItem.getValue()).getId().toString(), ((PurchaseOrgUnitInfo)this.prmtPurchaseOrg.getValue()).getId().toString()) == null) {
            this.prmtMaterialItem.setData(null);
            this.prmtMaterialItem.requestFocus();
            MsgBox.showInfo((String)this.getResource("Msg_Need_Request_Material"));
            SysUtil.abort();
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("baseUnit.*"));
        MaterialInfo materialInfo = iMaterial.getMaterialInfo((IObjectPK)iObjectPk, sic);
        if (materialInfo != null) {
            this.txtMateriaName.setText(materialInfo.getName());
            this.txtMateiralRule.setText(materialInfo.getModel());
            this.txtPrice.setPrecision(materialInfo.getPricePrecision());
            if (materialInfo.getBaseUnit() != null) {
                this.prmtMeasureUnit.setValue((Object)materialInfo.getBaseUnit());
            }
            if (this.prmtPurchaseOrg.getValue() != null) {
                String materialpk = ((MaterialInfo)this.prmtMaterialItem.getValue()).getId().toString();
                String purchaseOrgpk = ((PurchaseOrgUnitInfo)this.prmtPurchaseOrg.getValue()).getId().toString();
                MaterialPurchasingInfo mpInfo = MaterialPurchasingFactory.getRemoteInstance().getPurchasingInfo(materialpk, purchaseOrgpk);
                if (mpInfo != null) {
                    this.prmtPurMeasureUnit.setValue((Object)mpInfo.getUnit());
                    this.txtPrice.setValue((Object)mpInfo.getPrice());
                    try {
                        this.pkDayBottom.setValue((Object)new Integer(mpInfo.getDaysDelay()));
                        this.pkDayTop.setValue((Object)new Integer(mpInfo.getDaydAhead()));
                        this.txtQtySupplyBottom.setValue((Object)new Integer(mpInfo.getReceiveBottomRatio()));
                        this.txtQtySupplyTop.setValue((Object)new Integer(mpInfo.getReceiveTopRatio()));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    this.prmtPurMeasureUnit.setValue(null);
                    this.txtPrice.setValue(null);
                }
            }
            this.prmtPurMeasureUnit.setEnabled(true);
            this.setF7MeasureUnit(this.prmtPurMeasureUnit, materialInfo.getId().toString());
        }
    }

    private void setF7MeasureUnit(KDBizPromptBox bizBox, String matid) {
        if (matid != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)matid, CompareType.EQUALS));
            filterInfo.setMaskString("#0");
            viewInfo.setFilter(filterInfo);
            bizBox.setHasCUDefaultFilter(false);
            bizBox.setEntityViewInfo(viewInfo);
        }
    }

    private void setF7MeasureUnit() {
        if (this.prmtMaterialItem.getData() != null) {
            MaterialInfo mInfo = (MaterialInfo)this.prmtMaterialItem.getData();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)mInfo.getId(), CompareType.EQUALS));
            filterInfo.setMaskString("#0");
            viewInfo.setFilter(filterInfo);
            this.prmtPurMeasureUnit.setHasCUDefaultFilter(false);
            this.prmtPurMeasureUnit.setEntityViewInfo(viewInfo);
        }
    }

    public SupplyInfoEditUI() throws Exception {
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.pkEffectualDate.setRequired(true);
        this.pkUneffectualDate.setRequired(true);
    }

    @Override
    public void loadFields() {
        if (this.prmtPurchaseOrgUnitListener != null) {
            this.prmtPurchaseOrg.removeDataChangeListener(this.prmtPurchaseOrgUnitListener);
        }
        if (this.prmtSupplierListener != null) {
            this.prmtSupplier.removeDataChangeListener(this.prmtSupplierListener);
        }
        if (this.prmtMaterialItemListener != null) {
            this.prmtMaterialItem.removeDataChangeListener(this.prmtMaterialItemListener);
        }
        if (this.txtPriceListener != null) {
            this.txtPrice.removeDataChangeListener(this.txtPriceListener);
        }
        if (this.txtEffDateListener != null) {
            this.pkEffectualDate.removeDataChangeListener(this.txtEffDateListener);
        }
        if (this.prmtPurMeasureUnitListener != null) {
            this.prmtPurMeasureUnit.removeDataChangeListener(this.prmtPurMeasureUnitListener);
        }
        if (this.cbQuantityUnCtrlListener != null) {
            this.cbQuantityUnCtrl.removeChangeListener(this.cbQuantityUnCtrlListener);
        }
        if (this.cbTimeUnCtrlListener != null) {
            this.cbTimeUnCtrl.removeChangeListener(this.cbTimeUnCtrlListener);
        }
        if (this.cbIsTaxListener != null) {
            this.cbIsTaxPrice.removeItemListener(this.cbIsTaxListener);
        }
        this.InitUIContext();
        super.loadFields();
        this.setF7MeasureUnit();
        this.initCtontrolListener();
        this.initControls();
        String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        if (this.getMainOrgInfo() != null) {
            cuid = this.getMainOrgInfo().getId().toString();
        }
        this.discountRatePrecision = SCMBaseCommonUtil.getDiscountRatePrecision(cuid);
        try {
            this.initPrecision();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.initOldData((IObjectValue)this.editData);
    }

    private void initPrecision() throws Exception {
        if (this.prmtMaterialItem.getData() != null) {
            IMultiMeasureUnit immu;
            MultiMeasureUnitInfo mmuInfo;
            IMaterial iMaterial = MaterialFactory.getRemoteInstance();
            MaterialInfo mInfo = (MaterialInfo)this.prmtMaterialItem.getData();
            this.txtPrice.setPrecision(mInfo.getPricePrecision());
            if (mInfo != null && this.prmtPurchaseOrg.getData() != null && this.prmtPurMeasureUnit.getData() != null && (mmuInfo = (immu = MultiMeasureUnitFactory.getRemoteInstance()).getMultiUnit(mInfo.getId().toString(), ((MeasureUnitInfo)this.prmtPurMeasureUnit.getData()).getId().toString())) != null) {
                this.txtQtyOrderBottom.setPrecision(mmuInfo.getQtyPrecision());
                this.txtQtyOrderTop.setPrecision(mmuInfo.getQtyPrecision());
            }
        } else {
            this.txtPrice.setPrecision(2);
            this.txtQtyOrderBottom.setPrecision(2);
            this.txtQtyOrderTop.setPrecision(2);
        }
        this.txtDiscountRate.setPrecision(this.discountRatePrecision);
        this.txtDiscountRate.setNegatived(false);
        this.txtTaxRate.setPrecision(2);
        this.txtTaxRate.setNegatived(false);
        this.txtPrice.setRemoveingZeroInDispaly(false);
        this.txtPrice.setRemoveingZeroInEdit(false);
        this.txtDiscountRate.setRemoveingZeroInDispaly(false);
        this.txtDiscountRate.setRemoveingZeroInEdit(false);
        this.txtQtyOrderBottom.setRemoveingZeroInDispaly(false);
        this.txtQtyOrderBottom.setRemoveingZeroInEdit(false);
        this.txtQtyOrderTop.setRemoveingZeroInDispaly(false);
        this.txtQtyOrderTop.setRemoveingZeroInEdit(false);
    }

    private void initCtontrolListener() {
        if (this.oprtState.equalsIgnoreCase("ADDNEW") && !(this.prmtMaterialItem.getData() instanceof MaterialInfo)) {
            this.prmtPurMeasureUnit.setEnabled(false);
        } else {
            this.prmtPurMeasureUnit.setEnabled(true);
        }
        this.prmtPurchaseOrgUnitListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    SupplyInfoEditUI.this.prmtPurchaseOrg_dataChanged(e);
                }
                catch (Exception exc) {
                    SupplyInfoEditUI.this.handUIException(exc);
                }
            }
        };
        this.prmtPurchaseOrg.addDataChangeListener(this.prmtPurchaseOrgUnitListener);
        this.prmtSupplierListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    SupplyInfoEditUI.this.prmtSupplier_dataChanged(e);
                }
                catch (Exception exc) {
                    SupplyInfoEditUI.this.handUIException(exc);
                }
            }
        };
        this.prmtSupplier.addDataChangeListener(this.prmtSupplierListener);
        this.prmtMaterialItemListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    SupplyInfoEditUI.this.prmtMaterialItem_dataChanged(e);
                }
                catch (Exception exc) {
                    SupplyInfoEditUI.this.handUIException(exc);
                }
            }
        };
        this.prmtMaterialItem.addDataChangeListener(this.prmtMaterialItemListener);
        this.txtPriceListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    SupplyInfoEditUI.this.txtPrice_dataChanged(e);
                }
                catch (Exception exc) {
                    SupplyInfoEditUI.this.handUIException(exc);
                }
            }
        };
        this.txtPrice.addDataChangeListener(this.txtPriceListener);
        this.txtDisCountListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    SupplyInfoEditUI.this.txtDisCountRate_dataChanged(e);
                }
                catch (Exception exc) {
                    SupplyInfoEditUI.this.handUIException(exc);
                }
            }
        };
        this.txtDiscountRate.addDataChangeListener(this.txtDisCountListener);
        this.pkUneffectualDate.addDataChangeListener(this.pkUneffectualDateListener);
        this.prmtPurMeasureUnitListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    SupplyInfoEditUI.this.prmtPurMeasureUnit_dataChanged(e);
                }
                catch (Exception exc) {
                    SupplyInfoEditUI.this.handUIException(exc);
                }
            }
        };
        this.prmtPurMeasureUnit.addDataChangeListener(this.prmtPurMeasureUnitListener);
        this.cbQuantityUnCtrlListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    SupplyInfoEditUI.this.cbQtyUnCtrl_dataChanged(e);
                }
                catch (Exception exc) {
                    SupplyInfoEditUI.this.handUIException(exc);
                }
            }
        };
        this.cbQuantityUnCtrl.addChangeListener(this.cbQuantityUnCtrlListener);
        this.cbTimeUnCtrlListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    SupplyInfoEditUI.this.cbTimeUnCtrl_dataChanged(e);
                }
                catch (Exception exc) {
                    SupplyInfoEditUI.this.handUIException(exc);
                }
            }
        };
        this.cbTimeUnCtrl.addChangeListener(this.cbTimeUnCtrlListener);
        this.cbIsTaxListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    SupplyInfoEditUI.this.cbIsTaxPrice_dataChanged(e);
                }
                catch (Exception exc) {
                    SupplyInfoEditUI.this.handUIException(exc);
                }
            }
        };
        this.cbIsTaxPrice.addItemListener(this.cbIsTaxListener);
    }

    protected void cbIsTaxPrice_dataChanged(ItemEvent e) throws Exception {
        this.txtPrice_dataChanged(null);
    }

    protected void cbQtyUnCtrl_dataChanged(ChangeEvent e) {
        if (this.cbQuantityUnCtrl.isSelected()) {
            this.txtQtySupplyTop.setValue(null);
            this.txtQtySupplyTop.setEnabled(false);
            this.txtQtySupplyBottom.setValue(null);
            this.txtQtySupplyBottom.setEnabled(false);
        } else {
            this.txtQtySupplyTop.setEnabled(true);
            this.txtQtySupplyBottom.setEnabled(true);
        }
    }

    protected void cbTimeUnCtrl_dataChanged(ChangeEvent e) {
        if (this.cbTimeUnCtrl.isSelected()) {
            this.pkDayTop.setValue(null);
            this.pkDayTop.setEnabled(false);
            this.pkDayBottom.setValue(null);
            this.pkDayBottom.setEnabled(false);
        } else {
            this.pkDayTop.setEnabled(true);
            this.pkDayBottom.setEnabled(true);
        }
    }

    protected void prmtPurMeasureUnit_dataChanged(DataChangeEvent e) throws Exception {
        MaterialInfo materialInfo = (MaterialInfo)this.prmtMaterialItem.getData();
        MeasureUnitInfo unitInfo = (MeasureUnitInfo)this.prmtPurMeasureUnit.getData();
        if (materialInfo != null) {
            IMultiMeasureUnit immu = MultiMeasureUnitFactory.getRemoteInstance();
            MultiMeasureUnitInfo mmuInfo = immu.getMultiUnit(materialInfo.getId().toString(), unitInfo.getId().toString());
            if (mmuInfo != null) {
                this.txtQtyOrderBottom.setPrecision(mmuInfo.getQtyPrecision());
                this.txtQtyOrderTop.setPrecision(mmuInfo.getQtyPrecision());
            } else {
                this.txtQtyOrderBottom.setPrecision(unitInfo.getQtyPrecision());
                this.txtQtyOrderTop.setPrecision(unitInfo.getQtyPrecision());
            }
        } else if (unitInfo != null) {
            this.txtQtyOrderBottom.setPrecision(unitInfo.getQtyPrecision());
            this.txtQtyOrderTop.setPrecision(unitInfo.getQtyPrecision());
        } else {
            this.txtQtyOrderBottom.setPrecision(2);
            this.txtQtyOrderTop.setPrecision(2);
        }
    }

    protected void EffDate_dataChanged(DataChangeEvent e) throws Exception {
        Calendar calendar = Calendar.getInstance();
        if (this.pkEffectualDate.getValue() != null) {
            calendar.setTime((Date)this.pkEffectualDate.getValue());
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
            Timestamp t = new Timestamp(calendar.getTimeInMillis());
            if (t.before(new Date(System.currentTimeMillis()))) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getResource("check_effectDate"));
            }
        }
    }

    protected void pkUneffectualDate_dataChanged(DataChangeEvent e) throws Exception {
        Calendar calendar = Calendar.getInstance();
        if (this.pkUneffectualDate.getValue() != null) {
            calendar.setTime((Date)this.pkUneffectualDate.getValue());
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
            Timestamp t = new Timestamp(calendar.getTimeInMillis());
            if (((Date)this.pkEffectualDate.getValue()).after(t)) {
                this.pkUneffectualDate.requestFocus();
                MsgBox.showInfo((String)this.getResource("Msg_EffectualDateNotGreat"));
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected IObjectValue createNewData() {
        SupplyInfoInfo dataObjectNew = new SupplyInfoInfo();
        dataObjectNew.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        if (this.getDefaultMainBizOrg() instanceof PurchaseOrgUnitInfo && ((PurchaseOrgUnitInfo)this.getDefaultMainBizOrg()).isIsBizUnit()) {
            dataObjectNew.setPurchaseOrg((PurchaseOrgUnitInfo)this.getDefaultMainBizOrg());
        } else {
            dataObjectNew.setPurchaseOrg(null);
        }
        dataObjectNew.setPrice(new BigDecimal("0.00"));
        dataObjectNew.setIsTaxPrice(true);
        dataObjectNew.setIsBatchTemp(false);
        dataObjectNew.setEffectualDate(new Timestamp(System.currentTimeMillis()));
        dataObjectNew.setUneffectualDate(this.getBigTime());
        try {
            dataObjectNew.setCreateTime(SCMClientUtils.getServerDate());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return dataObjectNew;
    }

    private Timestamp getBigTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2199, 11, 31, 0, 0, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return SupplyInfoFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    private void InitUIContext() {
        this.initSupplierInfo = (SupplierInfo)this.getUIContext().get("supplierTree");
        if (this.initSupplierInfo != null) {
            this.prmtSupplier.setData((Object)this.initSupplierInfo);
        }
    }

    public void onLoad() throws Exception {
        this.f7DisplayMode = SCMGroupClientUtils.getF7DisplayMode((String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        this.initNeedMainOrgF7s();
        SysContext.getSysContext().setCurrentOrgUnit(this.getMainBizOrgType(), this.getDefaultMainBizOrg());
        super.onLoad();
        this.pkUneffectualDate.isSupportedEmpty();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.kDMenuItem1.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.kDMenuItem2.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.txtQtySupplyTop.setPrecision(4);
        this.txtQtySupplyBottom.setPrecision(4);
        this.initNumberCtrl();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        if (this.getMainBizOrg() != null) {
            this.setMainBizOrgF7(this.getMainBizOrg(), this.getMainBizOrgType());
        }
    }

    private void initNumberCtrl() {
        this.txtPrice.setHorizontalAlignment(4);
        this.txtLastPrice.setHorizontalAlignment(4);
        this.txtMaxPrice.setHorizontalAlignment(4);
        this.txtMinPrice.setHorizontalAlignment(4);
        this.txtQtyOrderBottom.setHorizontalAlignment(4);
        this.txtQtyOrderTop.setHorizontalAlignment(4);
        this.txtQtySupplyTop.setHorizontalAlignment(4);
        this.txtQtySupplyBottom.setHorizontalAlignment(4);
        this.pkDayTop.setHorizontalAlignment(4);
        this.pkDayBottom.setHorizontalAlignment(4);
        this.txtLeadtime.setHorizontalAlignment(4);
        this.txtDiscountRate.setHorizontalAlignment(4);
        this.txtPrice.setSupportedEmpty(true);
        this.txtLastPrice.setSupportedEmpty(true);
        this.txtMaxPrice.setSupportedEmpty(true);
        this.txtMinPrice.setSupportedEmpty(true);
        this.txtQtyOrderBottom.setSupportedEmpty(true);
        this.txtQtyOrderTop.setSupportedEmpty(true);
        this.txtQtySupplyTop.setSupportedEmpty(true);
        this.txtQtySupplyBottom.setSupportedEmpty(true);
        this.pkDayTop.setSupportedEmpty(true);
        this.pkDayBottom.setSupportedEmpty(true);
        this.txtLeadtime.setSupportedEmpty(true);
        this.txtDiscountRate.setSupportedEmpty(true);
        this.txtQtyOrderBottom.setNegatived(false);
        this.txtQtyOrderTop.setNegatived(false);
        this.txtQtySupplyTop.setNegatived(false);
        this.txtQtySupplyBottom.setNegatived(false);
        this.pkDayTop.setNegatived(false);
        this.pkDayBottom.setNegatived(false);
        this.txtLeadtime.setNegatived(false);
        this.txtDiscountRate.setNegatived(false);
        this.txtPrice.setNegatived(false);
        this.txtLastPrice.setNegatived(false);
        this.txtMaxPrice.setNegatived(false);
        this.txtMinPrice.setNegatived(false);
    }

    public static void setF7OrgUnitBizUnit(KDBizPromptBox bizBox) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        bizBox.setEntityViewInfo(viewInfo);
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoUIResource", (String)key);
    }

    protected void checkData() throws Exception {
        if (this.editData.getIsUseable().equals((Object)IsUseableEnum.Useable)) {
            MsgBox.showInfo((String)this.getResource("Cannot_Edit"));
            SysUtil.abort();
        }
        if (this.prmtPurchaseOrg.getData() == null) {
            this.prmtPurchaseOrg.requestFocus();
            MsgBox.showInfo((String)this.getResource("Msg_PurOrgNotExist"));
            SysUtil.abort();
        }
        if (this.prmtSupplier.getData() == null) {
            this.prmtSupplier.requestFocus();
            MsgBox.showInfo((String)this.getResource("Msg_SupplierNotExist"));
            SysUtil.abort();
        }
        if (this.prmtMaterialItem.getData() == null) {
            this.prmtMaterialItem.requestFocus();
            MsgBox.showInfo((String)this.getResource("Msg_MaterialNotExist"));
            SysUtil.abort();
        }
        if (this.prmtMeasureUnit.getData() == null) {
            this.prmtMeasureUnit.requestFocus();
            MsgBox.showInfo((String)this.getResource("Msg_BaseMessureUnitNotExist"));
            SysUtil.abort();
        }
        if (this.prmtPurMeasureUnit.getData() == null) {
            this.prmtPurMeasureUnit.requestFocus();
            MsgBox.showInfo((String)this.getResource("Msg_BasePurMessureUnitNotExist"));
            SysUtil.abort();
        }
        if (this.pkEffectualDate.getValue() == null) {
            this.pkEffectualDate.requestFocus();
            MsgBox.showInfo((String)this.getResource("Msg_EffectualDateNotExist"));
            SysUtil.abort();
        }
        if (this.pkUneffectualDate.getValue() == null) {
            this.pkUneffectualDate.requestFocus();
            MsgBox.showInfo((String)this.getResource("Msg_UnEffectualDateNotExist"));
            SysUtil.abort();
        }
        if (((Date)this.pkEffectualDate.getValue()).after((Date)this.pkUneffectualDate.getValue())) {
            this.pkEffectualDate.requestFocus();
            MsgBox.showInfo((String)this.getResource("Msg_EffectualDateNotGreat"));
            SysUtil.abort();
        }
        if (this.txtQtyOrderBottom.getBigDecimalValue() != null && this.txtQtyOrderTop.getBigDecimalValue() != null && this.txtQtyOrderBottom.getBigDecimalValue().compareTo(this.txtQtyOrderTop.getBigDecimalValue()) == 1) {
            this.txtQtyOrderBottom.requestFocus();
            MsgBox.showInfo((String)this.getResource("Msg_OrderQty"));
            SysUtil.abort();
        }
        if (this.txtPrice.getBigDecimalValue() == null || this.txtPrice.getBigDecimalValue().compareTo(this.ZERO) <= 0) {
            this.txtPrice.requestFocus();
            MsgBox.showInfo((String)this.getResource("Msg_Qty"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        if (this.editData.getIsUseable().equals((Object)IsUseableEnum.Useable)) {
            MsgBox.showInfo((String)this.getResource("Msg_Cannot_Audit"));
            SysUtil.abort();
        }
        if (this.txtPrice.getBigDecimalValue() == null || this.txtPrice.getBigDecimalValue().compareTo(this.ZERO) < 0) {
            this.txtPrice.requestFocus();
            MsgBox.showInfo((String)this.getResource("Msg_Qty"));
            SysUtil.abort();
        }
        ISupplyInfo iSupplyInfo = (ISupplyInfo)this.getBizInterface();
        if (this.editData.getId() != null) {
            ObjectUuidPK iObjectPk = new ObjectUuidPK(this.editData.getId());
            iSupplyInfo.audit((IObjectPK)iObjectPk);
            this.editData = iSupplyInfo.getSupplyInfoInfo((IObjectPK)iObjectPk, this.getSelectors());
            this.refreshCurPage();
            this.setMessageText(this.getResource("Msg_Audit_Successed"));
            this.showMessage();
        }
        this.initControls();
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnAudit_actionPerformed(e);
        if (this.editData.getIsUseable().equals((Object)IsUseableEnum.UnUseable)) {
            MsgBox.showInfo((String)this.getResource("Msg_Cannot_UnAudit"));
            SysUtil.abort();
        }
        ISupplyInfo iSupplyInfo = (ISupplyInfo)this.getBizInterface();
        if (this.editData.getId() != null) {
            ObjectUuidPK iObjectPk = new ObjectUuidPK(this.editData.getId());
            iSupplyInfo.unAudit((IObjectPK)iObjectPk);
            this.editData = iSupplyInfo.getSupplyInfoInfo((IObjectPK)iObjectPk, this.getSelectors());
            this.setDataObject((IObjectValue)this.editData);
            this.loadFields();
            this.setMessageText(this.getResource("Msg_UnAudit_Successed"));
            this.showMessage();
        }
        this.initControls();
        this.refreshCurPage();
    }

    protected void initControls() {
        if (this.getOprtState().equals("ADDNEW")) {
            this.btnAudit.setEnabled(false);
            this.btnUnAudit.setEnabled(false);
        } else if (this.getOprtState().equals("EDIT")) {
            if (IsUseableEnum.getEnum(1).equals((Object)this.editData.getIsUseable())) {
                this.btnAudit.setEnabled(false);
                this.btnUnAudit.setEnabled(true);
            } else {
                this.btnAudit.setEnabled(true);
                this.btnUnAudit.setEnabled(false);
            }
        } else if (this.getOprtState().equals("VIEW")) {
            if (IsUseableEnum.getEnum(1).equals((Object)this.editData.getIsUseable())) {
                this.btnAudit.setEnabled(false);
                this.btnUnAudit.setEnabled(true);
            } else {
                this.btnAudit.setEnabled(true);
                this.btnUnAudit.setEnabled(false);
            }
        }
        this.prmtAuditor.setEnabled(false);
        this.prmtCreator.setEnabled(false);
        this.prmtLastUpdateUser.setEnabled(false);
        this.pkAuditDate.setEditable(false);
        this.pkCreateTime.setEditable(false);
        this.pkLastUpdateTime.setEditable(false);
        this.comboIsUseable.setEditable(false);
        this.prmtMeasureUnit.setEnabled(false);
        this.prmtMeasureUnit.setEditable(false);
        if (this.cbQuantityUnCtrl.isSelected()) {
            this.txtQtySupplyTop.setEnabled(false);
            this.txtQtySupplyBottom.setEnabled(false);
        }
        if (this.cbTimeUnCtrl.isSelected()) {
            this.pkDayTop.setEnabled(false);
            this.pkDayBottom.setEnabled(false);
        }
        this.menuTool.setVisible(false);
    }

    protected void checkDate() throws Exception {
        ISupplyInfo iSupplyInfo = (ISupplyInfo)this.getBizInterface();
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = (PurchaseOrgUnitInfo)this.prmtPurchaseOrg.getValue();
        SupplierInfo supplierInfo = (SupplierInfo)this.prmtSupplier.getValue();
        MaterialInfo materialInfo = (MaterialInfo)this.prmtMaterialItem.getValue();
        ObjectUuidPK pk = null;
        if (this.editData.getId() != null) {
            pk = new ObjectUuidPK(this.editData.getId());
        }
        String retStr = "";
        int choice = 0;
        retStr = iSupplyInfo.isInvalidDate((IObjectPK)new ObjectUuidPK(purchaseOrgUnitInfo.getId()), (IObjectPK)new ObjectUuidPK(supplierInfo.getId()), (IObjectPK)new ObjectUuidPK(materialInfo.getId()), (Date)this.pkEffectualDate.getValue(), (IObjectPK)pk);
        if (retStr.length() > 0) {
            choice = MsgBox.showConfirm2((Component)((Object)this), (String)(this.getResource("Msg_EffectualDateExists") + retStr + this.getResource("Msg_Conflict")));
        }
        if (choice == 2) {
            SysUtil.abort();
        }
        if ((retStr = iSupplyInfo.isInvalidDate((IObjectPK)new ObjectUuidPK(purchaseOrgUnitInfo.getId()), (IObjectPK)new ObjectUuidPK(supplierInfo.getId()), (IObjectPK)new ObjectUuidPK(materialInfo.getId()), (Date)this.pkUneffectualDate.getValue(), (IObjectPK)pk)).length() > 0) {
            choice = MsgBox.showConfirm2((Component)((Object)this), (String)(this.getResource("Msg_UnEffectualDateExists") + retStr + this.getResource("Msg_Conflict")));
        }
        if (choice == 2) {
            SysUtil.abort();
        }
    }

    @Override
    public void actionTest_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    protected void txtPrice_dataChanged(DataChangeEvent e) throws Exception {
        PurchaseOrgUnitInfo pInfo = (PurchaseOrgUnitInfo)this.prmtPurchaseOrg.getData();
        MaterialInfo mInfo = (MaterialInfo)this.prmtMaterialItem.getData();
        if (mInfo == null || pInfo == null) {
            return;
        }
        IMaterial iMaterial = MaterialFactory.getRemoteInstance();
        MaterialPurchasingInfo mpInfo = MaterialPurchasingFactory.getRemoteInstance().getPurchasingInfo(mInfo.getId().toString(), pInfo.getId().toString());
        if (mpInfo != null && this.txtPrice.getText() != null && !this.txtPrice.getText().equals("")) {
            BigDecimal priceTop = mpInfo.getPriceTop();
            boolean isHasTax = this.isPurParamPUR(pInfo.getId().toString(), "PURORDER002", true);
            MeasureUnitInfo purUnit = (MeasureUnitInfo)this.prmtPurMeasureUnit.getData();
            IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
            BigDecimal[] rateArray = null;
            if (purUnit != null) {
                rateArray = imultiUnit.getConvRatesByMaterial((String[][])new String[][]{{mInfo.getId().toString(), purUnit.getId().toString(), mpInfo.getUnit().getId().toString()}});
            }
            BigDecimal rate = new BigDecimal("1");
            if (rateArray != null && rateArray.length > 0 && rateArray[0].compareTo(new BigDecimal("0")) != 0) {
                rate = rateArray[0];
            }
            BigDecimal price = this.txtPrice.getBigDecimalValue();
            if (priceTop != null && priceTop.compareTo(this.ZERO) == 1) {
                BigDecimal taxRate = new BigDecimal("0");
                if (this.txtTaxRate.getBigDecimalValue() != null && this.txtTaxRate.getBigDecimalValue().compareTo(new BigDecimal("0")) != 0) {
                    taxRate = this.txtTaxRate.getBigDecimalValue();
                }
                if (price != null && isHasTax && !this.cbIsTaxPrice.isSelected()) {
                    price = price.multiply(new BigDecimal("1").add(taxRate.divide(new BigDecimal("100"), 4)));
                } else if (price != null && !isHasTax && this.cbIsTaxPrice.isSelected()) {
                    price = price.multiply(new BigDecimal("1").subtract(taxRate.divide(new BigDecimal("100"), 4)));
                }
                priceTop = priceTop.divide(rate, 10, 4);
                if (price != null && price.compareTo(priceTop) == 1) {
                    MsgBox.showInfo((Component)((Object)this), (String)this.getResource("high_price"));
                    if (this.cbIsTaxListener != null) {
                        this.cbIsTaxPrice.removeItemListener(this.cbIsTaxListener);
                    }
                    this.txtPrice.setValue((Object)new BigDecimal("0.00"));
                    if (this.cbIsTaxListener != null) {
                        this.cbIsTaxPrice.addItemListener(this.cbIsTaxListener);
                    }
                    SysUtil.abort();
                }
            }
        }
    }

    protected void txtDisCountRate_dataChanged(DataChangeEvent e) throws Exception {
        BigDecimal disCountRate = this.txtDiscountRate.getBigDecimalValue();
        if (disCountRate != null && (disCountRate.compareTo(this.ZERO) == -1 || disCountRate.compareTo(this.Hundrud) == 1)) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResource("Illegal_DisCount"));
            this.txtDiscountRate.setValue(null);
            SysUtil.abort();
        }
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
    }

    protected void prmtPurchaseOrg_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtPurchaseOrg.getValue() != null) {
            this.initPurOrgUnitInfo = (PurchaseOrgUnitInfo)this.prmtPurchaseOrg.getValue();
        }
    }

    protected void prmtSupplier_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtSupplier.getValue() != null) {
            this.initSupplierInfo = (SupplierInfo)this.prmtSupplier.getValue();
            if (this.prmtPurchaseOrg.getValue() == null) {
                this.prmtSupplier.setData(null);
                MsgBox.showInfo((String)this.getResource("Msg_Need_PurOrgUnit"));
                SysUtil.abort();
            } else if (this.checkSupplier()) {
                this.prmtSupplier.setData(null);
                this.prmtSupplier.requestFocus();
                MsgBox.showInfo((String)this.getResource("Msg_Need_Request_Supplier"));
                SysUtil.abort();
            }
            this.txtTaxRate.setValue((Object)this.initSupplierInfo.getTaxRate());
        }
    }

    private boolean checkSupplier() throws Exception {
        this.prmtSupplier.getData();
        ObjectUuidPK sPK = new ObjectUuidPK(((SupplierInfo)this.prmtSupplier.getData()).getId());
        ObjectUuidPK pPK = new ObjectUuidPK(((PurchaseOrgUnitInfo)this.prmtPurchaseOrg.getData()).getId());
        ISupplierPurchaseInfo is = SupplierPurchaseInfoFactory.getRemoteInstance();
        return is.getPurChaseInfo((IObjectPK)sPK, (IObjectPK)pPK) == null;
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue newData) {
        SupplyInfoInfo sInfo = (SupplyInfoInfo)newData;
        sInfo.setIsUseable(IsUseableEnum.UnUseable);
        sInfo.setAuditor(null);
        sInfo.setAuditDate(null);
        sInfo.setIsBatchTemp(false);
        super.setFieldsNull((AbstractObjectValue)sInfo);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return super.getSelectors();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkData();
        super.actionSubmit_actionPerformed(e);
    }

    protected void initDataStatus() {
        super.initDataStatus();
    }

    protected void refreshCurPage() throws EASBizException, BOSException, Exception {
        if (this.editData.getId() != null) {
            ObjectUuidPK iObjectPk = new ObjectUuidPK(this.editData.getId());
            this.editData = ((ISupplyInfo)this.getBizInterface()).getSupplyInfoInfo((IObjectPK)iObjectPk, this.getSelectors());
            this.setDataObject((IObjectValue)this.editData);
            this.loadFields();
        }
    }

    public void setPurchaseOrgF7(KDBizPromptBox f7) throws Exception {
        NewOrgUnitFilterInfoProducer oufip = new NewOrgUnitFilterInfoProducer(OrgType.Purchase);
        oufip.getModel().setIsCUFilter(true);
        f7.setFilterInfoProducer((IFilterInfoProducer)oufip);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getIsUseable().equals((Object)IsUseableEnum.Useable)) {
            MsgBox.showInfo((String)this.getResource("Cannot_Edit"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        BDInvClientUtils.logUIOperation("LOG_PRINT", new SupplyInfoInfo().getBOSType());
        super.actionPrint_actionPerformed(e);
    }

    protected void initNeedMainOrgF7s() {
        this.setBizSupplierF7(this.prmtSupplier, null, null);
        this.setBizMaterial(this.prmtMaterialItem, null, null);
    }

    protected String getPermissionItem(String status) {
        if (status.equals("ADDNEW")) {
            return "supplyInfo_addnew";
        }
        return null;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtPurchaseOrg;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Purchase;
    }

    protected void setBizSupplierF7(KDBizPromptBox bizSupplierBox, IColumn col, String queryInfo) {
        OrgUnitInfo orgInfo = null;
        if (queryInfo != null) {
            bizSupplierBox.setQueryInfo(queryInfo);
        }
        if (this.f7DisplayMode == 0) {
            SCMGroupClientUtils.setBizSupplierF7((KDBizPromptBox)bizSupplierBox, (Component)((Object)this), (OrgType)this.getMainBizOrgType(), (String)queryInfo);
        } else {
            if (queryInfo == null) {
                bizSupplierBox.setQueryInfo(QueryInfoConstants.getStdSupplierQueryInfo((OrgType)this.getMainBizOrgType()));
            }
            bizSupplierBox.setEditable(true);
        }
        SCMGroupClientUtils.setApproved4SupplierF7((KDBizPromptBox)bizSupplierBox, (OrgType)this.getMainBizOrgType());
        if (col != null) {
            col.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizSupplierBox));
        }
        if (this.getMainOrgContext() != null) {
            orgInfo = (OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType());
        }
        if (orgInfo != null) {
            bizSupplierBox.setCurrentMainBizOrgUnit(orgInfo, this.getMainBizOrgType());
        }
    }

    protected void setBizMaterial(KDBizPromptBox bizMaterialBox, IColumn col, String queryInfo) {
        OrgUnitInfo orgInfo = null;
        if (queryInfo != null) {
            bizMaterialBox.setQueryInfo(queryInfo);
        }
        bizMaterialBox.setEditFormat("$number$");
        bizMaterialBox.setDisplayFormat("$number$");
        bizMaterialBox.setCommitFormat("$number$;$helpCode$");
        bizMaterialBox.setEditable(true);
        if (this.f7DisplayMode == 0) {
            SCMGroupClientUtils.setBizMaterialF7((KDBizPromptBox)bizMaterialBox, (Component)((Object)this), (OrgType)this.getMainBizOrgType(), (boolean)false, null);
        } else if (queryInfo == null) {
            bizMaterialBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialPurchasingNoGroupQuery");
        }
        SCMGroupClientUtils.setApproved4MaterialF7((KDBizPromptBox)bizMaterialBox, (OrgType)this.getMainBizOrgType());
        if (col != null) {
            col.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizMaterialBox));
        }
        if (this.getMainOrgContext() != null && (orgInfo = (OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())) != null) {
            bizMaterialBox.setCurrentMainBizOrgUnit(orgInfo, this.getMainBizOrgType());
        }
    }

    protected KDBizPromptBox[] getNeedSetOrgF7s() {
        return new KDBizPromptBox[]{this.prmtSupplier, this.prmtMaterialItem};
    }

    protected void setMainBizOrgF7(KDBizPromptBox bizOrgUnitBox, OrgType orgType) {
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(orgType);
        String permissionItem = this.getPermissionItem(this.getOprtState());
        if (permissionItem != null) {
            iProducer.getModel().setPermissionItem(permissionItem);
        }
        bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
    }

    protected final OrgUnitInfo getDefaultMainBizOrg() {
        OrgUnitInfo[] mainOrgs = null;
        try {
            FullOrgUnitCollection collection = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)this.getMainBizOrgType(), (String)this.getPermissionItem("ADDNEW"));
            mainOrgs = SCMGroupClientUtils.getOrgUnitInfosByType((FullOrgUnitCollection)collection, (OrgType)this.getMainBizOrgType());
            if (mainOrgs == null) {
                mainOrgs = new OrgUnitInfo[]{};
                return null;
            }
            if (mainOrgs.length > 0) {
                mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, (boolean)true);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        OrgUnitInfo currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        if (currentMainOrg != null && mainOrgs != null && mainOrgs.length > 0) {
            for (int i = 0; i < mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(mainOrgs[i].getId().toString())) continue;
                return currentMainOrg;
            }
        }
        if (mainOrgs != null && mainOrgs.length > 0) {
            return mainOrgs[0];
        }
        return null;
    }

    private boolean isPurParamPUR(String orgId, String key, boolean defaultValue) throws EASBizException, BOSException {
        ObjectUuidPK pk;
        boolean isPurParam = defaultValue;
        IParamControl ipc = ParamControlFactory.getRemoteInstance();
        String strPurParam = ipc.getParamValue((IObjectPK)(pk = new ObjectUuidPK(orgId)), key);
        if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("true")) {
            isPurParam = true;
        }
        if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("false")) {
            isPurParam = false;
        }
        return isPurParam;
    }

    private void changeF7Context() {
        SCMGroupClientUtils.isCurrentMainOrgChanged((KDBizPromptBox)this.prmtSupplier, (String)QueryInfoConstants.getSupplierQueryOrgId((OrgType)this.getMainBizOrgType()), null);
        SCMGroupClientUtils.isCurrentMainOrgChanged((KDBizPromptBox)this.prmtMaterialItem, (String)QueryInfoConstants.getMaterialQueryOrgId((OrgType)this.getMainBizOrgType()), null);
    }

    protected void afterMainOrgChanged(String arg0, String arg1) {
        if (arg1 != null) {
            this.changeF7Context();
            try {
                this.f7DisplayMode = SCMGroupClientUtils.getF7DisplayMode((String)((PurchaseOrgUnitInfo)this.prmtPurchaseOrg.getData()).getCU().getId().toString());
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }
}

