/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sm.srm.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sm.srm.client.AbstractSupplyScopeSelectUI;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class SupplyScopeSelectUI
extends AbstractSupplyScopeSelectUI {
    private static final Logger logger = CoreUIObject.getLogger(SupplyScopeSelectUI.class);
    private OrgUnitCollection orgUnitCollection = null;
    private String theFirst5SelectedNumber = null;
    private String selectedIds = null;
    private boolean isConfirm = false;
    private List selectIDList = new ArrayList();
    private boolean isEditable = false;
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String NAME = "name";

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
        this.btnSelectItems.setEnabled(isEditable);
        this.btnSelectAll.setEnabled(isEditable);
        this.btnDelectItems.setEnabled(isEditable);
        this.btnDelectAll.setEnabled(isEditable);
    }

    public String getTheFirst5SelectedNumber() {
        return this.theFirst5SelectedNumber;
    }

    public String getSelectedIds() {
        return this.selectedIds;
    }

    public boolean isConfirm() {
        return this.isConfirm;
    }

    protected void setOrgUnitCollection(OrgUnitCollection col) {
        this.orgUnitCollection = col;
        this.fillKDTableAll();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDTableAll.checkParsed();
        this.kDTableAll.setEditable(false);
        this.kDTableAll.getSelectManager().setSelectMode(10);
        this.kDTableSelect.checkParsed();
        this.kDTableSelect.setEditable(false);
        this.kDTableSelect.getSelectManager().setSelectMode(10);
        this.kDTableSelect.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    SupplyScopeSelectUI.this.deleteSelectItems();
                }
            }
        });
        this.kDTableAll.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    SupplyScopeSelectUI.this.addSelectItems();
                }
            }
        });
    }

    private void fillKDTableAll() {
        if (this.orgUnitCollection == null) {
            return;
        }
        OrgUnitInfo info = null;
        IRow row = null;
        int size = this.orgUnitCollection.size();
        for (int i = 0; i < size; ++i) {
            info = this.orgUnitCollection.get(i);
            row = this.kDTableAll.addRow();
            this.setValue(row, ID, info.getId());
            this.setValue(row, NUMBER, info.get(NUMBER));
            this.setValue(row, NAME, info.getName());
        }
    }

    private void setValue(IRow row, String fieldName, Object value) {
        row.getCell(fieldName).setValue(value);
    }

    private void addSelectItems() {
        int size = this.kDTableAll.getSelectManager().size();
        if (size == 0 || this.kDTableAll.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        for (int j = 0; j < size; ++j) {
            int topIndex;
            KDTSelectBlock selectBlock = this.kDTableAll.getSelectManager().get(j);
            int bottomIndex = selectBlock.getBottom();
            for (int i = topIndex = selectBlock.getTop(); i <= bottomIndex; ++i) {
                IRow row = this.kDTableAll.getRow(i);
                String keyValue = row.getCell(ID).getValue().toString();
                if (this.selectIDList.contains(keyValue)) continue;
                this.selectIDList.add(keyValue);
                this.setSelectTableRows(keyValue, row.getCell(NUMBER).getValue().toString(), row.getCell(NAME).getValue().toString());
            }
        }
    }

    private void setSelectTableRows(String id, String number, String name) {
        IRow row = this.kDTableSelect.addRow();
        this.setValue(row, ID, id);
        this.setValue(row, NUMBER, number);
        this.setValue(row, NAME, name);
    }

    @Override
    protected void btnSelectItems_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectItems_actionPerformed(e);
        this.addSelectItems();
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectAll_actionPerformed(e);
        this.kDTableAll.getSelectManager().select(0, 0, this.kDTableAll.getRowCount(), 1);
        this.addSelectItems();
        this.kDTableAll.getSelectManager().select(-1, -1);
    }

    private void deleteSelectItems() {
        int size = this.kDTableSelect.getSelectManager().size();
        if (size == 0 || this.kDTableSelect.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        for (int j = size - 1; j >= 0; --j) {
            KDTSelectBlock selectBlock = this.kDTableSelect.getSelectManager().get(j);
            int bottomIndex = selectBlock.getBottom();
            int topIndex = selectBlock.getTop();
            for (int i = bottomIndex; i >= topIndex; --i) {
                IRow row = this.kDTableSelect.getRow(i);
                String keyValue = row.getCell(ID).getValue().toString();
                this.selectIDList.remove(keyValue);
                int index = row.getRowIndex();
                this.kDTableSelect.removeRow(index);
            }
        }
        this.kDTableSelect.getSelectManager().removeAll();
    }

    @Override
    protected void btnDelectItems_actionPerformed(ActionEvent e) throws Exception {
        super.btnDelectItems_actionPerformed(e);
        this.deleteSelectItems();
    }

    @Override
    protected void btnDelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnDelectAll_actionPerformed(e);
        this.selectIDList.clear();
        this.kDTableAll.getSelectManager().select(0, 0, 0, 1);
        this.kDTableSelect.refresh();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) {
        if (this.isEditable && this.selectIDList.size() > 0) {
            int i;
            int rowCount = this.kDTableSelect.getRowCount();
            rowCount = rowCount > 5 ? 5 : rowCount;
            StringBuffer sb = new StringBuffer();
            for (i = 0; i < rowCount; ++i) {
                sb.append(this.kDTableSelect.getRow(i).getCell(NAME).getValue()).append(";");
            }
            this.theFirst5SelectedNumber = sb.substring(0, sb.length() - 1);
            sb.setLength(0);
            int size = this.selectIDList.size();
            for (i = 0; i < size; ++i) {
                sb.append(this.selectIDList.get(i)).append(";");
            }
            this.selectedIds = sb.substring(0, sb.length() - 1);
            this.isConfirm = true;
        }
        if (this.selectIDList.size() == 0) {
            this.isConfirm = true;
            this.theFirst5SelectedNumber = null;
            this.selectedIds = null;
        }
        this.getUIWindow().close();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) {
        this.getUIWindow().close();
    }

    protected void setSelectedOrgUnitCollection(StorageOrgUnitCollection col) {
        StorageOrgUnitInfo info = null;
        IRow row = null;
        if (col != null) {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                info = col.get(i);
                this.selectIDList.add(info.get(ID).toString());
                row = this.kDTableSelect.addRow();
                this.setValue(row, ID, info.getId().toString());
                this.setValue(row, NUMBER, info.getNumber());
                this.setValue(row, NAME, info.getName());
            }
        }
    }
}

