/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectCollectionChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.IObjectValueChangeListener;
import com.kingdee.bos.dao.ObjectCollectionChangeEvent;
import com.kingdee.bos.dao.ObjectValueChangeEvent;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.ORMEngine;
import com.kingdee.eas.base.core.util.EqualsUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class ORMHelper {
    private static final String _REMOVELIST_ = "_removelist_";
    public static final String _ISNEW = "_isnew";
    public static final String ISCHANGED = "_ischanged";
    private static final String ISLISENER = "_islisener";
    public static final String ENTITY_PK_NAME = "id";
    public static final String LISENERPROPERTY = "_lisenerproperty";

    public static void setIsNew(IObjectValue vo, boolean isNew) {
        vo.setBoolean(_ISNEW, isNew);
    }

    public static void setIsLisening(IObjectValue vo, boolean isLisener) {
        vo.setBoolean(ISLISENER, isLisener);
    }

    public static boolean getIsChange(IObjectValue vo) {
        return ORMEngine.getIsChange(vo);
    }

    public static boolean getIsLisening(IObjectValue vo) {
        return vo.getBoolean(ISLISENER);
    }

    public static boolean getIsNew(IObjectValue vo) {
        return ORMEngine.getIsNew(vo);
    }

    public static void setIsChanged(IObjectValue vo, boolean isChanged) {
        vo.setBoolean(ISCHANGED, isChanged);
    }

    public static void addRemoveLisener(final IObjectCollection coll, final Set list) {
        list.clear();
        coll.addEventListener(new IObjectCollectionChangeListener(){

            public void objectCollectionChange(ObjectCollectionChangeEvent cce) {
                BOSUuid id;
                IObjectValue vo;
                if (cce.getType() == 4 && cce.getIndex() == -1 && (vo = cce.getItem()) != null && (id = vo.getBOSUuid(ORMHelper.ENTITY_PK_NAME)) != null && id != null && !ORMEngine.getIsNew(vo)) {
                    list.add(id);
                }
                if (cce.getType() == 6) {
                    for (IObjectValue vo2 : coll) {
                        BOSUuid id2 = vo2.getBOSUuid(ORMHelper.ENTITY_PK_NAME);
                        if (id2 == null || ORMEngine.getIsNew(vo2) || list.contains(id2)) continue;
                        list.add(id2);
                    }
                }
                if (cce.getType() == 1) {
                    vo = cce.getNewItem();
                    id = vo.getBOSUuid(ORMHelper.ENTITY_PK_NAME);
                    if (list.contains(id)) {
                        list.remove(id);
                    } else {
                        ORMHelper.setIsNew(cce.getNewItem(), true);
                    }
                }
            }
        });
    }

    public static void addRemoveLisener(IObjectValue vo, String property) {
        HashSet list = (HashSet)vo.get(_REMOVELIST_ + property);
        if (list == null) {
            list = new HashSet();
            vo.put(_REMOVELIST_ + property, list);
        }
        IObjectCollection coll = (IObjectCollection)vo.get(property);
        ORMHelper.addRemoveLisener(coll, list);
    }

    public static void addChangeLisener(IObjectValue vo, String[] property) {
        ORMHelper.setIsLisening(vo, false);
        vo.put(LISENERPROPERTY, (Object)property);
        ORMHelper.setIsNew(vo, false);
        ORMHelper.setIsChanged(vo, false);
        ORMHelper.setIsLisening(vo, true);
        vo.addEventListener(new IObjectValueChangeListener(){

            public void objectValueChange(ObjectValueChangeEvent event) {
                if (event.getType() != 1) {
                    return;
                }
                IObjectValue src = (IObjectValue)event.getSource();
                if (ORMEngine.getIsChange(src)) {
                    return;
                }
                if (!ORMHelper.getIsLisening(src)) {
                    return;
                }
                String pro = event.getPropertyName();
                if (pro.equals(ORMHelper.ISLISENER) || pro.equals(ORMHelper.ISCHANGED)) {
                    return;
                }
                String[] property = (String[])src.get(ORMHelper.LISENERPROPERTY);
                if (property == null || property.length == 0) {
                    return;
                }
                for (int i = 0; i < property.length; ++i) {
                    boolean ischange;
                    if (!pro.equals(property[i])) continue;
                    Object old = event.getOldValue();
                    boolean bl = ischange = !EqualsUtil.equals(event.getNewValue(), event.getOldValue());
                    if (!ischange) continue;
                    ORMHelper.setIsChanged(src, true);
                }
            }
        });
    }

    public static Set getRemoveList(IObjectValue vo, String property) {
        Set list = (Set)vo.get(_REMOVELIST_ + property);
        if (list == null) {
            return new HashSet();
        }
        return list;
    }

    public static void addChangeLisener(IObjectCollection coll, String[] property) {
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            ORMHelper.addChangeLisener((IObjectValue)iter.next(), property);
        }
    }

    public static String[] getLisenerProperties(IObjectValue vo) {
        return ORMEngine.getLisenerProperties(vo);
    }

    public static void setLisenerProperties(IObjectValue vo, String[] val) {
        vo.put(LISENERPROPERTY, (Object)val);
    }
}

