/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.util;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;

public class KDTableUtil {
    public static void clearCells(KDTable kdt, int rowIndex, String[] colNames) {
        IRow row = kdt.getRow(rowIndex);
        if (colNames != null) {
            int n = colNames.length;
            for (int i = 0; i < n; ++i) {
                ICell cell = row.getCell(colNames[i]);
                cell.setValue(null);
            }
        } else {
            int n = kdt.getColumnCount();
            for (int i = 0; i < n; ++i) {
                ICell cell = row.getCell(i);
                cell.setValue(null);
            }
        }
    }

    public static String[] getSelectRowFieldValue(KDTable kdtTable, String fieldname) {
        if (!KDTableUtil.isSelectRow(kdtTable)) {
            return null;
        }
        KDTSelectManager sm = kdtTable.getSelectManager();
        int blockCount = sm.size();
        int keyField = kdtTable.getColumnIndex(fieldname);
        ArrayList<String> retList = new ArrayList<String>();
        Object value = null;
        for (int i = 0; i < blockCount; ++i) {
            KDTSelectBlock block = sm.get(i);
            int bottom = block.getBottom();
            for (int j = block.getTop(); j <= bottom; ++j) {
                IRow row = kdtTable.getRow(j);
                value = row.getCell(keyField).getValue();
                if (value == null || value.toString().trim().length() == 0) continue;
                String retStr = value.toString();
                retList.add(retStr);
            }
        }
        retList.trimToSize();
        if (retList.size() == 0) {
            return null;
        }
        String[] retStrs = new String[retList.size()];
        retStrs = retList.toArray(retStrs);
        return retStrs;
    }

    public static boolean isSelectRow(KDTable kdtTable) {
        KDTSelectManager sm = kdtTable.getSelectManager();
        return sm.size() > 0;
    }

    public static void setTableKeyBoardManager(final KDTable table) {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KDTEditManager em = table.getEditManager();
                int result = em.stopEditing();
                if (0 != result) {
                    return;
                }
                KDTSelectManager sm = table.getSelectManager();
                int rowIndex = sm.getActiveRowIndex();
                int colIndex = sm.getActiveColumnIndex();
                int rowCount = table.getRowCount();
                int colCount = table.getColumnCount();
                for (int nextRowIndex = rowIndex; nextRowIndex < rowCount; ++nextRowIndex) {
                    IRow row = table.getRow(nextRowIndex);
                    if (row == null) {
                        return;
                    }
                    for (int i = colIndex + 1; i < colCount; ++i) {
                        StyleAttributes sa = row.getCell(i).getStyleAttributes();
                        if (sa.isHided() || sa.isLocked()) continue;
                        em.editCellAt(nextRowIndex, i);
                        return;
                    }
                    colIndex = -1;
                }
            }
        };
        ActionMap actionMap = table.getActionMap();
        actionMap.put("FocusChangeRow", action);
        actionMap.put("FocusChangeCol", action);
        actionMap.put("Delete", null);
        actionMap.put("Copy", null);
        actionMap.put("Paste", null);
        actionMap.put("Cut", null);
        actionMap.put("BeginEdit", null);
    }
}

