/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.HRInstanceFactory;
import com.kingdee.eas.base.core.IPersonPositionApiInfo;
import com.kingdee.eas.base.core.fi.gl.GLUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOUPartAdmin;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.OUPartAdminFactory;
import com.kingdee.eas.basedata.org.OUPartAdminInfo;
import com.kingdee.eas.basedata.org.OrgStructureException;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class OrgStructureUtils {
    public static final String RES = "com.kingdee.eas.base.core.base.resource.VerifyResource";

    public static void checkAdminIsSealupByPosition(String positionId) throws Exception {
        IPosition iPosition = PositionFactory.getRemoteInstance();
        PositionInfo info = iPosition.getPositionInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)positionId)));
        OrgStructureUtils.checkAdminIsSealup(info.getAdminOrgUnit().getId().toString());
    }

    public static void checkAdminIsSealup(String adminId) throws Exception {
        IFullOrgUnit iFull = FullOrgUnitFactory.getRemoteInstance();
        FullOrgUnitInfo fullInfo = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)adminId)));
        IOUPartAdmin iOUPartAdmin = OUPartAdminFactory.getRemoteInstance();
        OUPartAdminInfo partAdminInfo = iOUPartAdmin.getOUPartAdminInfo((IObjectPK)new ObjectUuidPK(fullInfo.getPartAdmin().getId()));
        if (partAdminInfo.isIsSealUp()) {
            Object[] param = new Object[]{fullInfo.getName()};
            throw new OrgStructureException(OrgStructureException.ADMIN_IS_SEALUP, param);
        }
    }

    public static void setSysCU(IObjectValue ov) {
        ObjectBaseInfo info = (ObjectBaseInfo)ov;
        CtrlUnitInfo cu = new CtrlUnitInfo();
        cu.setId(BOSUuid.read((String)"11111111-1111-1111-1111-111111111111CCE7AED4"));
        info.setCU(cu);
    }

    public static Set getParentCU(String CUID) throws Exception {
        ICtrlUnit iCU = CtrlUnitFactory.getRemoteInstance();
        CtrlUnitInfo ctrlUnitInfo = iCU.getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(CUID));
        HashSet<String> set = new HashSet<String>();
        if (ctrlUnitInfo.getLongNumber() != null) {
            if (ctrlUnitInfo.getLongNumber().indexOf("!") == -1) {
                set.add(ctrlUnitInfo.getLongNumber());
            } else {
                String[] longNumberArgus = ctrlUnitInfo.getLongNumber().split("!");
                for (int i = 0; i < longNumberArgus.length; ++i) {
                    if (longNumberArgus[i] == null || longNumberArgus[i].length() <= 0) continue;
                    set.add(longNumberArgus[i]);
                }
            }
        }
        if (set.size() > 0) {
            return set;
        }
        return null;
    }

    public static void checkCompany(Component uiComp, CompanyOrgUnitInfo companyInfo) {
        boolean expired;
        if (companyInfo == null || GLUtil.isCompanyUnion((CompanyOrgUnitInfo)companyInfo)) {
            MsgBox.showWarning((Component)uiComp, (String)EASResource.getString((String)RES, (String)"Company_AlertMsg"));
            SysUtil.abort();
        }
        Date curDate = new Date();
        Date invalidDate = companyInfo.getInvalidDate();
        boolean bl = expired = invalidDate != null && curDate.after(invalidDate);
        if (expired) {
            MsgBox.showWarning((Component)uiComp, (String)EASResource.getString((String)RES, (String)"Company_InvalidMsg"));
            SysUtil.abort();
        }
    }

    public static AdminOrgUnitInfo getAdminOrgInfoByPersonId(Context ctx, String personid) throws BOSException, EASBizException {
        PositionInfo primaryPosition;
        if (personid == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("primaryPosition.id"));
        sic.add(new SelectorItemInfo("primaryPosition.adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("primaryPosition.adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("primaryPosition.adminOrgUnit.number"));
        view.setSelector(sic);
        FilterInfo ft = new FilterInfo();
        ft.getFilterItems().add(new FilterItemInfo("person.id", (Object)personid, CompareType.EQUALS));
        ft.getFilterItems().add(new FilterItemInfo("primaryPosition", null, CompareType.NOTEQUALS));
        view.setFilter(ft);
        IPersonPositionApiInfo personPosition = null;
        personPosition = ctx == null ? (IPersonPositionApiInfo)HRInstanceFactory.getPersonPositionRemoteInstance().getCollection(view).get(0) : (IPersonPositionApiInfo)HRInstanceFactory.getPersonPositionLocalInstance(ctx).getCollection(view).get(0);
        if (personPosition != null && (primaryPosition = personPosition.getPrimaryPosition()) != null) {
            AdminOrgUnitInfo adminInfoa = (AdminOrgUnitInfo)primaryPosition.get("adminOrgUnit");
            return adminInfoa;
        }
        return null;
    }
}

