/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.util;

import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import java.math.BigDecimal;

public class PrecisionUtil {
    public static final int DEFAULT_PRICISION = 2;
    public static final String FORMAT_STRING_WITHOUT_E = "%r-[=]{#,##0.############}f";
    public static final int PRECISION_DEFAUL_DB = 10;

    public static String getFormatString(int precision) {
        if (precision == 0) {
            return "%R-{#,##0}f";
        }
        StringBuffer buffer = new StringBuffer();
        if (precision == 0) {
            buffer.append("#");
        } else {
            buffer.append("0.");
        }
        for (int i = 0; i < precision; ++i) {
            buffer = buffer.append("0");
        }
        StringBuffer formatString = new StringBuffer();
        formatString.append("%r-[=]{#,##").append(buffer).append("}f");
        return formatString.toString();
    }

    public static String getFormatStringWithoutMinus(int precision) {
        if (precision == 0) {
            return "%R_{#,##0}f";
        }
        StringBuffer buffer = new StringBuffer();
        if (precision == 0) {
            buffer.append("#");
        } else {
            buffer.append("0.");
        }
        for (int i = 0; i < precision; ++i) {
            buffer = buffer.append("0");
        }
        StringBuffer formatString = new StringBuffer();
        formatString.append("%r_[=]{#,##").append(buffer).append("}f");
        return formatString.toString();
    }

    public static BigDecimal formatCurrencyPrecision(BigDecimal money, CurrencyInfo currencyInfo) {
        BigDecimal retvalue = null;
        int precision = currencyInfo.getPrecision();
        retvalue = money.setScale(precision, 4);
        return retvalue;
    }

    public static BigDecimal formatPricePrecision(BigDecimal price, MaterialInfo materialInfo) {
        BigDecimal retvalue = null;
        int precision = materialInfo.getPricePrecision();
        retvalue = price.setScale(precision, 4);
        return retvalue;
    }
}

