/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.calc.express.IllegalParameterException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class ClientHelper {
    public static final Integer TRUE = new Integer(1);
    public static final Integer FALSE = new Integer(0);

    public static void setTableKeyBoardManager(final KDTable table) {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KDTEditManager em = table.getEditManager();
                int result = em.stopEditing();
                if (0 != result) {
                    return;
                }
                KDTSelectManager sm = table.getSelectManager();
                int rowIndex = sm.getActiveRowIndex();
                int colIndex = sm.getActiveColumnIndex();
                int rowCount = table.getRowCount();
                int colCount = table.getColumnCount();
                for (int nextRowIndex = rowIndex; nextRowIndex < rowCount; ++nextRowIndex) {
                    IRow row = table.getRow(nextRowIndex);
                    if (row == null) {
                        return;
                    }
                    for (int i = colIndex + 1; i < colCount; ++i) {
                        StyleAttributes sa = row.getCell(i).getStyleAttributes();
                        if (sa.isHided() || sa.isLocked()) continue;
                        em.editCellAt(nextRowIndex, i);
                        return;
                    }
                    colIndex = -1;
                }
            }
        };
        ActionMap actionMap = table.getActionMap();
        actionMap.put("FocusChangeRow", action);
        actionMap.put("FocusChangeCol", action);
        actionMap.put("Delete", null);
        actionMap.put("Copy", null);
        actionMap.put("Paste", null);
        actionMap.put("Cut", null);
        actionMap.put("BeginEdit", null);
    }

    public static int showModifyConfirmBeforeExit(Component owner) {
        return MsgBox.showConfirm3((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
    }

    public static void fullCompanyInfo(CompanyOrgUnitInfo company, boolean isCover) throws BOSException, EASBizException {
        if (isCover || company.getAccountPeriodType().getId() == null || company.getAccountTable() == null || company.getAccountTable().getId() == null) {
            ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(company.getId().toString());
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.addObjectCollection((IObjectCollection)ClientHelper.getCompanySic());
            CompanyOrgUnitInfo buf = companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)pk, sic);
            if (!isCover) {
                buf.putAll((IObjectValue)company);
            }
            company.putAll((IObjectValue)buf);
        }
    }

    public static void setIcon(JButton btn, String name) {
        Icon icon = EASResource.getIcon((String)name);
        btn.setIcon(icon);
    }

    public static String getCompanyTreeNames(TreeModel model) throws BOSException {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getRoot();
        StringBuffer result = new StringBuffer();
        Enumeration<TreeNode> enumer = node.depthFirstEnumeration();
        while (enumer.hasMoreElements()) {
            node = (DefaultMutableTreeNode)enumer.nextElement();
            if (!node.isLeaf()) continue;
            SimpleCompanyUserObject userObject = (SimpleCompanyUserObject)node.getUserObject();
            result.append(userObject.getName()).append(", ");
        }
        if (result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    public static String getLeafCompany(TreeModel model) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getRoot();
        StringBuffer bf = new StringBuffer("''");
        for (node = node.getFirstLeaf(); node != null; node = node.getNextLeaf()) {
            if (node.getUserObject() == null || !(node.getUserObject() instanceof SimpleCompanyUserObject)) continue;
            SimpleCompanyUserObject info = (SimpleCompanyUserObject)node.getUserObject();
            bf.append(",'");
            bf.append(info.getCompanyId());
            bf.append("'");
        }
        return bf.toString();
    }

    public static Frame getFrameAncestor(Component c) {
        for (Component p = c; p != null; p = p.getParent()) {
            if (!(p instanceof Frame)) continue;
            return (Frame)p;
        }
        return null;
    }

    public static void centerWindow(Window window) {
        CtrlSwingUtilities.centerWindow((Window)window);
    }

    public static EntityViewInfo getAccountViewEvi(String cuId, String companyId, String currencyId, boolean isLeaf, boolean isShowCashAndBank) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyId));
        if (isLeaf) {
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1"));
        }
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Boolean.FALSE));
        if (!isShowCashAndBank) {
            filter.getFilterItems().add(new FilterItemInfo("isCash", (Object)Boolean.FALSE));
            filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)Boolean.FALSE));
        }
        EntityViewInfo customEvi = new EntityViewInfo();
        customEvi.setFilter(filter);
        EntityViewInfo evi = ClientHelper.getAccountViewEvi(companyId, currencyId, customEvi);
        SorterItemCollection sorter = evi.getSorter();
        sorter.add(new SorterItemInfo("number"));
        return evi;
    }

    public static SelectorItemCollection getAccountSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longName"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("DC"));
        sic.add(new SelectorItemInfo("isQty"));
        sic.add(new SelectorItemInfo("AC"));
        sic.add(new SelectorItemInfo("bw"));
        sic.add(new SelectorItemInfo("ACNotice"));
        sic.add(new SelectorItemInfo("control"));
        sic.add(new SelectorItemInfo("isCash"));
        sic.add(new SelectorItemInfo("isBank"));
        sic.add(new SelectorItemInfo("isCashEquivalent"));
        sic.add(new SelectorItemInfo("isChangeCurrency"));
        sic.add(new SelectorItemInfo("hasUserProperty"));
        sic.add(new SelectorItemInfo("isGFreeze"));
        sic.add(new SelectorItemInfo("isCFreeze"));
        sic.add(new SelectorItemInfo("isSelfFreeze"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("PLType"));
        sic.add(new SelectorItemInfo("accountingcurrency"));
        sic.add(new SelectorItemInfo("measureUnitID.number"));
        sic.add(new SelectorItemInfo("measureUnitID.name"));
        sic.add(new SelectorItemInfo("measureUnitID.coefficient"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.id"));
        sic.add(new SelectorItemInfo("accountTypeID.property"));
        sic.add(new SelectorItemInfo("mainCashFlowItem.*"));
        sic.add(new SelectorItemInfo("attCashFlowItem.*"));
        sic.add(new SelectorItemInfo("CAA.id"));
        sic.add(new SelectorItemInfo("CAA.measureUnit.number"));
        sic.add(new SelectorItemInfo("CAA.measureUnit.name"));
        sic.add(new SelectorItemInfo("CAA.measureUnit.coefficient"));
        sic.add(new SelectorItemInfo("CAA.measureUnitGroup.id"));
        sic.add(new SelectorItemInfo("CAA.isQty"));
        sic.add(new SelectorItemInfo("CAA.name"));
        sic.add(new SelectorItemInfo("CAA.number"));
        return sic;
    }

    public static void setComboBoxSelectByUUid(JComboBox jComboBox, ObjectBaseInfo businessData) {
        if (businessData == null || businessData.getId() == null) {
            return;
        }
        int index = ClientHelper.getIndexByBusinessDataOId(jComboBox, businessData);
        if (index == -1) {
            jComboBox.addItem(businessData);
            index = jComboBox.getItemCount() - 1;
        }
        jComboBox.setSelectedIndex(index);
    }

    public static int getIndexByBusinessDataOId(JComboBox jComboBox, ObjectBaseInfo businessData) {
        int itemCount = jComboBox.getItemCount();
        if (itemCount == 0 || businessData == null) {
            return -1;
        }
        for (int i = 0; i < itemCount; ++i) {
            ObjectBaseInfo businessDataInComboBox = null;
            if (jComboBox.getItemAt(i) instanceof ObjectBaseInfo) {
                businessDataInComboBox = (ObjectBaseInfo)jComboBox.getItemAt(i);
            }
            if (businessDataInComboBox == null || businessDataInComboBox.getId() == null || businessData.getId() == null || !businessDataInComboBox.getId().equals((Object)businessData.getId())) continue;
            return i;
        }
        return -1;
    }

    public static RptParams loadSystemParams(String companyId) {
        return ClientHelper.loadSystemParams(companyId, null);
    }

    public static RptParams loadSystemParams(String companyId, Context ctx) {
        ObjectUuidPK comPk = new ObjectUuidPK(companyId);
        RptParams pp = new RptParams();
        pp.setObject("G001", null);
        pp.setObject("GL_004", (Object)comPk);
        pp.setObject("GL_005", (Object)comPk);
        pp.setObject("GL_006", (Object)comPk);
        pp.setObject("GL_009", (Object)comPk);
        pp.setObject("GL_012", (Object)comPk);
        pp.setObject("GL_002", (Object)comPk);
        pp.setObject("GL_003", (Object)comPk);
        pp.setObject("GL_008", (Object)comPk);
        pp.setObject("G000", null);
        pp.setObject("GL_028", (Object)comPk);
        pp.setObject("GL_053", null);
        pp.setObject("GL_054", (Object)comPk);
        pp.setObject("G010", null);
        pp.setObject("GL_064", null);
        try {
            IParamControl pc = ctx == null ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)ctx);
            HashMap allParam = pc.getParamHashMap(new HashMap(pp.toMap()));
            return RptParams.parseFrom((Map)allParam);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SelectorItemCollection getCompanySic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("baseCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.precision"));
        sic.add(new SelectorItemInfo("reportCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("accountPeriodType.number"));
        sic.add(new SelectorItemInfo("accountPeriodType.name"));
        sic.add(new SelectorItemInfo("isGrouping"));
        sic.add(new SelectorItemInfo("isGroup"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("isOnlyUnion"));
        sic.add(new SelectorItemInfo("isBizUnit"));
        sic.add(new SelectorItemInfo("isCompanyOrgUnit"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("reportConvertMode"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("CU.longNumber"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("accountTable.number"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("adjustExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        sic.add(new SelectorItemInfo("isAssistantOrg"));
        sic.add(new SelectorItemInfo("mainOrg.id"));
        sic.add(new SelectorItemInfo("mainOrg.name"));
        sic.add(new SelectorItemInfo("mainOrg.number"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.id"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.name"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.number"));
        sic.add(new SelectorItemInfo("accountScheme.id"));
        sic.add(new SelectorItemInfo("accountScheme.name"));
        sic.add(new SelectorItemInfo("accountScheme.number"));
        return sic;
    }

    public static Set getAcctViewIdSet(String companyId, String currencyId, EntityViewInfo viewInfo) throws EASBizException, BOSException {
        HashSet<String> set = new HashSet<String>();
        AccountViewCollection acctViewColl = ClientHelper.getAccountViewCollection(null, companyId, currencyId, viewInfo);
        if (acctViewColl == null) {
            return null;
        }
        int size = acctViewColl.size();
        AccountViewInfo acctViewInfo = null;
        for (int i = 0; i < size; ++i) {
            acctViewInfo = acctViewColl.get(i);
            set.add(acctViewInfo.getId().toString());
        }
        return set;
    }

    public static AccountViewCollection getAccountViewCollection(Context ctx, String companyId, String currencyId, EntityViewInfo viewInfo) throws BOSException, EASBizException {
        if (companyId == null) {
            throw new BOSException((Throwable)new IllegalParameterException("company is null"));
        }
        EntityViewInfo view = viewInfo;
        if (viewInfo == null) {
            view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection items = filter.getFilterItems();
            items.add(new FilterItemInfo("isLeaf", (Object)TRUE));
            items.add(new FilterItemInfo("isGFreeze", (Object)FALSE));
            items.add(new FilterItemInfo("isCFreeze", (Object)FALSE));
        }
        return ClientHelper.getAccountViewCollectionWithDataPermission(ctx, companyId, currencyId, view);
    }

    public static AccountViewCollection getAccountViewCollectionWithDataPermission(Context ctx, String companyId, String currencyId, EntityViewInfo viewInfo) throws BOSException, EASBizException {
        ICompanyOrgUnit iCompany = null;
        iCompany = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitInfo comInfo = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        String strCUId = comInfo.getId().toString();
        String acctTableId = null;
        if (comInfo.getAccountTable() != null) {
            acctTableId = comInfo.getAccountTable().getId().toString();
        }
        IAccountView iAccountView = null;
        iAccountView = ctx != null ? AccountViewFactory.getLocalInstance((Context)ctx) : AccountViewFactory.getRemoteInstance();
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("companyID.id", (Object)strCUId));
        if (acctTableId != null) {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("accountTableID", (Object)acctTableId));
        }
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("accountCurrency.id"));
        selector.add(new SelectorItemInfo("accountCurrency.currency"));
        selector.add(new SelectorItemInfo("accountCurrency.currency.id"));
        selector.add(new SelectorItemInfo("accountCurrency.currency.name"));
        selector.add(new SelectorItemInfo("accountingcurrency"));
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        AccountViewCollection acctViewCol = iAccountView.getAccountViewCollection(viewInfo);
        if (acctViewCol == null || acctViewCol.size() == 0) {
            return null;
        }
        if (currencyId == null) {
            return acctViewCol;
        }
        CurrencyInfo baseCy = ClientHelper.getCompanyBaseCurrency(comInfo);
        String localCurrencyId = "";
        if (baseCy != null) {
            localCurrencyId = baseCy.getId().toString();
        }
        if (localCurrencyId.length() == 0) {
            return acctViewCol;
        }
        AccountViewCollection retColl = new AccountViewCollection();
        AccountCurrencyCollection acctCurColl = null;
        int size = acctViewCol.size();
        block5: for (int i = 0; i < size; ++i) {
            AccountViewInfo acctInfo = acctViewCol.get(i);
            switch (acctInfo.getAccountingcurrency().getValue()) {
                case 2: {
                    retColl.add(acctInfo);
                }
                case 0: {
                    if (localCurrencyId.equals(currencyId)) {
                        retColl.add(acctInfo);
                    }
                }
                case 1: {
                    acctCurColl = acctInfo.getAccountCurrency();
                    for (int j = 0; j < acctCurColl.size(); ++j) {
                        if (!acctCurColl.get(j).getCurrency().getId().toString().equals(currencyId)) continue;
                        retColl.add(acctInfo);
                        continue block5;
                    }
                    continue block5;
                }
            }
        }
        return retColl;
    }

    public static EntityViewInfo getAccountViewEvi(String companyId, String currencyId, EntityViewInfo viewInfo) throws EASBizException, BOSException {
        Set set = ClientHelper.getAcctViewIdSet(companyId, currencyId, viewInfo);
        EntityViewInfo info = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (set == null || set.size() == 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", null));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        }
        info.setFilter(filter);
        return info;
    }

    public static void setSelectedItem(KDComboBox cb, CoreBaseInfo obj) {
        if (obj == null) {
            return;
        }
        ComboBoxModel model = cb.getModel();
        int n = model.getSize();
        for (int i = 0; i < n; ++i) {
            Object element = model.getElementAt(i);
            if (!(element instanceof CoreBaseInfo) || !((CoreBaseInfo)element).getId().equals((Object)obj.getId())) continue;
            cb.setSelectedIndex(i);
            break;
        }
    }

    public static CurrencyInfo getCompanyBaseCurrency(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        CurrencyInfo currency = null;
        if (company == null) {
            return null;
        }
        if (company.getBaseCurrency() != null) {
            return company.getBaseCurrency();
        }
        ICompanyOrgUnit corgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("baseCurrency.*");
        CompanyOrgUnitInfo info = corgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selectors);
        currency = info.getBaseCurrency();
        return currency;
    }

    public static final class IconHelp {
        public static final String ADDNEW = "imgTbtn_new";
        public static final String DELETE = "imgTbtn_delete";
        public static final String VIEW = "imgTbtn_view";
        public static final String EDIT = "imgTbtn_edit";
        public static final String REFRESH = "imgTbtn_refresh";
        public static final String FILTER = "imgTbtn_filter";
        public static final String SAVE = "imgTbtn_save";
        public static final String ADDLINE = "imgTbtn_addline";
        public static final String DELETELINE = "imgTbtn_deleteline";
        public static final String PRINT = "imgTbtn_print";
        public static final String PREVIEW = "imgTbtn_preview";
        public static final String CLOSEINIT = "imgTbtn_closeinitialize";
        public static final String CLOSEALLINIT = "imgTbtn_allfinishinitialize";
        public static final String CANCELINIT = "imgTbtn_finitialize";
        public static final String CANCELALLINIT = "imgTbtn_allfinitialize";
        public static final String TRYBALANCE = "imgTbtn_trialbalance";
        public static final String VOUCHER = "imgTbtn_credence";
    }
}

