/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fi.gl.client.AbstractCompanyTreeSelectUI;
import com.kingdee.eas.base.core.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgBudgetViewInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.stepadd.StepAddParamInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.books.AcountSchemeCollection;
import com.kingdee.eas.fi.books.AcountSchemeFactory;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JDialog;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CompanyTreeSelectUI
extends AbstractCompanyTreeSelectUI {
    private static final long serialVersionUID = -4031913127266965320L;
    private static final String ENABLE_FLAG = "ENABLE_FLAG";
    private static Color disableColor = new Color(77, 77, 77);
    private CompanyOrgUnitInfo root = null;
    private JDialog dialog = null;
    private String accountTableID;
    private String periodTypeID;
    IMetaDataPK uiPK = null;
    IMetaDataPK actionPK = null;
    private boolean force = false;

    public CompanyTreeSelectUI(CompanyOrgUnitInfo root) throws Exception {
        this.root = root;
        this.initUIContentLayout();
        this.btnAdd.setText(null);
        this.btnDelete.setText(null);
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
    }

    public void setBooksModel() throws Exception {
        EventListener[] lister = this.kcbBooks.getListeners(ActionListener.class);
        if (lister != null) {
            for (int i = 0; i < lister.length; ++i) {
                this.kcbBooks.removeActionListener((ActionListener)lister[i]);
            }
        }
        this.kcbBooks.removeAllItems();
        if (BooksUtil.canCreateBook(null)) {
            EntityViewInfo view = new EntityViewInfo();
            SorterItemInfo sorter = new SorterItemInfo("number");
            view.getSorter().add(sorter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("isMaster"));
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isLock", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("accountTable.id", (Object)this.accountTableID));
            filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)this.periodTypeID));
            filter.getFilterItems().add(new FilterItemInfo("isMaster", (Object)new Integer(1)));
            filter.setMaskString(" (#0 and #1 and #2 )or  #3");
            view.setFilter(filter);
            AcountSchemeCollection col = AcountSchemeFactory.getRemoteInstance().getAcountSchemeCollection(view);
            this.kcbBooks.addItems(col.toArray());
            CompanyTreeSelectUI.setSelectedItem(this.kcbBooks, (CoreBaseInfo)BooksUtil.getCurrentBook(null));
        } else {
            this.kcbBooks.addItem((Object)BooksUtil.getCurrentBook(null));
            this.kcbBooks.setEnabled(false);
        }
        if (lister != null) {
            for (int i = 0; i < lister.length; ++i) {
                this.kcbBooks.addActionListener((ActionListener)lister[i]);
            }
        }
    }

    public void setSelectedModel(TreeModel selected) throws Exception {
        if (selected != null) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)selected.getRoot();
            DefaultMutableTreeNode leafNode = this.getFirstLeafNode(root);
            if (leafNode != null) {
                this.setAccountScheme((SimpleCompanyUserObject)leafNode.getUserObject());
            }
            DefaultKingdeeTreeNode aa = this.makeKingdeeTreeNode(root);
            DefaultKingdeeTreeNode root2 = new DefaultKingdeeTreeNode((Object)"");
            root2.add((MutableTreeNode)aa);
            KingdeeTreeModel km = new KingdeeTreeModel((TreeNode)root2);
            this.treeSelected.setModel((TreeModel)km);
            this.treeSelected.setRootVisible(false);
            this.treeSelected.expandAllNodes(true, (TreeNode)root2);
            this.treeSelected.updateUI();
        } else {
            this.treeSelected.setModel((TreeModel)new KingdeeTreeModel((TreeNode)new DefaultKingdeeTreeNode((Object)"")));
        }
    }

    private DefaultKingdeeTreeNode makeKingdeeTreeNode(DefaultMutableTreeNode node) {
        DefaultKingdeeTreeNode dd = new DefaultKingdeeTreeNode(node.getUserObject());
        for (int i = 0; i < node.getChildCount(); ++i) {
            dd.add((MutableTreeNode)this.makeKingdeeTreeNode((DefaultMutableTreeNode)node.getChildAt(i)));
        }
        return dd;
    }

    private void setAccountScheme(SimpleCompanyUserObject companyObj) throws Exception {
        String companyId = companyObj.getCompanyId();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("isAssistantOrg"));
        selector.add(new SelectorItemInfo("accountScheme.id"));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), selector);
        if (company.isIsAssistantOrg() && company.getAccountScheme() != null) {
            CompanyTreeSelectUI.setSelectedItem(this.kcbBooks, (CoreBaseInfo)company.getAccountScheme());
        }
    }

    private DefaultMutableTreeNode getFirstLeafNode(DefaultMutableTreeNode node) {
        if (node.isLeaf()) {
            return node;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode n = this.getFirstLeafNode((DefaultMutableTreeNode)node.getChildAt(i));
            if (n == null) continue;
            return n;
        }
        return null;
    }

    private DefaultKingdeeTreeNode searchRoot(DefaultKingdeeTreeNode root, String rootCompanyId) {
        OrgStructureInfo osi = (OrgStructureInfo)root.getUserObject();
        if (osi == null) {
            return root;
        }
        FullOrgUnitInfo userObject = osi.getUnit();
        String curId = userObject.getId().toString();
        if (curId.equals(rootCompanyId)) {
            return root;
        }
        int n = root.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultKingdeeTreeNode find = this.searchRoot((DefaultKingdeeTreeNode)root.getChildAt(i), rootCompanyId);
            if (find == null) continue;
            return find;
        }
        return null;
    }

    public TreeModel getCompanyTreeModel(String accountTableID, String periodTypeID, Map map, boolean force) throws Exception {
        OrgStructureCollection orgStructCol = this.getOrgStructureCollection(periodTypeID, force);
        DefaultKingdeeTreeNode root = NewOrgViewHelper.buildTreeByRowSet2((String)this.root.getId().toString(), (OrgStructureCollection)orgStructCol, (StepAddParamInfo)StepAddParamInfo.rootAllInstance);
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)root);
        if (root != null && root.getUserObject() != null) {
            this.filterTreeNode(root, map);
            this.clipTreeNode(root);
            this.checkNodeValid(root);
        }
        return treeModel;
    }

    private OrgStructureCollection getOrgStructureCollection(String periodTypeID, boolean force) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        String cpIdSql = this.getFIUnitIDSQL(periodTypeID, force);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("unit.id", (Object)cpIdSql, CompareType.INNER));
        fic.add(new FilterItemInfo("unit.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.NOTEQUALS));
        fic.add(new FilterItemInfo("tree.id", (Object)"00000000-0000-0000-0000-0000000000024F2827FD"));
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isleaf"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("isvalid"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("unit.longNumber"));
        sic.add(new SelectorItemInfo("unit.isCU"));
        sic.add(new SelectorItemInfo("unit.CU.id"));
        sic.add(new SelectorItemInfo("tree.id"));
        sic.add(new SelectorItemInfo("tree.type"));
        sic.add(new SelectorItemInfo("tree.number"));
        AcountSchemeInfo acountScheme = (AcountSchemeInfo)this.kcbBooks.getSelectedItem();
        if (acountScheme != null && !acountScheme.isIsMaster()) {
            sic.add(new SelectorItemInfo("unit.mainorg.name"));
        }
        view.getSorter().add(new SorterItemInfo("longNumber"));
        return OrgStructureFactory.getRemoteInstance().getOrgStructureCollection(view);
    }

    private String getFIUnitIDSQL(String periodTypeID, boolean force) {
        StringBuffer cpIdSql = new StringBuffer();
        cpIdSql.append(" SELECT pcp.fid ");
        cpIdSql.append(" from t_bd_systemstatusctrol ssc ");
        cpIdSql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = ").append(6);
        cpIdSql.append(" inner join t_org_company cp on cp.fid = ssc.fcompanyid ");
        cpIdSql.append(" left outer join T_BD_AcctRefContrast c on c.fcompanyid = cp.fid and c.freftype = 1 ");
        cpIdSql.append(" inner join t_org_company pcp on charindex(pcp.flongnumber||'!', cp.flongnumber) = 1 or pcp.fid = cp.fid ");
        cpIdSql.append(" where ssc.fstartperiodid is not null ");
        AcountSchemeInfo acountScheme = (AcountSchemeInfo)this.kcbBooks.getSelectedItem();
        if (acountScheme == null || acountScheme != null && acountScheme.isIsMaster()) {
            cpIdSql.append(" and cp.fisAssistantOrg = 0");
        } else {
            cpIdSql.append(" and cp.fisAssistantOrg = 1 and cp.faccountschemeid = '").append(acountScheme.getId()).append("'");
        }
        cpIdSql.append(" and (pcp.flongnumber like '").append(this.root.getLongNumber()).append("!%' or pcp.fid = '").append(this.root.getId().toString()).append("')");
        return cpIdSql.toString();
    }

    private void filterTreeNode(DefaultKingdeeTreeNode root, Map orgUnitIDs) {
        if (root != null) {
            OrgUnitInfo unitInfo = this.getUserObject(root);
            if (unitInfo != null) {
                if (orgUnitIDs != null) {
                    Boolean b = (Boolean)orgUnitIDs.get(unitInfo.getId().toString());
                    this.setUserObjectEnable(root, b != null);
                } else {
                    this.setUserObjectEnable(root, true);
                }
            }
            for (int i = 0; i < root.getChildCount(); ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                this.filterTreeNode(node, orgUnitIDs);
            }
        }
    }

    private void setUserObjectEnable(DefaultKingdeeTreeNode node, boolean enable) {
        OrgStructureInfo info;
        if (!enable) {
            this.disableTreeNode(node);
            return;
        }
        if (node.getUserObject() instanceof OrgStructureInfo) {
            info = (OrgStructureInfo)node.getUserObject();
            info.getUnit().put(ENABLE_FLAG, (Object)Boolean.TRUE);
        }
        if (node.getUserObject() instanceof FullOrgUnitInfo) {
            info = (FullOrgUnitInfo)node.getUserObject();
            info.put(ENABLE_FLAG, (Object)Boolean.TRUE);
        }
    }

    private void disableTreeNode(DefaultKingdeeTreeNode treeNode) {
        treeNode.setTextColor(disableColor);
        treeNode.setCheckBoxEnabled(false);
        treeNode.setCheckBoxVisible(false);
    }

    private void clipTreeNode(DefaultKingdeeTreeNode root) {
        DefaultKingdeeTreeNode node = null;
        if (root != null && root.getChildCount() > 0) {
            for (int i = root.getChildCount() - 1; i >= 0; --i) {
                node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                this.clipTreeNode(node);
                if (node.getChildCount() != 0 || this.isUserObjectEnable(node)) continue;
                root.remove((MutableTreeNode)node);
            }
        }
    }

    private boolean isUserObjectEnable(DefaultKingdeeTreeNode node) {
        if (node.getUserObject() instanceof OrgStructureInfo) {
            OrgStructureInfo info = (OrgStructureInfo)node.getUserObject();
            Boolean flag = (Boolean)info.getUnit().get(ENABLE_FLAG);
            return flag != null;
        }
        if (node.getUserObject() instanceof FullOrgUnitInfo) {
            FullOrgUnitInfo info = (FullOrgUnitInfo)node.getUserObject();
            Boolean flag = (Boolean)info.get(ENABLE_FLAG);
            return flag != null;
        }
        return false;
    }

    private void checkNodeValid(DefaultKingdeeTreeNode root) {
        if (root != null) {
            OrgStructureInfo structInfo = (OrgStructureInfo)root.getUserObject();
            if (!structInfo.isIsValid()) {
                root.setTextColor(Color.lightGray);
                root.setCheckBoxEnabled(false);
                root.setCheckBoxVisible(false);
            }
            if (structInfo.getUnit() != null && structInfo.getUnit().getMainOrg() != null) {
                String name = structInfo.getUnit().getMainOrg().getName();
                root.setText(name);
                structInfo.getUnit().setName(name);
            }
            for (int i = 0; i < root.getChildCount(); ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                this.checkNodeValid(node);
            }
        }
    }

    private OrgUnitInfo getUserObject(DefaultKingdeeTreeNode node) {
        if (node.getUserObject() instanceof OrgStructureInfo) {
            OrgStructureInfo info = (OrgStructureInfo)node.getUserObject();
            return info.getUnit();
        }
        if (node.getUserObject() instanceof OrgBudgetViewInfo) {
            OrgBudgetViewInfo info = (OrgBudgetViewInfo)node.getUserObject();
            return info.getOrgUnitInfo();
        }
        if (node.getUserObject() instanceof OrgUnitInfo) {
            return (OrgUnitInfo)node.getUserObject();
        }
        return null;
    }

    public void buildCompanyTree(IMetaDataPK uipk, IMetaDataPK actionpk, boolean force) throws Exception {
        TreeModel tm;
        DefaultKingdeeTreeNode root;
        if (this.uiPK == null) {
            this.setUiPK(uipk);
        }
        if (this.actionPK == null) {
            this.setActionPK(actionpk);
        }
        this.force = force;
        boolean isPerm = false;
        Map ret = null;
        if (isPerm) {
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            ObjectUuidPK orgViewPK = new ObjectUuidPK(BOSUuid.read((String)"00000000-0000-0000-0000-0000000000024F2827FD"));
            ret = iPermission.getAuthorizedOrgs((IObjectPK)userPK, OrgType.Company, (IObjectPK)orgViewPK, this.uiPK, this.actionPK);
        }
        if ((root = this.searchRoot((DefaultKingdeeTreeNode)(tm = this.getCompanyTreeModel(this.accountTableID, this.periodTypeID, ret, force)).getRoot(), this.root.getId().toString())) == null) {
            this.treeOrigin.setModel(null);
            this.treeSelected.setModel(null);
            this.btnOK.setEnabled(false);
            return;
        }
        if (root.getUserObject() == null) {
            this.btnAdd.setEnabled(false);
            this.btnDelete.setEnabled(false);
            this.btnOK.setEnabled(false);
            this.treeOrigin.setModel(null);
            this.treeSelected.setModel(null);
            return;
        }
        this.btnOK.setEnabled(true);
        this.btnAdd.setEnabled(true);
        this.btnDelete.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.treeSelected.setModel((TreeModel)new KingdeeTreeModel((TreeNode)new DefaultKingdeeTreeNode((Object)"")));
        DefaultTreeModel dtm = new DefaultTreeModel((TreeNode)root);
        this.treeOrigin.setModel((TreeModel)dtm);
        root = (DefaultKingdeeTreeNode)this.treeOrigin.getModel().getRoot();
        root.setParent(null);
        this.treeOrigin.expandAllNodes(true, (TreeNode)root);
        KingdeeTreeModel treeModel = (KingdeeTreeModel)this.treeSelected.getModel();
        if (treeModel.getRoot() != null) {
            DefaultKingdeeTreeNode root2 = new DefaultKingdeeTreeNode((Object)"");
            treeModel.setRoot((TreeNode)root2);
            this.treeSelected.setRootVisible(false);
            this.treeSelected.setShowsRootHandles(true);
        }
    }

    private void add() {
        TreePath[] tps = this.treeOrigin.getSelectionPaths();
        if (tps == null) {
            return;
        }
        block0: for (int i = 0; i < tps.length; ++i) {
            DefaultKingdeeTreeNode rightRoot;
            TreePath tp = tps[i];
            DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
            DefaultKingdeeTreeNode findNode = this.findNode(selectedNode, rightRoot = (DefaultKingdeeTreeNode)((KingdeeTreeModel)this.treeSelected.getModel()).getRoot());
            if (findNode != null) {
                DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)findNode.getParent();
                findNode.removeFromParent();
                ((KingdeeTreeModel)this.treeSelected.getModel()).nodeStructureChanged((TreeNode)parent);
            }
            DefaultKingdeeTreeNode toNode = null;
            for (int j = 0; j < tp.getPathCount(); ++j) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tp.getPathComponent(j);
                DefaultKingdeeTreeNode temp = null;
                temp = this.findNode(node, (DefaultKingdeeTreeNode)this.treeSelected.getModel().getRoot());
                if (temp == null) {
                    this.addTo(toNode, tp, j);
                    continue block0;
                }
                toNode = temp;
            }
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeSelected.getModel().getRoot();
        this.treeSelected.expandAllNodes(true, (TreeNode)root);
    }

    private void addTo(DefaultKingdeeTreeNode toNode, TreePath tp, int from) {
        DefaultKingdeeTreeNode root = null;
        while (from < tp.getPathCount()) {
            DefaultKingdeeTreeNode oriChild = (DefaultKingdeeTreeNode)tp.getPathComponent(from);
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)oriChild.clone();
            if (from == tp.getPathCount() - 1) {
                this.cloneTree(child, oriChild);
            }
            if (toNode == null) {
                root = (DefaultKingdeeTreeNode)((KingdeeTreeModel)this.treeSelected.getModel()).getRoot();
                ((KingdeeTreeModel)this.treeSelected.getModel()).insertNodeInto((MutableTreeNode)child, (MutableTreeNode)root, 0);
            } else {
                DefaultKingdeeTreeNode sibling = oriChild;
                DefaultKingdeeTreeNode found = null;
                while ((sibling = (DefaultKingdeeTreeNode)sibling.getNextSibling()) != null && (found = this.findNode(sibling, toNode)) == null) {
                }
                if (found != null) {
                    toNode.insert((MutableTreeNode)child, toNode.getIndex((TreeNode)found));
                } else {
                    toNode.add((MutableTreeNode)child);
                }
                ((KingdeeTreeModel)this.treeSelected.getModel()).nodeStructureChanged((TreeNode)toNode);
            }
            toNode = child;
            ++from;
        }
    }

    private void cloneTree(DefaultKingdeeTreeNode root, DefaultKingdeeTreeNode oriRoot) {
        for (int i = 0; i < oriRoot.getChildCount(); ++i) {
            DefaultKingdeeTreeNode oriChild = (DefaultKingdeeTreeNode)oriRoot.getChildAt(i);
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)oriChild.clone();
            root.add((MutableTreeNode)child);
            this.cloneTree(child, oriChild);
        }
    }

    DefaultKingdeeTreeNode findNode(DefaultKingdeeTreeNode source, DefaultKingdeeTreeNode dest) {
        if (dest == null) {
            return null;
        }
        OrgStructureInfo osi = (OrgStructureInfo)source.getUserObject();
        if (osi == null) {
            return null;
        }
        String sid = osi.getUnit().getId().toString();
        Object obj = dest.getUserObject();
        if (obj instanceof OrgStructureInfo ? sid.equals(((OrgStructureInfo)obj).getUnit().getId().toString()) : obj instanceof SimpleCompanyUserObject && sid.equals(((SimpleCompanyUserObject)obj).getCompanyId())) {
            return dest;
        }
        for (int i = 0; i < dest.getChildCount(); ++i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)dest.getChildAt(i);
            if ((child = this.findNode(source, child)) == null) continue;
            return child;
        }
        return null;
    }

    private void delete(KDTree tree) {
        TreePath[] tps = tree.getSelectionPaths();
        if (tps == null) {
            return;
        }
        for (int i = 0; i < tps.length; ++i) {
            TreePath tp = tps[i];
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
            while (node.getParent() != null && node.getParent().getChildCount() == 1 && node.getParent().getParent() != null) {
                tp = tp.getParentPath();
                node = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
            }
            if (node.getParent() != null && node.getParent().getChildCount() == 1 && node.getParent().getParent() != null) {
                node = (DefaultKingdeeTreeNode)node.getParent();
            }
            if (node.getParent() instanceof DefaultKingdeeTreeNode) {
                ((DefaultTreeModel)tree.getModel()).removeNodeFromParent((MutableTreeNode)node);
                continue;
            }
            KDTreeNode parent = (KDTreeNode)node.getParent();
            if (parent == null) continue;
            ((DefaultTreeModel)tree.getModel()).removeNodeFromParent((MutableTreeNode)node);
        }
    }

    public void makeSimpleTree(DefaultMutableTreeNode bigNode, DefaultMutableTreeNode simpleNode, int beginLevel) {
        SimpleCompanyUserObject newUserObject = null;
        Object obj = bigNode.getUserObject();
        if (obj instanceof SimpleCompanyUserObject) {
            newUserObject = (SimpleCompanyUserObject)((SimpleCompanyUserObject)obj).clone();
        } else {
            FullOrgUnitInfo userObject = ((OrgStructureInfo)obj).getUnit();
            newUserObject = new SimpleCompanyUserObject();
            String companyId = userObject.getId().toString();
            String longNumber = userObject.getLongNumber();
            String number = userObject.getNumber();
            String name = userObject.getName();
            boolean isLeaf = bigNode.isLeaf();
            int level = bigNode.getLevel() - beginLevel;
            if (userObject.isIsCU()) {
                newUserObject.setCuId(companyId);
            } else if (userObject.getCU() != null) {
                newUserObject.setCuId(userObject.getCU().getId().toString());
            }
            newUserObject.setCompanyId(companyId);
            newUserObject.setLongNumber(longNumber);
            newUserObject.setName(name);
            newUserObject.setNumber(number);
            newUserObject.setLeaf(isLeaf);
            newUserObject.setLevel(level);
        }
        simpleNode.setUserObject(newUserObject);
        Enumeration<TreeNode> enums = bigNode.children();
        while (enums.hasMoreElements()) {
            bigNode = (DefaultMutableTreeNode)enums.nextElement();
            DefaultMutableTreeNode simpleNode2 = new DefaultMutableTreeNode();
            simpleNode.add(simpleNode2);
            this.makeSimpleTree(bigNode, simpleNode2, beginLevel);
        }
    }

    private void confirm() {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)((KingdeeTreeModel)this.treeSelected.getModel()).getRoot();
        if (root.getChildCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)CompanyTreeSelectUI.getRes("select_company_please"));
            return;
        }
        DefaultMutableTreeNode simpleRoot = new DefaultMutableTreeNode();
        DefaultMutableTreeNode bigNode = (DefaultMutableTreeNode)root.getChildAt(0);
        this.makeSimpleTree(bigNode, simpleRoot, bigNode.getLevel());
        DefaultTreeModel newValue = new DefaultTreeModel(simpleRoot, false);
        this.firePropertyChange("companyChanged", null, newValue);
        this.dialog.setVisible(false);
    }

    private void cancel() {
        this.dialog.setVisible(false);
    }

    @Override
    public void addAction_actionPerformed(ActionEvent e) throws Exception {
        this.add();
    }

    @Override
    public void cancelAction_actionPerformed(ActionEvent e) throws Exception {
        this.cancel();
    }

    @Override
    public void deleteAction_actionPerformed(ActionEvent e) throws Exception {
        this.delete(this.treeSelected);
    }

    @Override
    protected void kcbBooks_actionPerformed(ActionEvent e) throws Exception {
        this.treeSelected.setSelectionRow(0);
        this.delete(this.treeSelected);
        this.treeOrigin.setSelectionRow(0);
        this.delete(this.treeOrigin);
        this.buildCompanyTree(this.uiPK, this.actionPK, this.force);
    }

    @Override
    public void oKAction_actionPerformed(ActionEvent e) throws Exception {
        this.confirm();
    }

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    public void setAccountTableID(String accountTableID) {
        this.accountTableID = accountTableID;
    }

    public void setPeriodTypeID(String periodTypeID) {
        this.periodTypeID = periodTypeID;
    }

    public void setActionPK(IMetaDataPK actionPK) {
        this.actionPK = actionPK;
    }

    public void setUiPK(IMetaDataPK uiPK) {
        this.uiPK = uiPK;
    }

    private static void setSelectedItem(KDComboBox cb, CoreBaseInfo obj) {
        if (obj == null) {
            return;
        }
        ComboBoxModel model = cb.getModel();
        int n = model.getSize();
        for (int i = 0; i < n; ++i) {
            Object element = model.getElementAt(i);
            if (!(element instanceof CoreBaseInfo) || !((CoreBaseInfo)element).getId().equals((Object)obj.getId())) continue;
            cb.setSelectedIndex(i);
            break;
        }
    }

    private static String getRes(String resKey) {
        String resName = "com.kingdee.eas.base.core.fi.gl.GLXResource";
        return EASResource.getString((String)resName, (String)resKey);
    }
}

