/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.FeeTypeFactory;
import com.kingdee.eas.fi.cas.client.AbstractFeeTypeListUI;
import com.kingdee.eas.fi.cas.client.FeeTypeEditUI;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.query.QuickFilteringSupportManager;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeSelectionListener;
import org.apache.log4j.Logger;

public class FeeTypeListUI
extends AbstractFeeTypeListUI {
    private static final Logger logger = CoreUIObject.getLogger(FeeTypeListUI.class);
    private FeeTypeItemTreeRender treeRender;
    QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    protected void initWorkButton() {
        super.initWorkButton();
        Component[] coms = this.toolBar.getComponents();
        for (int index = 0; index < coms.length; ++index) {
            Component com = coms[index];
            if (!(com instanceof KDWorkButton) || !"\u9ad8\u7ea7\u7edf\u8ba1".equals(((KDWorkButton)com).getText())) continue;
            com.setVisible(false);
        }
        this.btnDefaultMsg.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.actionDefaultMsg.setEnabled(true);
        this.chkShowAll.setVisible(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.treeRender = new FeeTypeItemTreeRender();
        this.tblMain.getColumn("number").setRenderer((IBasicRender)this.treeRender);
        this.tblMain.setRefresh(true);
        this.tblMain.reLayoutAndPaint();
        if (this.treeMain.getRowCount() >= 1) {
            this.treeMain.setSelectionRow(0);
        }
        this.tblMain.setColumnMoveable(true);
        this.tblMain.getColumn("level").getStyleAttributes().setNumberFormat("@");
    }

    protected String getKeyFieldName() {
        return "id";
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int selectRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (selectRow == -1) {
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    protected String getEditUIName() {
        return FeeTypeEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FeeTypeFactory.getRemoteInstance();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isleaf", (Object)Constants.FALSE));
        return filter;
    }

    @Override
    public void actionShowAll_actionPerformed(ActionEvent e) throws Exception {
        this.treeMain_valueChanged(null);
    }

    @Override
    public void actionDefaultMsg_actionPerformed(ActionEvent e) throws Exception {
        super.actionDefaultMsg_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create("com.kingdee.eas.fi.cas.client.FeeTypeDefaultMsgListUI", (Map)uiContext, null, null);
        window.show();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return FeeTypeFactory.getRemoteInstance();
    }

    protected String getRootName() {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = loader.getEntity((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.cas.app.FeeType"));
        return entity.getAlias();
    }

    protected boolean isIncludeAllChildren() {
        return true;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int start = e.getFirstRow();
                int end = e.getLastRow();
                for (int i = start; i <= end; ++i) {
                    IRow row = FeeTypeListUI.this.tblMain.getRow(i);
                    if (row == null) continue;
                    row.getStyleAttributes().setHided(false);
                }
                FeeTypeListUI.this.setTreeDisplayStyle(start, end + 1);
            }
        });
    }

    private void setTreeDisplayStyle(int start, int end) {
        int count = end;
        for (int i = start; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            String id = (String)row.getCell("id").getValue();
            int level = (Integer)row.getCell("level").getValue();
            Object longNumber = row.getCell("longNumber").getValue();
            Object number = row.getCell("number").getValue();
            if (!(number instanceof String) || !(longNumber instanceof String)) {
                return;
            }
            boolean isFpItemLeaf = (Boolean)row.getCell("isLeaf").getValue();
            NumberExpandInfo fpItemNumberExpandInfo = new NumberExpandInfo();
            fpItemNumberExpandInfo.setFeeTypeId(id);
            fpItemNumberExpandInfo.setLevel(level);
            fpItemNumberExpandInfo.setLeaf(isFpItemLeaf);
            fpItemNumberExpandInfo.setExpandStatus(true);
            fpItemNumberExpandInfo.setNumber(number.toString());
            fpItemNumberExpandInfo.setLongNumber(longNumber.toString());
            row.getCell("number").setValue((Object)fpItemNumberExpandInfo);
        }
    }

    protected boolean isOrderForClickTableHead() {
        return false;
    }

    public void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int columnIndex;
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 1 && (columnIndex = e.getColIndex()) == 1) {
            int rowIndex = e.getRowIndex();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return;
            }
            NumberExpandInfo numberExpandInfo = (NumberExpandInfo)row.getCell("number").getValue();
            if (this.treeRender.inRect(numberExpandInfo, e.getX(), e.getY())) {
                this.setTreeDisplayStyle(row);
            }
            return;
        }
    }

    private void setTreeDisplayStyle(IRow row) {
        boolean isFpItemLeaf = (Boolean)row.getCell("isLeaf").getValue();
        if (isFpItemLeaf) {
            return;
        }
        this.expandFpItem(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandFpItem(IRow row) {
        NumberExpandInfo fpItemNumberExpandInfo = (NumberExpandInfo)row.getCell("number").getValue();
        String fpItemNumber = fpItemNumberExpandInfo.getLongNumber();
        boolean isExpandStatus = fpItemNumberExpandInfo.isExpandStatus();
        String fpItemId = (String)row.getCell("id").getValue();
        if (isExpandStatus) {
            IRow child;
            NumberExpandInfo childNumberExpandInfo;
            String childNumber;
            fpItemNumberExpandInfo.setExpandStatus(false);
            this.tblMain.setRefresh(false);
            int count = this.tblMain.getRowCount();
            for (int i = row.getRowIndex() + 1; i < count && (childNumber = (childNumberExpandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(i)).getCell("number").getValue()).getLongNumber()).startsWith(fpItemNumber + "!"); ++i) {
                child.getStyleAttributes().setHided(true);
            }
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        } else {
            IRow child;
            NumberExpandInfo childNumberExpandInfo;
            String childNumber;
            IRow next;
            NumberExpandInfo nextNumberExpandInfo;
            fpItemNumberExpandInfo.setExpandStatus(true);
            int i = row.getRowIndex() + 1;
            boolean hasChildrenDataGotten = false;
            if (i < this.tblMain.getRowCount() && (nextNumberExpandInfo = (NumberExpandInfo)(next = this.tblMain.getRow(i)).getCell("number").getValue()).getLongNumber().startsWith(fpItemNumber)) {
                hasChildrenDataGotten = true;
            }
            if (!hasChildrenDataGotten) {
                this.setCursorOfWair();
                EntityViewInfo childQuery = new EntityViewInfo();
                FilterInfo childFilter = new FilterInfo();
                childQuery.setFilter(childFilter);
                childFilter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)fpItemId));
                if (this.mainQuery.getFilter() != null && this.mainQuery.getFilter().getFilterItems().size() > 0) {
                    try {
                        childFilter.mergeFilter(this.mainQuery.getFilter(), "and");
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                }
                IRowSet rowset = null;
                try {
                    rowset = this.getQueryExecutor(this.mainQueryPK, childQuery).executeQuery();
                    if (rowset != null && rowset.size() > 0) {
                        int start = row.getRowIndex() + 1;
                        while (rowset.next()) {
                            IRow child2 = this.tblMain.addRow(start);
                            ++start;
                            int colcount = this.tblMain.getColumnCount();
                            for (int col = 0; col < colcount; ++col) {
                                IColumn column = this.tblMain.getColumn(col);
                                String field = column.getFieldName();
                                if (field == null || field.length() < 1) continue;
                                Object value = rowset.getObject(field);
                                if (field.equals("number")) {
                                    NumberExpandInfo childNumberExpandInfo2 = new NumberExpandInfo();
                                    childNumberExpandInfo2.setFeeTypeId(rowset.getString("id"));
                                    childNumberExpandInfo2.setLevel(rowset.getInt("level"));
                                    childNumberExpandInfo2.setLeaf(rowset.getBoolean("isLeaf"));
                                    childNumberExpandInfo2.setNumber(rowset.getString("number"));
                                    childNumberExpandInfo2.setLongNumber(rowset.getString("longNumber"));
                                    childNumberExpandInfo2.setExpandStatus(false);
                                    value = childNumberExpandInfo2;
                                }
                                child2.getCell(col).setValue(value);
                            }
                        }
                        this.tblMain.setRowCount(this.tblMain.getRowCount() + rowset.size());
                    }
                }
                catch (BOSException e) {
                    this.handleException((Exception)((Object)e));
                }
                catch (SQLException e) {
                    this.handleException(e);
                }
                finally {
                    this.setCursorOfDefault();
                }
            }
            int count = this.tblMain.getRowCount();
            while (i < count && (childNumber = (childNumberExpandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(i)).getCell("number").getValue()).getLongNumber()).startsWith(fpItemNumber + "!")) {
                String parentId = (String)child.getCell("parent.id").getValue();
                if (parentId.equals(fpItemId)) {
                    this.expandChildFpItem(child);
                }
                ++i;
            }
        }
    }

    private void expandChildFpItem(IRow row) {
        NumberExpandInfo acctNumberExpandInfo = (NumberExpandInfo)row.getCell("number").getValue();
        String fpItemNumber = acctNumberExpandInfo.getLongNumber();
        boolean isExpandStatus = acctNumberExpandInfo.isExpandStatus();
        String fpItemId = (String)row.getCell("id").getValue();
        row.getStyleAttributes().setHided(false);
        if (isExpandStatus) {
            IRow child;
            NumberExpandInfo childNumberExpandInfo;
            String childNumber;
            int count = this.tblMain.getRowCount();
            for (int i = row.getRowIndex() + 1; i < count && (childNumber = (childNumberExpandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(i)).getCell("number").getValue()).getLongNumber()).startsWith(fpItemNumber + "!"); ++i) {
                String parentId = (String)child.getCell("parent.id").getValue();
                if (!parentId.equals(fpItemId)) continue;
                this.expandChildFpItem(child);
            }
        }
    }

    protected EntityViewInfo getDefaultEntityViewInfo() {
        EntityViewInfo entityViewInfo = super.getDefaultEntityViewInfo();
        if (entityViewInfo == null) {
            entityViewInfo = new EntityViewInfo();
        }
        return entityViewInfo;
    }

    protected void execQuery() {
        try {
            if (this.getDefaultEntityViewInfo() != null) {
                this.mainQuery.getFilter().mergeFilter(this.getDefaultEntityViewInfo().getFilter(), "AND");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.handleException((Exception)((Object)e));
        }
        super.execQuery();
    }

    protected void SelectNode() throws EASBizException, BOSException, Exception {
        KDTreeNode selectNode = this.getSelectedTreeNode();
        super.SelectNode();
        TreeSelectionListener[] listeners = this.treeMain.getTreeSelectionListeners();
        this.treeMain.removeTreeSelectionListener(listeners[0]);
        this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)selectNode);
        this.treeMain.addTreeSelectionListener(listeners[0]);
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        return this.qfsi.supportExecutionWithoutFilters();
    }

    protected QuickFilteringSupportManager createQuickFilteringSupportManager() throws Exception {
        QuickFilteringSupportManager manager = super.createQuickFilteringSupportManager();
        this.getQuickFilteringSupport().setMustQueryAtFirst(true);
        return manager;
    }

    @Override
    public void actionEnable_actionPerformed(ActionEvent e) throws Exception {
        this.setEnable(true);
        super.actionRefresh_actionPerformed(e);
        this.execQuery();
    }

    @Override
    public void actionDisable_actionPerformed(ActionEvent e) throws Exception {
        this.setEnable(false);
        super.actionRefresh_actionPerformed(e);
        this.execQuery();
    }

    private void setEnable(boolean enable) throws Exception {
        this.checkSelected();
        String cancelMsg = "";
        cancelMsg = enable ? EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel") : EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        if (this.confirmDialog(cancelMsg)) {
            ArrayList idList = this.getSelectedIdValues();
            Set idSet = FMHelper.list2Set((List)idList);
            FeeTypeFactory.getRemoteInstance().setEnable(idSet, enable);
            this.cancel();
        }
    }

    private class FeeTypeItemTreeRender
    implements IBasicRender {
        private int TABSIZE = 8;
        private int ICONSIZE = 10;
        private int margin = 2;
        protected SimpleTextRender simpleRender = new SimpleTextRender();
        protected HashMap feeTypeIdToPos = new HashMap();

        private FeeTypeItemTreeRender() {
        }

        protected void drawExpanded(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
            g.drawLine(x + this.ICONSIZE / 2, y + this.margin, x + this.ICONSIZE / 2, y + this.margin + lineSize);
        }

        protected void drawLeaf(Graphics g, int x, int y) {
            int lineSize = this.ICONSIZE - 2 * this.margin;
        }

        public boolean inRect(NumberExpandInfo numberExpandInfo, int x, int y) {
            String feeTypeId = numberExpandInfo.getFeeTypeId();
            Rectangle rec = (Rectangle)this.feeTypeIdToPos.get(feeTypeId);
            if (rec != null) {
                return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
            }
            return false;
        }

        public void draw(Graphics graphics, Shape clip, Object obj, Style style) {
            if (obj instanceof NumberExpandInfo) {
                NumberExpandInfo numberExpandInfo = (NumberExpandInfo)obj;
                int ident = numberExpandInfo.getLevel() * this.TABSIZE;
                Rectangle rect = clip.getBounds();
                int x = rect.x + ident;
                int y = rect.y + (rect.height - this.ICONSIZE) / 2;
                Rectangle iconRect = new Rectangle(x, y, this.ICONSIZE, this.ICONSIZE);
                this.feeTypeIdToPos.put(numberExpandInfo.getFeeTypeId(), iconRect);
                this.simpleRender.draw(graphics, (Shape)new Rectangle(x + this.ICONSIZE + this.TABSIZE, rect.y, rect.width - x - this.ICONSIZE - this.TABSIZE, rect.height), numberExpandInfo.getNumber(), style);
                this.paintIcon(graphics, numberExpandInfo, iconRect);
            } else if (obj != null) {
                this.simpleRender.draw(graphics, clip, obj.toString(), style);
            }
        }

        private void paintIcon(Graphics graphics, NumberExpandInfo numberExpandInfo, Rectangle iconRect) {
            if (numberExpandInfo.isLeaf()) {
                this.drawLeaf(graphics, iconRect.x, iconRect.y);
            } else if (numberExpandInfo.isExpandStatus()) {
                this.drawExpanded(graphics, iconRect.x, iconRect.y);
            } else if (!numberExpandInfo.isExpandStatus()) {
                this.drawCollapsed(graphics, iconRect.x, iconRect.y);
            }
        }
    }

    private class NumberExpandInfo {
        private String feeTypeId;
        private String number;
        private boolean isExpandStatus;
        private int level;
        private boolean isLeaf;
        private String longNumber;

        private NumberExpandInfo() {
        }

        public void setLongNumber(String longNumber) {
            this.longNumber = longNumber;
        }

        public String getLongNumber() {
            return this.longNumber;
        }

        public boolean isExpandStatus() {
            return this.isExpandStatus;
        }

        public void setExpandStatus(boolean isExpandStatus) {
            this.isExpandStatus = isExpandStatus;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String toString() {
            return this.number;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public void setLeaf(boolean isLeaf) {
            this.isLeaf = isLeaf;
        }

        public String getFeeTypeId() {
            return this.feeTypeId;
        }

        public void setFeeTypeId(String feeTypeId) {
            this.feeTypeId = feeTypeId;
        }
    }
}

