/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.subacct.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.client.f7.F7ContextInitializationHelper;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.util.BaseDataF7ContextUtil;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.cas.subacct.SubAccountException;
import com.kingdee.eas.fi.cas.subacct.SubAccountFactory;
import com.kingdee.eas.fi.cas.subacct.SubAccountInfo;
import com.kingdee.eas.fi.cas.subacct.client.AbstractSubAccountEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class SubAccountEditUI
extends AbstractSubAccountEditUI {
    private static final Logger logger = CoreUIObject.getLogger(SubAccountEditUI.class);

    protected IObjectValue createNewData() {
        SubAccountInfo subAccountInfo = new SubAccountInfo();
        if (subAccountInfo.getCompany() == null) {
            subAccountInfo.setCompany(ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        }
        subAccountInfo.setIsClosed(false);
        return subAccountInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SubAccountFactory.getRemoteInstance();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            if (OprtState.EDIT.equals(this.getOprtState()) && SubAccountFactory.getRemoteInstance().referCondition(this.editData.getId())) {
                this.prmtRelationalUnit.setEditable(false);
                this.prmtBank.setEditable(false);
                this.prmtAccountBank.setEditable(false);
                this.prmtRelationalUnit.setEnabled(false);
                this.prmtBank.setEnabled(false);
                this.prmtAccountBank.setEnabled(false);
            }
            if (this.prmtRelationalUnit.getValue() == null) {
                this.prmtInnerAccount.setEditable(false);
                this.prmtInnerAccount.setEnabled(false);
            }
            BaseDataF7ContextUtil.initBankTree(null, (KDBizPromptBox)this.prmtBank);
            this.initCompanyTreeF7();
            this.initPayeeTreeF7();
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.subacct.SubAccountResource", (String)"EDIT_LOAD_FIELDS"));
            SysUtil.abort((Throwable)e);
        }
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("bank.*");
        this.prmtAccountBank.setSelectorCollection(selectors);
        try {
            this.settleSubTable();
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
            e.printStackTrace();
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if (OprtState.EDIT.equals(this.getOprtState())) {
            boolean isRef = false;
            boolean isClosed = false;
            try {
                isRef = SubAccountFactory.getRemoteInstance().referCondition(((SubAccountInfo)this.getDataObject()).getId());
                isClosed = ((SubAccountInfo)this.getDataObject()).isIsClosed();
            }
            catch (BOSException e) {
                e.printStackTrace();
                this.handUIException(e.getCause());
            }
            this.prmtRelationalUnit.setEnabled(!isRef);
            this.prmtBank.setEnabled(!isRef);
            this.prmtAccountBank.setEnabled(!isRef);
            this.actionCancel.setEnabled(!isClosed);
            this.actionCancelCancel.setEnabled(isClosed);
            boolean hasAccountBank = this.kdtaccountBank.getRowCount1() > 0;
            this.prmtRelationalUnit.setEnabled(!hasAccountBank);
            this.prmtBank.setEnabled(!hasAccountBank);
            this.prmtAccountBank.setEnabled(!hasAccountBank);
        } else if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.prmtRelationalUnit.setEnabled(true);
            this.prmtBank.setEnabled(true);
            this.prmtAccountBank.setEnabled(true);
        }
    }

    @Override
    protected void prmtRelationalUnit_dataChanged(DataChangeEvent e) throws Exception {
        CompanyOrgUnitInfo relaUnit = (CompanyOrgUnitInfo)this.prmtRelationalUnit.getValue();
        if (relaUnit != null && !relaUnit.isIsBizUnit()) {
            this.prmtRelationalUnit.setValue(null);
            throw new SubAccountException(SubAccountException.RALATIONAL_BIZUNIT);
        }
        if (this.prmtRelationalUnit.getValue() == null) {
            this.prmtInnerAccount.setValue(null);
            this.prmtInnerAccount.setEditable(false);
            this.prmtInnerAccount.setEnabled(false);
        } else {
            this.prmtInnerAccount.setEnabled(true);
            this.prmtInnerAccount.setEditable(true);
            this.prmtInnerAccount.setValue(null);
        }
        super.prmtRelationalUnit_dataChanged(e);
    }

    @Override
    protected void prmtInnerAccount_willCommit(CommitEvent e) throws Exception {
        this.putInnerAccountFilter();
        super.prmtInnerAccount_willCommit(e);
    }

    @Override
    protected void prmtInnerAccount_willShow(SelectorEvent e) throws Exception {
        this.putInnerAccountFilter();
        super.prmtInnerAccount_willShow(e);
    }

    @Override
    protected void prmtAccountBank_willCommit(CommitEvent e) throws Exception {
        this.putRelativeParentAccountFilter();
        super.prmtAccountBank_willCommit(e);
    }

    @Override
    protected void prmtAccountBank_willShow(SelectorEvent e) throws Exception {
        this.putRelativeParentAccountFilter();
        super.prmtAccountBank_willShow(e);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        ClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        this.checkRelationalUnit();
        this.checkInnerPayee();
        this.checkSameTopBank();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkRelaOrgBank() && MsgBox.isCancel((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.subacct.SubAccountResource", (String)"sameBankMutilAcct")))) {
            return;
        }
        super.actionSubmit_actionPerformed(e);
    }

    private void checkRelationalUnit() throws SubAccountException {
        CompanyOrgUnitInfo relationUnit = (CompanyOrgUnitInfo)this.prmtRelationalUnit.getValue();
        if (relationUnit == null) {
            return;
        }
        if (!relationUnit.isIsBizUnit()) {
            throw new SubAccountException(SubAccountException.RALATIONAL_BIZUNIT);
        }
    }

    private void checkInnerPayee() throws SubAccountException {
        if (this.prmtAccountView.getValue() != null && this.prmtInnerAccount.getValue() != null) {
            throw new SubAccountException(SubAccountException.PAYEE_INNER_BOTH);
        }
        if (this.prmtAccountView.getValue() == null && this.prmtInnerAccount.getValue() == null) {
            throw new SubAccountException(SubAccountException.PAYEE_INNER_NULL);
        }
    }

    private boolean checkRelaOrgBank() throws SubAccountException, BOSException {
        CompanyOrgUnitInfo comOrgInfo = (CompanyOrgUnitInfo)this.prmtRelationalUnit.getValue();
        if (comOrgInfo == null || comOrgInfo.getId() == null) {
            return false;
        }
        String comID = comOrgInfo.getId().toString();
        BankInfo subAcc = (BankInfo)this.prmtBank.getValue();
        if (subAcc == null) {
            return false;
        }
        if (subAcc.getLongNumber() == null) {
            return false;
        }
        String topNum = subAcc.getLongNumber().split("!")[0];
        String mainId = null;
        if (this.editData != null && this.editData.getId() != null) {
            mainId = this.editData.getId().toString();
        }
        return !this.editData.isIsClosed() && !SubAccountFactory.getRemoteInstance().monoCombine(comID, topNum, mainId);
    }

    private void checkSameTopBank() throws SubAccountException {
        BankInfo subAcc = (BankInfo)this.prmtBank.getValue();
        if (subAcc == null || EmptyUtil.isEmpty((String)subAcc.getLongNumber())) {
            return;
        }
        String bankTopNum = subAcc.getLongNumber().split("!")[0];
        AccountBankInfo acctBankInfo = (AccountBankInfo)this.prmtAccountBank.getValue();
        if (acctBankInfo == null || acctBankInfo.getBank() == null) {
            return;
        }
        String parentAccLongN = acctBankInfo.getBank().getLongNumber();
        if (EmptyUtil.isEmpty((String)parentAccLongN)) {
            return;
        }
        String parentTopNum = parentAccLongN.split("!")[0];
        if (!(EmptyUtil.isEmpty((String)bankTopNum) || EmptyUtil.isEmpty((String)parentTopNum) || bankTopNum.equals(parentTopNum))) {
            throw new SubAccountException(SubAccountException.PARENT_BANK_SAMETOP);
        }
    }

    private void settleSubTable() throws BOSException {
        this.kdtaccountBank.removeRows();
        this.kdtaccountBank.checkParsed();
        String id = null;
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        id = this.editData.getId().toString();
        AccountBankCollection coll = this.getParentAccountBankCol(id);
        if (coll == null || coll.size() == 0) {
            return;
        }
        IRow row = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            row = this.kdtaccountBank.addRow();
            AccountBankInfo info = coll.get(i);
            row.getCell("name").setValue((Object)(info.getBankAccountNumber() + " " + info.getName()));
            row.getCell("property.name").setValue((Object)info.getAccountType().getAlias());
            row.getCell("bank.name").setValue((Object)info.getBank().getName());
            row.getCell("id").setValue((Object)info.getId());
        }
    }

    private AccountBankCollection getParentAccountBankCol(String accId) throws BOSException {
        if (EmptyUtil.isEmpty((String)accId)) {
            return new AccountBankCollection();
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.getSelector().add("bank.*");
        evi.getSelector().add("property.*");
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("subAccount.id", (Object)accId));
        IAccountBank iAccBank = AccountBankFactory.getRemoteInstance();
        AccountBankCollection coll = iAccBank.getAccountBankCollection(evi);
        return coll;
    }

    private void initCompanyTreeF7() {
        NewCompanyF7 companyF7 = F7ContextInitializationHelper.getSelectCompany((IUIObject)this, null, null, (boolean)false);
        if (companyF7 == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        this.prmtRelationalUnit.setEntityViewInfo(view);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        companyF7.setNeedAddOrgRange(false);
        this.prmtRelationalUnit.setSelector((KDPromptSelector)companyF7);
    }

    private void initPayeeTreeF7() {
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        String companyId = companyInfo.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Boolean(true)));
        AccountPromptBox opseelect = new AccountPromptBox((IUIObject)this, companyInfo, view.getFilter(), false, true);
        this.prmtAccountView.setEntityViewInfo(view);
        this.prmtAccountView.setSelector((KDPromptSelector)opseelect);
        this.prmtAccountView.getQueryAgent().resetRuntimeEntityView();
    }

    private void putInnerAccountFilter() throws SubAccountException {
        if (this.prmtRelationalUnit.getValue() == null) {
            throw new SubAccountException(SubAccountException.NO_RELATIONALORG);
        }
        CompanyOrgUnitInfo relationalOrg = (CompanyOrgUnitInfo)this.prmtRelationalUnit.getValue();
        if (relationalOrg == null || relationalOrg.getId() == null) {
            return;
        }
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (currentCompany == null || currentCompany.getId() == null) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompany.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)relationalOrg.getId().toString()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtInnerAccount.setEntityViewInfo(evi);
        this.prmtInnerAccount.getQueryAgent().resetRuntimeEntityView();
    }

    private void putRelativeParentAccountFilter() {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (currentCompany == null || currentCompany.getId() == null) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompany.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isMotherAccount", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtAccountBank.setEntityViewInfo(evi);
        this.prmtAccountBank.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.isBizUnit"));
        sic.add(new SelectorItemInfo("bank.id"));
        sic.add(new SelectorItemInfo("bank.number"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("bank.longNumber"));
        sic.add(new SelectorItemInfo("relationalUnit.id"));
        sic.add(new SelectorItemInfo("relationalUnit.number"));
        sic.add(new SelectorItemInfo("relationalUnit.name"));
        sic.add(new SelectorItemInfo("relationalUnit.isBizUnit"));
        sic.add(new SelectorItemInfo("innerAccount.id"));
        sic.add(new SelectorItemInfo("innerAccount.number"));
        sic.add(new SelectorItemInfo("innerAccount.name"));
        sic.add(new SelectorItemInfo("accountView.id"));
        sic.add(new SelectorItemInfo("accountView.number"));
        sic.add(new SelectorItemInfo("accountView.name"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("ctrlStrategy.id"));
        sic.add(new SelectorItemInfo("ctrlStrategy.number"));
        sic.add(new SelectorItemInfo("ctrlStrategy.name"));
        sic.add(new SelectorItemInfo("accountBank.bank.id"));
        sic.add(new SelectorItemInfo("accountBank.bank.number"));
        sic.add(new SelectorItemInfo("accountBank.bank.name"));
        sic.add(new SelectorItemInfo("accountBank.bank.longNumber"));
        sic.add(new SelectorItemInfo("bank.id"));
        sic.add(new SelectorItemInfo("bank.number"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("bank.longNumber"));
        return sic;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdtaccountBank.setEditable(false);
    }

    @Override
    protected void prmtRelationalUnit_willCommit(CommitEvent e) throws Exception {
        super.prmtRelationalUnit_willCommit(e);
    }

    @Override
    protected void prmtRelationalUnit_willShow(SelectorEvent e) throws Exception {
        super.prmtRelationalUnit_willShow(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        SubAccountInfo subAcc = (SubAccountInfo)this.getDataObject();
        if (subAcc != null && !subAcc.isIsClosed()) {
            subAcc.setIsClosed(true);
            this.actionCancelCancel.setEnabled(true);
            this.actionCancel.setEnabled(false);
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        SubAccountInfo subAcc = (SubAccountInfo)this.getDataObject();
        if (subAcc != null && subAcc.isIsClosed()) {
            subAcc.setIsClosed(false);
            this.actionCancelCancel.setEnabled(false);
            this.actionCancel.setEnabled(true);
        }
    }
}

