/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.subacct.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.OrgStructureUtils;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.subacct.ISubAccount;
import com.kingdee.eas.fi.cas.subacct.SubAccountException;
import com.kingdee.eas.fi.cas.subacct.SubAccountFactory;
import com.kingdee.eas.fi.cas.subacct.SubAccountInfo;
import com.kingdee.eas.fi.cas.subacct.client.AbstractSubAccountListUI;
import com.kingdee.eas.fi.cas.subacct.client.SubAccountEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class SubAccountListUI
extends AbstractSubAccountListUI {
    private static final Logger logger = CoreUIObject.getLogger(SubAccountListUI.class);
    private static final String RESOURCE_FILE_NAME = "com.kingdee.eas.basedata.assistant.client.AssistantDavidResource";

    public SubAccountListUI() throws Exception {
        OrgStructureUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        this.tblMain.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int i = e.getSelectBlock().getTop();
                if (i >= 0) {
                    try {
                        ISubAccount info = SubAccountFactory.getRemoteInstance();
                        String pkid = SubAccountListUI.this.getSelectedKeyValue();
                        ObjectUuidPK pk = new ObjectUuidPK(pkid);
                        SubAccountInfo counterInfo = info.getSubAccountInfo((IObjectPK)pk);
                        if (counterInfo.isIsClosed()) {
                            SubAccountListUI.this.actionCancelCancel.setEnabled(true);
                            SubAccountListUI.this.actionCancel.setEnabled(false);
                        } else {
                            SubAccountListUI.this.actionCancelCancel.setEnabled(false);
                            SubAccountListUI.this.actionCancel.setEnabled(true);
                        }
                    }
                    catch (BOSException e1) {
                        e1.printStackTrace();
                        MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.subacct.SubAccountResource", (String)"LIST_FETCH_DELETE"));
                        SysUtil.abort((Throwable)e1);
                    }
                    catch (EASBizException e1) {
                        e1.printStackTrace();
                        MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.subacct.SubAccountResource", (String)"LIST_FETCH_DELETE"));
                        SysUtil.abort((Throwable)e1);
                    }
                }
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return SubAccountEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SubAccountFactory.getRemoteInstance();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.checkSelected();
        ISubAccount iSubAcct = SubAccountFactory.getRemoteInstance();
        if (iSubAcct == null) {
            return;
        }
        String pkid = this.getSelectedKeyValue();
        if (EmptyUtil.isEmpty((String)pkid)) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(pkid);
        SelectorItemCollection sic = super.getSelectors();
        if (sic == null) {
            return;
        }
        sic.add("accountBank.bank.*");
        sic.add("bank.*");
        SubAccountInfo counteryInfo = iSubAcct.getSubAccountInfo((IObjectPK)pk, sic);
        if (counteryInfo != null && !counteryInfo.isIsClosed()) {
            this.checkCancel();
            counteryInfo.setIsClosed(true);
            SubAccountFactory.getRemoteInstance().setClosed(true, (IObjectPK)pk);
            this.actionCancelCancel.setEnabled(true);
            this.actionCancel.setEnabled(false);
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_FILE_NAME, (String)"disableSuccessed"));
        }
        this.refresh(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        ISubAccount iSubAcct = SubAccountFactory.getRemoteInstance();
        if (iSubAcct == null) {
            return;
        }
        super.checkSelected();
        String pkid = this.getSelectedKeyValue();
        if (EmptyUtil.isEmpty((String)pkid)) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(pkid);
        SelectorItemCollection sic = super.getSelectors();
        sic.add("accountBank.bank.*");
        sic.add("bank.*");
        SubAccountInfo counterInfo = iSubAcct.getSubAccountInfo((IObjectPK)pk, sic);
        if (counterInfo != null && counterInfo.isIsClosed()) {
            counterInfo.setIsClosed(false);
            SubAccountFactory.getRemoteInstance().setClosed(false, (IObjectPK)pk);
            this.actionCancelCancel.setEnabled(false);
            this.actionCancel.setEnabled(true);
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_FILE_NAME, (String)"enableSuccessed"));
        }
        this.refresh(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        if (super.getSelectors() == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("accountBank.bank.*");
            sic.add("bank.*");
            return sic;
        }
        SelectorItemCollection sic = super.getSelectors();
        sic.add("accountBank.bank.*");
        sic.add("bank.*");
        return sic;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        if ("FINDVIEW".equals(this.getOprtState())) {
            return null;
        }
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        FilterInfo filter = new FilterInfo();
        if (company == null || company.getId() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        return filter;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws SubAccountException, Exception {
        if (EmptyUtil.isEmpty((String)this.getSelectedKeyValue()) && SubAccountFactory.getRemoteInstance().referCondition(BOSUuid.read((String)this.getSelectedKeyValue()))) {
            throw new SubAccountException(SubAccountException.DELETE_REFERENCED);
        }
        super.actionRemove_actionPerformed(e);
    }

    private void checkCancel() throws Exception {
        String subAccId = this.getSelectedKeyValue();
        if (EmptyUtil.isEmpty((String)subAccId)) {
            return;
        }
        SubAccountFactory.getRemoteInstance().actionCancel(subAccId);
    }

    private void checkCancelCancel() throws Exception {
        ISubAccount info = SubAccountFactory.getRemoteInstance();
        String pkid = this.getSelectedKeyValue();
        if (EmptyUtil.isEmpty((String)pkid)) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(pkid);
        SelectorItemCollection sic = super.getSelectors();
        if (sic == null) {
            sic = new SelectorItemCollection();
            sic.add("accountBank.bank.*");
            sic.add("bank.*");
        } else {
            sic.add("accountBank.bank.*");
            sic.add("bank.*");
        }
        SubAccountInfo counterInfo = info.getSubAccountInfo((IObjectPK)pk, sic);
        CompanyOrgUnitInfo comOrgInfo = counterInfo.getRelationalUnit();
        if (comOrgInfo == null || comOrgInfo.getId() == null) {
            return;
        }
        String comID = comOrgInfo.getId().toString();
        BankInfo bankif = counterInfo.getBank();
        if (bankif == null || EmptyUtil.isEmpty((String)bankif.getLongNumber())) {
            return;
        }
        String longNum = bankif.getLongNumber();
        String topNum = longNum.split("!")[0];
        if (!SubAccountFactory.getRemoteInstance().monoCombine(comID, topNum, pkid)) {
            throw new SubAccountException(SubAccountException.COMBINE_ERROR);
        }
    }

    protected void execQuery() {
        super.execQuery();
    }

    public void onShow() throws Exception {
        super.onShow();
    }
}

