/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.expr.ExprMethod;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.HelpUtils;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.TableToolKitForAPIFactory;
import com.kingdee.eas.fi.rpt.ValidatorResults;
import com.kingdee.eas.fi.rpt.api.IRptContextManager;
import com.kingdee.eas.fi.rpt.api.IRptFormula;
import com.kingdee.eas.fi.rpt.api.IRptFormulaCompProxy;
import com.kingdee.eas.fi.rpt.client.AbstractFormulaWizardUI;
import com.kingdee.eas.fi.rpt.client.FormulaUpgraderFactory;
import com.kingdee.eas.fi.rpt.client.FormulaWizardCompoundResult;
import com.kingdee.eas.fi.rpt.client.IFormulaUpgrader;
import com.kingdee.eas.fi.rpt.client.IFormulaWizardListener;
import com.kingdee.eas.fi.rpt.client.IRptFormulaValidator;
import com.kingdee.eas.fi.rpt.client.IValidator;
import com.kingdee.eas.fi.rpt.client.ParamInductor;
import com.kingdee.eas.fi.rpt.client.RptFormulaCompProxyFactory;
import com.kingdee.eas.fi.rpt.client.RptFormulaDataType;
import com.kingdee.eas.fi.rpt.client.RptFormulaParameter;
import com.kingdee.eas.fi.rpt.client.RptFormulaRelaxType;
import com.kingdee.eas.fi.rpt.client.RptFormulaValidatorFactory;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.fi.rpt.util.RptUtilForAPI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

public class FormulaWizardUI
extends AbstractFormulaWizardUI {
    private static final Logger logger = CoreUIObject.getLogger(FormulaWizardUI.class);
    private ArrayList listeners = new ArrayList(1);
    private String formulaLine;
    IRptFormula formula;
    private ArrayList txtPrarms;
    private Point basePos = null;
    private IRptContextManager context;
    private String formulaName2;
    protected Map paramComponents = new HashMap(5);
    private boolean alart = true;
    private List validatorChain;
    private static final int LD_FAILED = 0;
    private static final int LD_OKEY = 1;
    private static final int LD_FINISH = 2;
    boolean isFirstTry = true;
    private static MouseListener paramHook = null;
    private boolean isLoadOnce = false;

    public boolean isAlart() {
        return this.alart;
    }

    public void openAlart() {
        this.alart = true;
    }

    public void closeAlart() {
        this.alart = false;
    }

    public FormulaWizardUI() throws Exception {
        HelpUtils.addCSHelp((JComponent)this.getRootPane());
        HelpUtils.addCSHelpforBtn((JButton)this.btnHelp);
    }

    public static FormulaWizardUI creatFormulaWizard(Object parentUI) throws Exception {
        return (FormulaWizardUI)UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FormulaWizardUI.class.getName(), (Map)new UIContext(parentUI)).getUIObject();
    }

    public static FormulaWizardUI creatFormulaWizard(String wizardUI, Object parentUI) throws Exception {
        String uiName = null;
        try {
            Class<?> clazz;
            if (!parentUI.getClass().getName().equals("com.kingdee.eas.fi.rpt.client.FormulaPickerUI") && parentUI instanceof Component) {
                parentUI = SwingUtilities.getWindowAncestor((Component)parentUI);
            }
            uiName = FormulaWizardUI.class.isAssignableFrom(clazz = Class.forName(wizardUI)) ? wizardUI : FormulaWizardUI.class.getName();
        }
        catch (Exception e) {
            uiName = FormulaWizardUI.class.getName();
        }
        return (FormulaWizardUI)UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)new UIContext(parentUI)).getUIObject();
    }

    @Override
    public void initUIContentLayout() {
        this.pnlTop.setBorder(BorderFactory.createEtchedBorder());
        super.initUIContentLayout();
    }

    public void open(String formulaName) {
        this.open(formulaName, null);
    }

    public void open(String formulaName, FormulaHint hint) {
        this.formulaName2 = formulaName;
        this.fireListenersSetout();
        IFormulaUpgrader upgrader = FormulaUpgraderFactory.getInstance(formulaName);
        if (upgrader != null) {
            upgrader.upgrade(hint);
        }
        int sta = this.loadFormula(formulaName, hint);
        this.onOpen();
        if (sta == 1) {
            this.showWizard();
        } else {
            this.endWizard(sta == 2);
        }
    }

    public void openFormula(String line) {
        ArrayList<FormulaHint> hints = null;
        try {
            hints = TableToolKitForAPIFactory.getInstance().parseExcelFormula(line, true);
        }
        catch (ParserException e) {
            hints = new ArrayList<FormulaHint>(1);
            hints.add(TableToolKitForAPIFactory.getInstance().parseFormula(line));
        }
        IRptFormula fm = null;
        FormulaHint hint = null;
        if (hints != null && hints.size() > 0) {
            hint = (FormulaHint)hints.get(hints.size() - 1);
            try {
                fm = RptFormulaCompProxyFactory.getInstance().getFormula(hint.name);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (hints != null && hint != null && fm != null) {
            this.open(hint.name, hint);
        }
    }

    protected void onOpen() {
    }

    private void showWizard() {
        IUIWindow w = this.getUIWindow();
        if (this.formula != null) {
            KDDialog d = (KDDialog)w;
            if (this.basePos != null) {
                d.setLocation(this.basePos);
            }
            d.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    FormulaWizardUI.this.setDimension();
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    FormulaWizardUI.this.endWizard(e != null && e.getSource() == FormulaWizardUI.this.btnOk);
                }
            });
        }
        this.onShow();
        w.show();
    }

    public void setLocation(Point p) {
        this.basePos = p != null ? new Point(p) : null;
        super.setLocation(p);
    }

    public synchronized void addFormulaWizardListener(IFormulaWizardListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private void fireListenersReturnee(boolean isOk) {
        for (IFormulaWizardListener l : this.listeners) {
            if (l == null) continue;
            l.wizardReturnee(this, this.formulaLine, isOk);
        }
    }

    private void fireListenersSetout() {
        for (IFormulaWizardListener l : this.listeners) {
            if (l == null) continue;
            l.wizardSetout(this);
        }
    }

    void endWizard(boolean isOk) {
        if (isOk) {
            FormulaWizardCompoundResult res;
            try {
                res = this.compound();
            }
            catch (Exception e) {
                this.handUIException(e);
                return;
            }
            if (!this.validateCompoundResult(res)) {
                return;
            }
            if (res.isOkey) {
                try {
                    if (!this.doValidate(res)) {
                        return;
                    }
                    if (this.validatorChain != null && this.validatorChain.size() > 0) {
                        boolean pass = true;
                        ValidatorResults results = new ValidatorResults();
                        for (int i = 0; i < this.validatorChain.size(); ++i) {
                            IValidator v = (IValidator)this.validatorChain.get(i);
                            if (v.validator(res, results)) continue;
                            pass = false;
                            break;
                        }
                        if (!pass) {
                            StringBuffer sb = new StringBuffer();
                            List results2 = results.getResults();
                            for (int i = 0; i < results2.size(); ++i) {
                                String msg = (String)results2.get(i);
                                if (StringUtils.isEmpty((String)msg)) continue;
                                sb.append(msg).append('\n');
                            }
                            MsgBox.showError((Component)((Object)this), (String)sb.toString());
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
            this.formulaLine = res.formulaLine;
        } else {
            this.formulaLine = null;
        }
        this.disposeUIWindow();
        this.fireListenersReturnee(isOk);
        this.listeners.clear();
    }

    private boolean doValidate(FormulaWizardCompoundResult res) throws Exception {
        ValidatorResults results;
        if (!this.alart) {
            return true;
        }
        IRptFormulaValidator v = RptFormulaValidatorFactory.newInstance(this.formula, res);
        boolean valid = v.validate(results = new ValidatorResults(), this.context);
        if (!valid) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < results.getResults().size(); ++i) {
                String msg = (String)results.getResults().get(i);
                if (StringUtils.isEmpty((String)msg)) continue;
                sb.append(msg).append('\n');
            }
            if (!v.isStrict()) {
                return 0 == MsgBox.showConfirm2((Component)((Object)this), (String)sb.toString());
            }
            MsgBox.showWarning((Component)((Object)this), (String)sb.toString());
            return false;
        }
        return valid;
    }

    protected int loadFormula(String name, FormulaHint hint) {
        boolean isOk;
        if (!this.getFormula(name)) {
            return 0;
        }
        Collection params = this.formula.getParameters();
        int num = params.size();
        boolean isDynamic = false;
        if (hint == null || !name.equalsIgnoreCase(hint.name) || hint.params == null) {
            hint = null;
        } else if (hint.params.length > num) {
            if (((RptFormulaParameter)params.iterator().next()).repeatNum > 1) {
                isDynamic = true;
                num = hint.params.length;
            } else {
                hint = null;
            }
        }
        this.initContentPanel(num);
        boolean bl = isOk = isDynamic ? this.putParams((RptFormulaParameter)params.iterator().next(), hint) : this.putParams(params, hint);
        if (!isOk) {
            this.clearParams();
        } else {
            this.pnlTop.getViewport().getComponent(0).addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e != null) {
                        FormulaWizardUI.this.txtDescription.setText(FormulaWizardUI.this.formula.getDescription());
                    }
                }
            });
            this.txtDescription.setText(this.formula.getDescription());
            if (num < 1) {
                this.txtDescription.append("\n" + RptUtilForAPI.getResource("FormulaNoNeedParam"));
            }
        }
        String ln = this.formula.getLocalName();
        ln = ln != null && !ln.equalsIgnoreCase(name) ? ln + " : " + name : name;
        this.setUITitle(ln);
        return 1;
    }

    protected boolean putParams(Collection params, FormulaHint hint) {
        int id = 0;
        for (RptFormulaParameter p : params) {
            String iv = null;
            if (hint == null || hint.params == null || hint.params.length <= id) {
                iv = "";
            } else {
                String string = iv = hint == null ? null : hint.params[id++];
            }
            if (this.putParam(p, iv)) continue;
            return false;
        }
        return true;
    }

    private boolean putParams(RptFormulaParameter parameter, FormulaHint hint) {
        for (int i = 0; i < hint.params.length; ++i) {
            if (this.putParam(parameter, hint.params[i])) continue;
            return false;
        }
        return true;
    }

    private Component initContentPanel(int paramNum) {
        this.txtPrarms = new ArrayList(paramNum);
        Dimension dm = this.pnlTop.getPreferredSize();
        dm.height = paramNum * 23 + 20;
        dm.width -= 20;
        JPanel pa = new JPanel();
        pa.setPreferredSize(dm);
        pa.setSize(dm);
        pa.setLayout(null);
        return this.pnlTop.getViewport().add(pa);
    }

    private boolean getFormula(String name) {
        IRptFormulaCompProxy comp = RptFormulaCompProxyFactory.getInstance();
        try {
            if (!comp.isLoaded() && !this.isLoadOnce) {
                comp.load();
            }
            this.formula = comp.getFormula(name);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return this.formula != null;
    }

    private boolean setDimension() {
        Dimension dm = new Dimension(this.pnlTop.getViewport().getComponent(0).getPreferredSize());
        int myHeight = this.pnlBottom.getPreferredSize().height + dm.height + 40;
        dm.height = this.getScreenDim().height > myHeight && this.getScreenDim().width > dm.width ? (dm.height += this.pnlBottom.getPreferredSize().height + 40) : this.getScreenDim().height - 80;
        dm.width = this.pnlBottom.getPreferredSize().width + 6;
        IUIWindow w = this.getUIWindow();
        if (w != null && w instanceof UIModelDialog) {
            UIModelDialog d = (UIModelDialog)w;
            d.setSize(dm.width, dm.height);
            d.validate();
        }
        return true;
    }

    private void clearParams() {
        this.txtPrarms.clear();
    }

    private Dimension getScreenDim() {
        Toolkit kit = Toolkit.getDefaultToolkit();
        return kit.getScreenSize();
    }

    private boolean validateCompoundResult(FormulaWizardCompoundResult target) {
        if (!this.alart) {
            return true;
        }
        if (target == null) {
            return false;
        }
        if (target.isOkey) {
            return true;
        }
        String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"0_FormulaWizardUI"), target.infoLine);
        if (this.formula.isStrictRequired()) {
            MsgBox.showWarning((String)msg);
            return false;
        }
        return 0 == MsgBox.showConfirm2((Component)((Object)this), (String)msg);
    }

    private FormulaWizardCompoundResult compound() throws Exception {
        FormulaWizardCompoundResult res = new FormulaWizardCompoundResult();
        if (this.formula == null) {
            return res;
        }
        StringBuffer line = new StringBuffer(128);
        StringBuffer info = new StringBuffer(128);
        line.append(this.formula.getName());
        line.append("(");
        res.setFormulaName(this.formula.getName());
        boolean notInit = false;
        int size = this.txtPrarms == null ? 0 : this.txtPrarms.size();
        for (int i = 0; i < size; ++i) {
            KDTextField fld = (KDTextField)this.txtPrarms.get(i);
            String val = this.getText(fld);
            RptFormulaParameter p = ((Pilot)fld.getUserObject()).getParam();
            res.put(p.getName(), this.getTrueText(fld));
            if (this.isNullValue(val)) {
                if (p.getRepeatNum() > 1) continue;
                if (p.isNeed()) {
                    res.isOkey = false;
                    info.append('\"');
                    info.append(p.getLocalName());
                    info.append("\", ");
                }
            }
            if (notInit) {
                if (!this.isNullValue(val) || !p.overleap) {
                    line.append(',');
                }
            } else {
                notInit = true;
            }
            line.append(val);
        }
        line.append(')');
        res.formulaLine = line.toString();
        if (!res.isOkey) {
            res.infoLine = info.toString();
        }
        return res;
    }

    protected String getText(KDTextField fld) throws Exception {
        String line = null;
        if (line == null || line.length() == 0 || !fld.isDirty() && this.isAlart()) {
            ParamInductor pi = ((Pilot)fld.getUserObject()).getInductor();
            if (!this.alart && pi.controllerIsKDSpinner()) {
                if (fld.getText() != null) {
                    return fld.getText();
                }
                return "";
            }
            if (pi != null) {
                line = pi.getText();
            }
            if (line == null) {
                return null;
            }
        }
        boolean isFunc = false;
        if (!StringUtils.isEmpty((String)line)) {
            if (this.getStringNumber(line, "\"") % 2 == 1) {
                throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"123_FormulaWizardUI"));
            }
            if (this.getStringNumber(line, "(") != this.getStringNumber(line, ")")) {
                throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"124_FormulaWizardUI"));
            }
            try {
                Expression expr = TableToolKitForAPIFactory.getInstance().parse(line);
                isFunc = this.isFormula(expr);
                if (isFunc && line.startsWith("=")) {
                    line = line.substring(1);
                }
            }
            catch (Exception e) {
                logger.warn((Object)(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"125_FormulaWizardUI") + line));
                isFunc = false;
            }
        }
        StringBuffer tmp = new StringBuffer(line);
        if (((Pilot)fld.getUserObject()).isNeedQuotation()) {
            if (tmp.length() == 0) {
                tmp.append("\"\"");
            } else if (tmp.charAt(0) != '\"' && !isFunc) {
                tmp.insert(0, '\"');
                tmp.append('\"');
            }
        }
        return tmp.toString();
    }

    private boolean isFormula(Expression expr) {
        boolean isFormulaFormat = TableToolKitForAPIFactory.getInstance().isFormula(expr);
        if (!isFormulaFormat) {
            return false;
        }
        Book book = null;
        try {
            book = ((SpreadContext)((Map)((Object)this.context)).get(SpreadContext.class)).getBook();
            return this.isValidFormula(expr, book);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            return false;
        }
    }

    private boolean isValidFormula(Expression expr, Book book) {
        if (expr instanceof FunctionExpr) {
            String methodName = ((FunctionExpr)expr).funcionName;
            ExprMethod[] registeredMethod = book.getDeps().getFunctionManager().getFuncList(methodName);
            return registeredMethod != null;
        }
        if (expr instanceof UnaryOperationExpr) {
            return this.isValidFormula(((UnaryOperationExpr)expr).operand, book);
        }
        if (expr instanceof BinaryOperationExpr) {
            boolean b = this.isValidFormula(((BinaryOperationExpr)expr).left, book);
            if (!b) {
                return b;
            }
            b = this.isValidFormula(((BinaryOperationExpr)expr).right, book);
            return b;
        }
        return false;
    }

    private int getStringNumber(String str, String sub) {
        int i = -1;
        int length = str.length();
        int size = 0;
        while (i < length && (i = str.indexOf(sub, i + 1)) >= 0) {
            ++size;
        }
        return size;
    }

    private String getTrueText(KDTextField fld) {
        String line = fld.getText();
        if (line == null || line.length() == 0 || !fld.isDirty() && this.isAlart()) {
            ParamInductor pi = ((Pilot)fld.getUserObject()).getInductor();
            if (!this.alart && pi.controllerIsKDSpinner()) {
                if (line != null) {
                    return line;
                }
                return "";
            }
            if (pi != null) {
                line = pi.getText();
            }
            if (line == null) {
                return null;
            }
        }
        return line;
    }

    private boolean isNullValue(String value) {
        return value == null || value.length() == 0 || "\"\"".equals(value);
    }

    boolean tryAppend(RptFormulaParameter p, Object source) {
        int size = this.txtPrarms.size();
        if (p == null || p.getRepeatNum() < 2 || size > 0 && !this.txtPrarms.get(size - 1).equals(source) || this.txtPrarms.size() >= p.getRepeatNum()) {
            if (this.isFirstTry) {
                this.setDimension();
                this.isFirstTry = false;
            }
            return false;
        }
        return this.appendParam(p, null);
    }

    private boolean appendParam(RptFormulaParameter p, String initValue) {
        JPanel pa = (JPanel)this.pnlTop.getViewport().getComponent(0);
        Dimension dm = pa.getPreferredSize();
        dm.height += 23;
        pa.setPreferredSize(dm);
        dm = this.pnlTop.getSize();
        dm.height += 23;
        this.pnlTop.setSize(dm);
        this.pnlTop.setPreferredSize(dm);
        return this.putParam(p, initValue) && this.setDimension();
    }

    protected boolean putParam(RptFormulaParameter p, String initValue) {
        boolean isDate = false;
        if (!this.isAlart()) {
            initValue = null;
        }
        String n = p.getLocalName();
        if (p.getRepeatNum() > 1) {
            n = n + p.incRepeat();
        }
        if (initValue == null || initValue.length() < 1) {
            initValue = p.getDefaultValue();
            if (!this.isAlart()) {
                initValue = null;
            }
            if (initValue != null && initValue.startsWith("%") && initValue.endsWith("%")) {
                isDate = true;
                initValue = "";
            }
        } else if (initValue.charAt(0) == ',') {
            initValue = initValue.substring(1);
        }
        if (p.type.equalsIgnoreCase(RptFormulaCompProxyFactory.getInstance().getConstantVariable("anytype"))) {
            initValue = ParamInductor.formatAnytype(initValue, null);
        }
        JPanel panel = (JPanel)this.pnlTop.getViewport().getComponent(0);
        KDLabel lbl = new KDLabel();
        lbl.setText(n);
        lbl.setUnderline(true);
        lbl.setVerticalAlignment(3);
        lbl.setPreferredSize(new Dimension(120, 20));
        lbl.setBounds(new Rectangle(10, this.txtPrarms.size() * 23 + 10, 130, 20));
        panel.add((Component)lbl);
        KDTextField fld = new KDTextField();
        fld.setAutoscrolls(false);
        fld.setDocument((Document)new PlainDocument());
        fld.setPreferredSize(new Dimension(120, 20));
        fld.setBounds(new Rectangle(140, this.txtPrarms.size() * 23 + 10, panel.getPreferredSize().width - 148, 20));
        fld.addFocusListener((FocusListener)new ParamListener());
        fld.setEnabledPopup(false);
        if (isDate) {
            fld.setText("");
        } else {
            fld.setText(initValue);
        }
        fld.setEnabled(p.enabled);
        if (p.isNeed()) {
            fld.setRequired(true);
        }
        Pilot plt = new Pilot(p, (JComponent)fld);
        fld.setUserObject((Object)plt);
        plt.init(panel);
        fld.setDirty(false);
        fld.setName(p.getName());
        panel.add((Component)fld);
        this.txtPrarms.add(fld);
        fld.addMouseListener(this.getParamHook());
        return true;
    }

    private MouseListener getParamHook() {
        if (paramHook == null) {
            paramHook = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    FormulaWizardUI.this.updateParamDescription(((Pilot)((KDTextField)e.getSource()).getUserObject()).getParam());
                }
            };
        }
        return paramHook;
    }

    void updateParamDescription(RptFormulaParameter param) {
        if (param != null) {
            this.txtDescription.setText(param.getDescription());
            this.txtDescription.setCaretPosition(0);
        }
    }

    private void getFormattedField(String var, Set value) {
        if (StringUtils.isEmpty((String)var)) {
            return;
        }
        StringBuffer name = new StringBuffer(15);
        boolean inParam = false;
        for (int i = 0; i < var.length(); ++i) {
            char c = var.charAt(i);
            if (c == '$') {
                if (inParam) {
                    inParam = false;
                    value.add(name.toString());
                    name = new StringBuffer(15);
                    continue;
                }
                inParam = true;
                continue;
            }
            if (!inParam) continue;
            name.append(c);
        }
    }

    public String getParam(String paramName) {
        if (paramName == null) {
            return null;
        }
        int size = this.txtPrarms.size();
        for (int i = 0; i < size; ++i) {
            KDTextField fld = (KDTextField)this.txtPrarms.get(i);
            RptFormulaParameter p = ((Pilot)fld.getUserObject()).getParam();
            if (!p.getName().equalsIgnoreCase(paramName)) continue;
            return ((Pilot)fld.getUserObject()).getInductor().getText();
        }
        return null;
    }

    public void setParam(String paramName, String value) {
        if (paramName == null) {
            return;
        }
        int size = this.txtPrarms.size();
        for (int i = 0; i < size; ++i) {
            KDTextField fld = (KDTextField)this.txtPrarms.get(i);
            RptFormulaParameter p = ((Pilot)fld.getUserObject()).getParam();
            if (!p.getName().equalsIgnoreCase(paramName)) continue;
            fld.setText(value);
            ParamInductor.setControllerValue(((Pilot)fld.getUserObject()).inductor.getController(), value);
            return;
        }
    }

    public Object getParamObject(String paramName) {
        if (paramName == null) {
            return null;
        }
        int size = this.txtPrarms.size();
        for (int i = 0; i < size; ++i) {
            KDTextField fld = (KDTextField)this.txtPrarms.get(i);
            RptFormulaParameter p = ((Pilot)fld.getUserObject()).getParam();
            if (!p.getName().equalsIgnoreCase(paramName)) continue;
            ParamInductor d = ((Pilot)fld.getUserObject()).getInductor();
            if (d != null) {
                return d.getValue();
            }
            JComponent com = d == null ? null : d.getController();
            return com instanceof KDPromptBox ? ((KDPromptBox)com).getData() : fld.getText();
        }
        return null;
    }

    public JComponent getParamComponent(String paramName) {
        if (paramName == null) {
            return null;
        }
        if (this.paramComponents.get(paramName) == null) {
            return null;
        }
        return ((ParamInductor)this.paramComponents.get(paramName)).getController();
    }

    public JComponent getBaseParamComponent(String paramName) {
        if (paramName == null) {
            return null;
        }
        if (this.paramComponents.get(paramName) == null) {
            return null;
        }
        return ((ParamInductor)this.paramComponents.get(paramName)).getBaseComponent();
    }

    public void setRptContext(IRptContextManager rptContext) {
        this.context = rptContext;
    }

    public IRptContextManager getRptContext() {
        return this.context;
    }

    protected JButton getDefaultButton() {
        return this.btnOk;
    }

    public void onShow() {
        TableToolKitForAPIFactory.getInstance().setEscAction(this, (Action)((Object)this.actionFinish));
        this.isFirstTry = true;
    }

    public void setUIMenuBar(KDMenuBar bar) {
        this.menuBar = bar = null;
    }

    public void setUIToolBar(KDToolBar bar) {
        this.toolBar = bar = null;
    }

    @Override
    public void actionFinish_actionPerformed(ActionEvent e) throws Exception {
        this.endWizard(e != null && e.getSource() == this.btnOk);
    }

    public JPanel getParameterPane() {
        return (JPanel)this.pnlTop.getViewport().getComponent(0);
    }

    public Component getParamComponent(int index) {
        return this.getParameterPane().getComponent(index * 2 + 1);
    }

    public IRptFormula getFormula() {
        return this.formula;
    }

    public void addValidatorChain(Collection l) {
        if (l == null) {
            return;
        }
        if (this.validatorChain == null) {
            this.validatorChain = new ArrayList();
        }
        this.validatorChain.addAll(l);
    }

    public void addValidator(IValidator v) {
        if (this.validatorChain == null) {
            this.validatorChain = new ArrayList();
        }
        this.validatorChain.add(v);
    }

    public void setLoadOnce(boolean isLoadOnce) {
        this.isLoadOnce = isLoadOnce;
    }

    public OrgType getRptOrgType() {
        Object orgType = null;
        IRptContextManager rptContext = this.getRptContext();
        if (rptContext != null && rptContext.getPropertyAdapter() != null) {
            orgType = rptContext.getPropertyAdapter().getReportProperty("orgType");
        }
        if (orgType instanceof OrgType) {
            return (OrgType)orgType;
        }
        return OrgType.Company;
    }

    public OrgViewType getRptOrgViewType() {
        OrgType type = this.getRptOrgType();
        if (OrgType.Company.equals((Object)type)) {
            return OrgViewType.COMPANY;
        }
        if (OrgType.ProfitCenter.equals((Object)type)) {
            return OrgViewType.PROFITCENTER;
        }
        if (OrgType.Admin.equals((Object)type)) {
            return OrgViewType.ADMIN;
        }
        if (OrgType.ControlUnit.equals((Object)type)) {
            return OrgViewType.CTRLUNIT;
        }
        if (OrgType.CostCenter.equals((Object)type)) {
            return OrgViewType.COSTCENTER;
        }
        if (OrgType.HRO.equals((Object)type)) {
            return OrgViewType.HRO;
        }
        if (OrgType.Purchase.equals((Object)type)) {
            return OrgViewType.PURCHASE;
        }
        if (OrgType.Quality.equals((Object)type)) {
            return OrgViewType.QUALITY;
        }
        if (OrgType.Sale.equals((Object)type)) {
            return OrgViewType.SALE;
        }
        if (OrgType.Storage.equals((Object)type)) {
            return OrgViewType.STORAGE;
        }
        if (OrgType.Transport.equals((Object)type)) {
            return OrgViewType.TRANSPORT;
        }
        if (OrgType.UnionDebt.equals((Object)type)) {
            return OrgViewType.UNIONDEBT;
        }
        return OrgViewType.COMPANY;
    }

    public String getRptCompanyNumber() {
        IRptContextManager rptContext = this.getRptContext();
        Object cmpNum = null;
        if (rptContext != null && rptContext.getPropertyAdapter() != null) {
            cmpNum = rptContext.getPropertyAdapter().getReportProperty("Company.Number");
        }
        if (cmpNum instanceof String) {
            return cmpNum.toString();
        }
        return SysContext.getSysContext().getCurrentOrgUnit().getNumber();
    }

    private class ParamListener
    implements FocusListener {
        private ParamListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            KDTextField source = (KDTextField)e.getSource();
            Pilot pilot = (Pilot)source.getUserObject();
            FormulaWizardUI.this.tryAppend(pilot.getParam(), e.getSource());
            FormulaWizardUI.this.updateParamDescription(pilot.getParam());
            String queryParam = source.getText();
            this.fetchParameterData(pilot, queryParam);
            pilot.show();
        }

        private void fetchParameterData(Pilot pilot, String queryParam) {
            JComponent comp;
            if (pilot.getInductor() != null && !StringUtils.isEmpty((String)queryParam) && (comp = pilot.getInductor().getController()) != null && comp instanceof KDPromptBox) {
                KDPromptBox promptBox = (KDPromptBox)comp;
                if (pilot.getParam().isInquiryOnFocus() && (promptBox.getData() == null || promptBox.getData() instanceof String)) {
                    String type = pilot.getParam().getType();
                    RptFormulaDataType dataType = (RptFormulaDataType)RptFormulaCompProxyFactory.getInstance().getDataType(type);
                    if (dataType instanceof RptFormulaRelaxType) {
                        RptFormulaRelaxType rptFormulaRelaxType = (RptFormulaRelaxType)dataType;
                        String query = rptFormulaRelaxType.getProperty(RptFormulaCompProxyFactory.getInstance().getConstantVariable("query"));
                        String disp = rptFormulaRelaxType.getProperty(RptFormulaCompProxyFactory.getInstance().getConstantVariable("display_fm"));
                        String edit = rptFormulaRelaxType.getProperty(RptFormulaCompProxyFactory.getInstance().getConstantVariable("edit_fm"));
                        String cmt = rptFormulaRelaxType.getProperty(RptFormulaCompProxyFactory.getInstance().getConstantVariable("commit_fm"));
                        HashSet commit = new HashSet(1);
                        FormulaWizardUI.this.getFormattedField(cmt, commit);
                        if (commit.size() > 0) {
                            HashSet fields = new HashSet(3);
                            FormulaWizardUI.this.getFormattedField(disp, fields);
                            FormulaWizardUI.this.getFormattedField(edit, fields);
                            FormulaWizardUI.this.getFormattedField(cmt, fields);
                            try {
                                IObjectCollection collection;
                                IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                                QueryInfo queryInfo = loader.getQuery((IMetaDataPK)new MetaDataPK(query));
                                EntityViewInfo view = new EntityViewInfo();
                                SelectorItemCollection selector = view.getSelector();
                                Iterator i = fields.iterator();
                                while (i.hasNext()) {
                                    selector.add(new SelectorItemInfo(i.next().toString()));
                                }
                                FilterInfo filter = new FilterInfo();
                                view.setFilter(filter);
                                view.setTopCount(1);
                                Iterator iterator = commit.iterator();
                                filter.getFilterItems().add(new FilterItemInfo(iterator.next().toString(), (Object)queryParam.trim()));
                                SubObjectInfo mainObjectInfo = queryInfo.getMainObject();
                                if (mainObjectInfo instanceof SubEntityInfo && !(collection = DynamicObjectFactory.getRemoteInstance().getCollection(((SubEntityInfo)mainObjectInfo).getEntityRef().getType(), view)).isEmpty()) {
                                    promptBox.setData((Object)collection.getObject(0));
                                }
                            }
                            catch (BOSException bOSException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    class Pilot {
        private RptFormulaParameter param;
        private JComponent holder;
        private ParamInductor inductor;
        private boolean isInit;

        Object getValue() {
            if (this.holder instanceof KDTextField) {
                return ((KDTextField)this.holder).getText();
            }
            return null;
        }

        public ParamInductor getInductor() {
            return this.inductor;
        }

        public RptFormulaParameter getParam() {
            return this.param;
        }

        public boolean isNeedQuotation() {
            if (this.inductor == null) {
                return ParamInductor.isString((RptFormulaDataType)RptFormulaCompProxyFactory.getInstance().getDataType(this.param.getType()));
            }
            return this.inductor.isString();
        }

        public void setController() {
            this.inductor = null;
        }

        public void setParam(RptFormulaParameter p) {
            this.param = p;
        }

        public Pilot(RptFormulaParameter p, JComponent h) {
            this.param = p;
            this.holder = h;
            this.inductor = null;
            this.isInit = true;
        }

        public String getString() {
            return ((KDTextField)this.holder).getText().trim();
        }

        public void init(JPanel container) {
            if (this.isInit) {
                RptFormulaDataType t = (RptFormulaDataType)RptFormulaCompProxyFactory.getInstance().getDataType(this.param.getType());
                this.holder.setName(this.param.getName());
                this.inductor = ParamInductor.createInductor(t, this.holder, FormulaWizardUI.this, FormulaWizardUI.this.formulaName2);
                if (this.inductor != null) {
                    this.inductor.setBounds(this.holder.getBounds());
                    container.add(this.inductor.getController());
                    this.inductor.getController().setVisible(false);
                    if (this.param.isNeed) {
                        this.setRequired(this.inductor.getController());
                    }
                    FormulaWizardUI.this.paramComponents.put(this.param.getName(), this.inductor);
                }
                this.isInit = false;
            }
        }

        private void setRequired(Object obj) {
            try {
                Method method = obj.getClass().getMethod("setRequired", Boolean.TYPE);
                if (method != null) {
                    method.invoke(obj, Boolean.TRUE);
                }
            }
            catch (Exception e) {
                logger.debug((Object)"", (Throwable)e);
            }
        }

        public void show() {
            JPanel pan = (JPanel)this.holder.getParent();
            if (this.isInit) {
                RptFormulaDataType t = (RptFormulaDataType)RptFormulaCompProxyFactory.getInstance().getDataType(this.param.getType());
                this.inductor = ParamInductor.createInductor(t, this.holder, FormulaWizardUI.this);
                if (this.inductor != null) {
                    this.inductor.setBounds(this.holder.getBounds());
                    pan.add(this.inductor.getController());
                    FormulaWizardUI.this.paramComponents.put(this.param.getName(), this.inductor);
                }
                this.isInit = false;
            }
            if (this.inductor != null) {
                this.holder.setNextFocusableComponent(this.inductor.getTrueController());
                this.inductor.show();
                this.holder.setVisible(false);
                pan.validate();
            }
        }

        public void show(Pilot pilot) {
            JPanel pan = (JPanel)this.holder.getParent();
            if (this.isInit) {
                RptFormulaDataType t = (RptFormulaDataType)RptFormulaCompProxyFactory.getInstance().getDataType(this.param.getType());
                this.inductor = ParamInductor.createInductor(t, this.holder, FormulaWizardUI.this);
            }
            JComponent controller = this.inductor.getController();
            if (this.isInit) {
                if (this.inductor != null) {
                    this.inductor.setBounds(this.holder.getBounds());
                    pan.add(controller);
                    FormulaWizardUI.this.paramComponents.put(pilot.param.getName(), this.inductor);
                }
                this.isInit = false;
            }
            if (this.inductor != null) {
                this.holder.setNextFocusableComponent(this.inductor.getTrueController());
                this.inductor.show();
                this.holder.setVisible(false);
                pan.validate();
            }
        }
    }
}

