/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.rpt.TableToolKitForAPIFactory;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.fi.rpt.client.IItemObject;
import com.kingdee.eas.fi.rpt.client.IRptFormulaComboBoxInductorHint;
import com.kingdee.eas.fi.rpt.client.IRptFormulaInductorHint;
import com.kingdee.eas.fi.rpt.client.KDComboBoxAgent;
import com.kingdee.eas.fi.rpt.client.QueryTypeConditionBuilder;
import com.kingdee.eas.fi.rpt.client.RptFormulaCompProxyFactory;
import com.kingdee.eas.fi.rpt.client.RptFormulaDataType;
import com.kingdee.eas.fi.rpt.client.RptFormulaEnumEntry;
import com.kingdee.eas.fi.rpt.client.RptFormulaEnumType;
import com.kingdee.eas.fi.rpt.client.RptFormulaParameter;
import com.kingdee.eas.fi.rpt.client.RptFormulaRelaxType;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class ParamInductor {
    private static final Logger logger = CoreUIObject.getLogger(ParamInductor.class);
    private FormulaWizardUI wizard;
    private JComponent controller;
    private JComponent baseComponent;
    private int typeID = 0;
    private RptFormulaDataType dataType;
    private String committingString = null;
    private static final int TYPE_BIZPROMPT = 0x10000000;
    private static final int TYPE_CONTEXTPROMPT = 0x20000000;
    protected static final int TYPE_ANY = 4352;
    private static final int TYPE_ENUM = 0x30000000;
    private static final int TYPE_DATE = 0x40000000;
    private static final int TYPE_NUMBER = 0x50000000;
    private static final int TYPE_STRING = 0x60000000;
    private static final int TYPE_DATETIME = 0x70000000;
    private static final int TYPE_AMOUNT = Integer.MIN_VALUE;
    private static final int TYPE_COMMON = -1879048192;
    private static final int TYPE_LIST = -1862270976;
    private static final int TYPE_MAX = -65536;
    private static final int SUB_STRING = 4096;
    private static final int SUB_DATE = 8192;
    private static final int SUB_BOOLEAN = 12288;
    private static final int SUB_NUMBER = 16384;
    private static final int SUB_AMOUNT = 24576;
    private static final int SUB_COMMON = 28672;
    private static final int SUB_NULL = 0;
    private static final int SUB_MAX = 65535;
    private static final int TYPE_INIT = 0;
    private static final String CALLBACKHINT = "setFormulaWizardUI";

    public static ParamInductor createInductor(RptFormulaDataType type, JComponent base, FormulaWizardUI wizard) {
        return ParamInductor.createInductor(type, base, wizard, null);
    }

    public static ParamInductor createInductor(RptFormulaDataType type, JComponent base, FormulaWizardUI wizard, String formulaName) {
        return new ParamInductor(type, base, wizard, formulaName);
    }

    private ParamInductor(RptFormulaDataType type, JComponent base, FormulaWizardUI wizard, String formulaName) {
        this.baseComponent = base;
        this.dataType = type;
        this.wizard = wizard;
        String initValue = null;
        if (this.baseComponent instanceof KDTextField) {
            initValue = ((KDTextField)this.baseComponent).getText();
        }
        if (this.getController(type, initValue, formulaName) != null) {
            this.getTrueController().addFocusListener(new ControllerListener());
            this.controller.setName(base.getName());
        }
    }

    public JComponent getController(RptFormulaDataType type, String initValue, final String formulaName) {
        this.controller = null;
        if (!this.wizard.isAlart()) {
            initValue = "";
        }
        if (type instanceof RptFormulaEnumType) {
            RptFormulaEnumType et = (RptFormulaEnumType)type;
            KDComboBox cb = new KDComboBox();
            cb.setEditable(true);
            RptFormulaEnumEntry hot = null;
            if (StringUtils.isEmpty((String)initValue)) {
                hot = (RptFormulaEnumEntry)((Vector)et.getEntrys()).get(et.getDefaultIndex());
            }
            for (RptFormulaEnumEntry e : et.getEntrys()) {
                if (e == null) continue;
                if (hot == null && e.getName().equalsIgnoreCase(initValue)) {
                    hot = e;
                }
                cb.addItem((Object)e);
            }
            if (this.wizard.isAlart()) {
                if (hot != null) {
                    cb.setSelectedItem((Object)hot);
                    if (this.baseComponent instanceof KDTextField) {
                        ((KDTextField)this.baseComponent).setText(hot.getLocalName());
                    }
                }
            } else {
                cb.setSelectedIndex(-1);
            }
            this.typeID = 0x30000000;
            this.controller = cb;
        } else if (type instanceof RptFormulaRelaxType) {
            RptFormulaRelaxType rt = (RptFormulaRelaxType)type;
            this.typeID = this.getMainType(rt);
            switch (this.typeID) {
                case 0x40000000: {
                    KDSpinner sp = new KDSpinner();
                    this.setSpinRange((JSpinner)sp, rt.getMaxValue(), rt.getMinValue());
                    Number v = ParamInductor.getNumber(initValue);
                    if (v != null) {
                        sp.setValue((Object)v);
                    }
                    this.controller = sp;
                    break;
                }
                case 0x70000000: {
                    KDDatePicker dp = new KDDatePicker();
                    dp.getDatePickerDownList().setNullValueEnabled(true);
                    if (initValue == null || initValue.trim().length() == 0) {
                        dp.setValue(null);
                    } else {
                        Timestamp d = ParamInductor.getDateTime(initValue);
                        if (d != null) {
                            dp.setValue((Object)d);
                        }
                    }
                    this.controller = dp;
                    break;
                }
                case 0x10000000: {
                    KDBizPromptBox bo = this.createF7(rt);
                    bo.setValue((Object)initValue);
                    this.controller = bo;
                    break;
                }
                case 0x20000000: {
                    KDPromptBox box = new KDPromptBox();
                    box.setText(initValue);
                    this.controller = box;
                    break;
                }
                case 0x50000000: {
                    KDFormattedTextField fldn = new KDFormattedTextField(7);
                    fldn.setDataVerifierType(12);
                    fldn.setText(initValue);
                    this.controller = fldn;
                    break;
                }
                case -2147483648: {
                    KDFormattedTextField flda = new KDFormattedTextField(1);
                    flda.setDataVerifierType(12);
                    flda.setText(initValue);
                    this.controller = flda;
                    break;
                }
                case 4352: {
                    KDTextField fda = new KDTextField();
                    fda.setText(initValue);
                    this.controller = fda;
                    fda.addFocusListener(new FocusListener(){

                        @Override
                        public void focusGained(FocusEvent e) {
                        }

                        @Override
                        public void focusLost(FocusEvent e) {
                            KDTextField src = (KDTextField)e.getSource();
                            String txt = src.getText();
                            src.setText(ParamInductor.formatAnytype(txt, formulaName));
                        }
                    });
                    break;
                }
                case -1862270976: {
                    KDComboBox cmb = this.createCustomerComboBox(rt);
                    if (StringUtils.isEmpty((String)initValue)) {
                        cmb.setSelectedIndex(-1);
                    } else {
                        int selectedIdx = -1;
                        int size = cmb.getItemCount();
                        for (int i = 0; i < size; ++i) {
                            if (!initValue.equalsIgnoreCase(((IItemObject)cmb.getItemAt(i)).getNumber())) continue;
                            selectedIdx = i;
                            break;
                        }
                        cmb.setSelectedIndex(selectedIdx);
                    }
                    this.controller = cmb;
                    break;
                }
                default: {
                    KDTextField fd = new KDTextField();
                    fd.setText(initValue);
                    this.controller = fd;
                    break;
                }
            }
        } else {
            this.typeID = 0x60000000;
            KDTextField fd = new KDTextField();
            fd.setText(initValue);
            this.controller = fd;
        }
        this.typeID |= this.getSubType(type.getOriginType());
        this.controller.setName(this.baseComponent.getName());
        return this.controller;
    }

    private KDComboBox createCustomerComboBox(RptFormulaRelaxType type) {
        KDComboBoxAgent cmb = new KDComboBoxAgent();
        cmb.setEditable(true);
        cmb.setUserObject((Object)this.wizard);
        String hint = type.getProperty("combobox_hint");
        try {
            Class<?> cl = Class.forName(hint);
            Object o = cl.newInstance();
            if (o instanceof IRptFormulaComboBoxInductorHint) {
                IRptFormulaComboBoxInductorHint h = (IRptFormulaComboBoxInductorHint)o;
                h.setCustomConfig(cmb);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return cmb;
    }

    protected static String formatAnytype(String txt, String formulaName) {
        boolean isString = false;
        if (txt != null && txt.length() > 0) {
            if (txt.length() > 0 && txt.charAt(0) == '\"') {
                isString = true;
                txt = txt.substring(1);
            }
            if (txt.length() > 0 && txt.charAt(txt.length() - 1) == '\"') {
                isString = true;
                txt = txt.substring(0, txt.length() - 1);
            }
            if (isString) {
                txt = "\"" + txt + "\"";
                return txt;
            }
            if (TableToolKitForAPIFactory.getInstance().isCellRef(txt)) {
                return txt;
            }
            if (Pattern.compile("\\d*\\.?\\d*").matcher(txt).matches()) {
                return txt;
            }
            try {
                if (TableToolKitForAPIFactory.getInstance().isValidStmt(txt)) {
                    return txt;
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (!"sumif".equalsIgnoreCase(formulaName)) {
                txt = "\"" + txt + "\"";
            }
            return txt;
        }
        return txt;
    }

    private static Timestamp getDateTime(String text) {
        Timestamp res = null;
        try {
            if (text != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyy-MM-dd");
                long t = sdf.parse(text).getTime();
                res = new Timestamp(t);
            }
        }
        catch (Exception e) {
            res = null;
        }
        return res;
    }

    private static Number getNumber(String text) {
        Integer res = null;
        try {
            if (text != null) {
                res = Integer.valueOf(text);
            }
        }
        catch (Exception e) {
            res = null;
        }
        return res;
    }

    private KDBizPromptBox createF7(RptFormulaRelaxType type) {
        KDPromptSelector s;
        KDBizPromptBox pb = new KDBizPromptBox();
        pb.setName(this.baseComponent.getName());
        pb.setUserObject((Object)this.wizard);
        pb.setEnabledMultiSelection(false);
        pb.setEditable(true);
        pb.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                ParamInductor.this.committingString = e.getText();
                ((KDBizPromptBox)e.getSource()).setDirty(false);
            }
        });
        pb.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                Object obj = e.getData();
                if (obj == null) {
                    ParamInductor.this.committingString = null;
                }
            }
        });
        String hint = new QueryTypeConditionBuilder().build("query", type, this.wizard);
        if (hint == null) {
            logger.error((Object)("\u516c\u5f0f\u5b9a\u4e49\u9519\u8bef\uff0cquery\u6ca1\u6709\u627e\u5230\u3002debug: type is \n " + type));
        }
        pb.setQueryInfo(hint);
        this.filterFreezedRptItem(pb, hint);
        hint = type.getProperty("edit_fm");
        if (hint == null) {
            hint = type.getProperty("display_fm");
        }
        pb.setEditFormat(hint);
        hint = type.getProperty("display_fm");
        pb.setDisplayFormat(hint);
        hint = type.getProperty("commit_fm");
        if (hint == null) {
            pb.setCommitParser(new IParser(){

                public void applyPattern(String pattern) {
                }

                public Object stringToValue(String str) {
                    return str;
                }

                public void setQuickQureyEntityViewInfo(EntityViewInfo quickQueryEvi) {
                }

                public IRowSet getRowSetForPopupF8(String text) {
                    return null;
                }
            });
        } else {
            pb.setCommitFormat(hint);
        }
        hint = type.getProperty("prompt_hint");
        if (hint != null) {
            this.getHint(pb, hint);
        }
        if ((hint = type.getProperty("selector")) != null) {
            try {
                Class<?> cl = Class.forName(hint);
                Object o = cl.newInstance();
                if (o instanceof KDPromptSelector) {
                    pb.setSelector((KDPromptSelector)o);
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if ((s = pb.getSelector()) != null) {
            Object[] args;
            Class[] params = new Class[]{FormulaWizardUI.class};
            try {
                Method m = s.getClass().getDeclaredMethod(CALLBACKHINT, params);
                args = new Object[]{this.wizard};
                if (m != null) {
                    m.invoke((Object)s, args);
                }
            }
            catch (Exception e) {
                logger.debug((Object)e);
            }
            try {
                params[0] = JComponent.class;
                Method m2 = s.getClass().getDeclaredMethod("setCtrlComponent", params);
                args = new Object[]{pb};
                if (m2 != null) {
                    m2.invoke((Object)s, args);
                }
            }
            catch (Exception e) {
                logger.debug((Object)e);
            }
        }
        return pb;
    }

    private void filterFreezedRptItem(KDBizPromptBox bizPmptBox, String queryInfo) {
        if ("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery".equals(queryInfo)) {
            EntityViewInfo viewInfo = bizPmptBox.getEntityViewInfo();
            if (null == viewInfo) {
                viewInfo = new EntityViewInfo();
            }
            FilterInfo fltrInfo = new FilterInfo();
            FilterItemInfo fltrItemInfo = new FilterItemInfo("isFreezed", (Object)0);
            fltrInfo.getFilterItems().add(fltrItemInfo);
            fltrInfo.setMaskString("#0");
            viewInfo.setFilter(fltrInfo);
            bizPmptBox.setEntityViewInfo(viewInfo);
        }
    }

    private void getHint(KDBizPromptBox pb, String hint) {
        try {
            Class<?> cl = Class.forName(hint);
            Object o = cl.newInstance();
            if (o instanceof IRptFormulaInductorHint) {
                IRptFormulaInductorHint h = (IRptFormulaInductorHint)o;
                h.setCustomConfig(pb);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void setSpinRange(JSpinner sp, String maxVal, String minVal) {
        Integer n2;
        if (sp == null) {
            return;
        }
        SpinnerModel sm = sp.getModel();
        if (!(sm instanceof SpinnerNumberModel)) {
            return;
        }
        SpinnerNumberModel nm = (SpinnerNumberModel)sm;
        if (maxVal != null) {
            try {
                n2 = Integer.valueOf(maxVal);
                nm.setMaximum(n2);
                if (n2 < 0) {
                    nm.setValue(n2);
                }
            }
            catch (NumberFormatException n2) {
                // empty catch block
            }
        }
        if (minVal != null) {
            try {
                n2 = Integer.valueOf(minVal);
                nm.setMinimum(n2);
                if (n2 > 0) {
                    nm.setValue(n2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private int getMainType(RptFormulaRelaxType type) {
        boolean isCustomBiz;
        if (type.getProperty("combobox_hint") != null) {
            return -1862270976;
        }
        if (type.getProperty("context_item") != null) {
            return 0x20000000;
        }
        boolean isCommonBiz = type.getProperty("selector") != null;
        isCommonBiz = isCommonBiz || type.getProperty("query") != null && type.getProperty("display_fm") != null;
        boolean bl = isCustomBiz = type.getProperty("prompt_hint") != null;
        if (isCommonBiz || isCustomBiz) {
            return 0x10000000;
        }
        String name = type.getOriginType();
        if (name == null) {
            return 0x60000000;
        }
        if ("string".equalsIgnoreCase(name)) {
            return 0x60000000;
        }
        if ("date".equalsIgnoreCase(name)) {
            return 0x40000000;
        }
        if ("datetime".equalsIgnoreCase(name)) {
            return 0x70000000;
        }
        if ("integer".equalsIgnoreCase(name)) {
            return 0x50000000;
        }
        if ("amount".equalsIgnoreCase(name)) {
            return Integer.MIN_VALUE;
        }
        if ("common".equalsIgnoreCase(name)) {
            return -1879048192;
        }
        if ("anytype".equalsIgnoreCase(name)) {
            return 4352;
        }
        return 0x60000000;
    }

    private int getSubType(String originType) {
        if (originType == null) {
            int sub = this.typeID & 0xFFFF;
            return sub == 0 ? 4096 : sub;
        }
        if ("string".equalsIgnoreCase(originType)) {
            return 4096;
        }
        if ("date".equalsIgnoreCase(originType)) {
            return 8192;
        }
        if ("datetime".equalsIgnoreCase(originType)) {
            return 4096;
        }
        if ("boolean".equalsIgnoreCase(originType)) {
            return 12288;
        }
        if ("integer".equalsIgnoreCase(originType)) {
            return 16384;
        }
        if ("amount".equalsIgnoreCase(originType)) {
            return 24576;
        }
        if ("common".equalsIgnoreCase(originType)) {
            return 28672;
        }
        return 4096;
    }

    public void setBounds(Rectangle bounds) {
        if (this.controller == null) {
            return;
        }
        this.controller.setBounds(bounds);
    }

    public JComponent getController() {
        return this.controller;
    }

    public void setController(JComponent componet) {
        this.controller = componet;
    }

    public JComponent getTrueController() {
        JComponent res = null;
        if (this.controller instanceof JSpinner) {
            JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)((JSpinner)this.controller).getEditor();
            res = editor.getTextField();
        } else {
            res = this.controller instanceof KDPromptBox ? ((KDPromptBox)this.controller).getEditor() : (this.controller instanceof KDComboBox ? (JComponent)((KDComboBox)this.controller).getEditor().getEditorComponent() : (this.controller instanceof KDDatePicker ? ((KDDatePicker)this.controller).getEditor().getEditorComponent() : this.controller));
        }
        return res;
    }

    public void show() {
        if (this.controller == null) {
            return;
        }
        this.controller.setVisible(true);
    }

    public void hide() {
    }

    public Object getValue() {
        Object res = null;
        switch (this.typeID & 0xFFFF0000) {
            case 0x30000000: {
                KDComboBox cb = (KDComboBox)this.controller;
                res = cb.getSelectedItem();
                break;
            }
            case 0x10000000: 
            case 0x20000000: {
                KDBizPromptBox bizpb;
                if (this.controller instanceof KDBizPromptBox && (bizpb = (KDBizPromptBox)this.controller).getDisplayFormatter() != null) {
                    res = bizpb.getDisplayFormatter().valueToString(bizpb.getData());
                    break;
                }
                KDPromptBox pb = (KDPromptBox)this.controller;
                res = pb.getText();
                if (this.committingString == null) break;
                res = this.committingString;
                pb.setData((Object)this.committingString);
                break;
            }
            case -1862270976: {
                KDComboBoxAgent box = (KDComboBoxAgent)((Object)this.controller);
                IItemObject item = (IItemObject)box.getSelectedItem();
                if (item == null) break;
                res = item.getAlias();
                break;
            }
            default: {
                res = this.getText();
            }
        }
        return res;
    }

    public String getText() {
        String res = null;
        switch (this.typeID & 0xFFFF0000) {
            case 0x30000000: {
                KDComboBox cb = (KDComboBox)this.controller;
                Object obj = cb.getSelectedItem();
                if (obj instanceof RptFormulaEnumEntry) {
                    RptFormulaEnumEntry en = (RptFormulaEnumEntry)obj;
                    res = ((RptFormulaEnumType)this.dataType).getEntryRawName(en.getLocalName());
                    break;
                }
                if (obj instanceof String) {
                    res = (String)obj;
                    break;
                }
                if (obj != null) break;
                res = "";
                break;
            }
            case 0x60000000: {
                KDTextField fd = (KDTextField)this.controller;
                res = fd.getText();
                break;
            }
            case 0x40000000: {
                KDSpinner sp = (KDSpinner)this.controller;
                JSpinner.DefaultEditor ed = (JSpinner.DefaultEditor)sp.getEditor();
                res = ed.getTextField().getText().toString();
                break;
            }
            case 0x70000000: {
                KDDatePicker dp = (KDDatePicker)this.controller;
                res = dp.getText();
                break;
            }
            case 0x10000000: 
            case 0x20000000: {
                IFormatter fmt;
                KDPromptBox pb = (KDPromptBox)this.controller;
                if (pb instanceof KDBizPromptBox && (fmt = ((KDBizPromptBox)pb).getEditFormatter()) != null) {
                    res = fmt.valueToString(pb.getData());
                }
                if (StringUtils.isEmpty((String)res)) {
                    res = pb.getText();
                }
                if (!StringUtils.isEmpty((String)res) || this.committingString == null) break;
                res = this.committingString;
                pb.setData((Object)this.committingString);
                break;
            }
            case -1862270976: {
                KDComboBoxAgent box = (KDComboBoxAgent)((Object)this.controller);
                IItemObject item = (IItemObject)box.getSelectedItem();
                if (item != null) {
                    res = item.getNumber();
                    break;
                }
                res = "";
                break;
            }
            case -2147483648: 
            case 0x50000000: {
                KDFormattedTextField fm = (KDFormattedTextField)this.controller;
                res = fm.getText();
                break;
            }
            default: {
                if (!(this.controller instanceof JTextField)) break;
                res = ((JTextField)this.controller).getText();
            }
        }
        return res;
    }

    public boolean controllerIsKDSpinner() {
        return (this.typeID & 0xFFFF0000) == 0x40000000;
    }

    public boolean controllerIsDate() {
        return (this.typeID & 0xFFFF0000) == 0x70000000;
    }

    public boolean isString() {
        if (this.typeID == 0) {
            // empty if block
        }
        return this.typeID == 0x60000000 || (this.typeID & 0xFFFF) == 4096;
    }

    public void setWizard(FormulaWizardUI wizardUI) {
        this.wizard = wizardUI;
    }

    public static boolean isString(RptFormulaDataType type) {
        if (type == null) {
            return true;
        }
        return "string".equalsIgnoreCase(type.getOriginType()) || "datetime".equalsIgnoreCase(type.getOriginType());
    }

    public static boolean canHaveCellRef(RptFormulaParameter param) {
        if (param == null) {
            return false;
        }
        if (param.getValueType() == 0) {
            RptFormulaDataType dt = (RptFormulaDataType)RptFormulaCompProxyFactory.getInstance().getDataType(param.getType());
            if (dt != null && "common".equalsIgnoreCase(dt.getOriginType())) {
                param.setValueType(1);
            } else {
                param.setValueType(-1);
            }
        }
        return param.getValueType() > 0;
    }

    public JComponent getBaseComponent() {
        return this.baseComponent;
    }

    public static void setControllerValue(JComponent comp, Object initValue) {
        if (comp instanceof KDSpinner) {
            ((KDSpinner)comp).setValue((Object)ParamInductor.getNumber((String)initValue));
        } else if (comp instanceof KDDatePicker) {
            Timestamp d = ParamInductor.getDateTime((String)initValue);
            ((KDDatePicker)comp).setValue((Object)d);
        } else if (comp instanceof KDBizPromptBox) {
            ((KDBizPromptBox)comp).setValue(initValue);
        } else if (comp instanceof KDPromptBox) {
            ((KDPromptBox)comp).setText((String)initValue);
        } else if (comp instanceof KDSpinner) {
            ((KDFormattedTextField)comp).setText((String)initValue);
        } else if (comp instanceof KDTextField) {
            ((KDTextField)comp).setText((String)initValue);
        }
    }

    class ControllerListener
    implements FocusListener {
        ControllerListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (e.isTemporary()) {
                return;
            }
            ParamInductor.this.baseComponent.setNextFocusableComponent(null);
            ParamInductor.this.baseComponent.setVisible(true);
            if (ParamInductor.this.baseComponent instanceof KDTextField) {
                KDTextField bc = (KDTextField)ParamInductor.this.baseComponent;
                bc.setText(ParamInductor.this.getValue() == null ? null : ParamInductor.this.getValue().toString());
                bc.setDirty(true);
            }
            ParamInductor.this.controller.setVisible(false);
        }
    }
}

