/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.eas.fi.rpt.api.IRptFormula;
import com.kingdee.eas.fi.rpt.client.FormulaWizardCompoundResult;
import com.kingdee.eas.fi.rpt.client.IRptFormulaValidator;
import com.kingdee.eas.fi.rptapi.NoSuchSystemException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.lang.reflect.Constructor;
import org.apache.log4j.Logger;

public class RptFormulaValidatorFactory {
    private static Logger logger = Logger.getLogger(RptFormulaValidatorFactory.class);
    private static final String VALIDATOR_CLZ_PZTH = "com.kingdee.eas.fi.rpt.client.RptFormulaValidatorImpl";
    private static Constructor constr;
    private IRptFormula formula;
    private FormulaWizardCompoundResult res;

    public RptFormulaValidatorFactory(IRptFormula formula, FormulaWizardCompoundResult res) {
        this.formula = formula;
        this.res = res;
        this.getConstructor();
    }

    public static IRptFormulaValidator newInstance(IRptFormula formula, FormulaWizardCompoundResult res) throws Exception {
        return new RptFormulaValidatorFactory(formula, res).getFormulaValidator();
    }

    private void getConstructor() {
        try {
            if (constr == null) {
                Class<?> clz = Class.forName(VALIDATOR_CLZ_PZTH, false, this.getClass().getClassLoader());
                constr = clz.getConstructor(IRptFormula.class, FormulaWizardCompoundResult.class);
            }
        }
        catch (ClassNotFoundException e) {
            ExceptionHandler.handle((Throwable)((Object)new NoSuchSystemException(NoSuchSystemException.NOT_EXIST_SYSTEM, e)));
            SysUtil.abort();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private IRptFormulaValidator getFormulaValidator() throws Exception {
        return (IRptFormulaValidator)constr.newInstance(this.formula, this.res);
    }
}

