/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.eas.fi.rpt.client.IRptDataChecker;
import com.kingdee.eas.fi.rpt.client.IRptDataPublisher;
import com.kingdee.eas.fi.rpt.client.IRptDataSucker;
import com.kingdee.eas.fi.rpt.client.RptFormulaCompProxyFactory;
import java.util.Comparator;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class RptOperObject
implements IRptDataChecker,
IRptDataSucker {
    protected String name;
    protected HashMap alias;
    protected HashMap description;
    protected int status;
    protected IRptDataPublisher publisher;
    protected static String language;
    protected static final int STA_INIT = 0;
    protected static final int STA_ERROR = -1;
    private static RptObjComparator comparator;

    public RptOperObject(String name) {
        this(name, null);
    }

    public RptOperObject(String name, IRptDataPublisher pb) {
        this.name = name;
        this.publisher = pb;
        this.alias = new HashMap(3, 0.75f);
        this.description = new HashMap(3, 0.75f);
        language = RptFormulaCompProxyFactory.getInstance().getLanguage();
    }

    public String getDescription() {
        String desc = (String)this.description.get(language);
        if (desc == null) {
            desc = (String)this.alias.get(language);
        }
        if (desc == null) {
            desc = (String)this.alias.get(RptFormulaCompProxyFactory.getInstance().getConstantVariable("default"));
        }
        if (desc == null) {
            desc = (String)this.alias.get(RptFormulaCompProxyFactory.getInstance().getConstantVariable("en_US"));
        }
        return desc;
    }

    public String getLocalName() {
        String lname = (String)this.alias.get(language);
        if (lname == null) {
            lname = (String)this.alias.get(RptFormulaCompProxyFactory.getInstance().getConstantVariable("default"));
        }
        if (lname == null) {
            lname = (String)this.alias.get(RptFormulaCompProxyFactory.getInstance().getConstantVariable("en_US"));
        }
        if (lname == null) {
            lname = this.name;
        }
        return lname;
    }

    @Override
    public abstract void goContent(String var1);

    @Override
    public abstract void goInto(String var1, Attributes var2) throws SAXException;

    @Override
    public abstract void goOut(String var1);

    public String toString() {
        return this.getLocalName();
    }

    public boolean isNamedAs(String name) {
        if (name == null) {
            return false;
        }
        String lname = (String)this.alias.get(language);
        if (lname != null && name.equalsIgnoreCase(lname)) {
            return true;
        }
        lname = (String)this.alias.get(RptFormulaCompProxyFactory.getInstance().getConstantVariable("default"));
        if (lname != null && name.equalsIgnoreCase(lname)) {
            return true;
        }
        lname = (String)this.alias.get(RptFormulaCompProxyFactory.getInstance().getConstantVariable("en_US"));
        if (lname == null && name.equalsIgnoreCase(lname)) {
            return true;
        }
        lname = this.name;
        return name.equalsIgnoreCase(lname);
    }

    public void setLocalName(String language, String text) {
        this.alias.put(language, text);
    }

    public void setDescription(String language, String text) {
        this.description.put(language, text);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void clear() {
        this.alias.clear();
        this.description.clear();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RptOperObject ro = (RptOperObject)obj;
        if (this.name == null) {
            return ro.name == null;
        }
        return this.name.equals(ro.name);
    }

    public static Comparator getComparator() {
        if (comparator == null) {
            comparator = new RptObjComparator();
        }
        return comparator;
    }

    static {
        comparator = null;
    }

    static class RptObjComparator
    implements Comparator {
        RptObjComparator() {
        }

        public int compare(Object o1, Object o2) {
            String n2;
            int res = this.comparePointer(o1, o2);
            if (res != 2) {
                return res;
            }
            String n1 = ((RptOperObject)o1).getName();
            res = this.comparePointer(n1, n2 = ((RptOperObject)o2).getName());
            if (res == 2) {
                res = n1.compareTo(n2);
            }
            return res;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return RptObjComparator.class.equals(obj.getClass());
        }

        private int comparePointer(Object p1, Object p2) {
            if (p1 == null) {
                return p2 == null ? 0 : -1;
            }
            return p2 == null ? 1 : 2;
        }
    }
}

