/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.fm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IKACLlassficationType;
import com.kingdee.eas.basedata.assistant.KACLlassficationTypeCollection;
import com.kingdee.eas.basedata.assistant.KACLlassficationTypeFactory;
import com.kingdee.eas.basedata.assistant.KACLlassficationTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.sql.SQLException;
import java.util.HashMap;
import javax.swing.JToolBar;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class ClientHelper {
    public static final int TOTAL = 0xF6F6B6;
    public static final int SUBTOTAL = 16119270;
    private static final Logger logger = CoreUIObject.getLogger((String)"com.kingdee.eas.base.core.fm.ClientHelper");
    public static final String RES = "com.kingdee.eas.base.core.fm.UIMessageResource";
    public static final String resourcePath = "com.kingdee.eas.fm.fs.FSClientResource";
    public static final HashMap mapPrecOfCurrency = new HashMap(32);

    public static String getInnerAccountClassificationType(String objectTypeId) {
        KACLlassficationTypeInfo info;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("objectType.id", (Object)objectTypeId));
        ev.setFilter(fi);
        KACLlassficationTypeCollection coll = null;
        try {
            IKACLlassficationType iKAClassficationType = KACLlassficationTypeFactory.getRemoteInstance();
            coll = iKAClassficationType.getKACLlassficationTypeCollection(ev);
        }
        catch (BOSException e) {
            MsgBox.showError((String)EASResource.getString((String)resourcePath, (String)"GetKACLlassficationTypeFail"));
            SysUtil.abort();
        }
        KACLlassficationTypeInfo kACLlassficationTypeInfo = info = null != coll ? coll.get(0) : null;
        if (info != null) {
            return info.getId().toString();
        }
        return null;
    }

    public static int getPrecOfCurrency(BOSUuid currencyId) {
        if (mapPrecOfCurrency.size() == 0) {
            ClientHelper.setPrecOfCurrenty(mapPrecOfCurrency);
        }
        if (!mapPrecOfCurrency.containsKey(currencyId)) {
            CurrencyInfo info = ClientHelper.getCurrencyInfo(currencyId);
            if (info != null) {
                mapPrecOfCurrency.put(info.getId(), new Integer(info.getPrecision()));
                return info.getPrecision();
            }
            return 10;
        }
        return (Integer)mapPrecOfCurrency.get(currencyId);
    }

    public static CurrencyInfo getCurrencyInfo(BOSUuid id) {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        CurrencyInfo info = null;
        try {
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            info = iCurrency.getCurrencyInfo((IObjectPK)pk);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        return info;
    }

    private static void setPrecOfCurrenty(HashMap map) {
        String str = "select fid,fprecision from t_bd_currency";
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)str);
        IRowSet rs = null;
        try {
            rs = sqlExe.executeSQL();
            while (rs.next()) {
                map.put(BOSUuid.read((String)rs.getString(1)), new Integer(rs.getInt(2)));
            }
        }
        catch (BOSException bose) {
            return;
        }
        catch (SQLException sqle) {
            return;
        }
    }

    public static void clearSeparatorOnToolBar(KDToolBar toolBar) {
        int i;
        int size = toolBar.getComponentCount();
        Component c = null;
        boolean isSeparator = false;
        int lastVisibleBtnPosition = 0;
        for (i = 0; i < size; ++i) {
            c = toolBar.getComponentAtIndex(i);
            if (!c.isVisible()) continue;
            if (c instanceof JToolBar.Separator) {
                if (isSeparator) {
                    c.setVisible(false);
                }
                isSeparator = true;
                continue;
            }
            isSeparator = false;
            lastVisibleBtnPosition = i;
        }
        for (i = lastVisibleBtnPosition; i < size; ++i) {
            c = toolBar.getComponentAtIndex(i);
            if (!(c instanceof JToolBar.Separator)) continue;
            c.setVisible(false);
        }
    }

    public static DefaultKingdeeTreeNode goLeaf(KDTree tree) {
        TreeModel model = tree.getModel();
        if (model == null) {
            return null;
        }
        Object objNode = model.getRoot();
        while (tree.getModel().getChildCount(objNode) > 0) {
            objNode = tree.getModel().getChild(objNode, 0);
        }
        tree.setSelectionNode((DefaultKingdeeTreeNode)objNode);
        return (DefaultKingdeeTreeNode)objNode;
    }

    public static void showSuccessInfo(CoreUI ui, ItemAction action) {
        if (action == null) {
            return;
        }
        ui.setMessageText(action.getExtendProperty("Name") + EASResource.getString((String)RES, (String)"SUCCESS"));
        ui.showMessage();
    }
}

