/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.fm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fi.gl.GLUtil;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.HashMap;
import org.apache.log4j.Logger;

public final class ContextHelperSrv
implements IContextHelper {
    private Context ctx;
    private static final Logger logger = CoreUIObject.getLogger((String)"com.kingdee.eas.base.core.fm.ContextHelperSrv");

    public ContextHelperSrv(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public CompanyOrgUnitInfo getCurrentCompany() {
        return ContextUtil.getCurrentFIUnit((Context)this.ctx);
    }

    @Override
    public CtrlUnitInfo getCurrentCtrlUnit() {
        return ContextUtil.getCurrentCtrlUnit((Context)this.ctx);
    }

    @Override
    public UserInfo getCurrentUser() {
        return ContextUtil.getCurrentUserInfo((Context)this.ctx);
    }

    @Override
    public String getSessionID() {
        return this.ctx.getContextID();
    }

    @Override
    public boolean isOnlyUnion(CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        if (company.containsKey("isOnlyUnion")) {
            return GLUtil.isCompanyUnion((CompanyOrgUnitInfo)company);
        }
        ICompanyOrgUnit corgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("isOnlyUnion");
        CompanyOrgUnitInfo info = corgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selectors);
        return GLUtil.isCompanyUnion((CompanyOrgUnitInfo)info);
    }

    @Override
    public CurrencyInfo getCompanyBaseCurrency(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        CurrencyInfo currency = null;
        if (company == null) {
            return null;
        }
        if (company.getBaseCurrency() != null) {
            currency = company.getBaseCurrency();
            return currency;
        }
        ICompanyOrgUnit corgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("baseCurrency.*");
        CompanyOrgUnitInfo info = corgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selectors);
        currency = info.getBaseCurrency();
        return currency;
    }

    @Override
    public int getIntParam(String key, IObjectPK orgPK) {
        int rst = 0;
        String value = this.getStringParam(key, orgPK);
        if (value == null || value.trim().length() == 0) {
            return 0;
        }
        rst = Integer.parseInt(value);
        return rst;
    }

    @Override
    public boolean getBooleanParam(String key, IObjectPK orgPK) {
        String value = this.getStringParam(key, orgPK);
        boolean rst = Boolean.valueOf(value);
        return rst;
    }

    @Override
    public String getStringParam(String key, IObjectPK orgPK) {
        HashMap<String, IObjectPK> map = new HashMap<String, IObjectPK>();
        map.put(key, orgPK);
        String value = null;
        try {
            IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)this.ctx);
            HashMap param = iParamControl.getParamHashMap(map);
            value = (String)param.get(key);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return value;
    }

    public Object[] getAllCompany() {
        try {
            return CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitCollection().toArray();
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public AdminOrgUnitInfo getCurrentAdmin() {
        return ContextUtil.getCurrentAdminUnit((Context)this.ctx);
    }
}

