/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.fm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.IEJBAccess;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;

public abstract class EJBAccessBase
implements IEJBAccess {
    protected abstract IMetaDataLoader getMetaDataLoader();

    @Override
    public String getEntityAlias(BOSObjectType entityType) throws BOSException {
        return this.getEntityInfo(entityType).getAlias();
    }

    @Override
    public Class getObjectValueClass(BOSObjectType entityType) throws BOSException {
        EntityObjectInfo entity = this.getEntityInfo(entityType);
        try {
            return Class.forName(entity.getObjectValueClass());
        }
        catch (ClassNotFoundException e) {
            BOSException be = new BOSException((Throwable)e);
            be.setStackTrace(e.getStackTrace());
            throw be;
        }
    }

    @Override
    public String getEntityTableName(BOSObjectType entityType) throws BOSException {
        return this.getEntityInfo(entityType).getTable().getName();
    }

    @Override
    public EntityObjectInfo getEntityInfo(BOSObjectType entityType) throws BOSException {
        return this.getMetaDataLoader().getEntity(entityType);
    }

    @Override
    public String getEntityAlias(String id) throws BOSException {
        BOSUuid uuid = BOSUuid.read((String)id);
        return this.getEntityAlias(uuid.getType());
    }

    @Override
    public ICoreBase getEntityBizInterface(String id) throws BOSException {
        BOSUuid uuid = BOSUuid.read((String)id);
        return this.getEntityBizInterface(uuid.getType());
    }

    @Override
    public CoreBaseInfo getEntityInfo(String id) throws BOSException, EASBizException {
        ICoreBase bizIntf = this.getEntityBizInterface(id);
        return bizIntf.getValue((IObjectPK)new ObjectUuidPK(id));
    }

    @Override
    public CoreBaseInfo getEntityInfo(String id, SelectorItemCollection sic) throws BOSException, EASBizException {
        ICoreBase bizIntf = this.getEntityBizInterface(id);
        return bizIntf.getValue((IObjectPK)new ObjectUuidPK(id), sic);
    }

    @Override
    public ICoreBase getEntityBizInterface(CoreBaseInfo ov) throws BOSException {
        return this.getEntityBizInterface(ov.getId().toString());
    }

    @Override
    public void deleteObjectValue(String id) throws BOSException, EASBizException {
        ICoreBase bizIntf = this.getEntityBizInterface(id);
        bizIntf.delete((IObjectPK)new ObjectUuidPK(id));
    }

    @Override
    public void deleteObjectValue(CoreBaseInfo ov) throws BOSException, EASBizException {
        String id = ov.getId().toString();
        ICoreBase bizIntf = this.getEntityBizInterface(id);
        bizIntf.delete((IObjectPK)new ObjectUuidPK(id));
    }

    @Override
    public void updateObjectValue(CoreBaseInfo ov) throws BOSException, EASBizException {
        String id = ov.getId().toString();
        ICoreBase bizIntf = this.getEntityBizInterface(id);
        bizIntf.update((IObjectPK)new ObjectUuidPK(id), ov);
    }
}

