/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.fm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.FMClientHelper;
import com.kingdee.eas.base.core.fm.client.AbstractOnLineHelpListUINew;
import com.kingdee.eas.base.core.fm.client.FileObject;
import com.kingdee.eas.base.core.fm.client.OnLineHelpUtil;
import com.kingdee.eas.base.core.fm.client.Resource;
import com.kingdee.eas.base.core.fm.client.ResourceUtils;
import com.kingdee.eas.base.core.fm.client.Ui2OnLineHelpMaping;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

public class OnLineHelpListUINew
extends AbstractOnLineHelpListUINew {
    private static final Logger logger = CoreUIObject.getLogger(OnLineHelpListUINew.class);
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final String WEBURL = "http://web20.kingdee.com/user/res";
    private static int BUFFER_SIZE = 8096;
    private String savePath = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdFileList.checkParsed();
        this.kdFileList.getSelectManager().setSelectMode(2);
        this.kdFileList.getStyleAttributes().setLocked(true);
        ArrayList<Resource> resList = this.getDefalutResList();
        this.fillResTree(resList);
        this.setHelp();
        boolean isViewlLable = true;
        this.setPage(isViewlLable);
    }

    private void setHelp() {
        StringBuffer help = new StringBuffer();
        help.append("<html>");
        help.append("<body>");
        help.append("<p><strong>\u76ee\u7684\uff1a</strong>\u63d0\u4f9b\u4ea7\u54c1\u4f7f\u7528\u8fc7\u7a0b\u4e2d\u5e38\u89c1\u548c\u91cd\u590d\u95ee\u9898\u7684\u89e3\u51b3\u65b9\u6848\uff0c\u63d0\u9ad8\u652f\u6301\u6548\u7387\u3002</p>");
        help.append("<p><strong>\u7279\u70b9\uff1a</strong>FAQ\u548c\u4ea7\u54c1\u7d27\u5bc6\u96c6\u6210\u5bb9\u6613\u83b7\u53d6\u3001\u5728\u7ebf\u66f4\u65b0\u3001\u667a\u80fd\u5b9a\u4f4d\u3001\u63d0\u4f9b\u95ee\u9898\u8bc4\u4ef7\u673a\u5236\u3002</p>");
        help.append("<p><strong>\u4f7f\u7528\u4ecb\u7ecd\uff1a</strong></p>");
        help.append("<p>1\u3001\u4ea7\u54c1\u4f7f\u7528\u9047\u5230\u95ee\u9898\uff0c\u8bf7\u5148\u4ece\u5728\u7ebfFAQ\u4e2d\u5bfb\u627e\u662f\u5426\u5df2\u7ecf\u6709\u6b64\u95ee\u9898\u89e3\u51b3\u65b9\u6848\uff1b</p>");
        help.append("<p>2\u3001\u5982\u679c\u627e\u5230\u76f8\u5e94\u7684\u95ee\u9898\uff0c\u6309\u7167\u7b54\u6848\u64cd\u4f5c\u540e\uff0c\u5bf9\u95ee\u9898\u8fdb\u884c\u8bc4\u4ef7\uff1b</p>");
        help.append("<p>3\u3001\u6211\u4eec\u4f1a\u6839\u636e\u65e5\u5e38\u4ea7\u54c1\u652f\u6301\u95ee\u9898\u60c5\u51b5\u548c\u8bc4\u4ef7\u60c5\u51b5\u5bf9\u5728\u7ebfFAQ\u53ca\u65f6\u66f4\u65b0\uff1b</p>");
        help.append("<p>&nbsp;</p>");
        help.append("<p><strong>\u8054\u7cfb\u65b9\u5f0f\uff1a</strong></p>");
        help.append("<p>\u6709\u4efb\u4f55\u5173\u4e8e\u5728\u7ebfFAQ\u7684\u5efa\u8bae\u548c\u610f\u89c1\uff0c\u6b22\u8fce\u53d1\u90ae\u4ef6\u5230\uff1akd_eas@kingdee.com\uff0c</p>");
        help.append("<p>\u90ae\u4ef6\u6807\u9898\u8bf7\u6ce8\u660e\u5173\u952e\u8bcd\uff08\u5728\u7ebfFAQ\uff09\uff0c\u8c22\u8c22\uff01</p>");
        help.append("</body>");
        help.append("</html>");
        this.editPanel.setText(help.toString());
    }

    private ArrayList<Resource> getDefalutResList() {
        String uiclass = (String)this.getUIContext().get("uiclass");
        Ui2OnLineHelpMaping onLineHelpUtil = Ui2OnLineHelpMaping.getInstance();
        ArrayList<Resource> resList = OnLineHelpUtil.getResList(uiclass, onLineHelpUtil);
        return resList;
    }

    private void fillResTree(ArrayList<Resource> resList) {
        this.treeView.setShowButton(false);
        this.treeList.setModel(OnLineHelpUtil.getNtTypeGroupTreeModel(resList));
        this.treeList.setCollapsePathDisabled(false);
        this.treeList.setRootVisible(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void treeList_valueChanged(TreeSelectionEvent e) throws Exception {
        TreePath path = this.treeList.getSelectionPath();
        if (path == null) {
            return;
        }
        String id = "";
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        Resource obj = (Resource)node.getUserObject();
        int count = path.getPathCount();
        if (count != 1) {
            id = obj.getId();
        }
        boolean isViewlLable = false;
        this.setPage(isViewlLable);
        this.viewAResource(id);
    }

    private void setPage(boolean isViewlLable) {
        this.kDPanel1.setVisible(!isViewlLable);
        this.lablePanel.setVisible(isViewlLable);
    }

    private void viewAResource(String id) throws EASBizException, BOSException {
        ResourceUtils resUtil = new ResourceUtils();
        Resource res = resUtil.getAResource(id);
        this.fillData(res);
    }

    private void fillData(Resource res) throws BOSException, EASBizException {
        this.txtId.setText(res.getId());
        this.lblName.setText("\u95ee\u9898\uff1a" + res.getName());
        this.txtDesc.setText(res.getDesc());
        this.lblAuthor.setText("\u4f5c\u8005\uff1a" + res.getAuthor());
        this.lblUpdateDate.setText("\u66f4\u65b0\u65e5\u671f\uff1a" + res.getUpdateTime());
        int allCount = Integer.parseInt(res.getScorec());
        int usefulCount = Integer.parseInt(res.getScores()) / 5;
        int usefullessCount = allCount - usefulCount;
        this.lblResult.setHorizontalAlignment(2);
        String lblResult = "\u5f53\u524d\u8bc4\u4ef7\u7ed3\u679c\uff1a\u6709 " + usefulCount + "\u4e2a\u4eba\u8ba4\u4e3a\u5bf9\u4ed6\u6709\u7528\uff1b\u6709" + usefullessCount + "\u4e2a\u4eba\u8ba4\u4e3a\u5bf9\u4ed6\u6ca1\u7528";
        this.lblResult.setText(lblResult);
        ArrayList<FileObject> fileList = res.getFileList();
        this.kdFileList.removeRows();
        int size = fileList.size();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kdFileList.addRow();
            FileObject file = fileList.get(i);
            row.getCell(NAME).setValue((Object)file.getName());
            row.getCell("size").setValue((Object)file.getLength());
            row.getCell("updateDate").setValue((Object)file.getUploadDate());
            row.setUserObject((Object)file);
        }
    }

    @Override
    protected void kdFileList_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.downLoadFile();
        }
    }

    private void downLoadFile() throws IOException {
        IRow row = this.getSelectedRow();
        String id = this.txtId.getText();
        String version = this.txtVersion.getText();
        String name = row.getCell(NAME).getValue().toString();
        String customerNum = ResourceUtils.getCustomerNumber();
        this.setFileSavePath();
        if (this.savePath != null) {
            String codeName = URLEncoder.encode(name, "utf-8");
            String uri = "http://web20.kingdee.com/user/res/dnload?id=" + id + "&version=" + version + "&name=" + codeName + "&cno=" + customerNum;
            String fileName = this.savePath + "/" + name;
            File file = new File(fileName);
            if (!file.exists()) {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            }
            this.downloadFile(uri, file);
            MsgBox.showInfo((String)"\u8d44\u6e90\u4e0b\u8f7d\u6210\u529f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(String uri, File file) {
        byte[] buf = new byte[BUFFER_SIZE];
        int size = 0;
        HttpClient httpClient = new HttpClient();
        GetMethod httpGet = new GetMethod(uri);
        try {
            httpClient.executeMethod((HttpMethod)httpGet);
            InputStream in = httpGet.getResponseBodyAsStream();
            BufferedInputStream bis = new BufferedInputStream(in);
            FileOutputStream fos = new FileOutputStream(file);
            while ((size = bis.read(buf)) != -1) {
                fos.write(buf, 0, size);
            }
            fos.close();
            bis.close();
        }
        catch (IOException e) {
            MsgBox.showError((String)"\u4e0b\u8f7d\u51fa\u9519");
        }
        finally {
            httpGet.releaseConnection();
        }
    }

    protected IRow getSelectedRow() {
        int rowNumber = FMClientHelper.getSelectedRow(this.kdFileList);
        if (rowNumber == -1) {
            MsgBox.showWarning((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6");
            SysUtil.abort();
        }
        IRow row = this.kdFileList.getRow(rowNumber);
        return row;
    }

    private void setFileSavePath() {
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle("\u8bf7\u9009\u62e9\u4fdd\u5b58\u8def\u5f84");
        fileChooser.setFileSelectionMode(1);
        fileChooser.setAcceptAllFileFilterUsed(false);
        int result = fileChooser.showOpenDialog((Component)((Object)this));
        this.savePath = result == 0 ? fileChooser.getSelectedFile().toString() : null;
    }

    @Override
    protected void btnUseful_actionPerformed(ActionEvent e) throws Exception {
        ResourceUtils resUtil = new ResourceUtils();
        String id = this.txtId.getText();
        String evaluation = resUtil.setUseFulResource(id, true);
        if (evaluation.equals("\u4f60\u4e0d\u80fd\u91cd\u590d\u8bc4\u4ef7")) {
            MsgBox.showInfo((String)"\u60a8\u4e0d\u80fd\u91cd\u590d\u8bc4\u4ef7\uff0c\u611f\u8c22\u60a8\u7684\u652f\u6301\uff01");
        } else {
            Resource res = resUtil.getAResource(id);
            MsgBox.showInfo((String)"\u8bc4\u4ef7\u6210\u529f\uff0c\u60a8\u7684\u8bc4\u4ef7\u5bf9\u6211\u4eec\u5b8c\u5584\u4ea7\u54c1\u975e\u5e38\u6709\u7528\uff0c\u611f\u8c22\u60a8\u7684\u652f\u6301\uff01");
            this.fillData(res);
        }
    }

    @Override
    protected void btnUseless_actionPerformed(ActionEvent e) throws Exception {
        ResourceUtils resUtil = new ResourceUtils();
        String id = this.txtId.getText();
        String evaluation = resUtil.setUseFulResource(id, false);
        if (evaluation.equals("\u4f60\u4e0d\u80fd\u91cd\u590d\u8bc4\u4ef7")) {
            MsgBox.showInfo((String)"\u60a8\u4e0d\u80fd\u91cd\u590d\u8bc4\u4ef7\uff0c\u611f\u8c22\u60a8\u7684\u652f\u6301\uff01");
        } else {
            Resource res = resUtil.getAResource(id);
            MsgBox.showInfo((String)"\u8bc4\u4ef7\u6210\u529f\uff0c\u60a8\u7684\u8bc4\u4ef7\u5bf9\u6211\u4eec\u5b8c\u5584\u4ea7\u54c1\u975e\u5e38\u6709\u7528\uff0c\u611f\u8c22\u60a8\u7684\u652f\u6301\uff01");
            this.fillData(res);
        }
    }

    @Override
    protected void btnSerach_actionPerformed(ActionEvent e) throws Exception {
        String searchContent = this.txtSearch.getText();
        if (searchContent == null || searchContent.length() == 0) {
            MsgBox.showInfo((String)"\u8bf7\u8f93\u5165\u641c\u7d22\u5173\u952e\u5b57\uff01");
            this.txtSearch.requestFocus();
            SysUtil.abort();
        }
        ResourceUtils resUtil = new ResourceUtils();
        String search = URLEncoder.encode(searchContent, "utf-8");
        ArrayList resList = resUtil.getResource(new String[]{search}, true);
        this.fillResTree(resList);
    }

    @Override
    protected void btnReturn_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<Resource> resList = this.getDefalutResList();
        this.fillResTree(resList);
        boolean isViewlLable = true;
        this.setPage(isViewlLable);
    }
}

