/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.fm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.FMClientHelper;
import com.kingdee.eas.base.core.fm.client.AbstractOnLineHelpViewUI;
import com.kingdee.eas.base.core.fm.client.FileObject;
import com.kingdee.eas.base.core.fm.client.Resource;
import com.kingdee.eas.base.core.fm.client.ResourceUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

public class OnLineHelpViewUI
extends AbstractOnLineHelpViewUI {
    private static final Logger logger = CoreUIObject.getLogger(OnLineHelpViewUI.class);
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final String WEBURL = "http://web20.kingdee.com/user/res";
    private static int BUFFER_SIZE = 8096;
    private String savePath = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        String id = (String)this.getUIContext().get(ID);
        ResourceUtils resUtil = new ResourceUtils();
        Resource res = resUtil.getAResource(id);
        this.fillData(res);
    }

    private void fillData(Resource res) throws BOSException, EASBizException {
        this.txtId.setText(res.getId());
        this.txtName.setText(res.getName());
        this.txtDesc.setText(res.getDesc());
        this.txtUpdateTime.setText(res.getUpdateTime());
        this.txtVersion.setText(res.getVersion());
        int allCount = Integer.parseInt(res.getScorec());
        int usefulCount = Integer.parseInt(res.getScores()) / 5;
        int usefullessCount = allCount - usefulCount;
        this.lblResult.setHorizontalAlignment(4);
        String lblResult = "\u5f53\u524d\u8bc4\u4ef7\u7ed3\u679c\uff1a\u6709 " + usefulCount + "\u4e2a\u4eba\u8ba4\u4e3a\u5bf9\u4ed6\u6709\u7528\uff1b\u6709" + usefullessCount + "\u4e2a\u4eba\u8ba4\u4e3a\u5bf9\u4ed6\u6ca1\u7528";
        this.lblResult.setText(lblResult);
        ArrayList<FileObject> fileList = res.getFileList();
        this.tblMain.removeRows();
        int size = fileList.size();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.addRow();
            FileObject file = fileList.get(i);
            row.getCell(NAME).setValue((Object)file.getName());
            row.getCell("size").setValue((Object)file.getLength());
            row.getCell("date").setValue((Object)file.getUploadDate());
            row.setUserObject((Object)file);
        }
    }

    @Override
    protected void btnUseful_actionPerformed(ActionEvent e) throws Exception {
        ResourceUtils resUtil = new ResourceUtils();
        String id = this.txtId.getText();
        String evaluation = resUtil.setUseFulResource(id, true);
        if (evaluation.equals("\u4f60\u4e0d\u80fd\u91cd\u590d\u8bc4\u4ef7")) {
            MsgBox.showInfo((String)"\u60a8\u4e0d\u80fd\u91cd\u590d\u8bc4\u4ef7\uff0c\u611f\u8c22\u60a8\u7684\u652f\u6301\uff01");
        } else {
            Resource res = resUtil.getAResource(id);
            this.fillData(res);
            MsgBox.showInfo((String)"\u8bc4\u4ef7\u6210\u529f\uff0c\u60a8\u7684\u8bc4\u4ef7\u5bf9\u6211\u4eec\u5b8c\u5584\u4ea7\u54c1\u975e\u5e38\u6709\u7528\uff0c\u611f\u8c22\u60a8\u7684\u652f\u6301\uff01");
        }
    }

    @Override
    protected void btnUseless_actionPerformed(ActionEvent e) throws Exception {
        ResourceUtils resUtil = new ResourceUtils();
        String id = this.txtId.getText();
        String evaluation = resUtil.setUseFulResource(id, false);
        if (evaluation.equals("\u4f60\u4e0d\u80fd\u91cd\u590d\u8bc4\u4ef7")) {
            MsgBox.showInfo((String)"\u60a8\u4e0d\u80fd\u91cd\u590d\u8bc4\u4ef7\uff0c\u611f\u8c22\u60a8\u7684\u652f\u6301\uff01");
        } else {
            Resource res = resUtil.getAResource(id);
            this.fillData(res);
            MsgBox.showInfo((String)"\u8bc4\u4ef7\u6210\u529f\uff0c\u60a8\u7684\u8bc4\u4ef7\u5bf9\u6211\u4eec\u5b8c\u5584\u4ea7\u54c1\u975e\u5e38\u6709\u7528\uff0c\u611f\u8c22\u60a8\u7684\u652f\u6301\uff01");
        }
    }

    @Override
    protected void btnDownload_actionPerformed(ActionEvent e) throws Exception {
        this.downLoadFile();
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.downLoadFile();
        }
    }

    private void downLoadFile() throws IOException {
        IRow row = this.getSelectedRow();
        String id = this.txtId.getText();
        String version = this.txtVersion.getText();
        String name = row.getCell(NAME).getValue().toString();
        String customerNum = ResourceUtils.getCustomerNumber();
        this.setFileSavePath();
        if (this.savePath != null) {
            String codeName = URLEncoder.encode(name, "utf-8");
            String uri = "http://web20.kingdee.com/user/res/dnload?id=" + id + "&version=" + version + "&name=" + codeName + "&cno=" + customerNum;
            String fileName = this.savePath + "/" + name;
            File file = new File(fileName);
            if (!file.exists()) {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            }
            this.downloadFile(uri, file);
            MsgBox.showInfo((String)"\u8d44\u6e90\u4e0b\u8f7d\u6210\u529f");
        }
    }

    protected IRow getSelectedRow() {
        int rowNumber = FMClientHelper.getSelectedRow(this.tblMain);
        if (rowNumber == -1) {
            MsgBox.showWarning((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6");
            SysUtil.abort();
        }
        IRow row = this.tblMain.getRow(rowNumber);
        return row;
    }

    private void setFileSavePath() {
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle("\u8bf7\u9009\u62e9\u4fdd\u5b58\u8def\u5f84");
        fileChooser.setFileSelectionMode(1);
        fileChooser.setAcceptAllFileFilterUsed(false);
        int result = fileChooser.showOpenDialog((Component)((Object)this));
        this.savePath = result == 0 ? fileChooser.getSelectedFile().toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(String uri, File file) {
        byte[] buf = new byte[BUFFER_SIZE];
        int size = 0;
        HttpClient httpClient = new HttpClient();
        GetMethod httpGet = new GetMethod(uri);
        try {
            httpClient.executeMethod((HttpMethod)httpGet);
            InputStream in = httpGet.getResponseBodyAsStream();
            BufferedInputStream bis = new BufferedInputStream(in);
            FileOutputStream fos = new FileOutputStream(file);
            while ((size = bis.read(buf)) != -1) {
                fos.write(buf, 0, size);
            }
            fos.close();
            bis.close();
        }
        catch (IOException e) {
            MsgBox.showError((String)"\u4e0b\u8f7d\u51fa\u9519");
        }
        finally {
            httpGet.releaseConnection();
        }
    }
}

