/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.jdbc.rowset.FetchedTooMuchRowsException;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.jdbc.rowset.impl.Row;
import com.kingdee.jdbc.rowset.impl.RowSetMetaDataImpl;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.sql.RowSetMetaData;

public class FMJdbcRowSet
extends JdbcRowSet {
    public int populate(ResultSet rs, int start, int rows, boolean refreshMetaData) throws SQLException {
        ResultSetMetaData RSMD = rs.getMetaData();
        int colCount = RSMD.getColumnCount();
        int fetched = 0;
        int currentRowIndex = -1;
        int logNumber = Integer.MAX_VALUE;
        int exceptionNumber = Integer.MAX_VALUE;
        assert (colCount > 0);
        if (UPPER_CELLNUMBER_FOR_LOG > 0) {
            logNumber = UPPER_CELLNUMBER_FOR_LOG;
        }
        if (UPPER_CELLNUMBER_FOR_EXCEPTION > 0) {
            exceptionNumber = UPPER_CELLNUMBER_FOR_EXCEPTION;
        }
        while (rs.next()) {
            if (start == -1 || ++currentRowIndex < start) continue;
            if (currentRowIndex >= start && (fetched < rows || rows == -1)) {
                Row row = new Row(colCount);
                for (int k = 1; k <= colCount; ++k) {
                    if (RSMD.getColumnType(k) == 2005 || RSMD.getColumnType(k) == 2004) {
                        if (rs.getObject(k) != null) {
                            row.initColumnObject(k, (Object)"CLOB\u3001BLOB\u6709\u503c");
                            continue;
                        }
                        row.initColumnObject(k, rs.getObject(k));
                        continue;
                    }
                    row.initColumnObject(k, rs.getObject(k));
                }
                this.cachedRows.add(row);
                int fetchedCell = (this.numRows + ++fetched) * colCount;
                if (fetchedCell >= exceptionNumber) {
                    StringBuffer msgBuf = new StringBuffer("fetched too much rows, cell number exceeding limit ");
                    msgBuf.append(exceptionNumber).append(". fetched column count:").append(colCount).append(". fected row count:").append(this.numRows + fetched).append(". fected cell count:").append(fetchedCell);
                    throw new FetchedTooMuchRowsException(msgBuf.toString());
                }
            }
            if (fetched != rows) continue;
        }
        this.numRows += fetched;
        int fetchedCell = this.numRows * colCount;
        StringBuffer msgBuf = new StringBuffer("fetched too much rows, cell number exceeding log limit ");
        msgBuf.append(logNumber).append(". fetched column count:").append(colCount).append(". fected row count:").append(this.numRows + fetched).append(". fected cell count:").append(fetchedCell);
        if (fetchedCell >= logNumber) {
            try {
                throw new FetchedTooMuchRowsException(msgBuf.toString());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (refreshMetaData) {
            this.rowSetMD = new RowSetMetaDataImpl();
            this.initMetaData((RowSetMetaData)this.rowSetMD, RSMD);
        }
        RSMD = null;
        return fetched;
    }
}

