/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.analysis.util.editor.DefaultEditorStyleModel;
import com.kingdee.bos.ctrl.analysis.util.editor.EditorStyleModel;
import com.kingdee.bos.ctrl.analysis.util.editor.Lexer;
import com.kingdee.bos.ctrl.analysis.util.editor.MatchedToken;
import com.kingdee.bos.ctrl.analysis.util.editor.StyledEditor;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.HashSet;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class FMISQLEditorStyleModel
extends DefaultEditorStyleModel {
    protected static String[] tableWordGloble;
    protected static HashSet<String> tableGlobleSet;

    public FMISQLEditorStyleModel() {
        this.initStyle();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setTitle("StyledEditor Sample");
        f.setSize(800, 600);
        f.getContentPane().setLayout(new CardLayout());
        StyledEditor se = new StyledEditor((EditorStyleModel)new FMISQLEditorStyleModel());
        se.setText("select now(),FID from T_Table where FId<>'aaa'");
        f.getContentPane().add((Component)se, "");
        f.setDefaultCloseOperation(2);
        f.setVisible(true);
    }

    public void beforeRun(Lexer lex) {
        lex.delSpecialChar("[]._");
    }

    private void initStyle() {
        this.addStyle(new MatchedToken(){

            public boolean match(String token) {
                return token.matches("'.*'") || token.matches("\".*\"");
            }
        }, this.createSimpleAttributeSet(Color.RED.darker()));
        this.addStyle(new MatchedToken(){

            public boolean match(String token) {
                return token.matches("[\\d]+(([Ll])|(\\.[\\d]+([DdFf])?))?");
            }
        }, this.createSimpleAttributeSet(Color.RED));
        String[] keyWords = new String[]{"select", "from", "delete", "insert", "update", "into", "in", "exist", "order", "by", "having", "not", "if", "then", "else", "case", "create", "table", "drop", "alter", "where", "and", "values", "or", "set", "union", "join", "outer", "on", "true", "false", "null", "is", "as", "default", "primary", "key", "constraint", "column"};
        this.addStyle(keyWords, this.createSimpleAttributeSet(Color.BLUE));
        String[] keyWords1 = new String[]{"inner"};
        this.addStyle(keyWords1, this.createSimpleAttributeSet(Color.MAGENTA));
        String[] keyWords2 = new String[]{"left"};
        this.addStyle(keyWords2, this.createSimpleAttributeSet(Color.ORANGE));
        String[] keyWords3 = new String[]{"right"};
        this.addStyle(keyWords3, this.createSimpleAttributeSet(Color.GREEN));
        String[] typeWords = new String[]{"int", "char", "varchar", "number", "decimal", "nvarchar", "NUMERIC", "DateTime"};
        this.addStyle(typeWords, this.createSimpleAttributeSet(Color.RED.darker()));
        String[] functionWord = new String[]{"now", "getdate", "ABS", "CEILING", "MOD", "ROUND", "SIGN", "CONVERT", "CURTIME", "DATEADD", "DATEDIFF", "TO_DATE", "MONTHS_BETWEEN", "DAYS_BETWEEN", "ADD_MONTHS", "ADD_YEARS", "LEN", "LOWER", "SUBSTRING", "TRIM", "UCASE", "UPPER", "TO_DECIMAL", "CAST", "TOCHAR", "TO_CHAR", "ISNULL", "NULLIF", "NEWID", "NEWBOSID"};
        this.addStyle(functionWord, this.createSimpleAttributeSet(Color.RED));
        List list = null;
        try {
            list = FMIsqlFacadeFactory.getRemoteInstance().fectchAllTableName();
        }
        catch (BOSException e) {
            MsgBox.showWarning((String)e.getMessage());
            SysUtil.abort();
        }
        String[] tableWord = list.toArray(new String[list.size()]);
        tableWordGloble = tableWord;
        SimpleAttributeSet attr = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attr, this.getFont().getFamily());
        StyleConstants.setFontSize(attr, this.getFont().getSize());
        StyleConstants.setBold(attr, true);
        StyleConstants.setForeground(attr, Color.BLACK);
        this.addStyle(tableWord, attr);
        for (int i = 0; i < tableWord.length; ++i) {
            tableGlobleSet.add(tableWord[i].toUpperCase());
        }
        this.addStyle("~`!@#$%^&*()-=_+[]{};':\",./<>?\\|".split(","), this.createSimpleAttributeSet(Color.GRAY));
    }

    public String[] getAllTableName() {
        return tableWordGloble;
    }

    public static boolean isInTableGloble(String tableName) {
        return tableName == null ? false : tableGlobleSet.contains(tableName.toUpperCase());
    }

    static {
        tableGlobleSet = new HashSet();
    }
}

