/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlTableSource;
import com.kingdee.bos.sql.dom.stmt.SqlSelectStmt;
import com.kingdee.bos.sql.dom.stmt.SqlStmt;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.client.SQLStmtInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.sql.SQLException;
import java.util.ArrayList;

public class FMIsqlUIHandler {
    public static SQLStmtInfo getSQLStmtInfo(SqlStmt sqlStmt) {
        SQLStmtInfo info = new SQLStmtInfo();
        if (!(sqlStmt instanceof SqlSelectStmt)) {
            info.isSelect = false;
            info.canAudoUpdate = false;
            return info;
        }
        info.isSelect = true;
        SqlSelectStmt selectStmt = (SqlSelectStmt)sqlStmt;
        SqlSelectBase sqlSelectBase = selectStmt.select;
        if (!(sqlSelectBase instanceof SqlSelect)) {
            info.canAudoUpdate = false;
            return info;
        }
        SqlSelect sqlSelect = (SqlSelect)sqlSelectBase;
        if (sqlSelect.distinct != 0) {
            info.canAudoUpdate = false;
            return info;
        }
        if (!(sqlSelect.tableSource instanceof SqlTableSource)) {
            info.canAudoUpdate = false;
            return info;
        }
        info.canAudoUpdate = true;
        info.tableSourceName = ((SqlTableSource)sqlSelect.tableSource).name;
        return info;
    }

    public static void updateTableCellToDB(KDTable table, KDTEditEvent e) throws EASBizException, BOSException, SQLException {
        SQLStmtInfo sqlStmtInfo = (SQLStmtInfo)table.getUserObject();
        IRow row = table.getRow(e.getRowIndex());
        int colCount = table.getColumnCount();
        String[] colNames = new String[colCount];
        String FID = "";
        int idIndex = 0;
        for (int i = 0; i < colCount; ++i) {
            colNames[i] = table.getHeadRow(0).getCell(i).getValue().toString();
            if (!"FID".equalsIgnoreCase(table.getHeadRow(0).getCell(i).getValue().toString())) continue;
            idIndex = i;
        }
        Object[] colValues = new Object[colCount];
        for (int i = 0; i < colCount; ++i) {
            colValues[i] = row.getCell(i).getValue();
        }
        FID = colValues[idIndex].toString();
        StringBuffer sbWhere = FMIsqlUIHandler.getWhereClause(colNames, colValues, e.getColIndex());
        StringBuffer sbWhereNew = new StringBuffer();
        if (sbWhere.toString().startsWith("where \n and")) {
            String sbWhereStr = sbWhere.toString().replaceAll("where \n and", "where \n ");
            sbWhereNew.append(sbWhereStr);
        }
        StringBuffer sbSelect = new StringBuffer();
        sbSelect.append("select count(*) from ").append(sqlStmtInfo.tableSourceName).append("\n");
        if (sbWhereNew.length() != 0) {
            sbSelect.append(sbWhereNew);
        } else {
            sbSelect.append(sbWhere);
        }
        ArrayList<Object> paramsForSelect = new ArrayList<Object>();
        for (int i = 0; i < colCount; ++i) {
            if (colValues[i] == null || i == e.getColIndex()) continue;
            paramsForSelect.add(colValues[i]);
        }
        IRowSet rs = FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sbSelect.toString(), paramsForSelect.toArray());
        rs.next();
        if (rs.getInt(1) != 1) {
            MsgBox.showWarning((Component)table, (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"159_FMIsqlUIHandler"));
            SysUtil.abort();
        }
        ArrayList<Object> paramForUpdate = new ArrayList<Object>();
        if (e.getValue() != null) {
            paramForUpdate.add(e.getValue());
        }
        for (int i = 0; i < colCount; ++i) {
            if (colValues[i] == null || i == e.getColIndex()) continue;
            paramForUpdate.add(colValues[i]);
        }
        StringBuffer sbUpdate = new StringBuffer();
        StringBuffer sbUpdateNew = new StringBuffer();
        sbUpdate.append("update ").append(sqlStmtInfo.tableSourceName).append("\n");
        sbUpdate.append("set ").append(colNames[e.getColIndex()]);
        sbUpdateNew.append("update ").append(sqlStmtInfo.tableSourceName).append(" set ").append(colNames[e.getColIndex()]);
        if (e.getValue() == null) {
            sbUpdate.append("=null\n");
        } else {
            sbUpdate.append("=?\n");
        }
        if (e.getValue() == null) {
            sbUpdateNew.append("=null where FID ='" + FID + "' ----\u624b\u5de5\u4fee\u6539\u8868\u683c\u6570\u636e");
        } else {
            sbUpdateNew.append("='" + paramForUpdate.get(0) + "' where FID ='" + FID + "' ----\u624b\u5de5\u4fee\u6539\u8868\u683c\u6570\u636e");
        }
        if (sbWhereNew.length() != 0) {
            sbUpdate.append(sbWhereNew);
        } else {
            sbUpdate.append(sbWhere);
        }
        FMIsqlFacadeFactory.getRemoteInstance().executeSql(sbUpdate.toString(), paramForUpdate.toArray());
        FMIsqlFacadeFactory.getRemoteInstance().recordSql(sbUpdateNew.toString());
    }

    private static StringBuffer getWhereClause(String[] colNames, Object[] colValues, int curColInd) {
        StringBuffer sbWhere = new StringBuffer();
        sbWhere.append("where \n");
        int n = colNames.length;
        for (int i = 0; i < n; ++i) {
            if (i == curColInd) continue;
            if (i >= 1) {
                sbWhere.append(" and ");
            }
            if (colValues[i] == null) {
                sbWhere.append(colNames[i]).append(" is null ");
                continue;
            }
            sbWhere.append(colNames[i]).append("=?");
        }
        return sbWhere;
    }

    public static String getAboutInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("ksql example:\n");
        sb.append("/*dialect*/\n");
        sb.append("Packages.com.kingdee.eas.fm.common.FMHelper.gc()\n");
        sb.append("frame = new java.awt.Frame(\"JavaScript\")\n");
        sb.append("frame.show()\n");
        sb.append("Packages.junit.textui.TestRunner.run(Packages.com.kingdee.eas.basedata.assistant.TestBankAccount)\n");
        sb.append("-------");
        sb.append("oracle top 25:\n");
        sb.append("/*dialect*/SELECT * FROM \n(SELECT  sql_text, \n    GREATEST (GREATEST (disk_reads, 0) \n      /DECODE (GREATEST (executions, 0),0, -1, executions), 0 ) t \n\t\t            FROM v$sql s \n\t\t           WHERE parsing_user_id <> 0\n\t\t             AND command_type <= 7\n\t\t        ORDER BY t DESC)\n\t\t WHERE ROWNUM <= 25\n");
        return sb.toString();
    }

    public static boolean equalsTo(Object one, Object other) {
        if (one == null && other == null) {
            return true;
        }
        if (one == null || other == null) {
            return false;
        }
        return one.equals(other);
    }
}

