/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.dynbusiness.condition.ParameterItem;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.util.HashSet;

public class FpItemClientHelper {
    public static void getItemOrgs(CostCenterOrgUnitInfo ccoInfo, FilterInfo filter, boolean isLevel1) {
        ParameterItem item = new ParameterItem("FP001");
        boolean value = false;
        try {
            value = item.getValueAsBoolean(null, null);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (!value) {
            return;
        }
        if (filter == null) {
            return;
        }
        if (ccoInfo == null) {
            ccoInfo = SysContext.getSysContext().getCurrentCostUnit();
        }
        HashSet<String> numberSet = new HashSet<String>();
        if (ccoInfo != null) {
            String[] numberStr = ccoInfo.getLongNumber().split("\\!");
            if (numberStr != null) {
                int in = numberStr.length;
                for (int i = 0; i < in; ++i) {
                    numberSet.add(numberStr[i]);
                }
            }
            int maskSize = filter.getFilterItems().size();
            filter.getFilterItems().add(new FilterItemInfo("orgNum", numberSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("orgLongnum", (Object)(ccoInfo.getLongNumber() + "!%"), CompareType.LIKE));
            if (isLevel1) {
                filter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(1), CompareType.EQUALS));
            }
            if (StringUtils.isEmpty((String)filter.getMaskString())) {
                String oldMaskS = "";
                for (int n = 0; n < maskSize; ++n) {
                    oldMaskS = n == 0 ? "#" + String.valueOf(n) : oldMaskS + " and  #" + String.valueOf(n);
                }
                if (oldMaskS.equals("")) {
                    if (isLevel1) {
                        filter.setMaskString("( #" + String.valueOf(maskSize) + " or #" + String.valueOf(maskSize + 1) + ") and #" + String.valueOf(maskSize + 2));
                    } else {
                        filter.setMaskString("(#" + String.valueOf(maskSize) + " or #" + String.valueOf(maskSize + 1) + ")");
                    }
                } else if (isLevel1) {
                    filter.setMaskString("(" + oldMaskS + ") and ( #" + String.valueOf(maskSize) + " or #" + String.valueOf(maskSize + 1) + ") and #" + String.valueOf(maskSize + 2));
                } else {
                    filter.setMaskString("(" + oldMaskS + ") and (#" + String.valueOf(maskSize) + " or #" + String.valueOf(maskSize + 1) + ")");
                }
            } else if (isLevel1) {
                filter.setMaskString("(" + filter.getMaskString() + ") and ( #" + String.valueOf(maskSize) + " or #" + String.valueOf(maskSize + 1) + ") and #" + String.valueOf(maskSize + 2));
            } else {
                filter.setMaskString("(" + filter.getMaskString() + ") and (#" + String.valueOf(maskSize) + " or #" + String.valueOf(maskSize + 1) + ")");
            }
        } else {
            filter.getFilterItems().clear();
            numberSet.add("_");
            filter.getFilterItems().add(new FilterItemInfo("orgNum", numberSet, CompareType.INCLUDE));
            filter.setMaskString("(#0)");
        }
    }

    public static void setOrgView(KDBizPromptBox prmtFpItem) {
        CostCenterOrgUnitInfo ccoInfo = SysContext.getSysContext().getCurrentCostUnit();
        EntityViewInfo itemevi = prmtFpItem.getEntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (itemevi == null) {
            itemevi = new EntityViewInfo();
        } else {
            filterInfo = itemevi.getFilter();
            if (filterInfo == null) {
                filterInfo = new FilterInfo();
            }
        }
        FpItemClientHelper.getItemOrgs(ccoInfo, filterInfo, false);
        itemevi.setFilter(filterInfo);
        prmtFpItem.setEntityViewInfo(itemevi);
    }
}

