/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.fpl.FPItemDirectionEnum;
import com.kingdee.eas.fm.fpl.FpItemException;
import com.kingdee.eas.fm.fpl.FpItemFactory;
import com.kingdee.eas.fm.fpl.FpItemGroupInfo;
import com.kingdee.eas.fm.fpl.FpItemInfo;
import com.kingdee.eas.fm.fpl.IFpItem;
import com.kingdee.eas.fm.fpl.client.AbstractFpItemEditUI;
import com.kingdee.eas.fm.fpl.client.FpItemGroupInDialog;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FpItemEditUI
extends AbstractFpItemEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FpItemEditUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.initf7Group();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        UIUtil.updateUITitle((CoreUIObject)this, (String)this.resHelper.getString("this.title"));
        if (this.getOprtState().equalsIgnoreCase(OprtState.EDIT)) {
            Map uiContext = this.getUIContext();
            String id = (String)uiContext.get("ID");
            try {
                FpItemFactory.getRemoteInstance().checkIsUsed(id);
            }
            catch (FpItemException e) {
                this.txtNumber.setEnabled(false);
            }
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.txtNumber.isEnabled()) {
            this.txtNumber.requestFocusInWindow();
            return;
        }
        this.mltName.requestFocusInWindow();
    }

    private void initf7Group() {
        FpItemGroupInDialog dialog = new FpItemGroupInDialog();
        this.f7ItemGroup.setSelector((KDPromptSelector)dialog);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.f7ItemGroup.setValue(this.getUIContext().get("groupInfo"));
        }
    }

    protected IObjectValue createNewData() {
        FpItemInfo fpItemInfo = new FpItemInfo();
        fpItemInfo.setGroup((FpItemGroupInfo)this.getUIContext().get("groupInfo"));
        fpItemInfo.setDirection(fpItemInfo.getGroup().getDirection());
        return fpItemInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FpItemFactory.getRemoteInstance();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyEditData();
        super.actionSubmit_actionPerformed(e);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    private void verifyEditData() {
        String description;
        String itemName = (String)this.mltName.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData();
        String textNum = this.txtNumber.getText();
        if (textNum == null && textNum.trim().length() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpItemResource", (String)"noNum"));
            SysUtil.abort();
        }
        if (itemName == null && itemName.trim().length() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpItemResource", (String)"noName"));
            SysUtil.abort();
        }
        if (this.txtNumber.getText().length() > 80) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpItemResource", (String)"tooLongNum"));
            SysUtil.abort();
        }
        if (itemName.length() > 254) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpItemResource", (String)"tooLongName"));
            SysUtil.abort();
        }
        if ((description = (String)this.mltDescription.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData()) != null && description.length() > 254) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpItemResource", (String)"tooLongDescription"));
            SysUtil.abort();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("displayName"));
        return sic;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddNew.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnPageSetup.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnEdit.setVisible(false);
        this.actionEdit.setEnabled(false);
        this.menuBar.setVisible(false);
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.txtNumber.setEditable(false);
            this.txtNumber.setEnabled(false);
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.txtNumber.setEnabled(false);
            this.mltName.setEnabled(false);
            this.mltDescription.setEnabled(false);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.txtNumber.setEnabled(false);
        this.mltName.setEnabled(true);
        this.mltDescription.setEnabled(true);
    }

    @Override
    protected void txtNumber_focusLost(FocusEvent e) throws Exception {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            int index = -1;
            String parentNum = null;
            String number = null;
            String parentID = null;
            FpItemGroupInfo fpItemGroup = (FpItemGroupInfo)this.getUIContext().get("groupInfo");
            if (fpItemGroup == null) {
                return;
            }
            parentID = fpItemGroup.getId().toString();
            FpItemInfo parentInfo = null;
            number = this.txtNumber.getText();
            IFpItem fpItem = FpItemFactory.getRemoteInstance();
            if (number != null && parentID != null && (index = number.lastIndexOf(".")) != -1) {
                parentNum = number.substring(0, index);
                try {
                    parentInfo = fpItem.getFpItemInfo("select id,level,displayName,name where number='" + parentNum + "' and Group.id='" + parentID + "'");
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                }
                if (parentInfo != null) {
                    this.f7ParentItem.setValue((Object)parentInfo.getName().toString());
                } else {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpItemResource", (String)"isMistakeNum"));
                    SysUtil.abort();
                    return;
                }
            }
        }
    }

    @Override
    protected void f7CashFlowItem_willShow(SelectorEvent e) throws Exception {
        FpItemGroupInfo fpItemGroupInfo = (FpItemGroupInfo)this.f7ItemGroup.getValue();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("direction", (Object)this.toCashDirection(fpItemGroupInfo.getDirection()), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isleaf", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("isfreeze", (Object)new Integer(0)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.f7CashFlowItem.setEntityViewInfo(evi);
        this.f7CashFlowItem.getQueryAgent().resetRuntimeEntityView();
    }

    private Set toCashDirection(FPItemDirectionEnum fpItemDirection) {
        HashSet<Integer> set = new HashSet<Integer>();
        if (fpItemDirection.getValue().equals("in")) {
            set.add(new Integer(1));
        } else if (fpItemDirection.getValue().equals("out")) {
            set.add(new Integer(2));
        } else {
            set.add(new Integer(1));
            set.add(new Integer(2));
        }
        return set;
    }
}

