/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.fpl.FpItemException;
import com.kingdee.eas.fm.fpl.FpItemFactory;
import com.kingdee.eas.fm.fpl.FpItemGroupFactory;
import com.kingdee.eas.fm.fpl.FpItemGroupInfo;
import com.kingdee.eas.fm.fpl.FpItemInfo;
import com.kingdee.eas.fm.fpl.IFpItem;
import com.kingdee.eas.fm.fpl.client.AbstractFpItemGroupListUI;
import com.kingdee.eas.fm.fpl.client.FpItemClientHelper;
import com.kingdee.eas.fm.fpl.client.FpItemEditUI;
import com.kingdee.eas.fm.fpl.client.FpItemGroupEditUI;
import com.kingdee.eas.fm.fpl.client.FpItemUtil;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class FpItemGroupListUI
extends AbstractFpItemGroupListUI {
    private static final Logger logger = CoreUIObject.getLogger(FpItemGroupListUI.class);
    String resPath = "com.kingdee.eas.fm.fpl.client.FpItemResource";
    private FpItemTreeRender treeRender;
    protected CompanyOrgUnitInfo currentCompany = null;
    protected CostCenterOrgUnitInfo ccoInfo = SysContext.getSysContext().getCurrentCostUnit();
    protected boolean isQuery = true;

    protected IObjectPK getSelectedTreeKeyValue() {
        ObjectUuidPK groupPK = null;
        String id = this.getSelectedKeyValue();
        if (!StringUtils.isEmpty((String)id)) {
            try {
                FpItemInfo fpItem = FpItemFactory.getRemoteInstance().getFpItemInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                FpItemGroupInfo group = fpItem.getGroup();
                if (group != null) {
                    groupPK = new ObjectUuidPK(group.getId());
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        }
        return groupPK;
    }

    protected boolean isOrderForClickTableHead() {
        return false;
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        this.kDMenuItem3.setEnabled(true);
        this.actionAddNew.setEnabled(false);
        this.btnAddNew.setEnabled(false);
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            if (!((FpItemGroupInfo)treeNode.getUserObject()).isIsLeaf()) {
                this.actionAddNew.setEnabled(false);
                this.btnAddNew.setEnabled(false);
                this.btnImport.setEnabled(false);
                this.actionImportData.setEnabled(false);
                this.kDMenuItem1.setEnabled(false);
                this.kDMenuItem2.setEnabled(false);
                this.btnImportExcel.setEnabled(false);
                this.actionImportExcel.setEnabled(false);
                this.btnGroupAddNew.setEnabled(true);
                this.actionGroupAddNew.setEnabled(true);
            } else {
                this.actionAddNew.setEnabled(true);
                this.btnAddNew.setEnabled(true);
                this.btnImport.setEnabled(true);
                this.actionImportData.setEnabled(true);
                this.kDMenuItem3.setEnabled(true);
                this.kDMenuItem1.setEnabled(true);
                this.kDMenuItem2.setEnabled(true);
                this.btnImportExcel.setEnabled(true);
                this.actionImportExcel.setEnabled(true);
                this.btnGroupAddNew.setEnabled(true);
                this.actionGroupAddNew.setEnabled(true);
            }
        } else {
            this.btnImport.setEnabled(false);
            this.btnImportExcel.setEnabled(false);
            this.kDMenuItem1.setEnabled(false);
            this.kDMenuItem2.setEnabled(false);
        }
    }

    protected String getGroupEditUIName() {
        return FpItemGroupEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return "group.id";
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return FpItemGroupFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return FpItemEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FpItemFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDBoxOrgUnit.setValue((Object)SysContext.getSysContext().getCurrentOrgUnit());
        this.treeRender = new FpItemTreeRender();
        this.tblMain.getColumn("number").setRenderer((IBasicRender)this.treeRender);
        this.tblMain.setRefresh(true);
        this.tblMain.reLayoutAndPaint();
        if (this.treeMain.getRowCount() >= 1) {
            this.treeMain.setSelectionRow(0);
        }
        int countrow = this.tblMain.getRowCount();
        for (int io = 0; io < countrow; ++io) {
            IRow row = this.tblMain.getRow(io);
            row.getStyleAttributes().setHided(false);
        }
        this.menuItemImportData.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.menuItemExportData.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.kDMenuItem2.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.kDMenuItem3.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemExitCurrent.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
    }

    protected void initPopmenu() {
        JPopupMenu menu = this.treeMain.getPopupMenu();
        EventListener[] ls = this.treeMain.getListeners(TreePopupMenuListener.class);
        if (ls == null || ls.length == 0) {
            this.treeMain.addTreePopupMenu(new TreePopupMenuListener(){

                public boolean popMenu(TreePopupMenuEvent event) {
                    return true;
                }
            });
            menu.add((Component)new KDSeparator());
            JMenuItem itemEdit = new JMenuItem((Action)this.actionGroupEdit);
            itemEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
            menu.add(itemEdit);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnMoveTree.setVisible(false);
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_importcyclostyle"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnImportExcel.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnAutoMatchCashItem.setIcon(EASResource.getIcon((String)"imgTbtn_automapped"));
        this.actionExport.setEnabled(true);
        this.actionImportExcel.setEnabled(true);
        this.actionGroupAddNew.setVisible(false);
        this.actionGroupRemove.setVisible(false);
        this.actionGroupMoveTree.setVisible(false);
        this.menuItemGroupAddNew.setVisible(false);
        this.kDMenuItem1.setVisible(false);
        this.menuItemGroupRemove.setVisible(false);
        this.actionAutoMatchCashItem.setVisible(false);
    }

    protected String getRootName() {
        return this.getResource("fpItem");
    }

    protected void prepareGroupUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareGroupUIContext(uiContext, e);
        FpItemGroupInfo groupInfo = null;
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            groupInfo = (FpItemGroupInfo)treeNode.getUserObject();
            uiContext.put((Object)"groupInfo", (Object)this.getSelectedFpItemGroupInfo());
            if (groupInfo.isIsLeaf()) {
                uiContext.put((Object)"tableCount", (Object)new Integer(this.tblMain.getRowCount()));
            }
        }
    }

    @Override
    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            String bizObjectId = ((TreeBaseInfo)treeNode.getUserObject()).getId().toString();
            boolean iscreator = FpItemUtil.isCreator(bizObjectId);
            if (!iscreator) {
                MsgBox.showWarning((String)EASResource.getString((String)this.resPath, (String)"NotCreatorNoEdit"));
                return;
            }
            if (!((FpItemGroupInfo)treeNode.getUserObject()).isIsLeaf()) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getResource("notLeaf_delete"));
            } else if (this.tblMain.getRowCount() >= 1) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getResource("hasItem_delete"));
            } else {
                super.actionGroupRemove_actionPerformed(e);
            }
        }
        this.refresh(e);
    }

    @Override
    public void actionGroupEdit_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            super.actionGroupEdit_actionPerformed(e);
        }
    }

    private String getResource(String key) {
        return EASResource.getString((String)this.resPath, (String)key);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"groupInfo", (Object)this.getSelectedFpItemGroupInfo());
        FpItemInfo info = null;
        try {
            info = this.getSelectedInfo();
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        uiContext.put((Object)"itemInfo", (Object)info);
    }

    private FpItemInfo getSelectedInfo() throws EASBizException, BOSException {
        FpItemInfo itemInfo = null;
        String fpItemID = this.getSelectedKeyValue();
        if (fpItemID != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("CU.id"));
            sic.add(new SelectorItemInfo("CU.name"));
            itemInfo = FpItemFactory.getRemoteInstance().getFpItemInfo((IObjectPK)new ObjectUuidPK(fpItemID), sic);
        }
        return itemInfo;
    }

    private FpItemGroupInfo getSelectedFpItemGroupInfo() {
        FpItemGroupInfo groupInfo = null;
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            groupInfo = (FpItemGroupInfo)treeNode.getUserObject();
        }
        return groupInfo;
    }

    public void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int columnIndex;
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 1 && (columnIndex = e.getColIndex()) == 0) {
            int rowIndex = e.getRowIndex();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return;
            }
            NumberExpandInfo numberExpandInfo = (NumberExpandInfo)row.getCell("number").getValue();
            if (this.treeRender.inRect(numberExpandInfo, e.getX(), e.getY())) {
                this.setTreeDisplayStyle(row);
            }
            return;
        }
    }

    private void setTreeDisplayStyle(IRow row) {
        boolean isFpItemLeaf = (Boolean)row.getCell("isLeaf").getValue();
        if (isFpItemLeaf) {
            return;
        }
        this.expandFpItem(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandFpItem(IRow row) {
        NumberExpandInfo fpItemNumberExpandInfo = (NumberExpandInfo)row.getCell("number").getValue();
        String fpItemNumber = fpItemNumberExpandInfo.getNumber();
        boolean isExpandStatus = fpItemNumberExpandInfo.isExpandStatus();
        String fpItemId = (String)row.getCell("id").getValue();
        if (isExpandStatus) {
            IRow child;
            NumberExpandInfo childNumberExpandInfo;
            String childNumber;
            fpItemNumberExpandInfo.setExpandStatus(false);
            this.tblMain.setRefresh(false);
            int count = this.tblMain.getRowCount();
            for (int i = row.getRowIndex() + 1; i < count && (childNumber = (childNumberExpandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(i)).getCell("number").getValue()).getNumber()).startsWith(fpItemNumber); ++i) {
                child.getStyleAttributes().setHided(true);
            }
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        } else {
            IRow child;
            NumberExpandInfo childNumberExpandInfo;
            String childNumber;
            IRow next;
            NumberExpandInfo nextNumberExpandInfo;
            fpItemNumberExpandInfo.setExpandStatus(true);
            int i = row.getRowIndex() + 1;
            boolean hasChildrenDataGotten = false;
            if (i < this.tblMain.getRowCount() && (nextNumberExpandInfo = (NumberExpandInfo)(next = this.tblMain.getRow(i)).getCell("number").getValue()).getNumber().startsWith(fpItemNumber)) {
                hasChildrenDataGotten = true;
            }
            if (!hasChildrenDataGotten) {
                this.setCursorOfWair();
                EntityViewInfo childQuery = new EntityViewInfo();
                FilterInfo childFilter = new FilterInfo();
                childQuery.setFilter(childFilter);
                childFilter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)fpItemId));
                childFilter.setMaskString("#0");
                IRowSet rowset = null;
                try {
                    rowset = this.getQueryExecutor(this.mainQueryPK, childQuery).executeQuery();
                    if (rowset != null && rowset.size() > 0) {
                        int start = row.getRowIndex() + 1;
                        while (rowset.next()) {
                            IRow child2 = this.tblMain.addRow(start);
                            ++start;
                            int colcount = this.tblMain.getColumnCount();
                            for (int col = 0; col < colcount; ++col) {
                                IColumn column = this.tblMain.getColumn(col);
                                String field = column.getFieldName();
                                if (field == null || field.length() < 1) continue;
                                Object value = rowset.getObject(field);
                                if (field.equals("number")) {
                                    NumberExpandInfo childNumberExpandInfo2 = new NumberExpandInfo();
                                    childNumberExpandInfo2.setFpItemId(rowset.getString("id"));
                                    childNumberExpandInfo2.setLevel(rowset.getInt("level"));
                                    childNumberExpandInfo2.setLeaf(rowset.getBoolean("isLeaf"));
                                    childNumberExpandInfo2.setNumber(rowset.getString("number"));
                                    childNumberExpandInfo2.setExpandStatus(false);
                                    value = childNumberExpandInfo2;
                                }
                                child2.getCell(col).setValue(value);
                            }
                        }
                        this.tblMain.setRowCount(this.tblMain.getRowCount() + rowset.size());
                    }
                }
                catch (BOSException e) {
                    this.handleException((Exception)((Object)e));
                }
                catch (SQLException e) {
                    this.handleException(e);
                }
                finally {
                    this.setCursorOfDefault();
                }
            }
            int count = this.tblMain.getRowCount();
            while (i < count && (childNumber = (childNumberExpandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(i)).getCell("number").getValue()).getNumber()).startsWith(fpItemNumber)) {
                String parentId = (String)child.getCell("parent.id").getValue();
                if (parentId.equals(fpItemId)) {
                    this.expandChildFpItem(child);
                }
                ++i;
            }
        }
    }

    private void expandChildFpItem(IRow row) {
        NumberExpandInfo acctNumberExpandInfo = (NumberExpandInfo)row.getCell("number").getValue();
        String fpItemNumber = acctNumberExpandInfo.getNumber();
        boolean isExpandStatus = acctNumberExpandInfo.isExpandStatus();
        String fpItemId = (String)row.getCell("id").getValue();
        row.getStyleAttributes().setHided(false);
        if (isExpandStatus) {
            IRow child;
            NumberExpandInfo childNumberExpandInfo;
            String childNumber;
            int count = this.tblMain.getRowCount();
            for (int i = row.getRowIndex() + 1; i < count && (childNumber = (childNumberExpandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(i)).getCell("number").getValue()).getNumber()).startsWith(fpItemNumber); ++i) {
                String parentId = (String)child.getCell("parent.id").getValue();
                if (!parentId.equals(fpItemId)) continue;
                this.expandChildFpItem(child);
            }
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int start = e.getFirstRow();
                int end = e.getLastRow();
                FpItemGroupListUI.this.setTreeDisplayStyle(start, end + 1);
            }
        });
    }

    private void setTreeDisplayStyle(int start, int end) {
        int count = end;
        for (int i = start; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            String id = (String)row.getCell("id").getValue();
            int level = (Integer)row.getCell("level").getValue();
            Object numberValue = row.getCell("number").getValue();
            if (!(numberValue instanceof String)) {
                return;
            }
            String acctNumber = (String)numberValue;
            boolean isFpItemLeaf = (Boolean)row.getCell("isLeaf").getValue();
            NumberExpandInfo fpItemNumberExpandInfo = new NumberExpandInfo();
            fpItemNumberExpandInfo.setFpItemId(id);
            fpItemNumberExpandInfo.setLevel(level);
            fpItemNumberExpandInfo.setLeaf(isFpItemLeaf);
            fpItemNumberExpandInfo.setNumber(acctNumber);
            fpItemNumberExpandInfo.setExpandStatus(true);
            row.getCell("number").setValue((Object)fpItemNumberExpandInfo);
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkIsCanHandle();
        FpItemFactory.getRemoteInstance().checkIsUsed(this.getSelectedKeyValue());
        try {
            super.actionRemove_actionPerformed(e);
        }
        catch (SQLException a) {
            throw new FpItemException(FpItemException.ISNOTLEAF);
        }
    }

    private boolean isCreateCU() throws Exception {
        CtrlUnitInfo cu = ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit();
        FpItemInfo info = this.getSelectedInfo();
        return cu.getId().equals((Object)info.getCU().getId());
    }

    private void checkIsCanHandle() throws Exception {
        String msg;
        CtrlUnitInfo cu = ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit();
        CostCenterOrgUnitInfo costUnit = SysContext.getSysContext().getCurrentCostUnit();
        FpItemInfo info = this.getSelectedInfo();
        if (!cu.getId().equals((Object)info.getCU().getId())) {
            msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpClientHelperResource", (String)"handleInCurrentCU"), info.getCU().getName());
            MsgBox.showWarning((String)msg);
            SysUtil.abort();
        }
        if (FpItemGroupListUI.isOrgCtrlFpItem(null) && costUnit.getLongNumber().length() > info.getOrgLongNum().length()) {
            msg = EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"21_FpItemGroupListUI");
            MsgBox.showWarning((String)msg);
            SysUtil.abort();
        }
    }

    public static boolean isOrgCtrlFpItem(Context ctx) {
        String paramValue = null;
        try {
            paramValue = ctx == null ? ParamManager.getParamValue(null, null, (String)"FP001") : ParamManager.getParamValue((Context)ctx, null, (String)"FP001");
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (paramValue == null || paramValue.trim().equals("")) {
            return false;
        }
        return Boolean.valueOf(paramValue);
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        Object tmp = para.get(0);
        if (tmp instanceof DatataskParameter) {
            DatataskParameter dp = (DatataskParameter)tmp;
            MetaDataPK queryPK = null;
            queryPK = new MetaDataPK("com.kingdee.eas.fm.fpl", "FpItemQuery");
            EntityViewInfo viewInfo = this.mainQuery;
            dp.putContextParam((Object)"mainQueryPK", (Object)queryPK);
            dp.putContextParam((Object)"mainQuery", (Object)viewInfo);
        }
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent((Component)((Object)this));
        dc.invoke(para, 1);
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        String solutionName = "FpItem";
        param.alias = EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"7_FpRptFacadeControllerBean");
        param.solutionName = solutionName;
        param.datataskMode = 1;
        param.varList = new ArrayList();
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public void actionImportExcel_actionPerformed(ActionEvent e) throws Exception {
        DatataskCaller task = new DatataskCaller();
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.fm.fpl.FpItem";
        param.alias = EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"7_FpRptFacadeControllerBean");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        Hashtable<String, FpItemGroupInfo> myParam = new Hashtable<String, FpItemGroupInfo>();
        myParam.put("group", this.getSelectedFpItemGroupInfo());
        param.setContextParam(myParam);
        if (SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof KDFrame) {
            task.setParentComponent((Component)((KDFrame)SwingUtilities.getWindowAncestor((Component)((Object)this))));
        }
        task.invoke(paramList, 0, false);
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.getSelectedFpItemGroupInfo() == null) {
            return;
        }
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        FpItemGroupInfo groupInfo = this.getSelectedFpItemGroupInfo();
        if (groupInfo == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"22_FpItemGroupListUI"));
            SysUtil.abort();
        }
        DatataskCaller task = new DatataskCaller();
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.fm.fpl.FpItem";
        param.alias = EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"7_FpRptFacadeControllerBean");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        Hashtable<String, FpItemGroupInfo> myParam = new Hashtable<String, FpItemGroupInfo>();
        myParam.put("group", groupInfo);
        param.setContextParam(myParam);
        if (SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof KDFrame) {
            task.setParentComponent((Component)((KDFrame)SwingUtilities.getWindowAncestor((Component)((Object)this))));
        }
        task.invoke(paramList, 0, false);
        this.refreshList();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("creator.*"));
        return sic;
    }

    public FpItemInfo getData() throws Exception {
        Object keyValue;
        FpItemInfo fpItemInfo = null;
        if (this.tblMain.getSelectManager().get() == null) {
            return null;
        }
        int rowIndex = this.tblMain.getSelectManager().get().getTop();
        IRow row = this.tblMain.getRow(rowIndex);
        ICell cell = row.getCell(this.getKeyFieldName());
        if (cell == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
            SysUtil.abort();
        }
        if ((keyValue = cell.getValue()) != null) {
            IFpItem iFpItem = (IFpItem)this.getBizInterface();
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)keyValue.toString()));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            fpItemInfo = iFpItem.getFpItemInfo((IObjectPK)pk, sic);
        }
        return fpItemInfo;
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkIsCanHandle();
        super.actionEdit_actionPerformed(e);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    @Override
    public void actionAutoMatchCashItem_actionPerformed(ActionEvent e) throws Exception {
        IFpItem iFpitem = FpItemFactory.getRemoteInstance();
        iFpitem.autoMatchCashItem();
        this.refreshList();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        FilterInfo filter = viewInfo.getFilter();
        FpItemClientHelper.getItemOrgs(this.ccoInfo, filter, false);
        this.afterQueryExecutor(filter);
        viewInfo.setFilter(filter);
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isIgnoreOrder = false;
        return exec;
    }

    protected void afterQueryExecutor(FilterInfo filter) {
    }

    private class FpItemTreeRender
    implements IBasicRender {
        private int TABSIZE = 8;
        private int ICONSIZE = 10;
        private int margin = 2;
        protected SimpleTextRender simpleRender = new SimpleTextRender();
        protected HashMap fpItemIdToPos = new HashMap();

        private FpItemTreeRender() {
        }

        protected void drawExpanded(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
            g.drawLine(x + this.ICONSIZE / 2, y + this.margin, x + this.ICONSIZE / 2, y + this.margin + lineSize);
        }

        protected void drawLeaf(Graphics g, int x, int y) {
            int lineSize = this.ICONSIZE - 2 * this.margin;
        }

        public boolean inRect(NumberExpandInfo numberExpandInfo, int x, int y) {
            String fpItemId = numberExpandInfo.getFpItemId();
            Rectangle rec = (Rectangle)this.fpItemIdToPos.get(fpItemId);
            if (rec != null) {
                return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
            }
            return false;
        }

        public void draw(Graphics graphics, Shape clip, Object obj, Style style) {
            if (obj instanceof NumberExpandInfo) {
                NumberExpandInfo numberExpandInfo = (NumberExpandInfo)obj;
                int ident = numberExpandInfo.getLevel() * this.TABSIZE;
                Rectangle rect = clip.getBounds();
                int x = rect.x + ident;
                int y = rect.y + (rect.height - this.ICONSIZE) / 2;
                Rectangle iconRect = new Rectangle(x, y, this.ICONSIZE, this.ICONSIZE);
                this.fpItemIdToPos.put(numberExpandInfo.getFpItemId(), iconRect);
                this.simpleRender.draw(graphics, (Shape)new Rectangle(x + this.ICONSIZE + this.TABSIZE, rect.y, rect.width - x - this.ICONSIZE - this.TABSIZE, rect.height), numberExpandInfo.getNumber(), style);
                this.paintIcon(graphics, numberExpandInfo, iconRect);
            } else if (obj != null) {
                this.simpleRender.draw(graphics, clip, obj.toString(), style);
            }
        }

        private void paintIcon(Graphics graphics, NumberExpandInfo numberExpandInfo, Rectangle iconRect) {
            if (numberExpandInfo.isLeaf()) {
                this.drawLeaf(graphics, iconRect.x, iconRect.y);
            } else if (numberExpandInfo.isExpandStatus()) {
                this.drawExpanded(graphics, iconRect.x, iconRect.y);
            } else if (!numberExpandInfo.isExpandStatus()) {
                this.drawCollapsed(graphics, iconRect.x, iconRect.y);
            }
        }
    }

    private class NumberExpandInfo {
        private String fpItemId;
        private String number;
        private boolean isExpandStatus;
        private int level;
        private boolean isLeaf;

        private NumberExpandInfo() {
        }

        public boolean isExpandStatus() {
            return this.isExpandStatus;
        }

        public void setExpandStatus(boolean isExpandStatus) {
            this.isExpandStatus = isExpandStatus;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String toString() {
            return this.number;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public void setLeaf(boolean isLeaf) {
            this.isLeaf = isLeaf;
        }

        public String getFpItemId() {
            return this.fpItemId;
        }

        public void setFpItemId(String fpItemId) {
            this.fpItemId = fpItemId;
        }
    }
}

