/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ClientHelper;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.NTTypeException;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgUnitHelper;
import com.kingdee.eas.fm.fin.FinancingProductsCollection;
import com.kingdee.eas.fm.fin.FinancingProductsFactory;
import com.kingdee.eas.fm.fin.FinancingProductsInfo;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.client.AbstractNTTypeEditUI;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class NTTypeEditUI
extends AbstractNTTypeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(NTTypeEditUI.class);
    boolean isGroup = false;
    public static final String CTX_NTTYPE_GROUP = "NTTypeGroup";
    public static final String CTX_NTTYPE_ISGOV = "NTTypeIsGov";

    public NTTypeEditUI() throws Exception {
        CompanyOrgUnitInfo cur = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.isGroup = NewOrgUnitHelper.getRootCU().getId().equals((Object)cur.getId());
        if (!this.isGroup) {
            this.hideButtonAndMenu();
        }
        this.actionSave.setEnabled(false);
        this.actionSave.setVisible(false);
        this.actionCopy.setEnabled(false);
        this.actionCopy.setVisible(false);
        this.actionCancel.setEnabled(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionCancelCancel.setEnabled(false);
        this.menuEdit.setVisible(false);
    }

    private void hideButtonAndMenu() {
        this.actionDisable.setEnabled(false);
        this.actionEnable.setEnabled(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        ClientHelper.clearSeparatorOnToolBar(this.toolBar);
        this.cboGroup.setEnabled(false);
        this.txtNumber.setMaxLength(80);
        this.txtName.setMaxLength(80);
        this.actionEdit.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.prmtFinanceType.setEnabled(false);
        NTTypeGroupEnum type = (NTTypeGroupEnum)((Object)this.getUIContext().get(CTX_NTTYPE_GROUP));
        if (!EmptyUtil.isEmpty((Object)((Object)type)) && (type.equals((Object)NTTypeGroupEnum.ImportCredit) || type.equals((Object)NTTypeGroupEnum.ExportCredit))) {
            this.txtName.setEnabled(true);
            this.cboGroup.setEnabled(false);
            this.prmtFinanceType.setEnabled(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    private FinancingProductsInfo getFinByTypegroup(NTTypeGroupEnum typeGroup) {
        String id = "";
        if (typeGroup.equals((Object)NTTypeGroupEnum.PAYABLE_BankAccept)) {
            id = "8iAQzQEJEADgAMdUwKgTyMJe16k=";
        }
        if (typeGroup.equals((Object)NTTypeGroupEnum.PAYABLE_CommerceAccept)) {
            id = "8iAQzQEJEADgAMe1wKgTyMJe16k=";
        }
        if (typeGroup.equals((Object)NTTypeGroupEnum.ImportCredit)) {
            id = "8iAQzQEJEADgAMdfwKgTyMJe16k=";
        }
        FinancingProductsInfo fin = null;
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)id));
        FinancingProductsCollection col = null;
        try {
            col = FinancingProductsFactory.getRemoteInstance().getFinancingProductsCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)col)) {
            fin = col.get(0);
        }
        return fin;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        boolean isUsed = this.editData.isIsUsed();
        boolean isSystem = this.editData.isIsSystem();
        if (isSystem) {
            throw new NTTypeException(NTTypeException.SYS_USED_NTTYPE);
        }
        if (!isUsed) {
            throw new NTTypeException(NTTypeException.DISABLE_NTTYPE);
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    protected String getEditUIName() {
        return NTTypeEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return NTTypeFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        NTTypeInfo objectValue = new NTTypeInfo();
        NTTypeGroupEnum type = (NTTypeGroupEnum)((Object)this.getUIContext().get(CTX_NTTYPE_GROUP));
        String isForGov = (String)this.getUIContext().get(CTX_NTTYPE_ISGOV);
        Map map = NTTypeGroupEnum.getEnumMap();
        if ("GOV".equals(isForGov)) {
            this.cboGroup.removeItem((Object)NTTypeGroupEnum.PAYABLE);
            this.cboGroup.removeItem((Object)NTTypeGroupEnum.RECEIVABLE);
            this.cboGroup.removeItem((Object)NTTypeGroupEnum.ImportCredit);
        } else {
            this.cboGroup.removeItem((Object)NTTypeGroupEnum.APPROPRIATION);
        }
        if (type != null) {
            this.cboGroup.setSelectedItem((Object)type);
            objectValue.setGroup(type);
            objectValue.setFinanceType(this.getFinByTypegroup(type));
        } else {
            objectValue.setGroup(NTTypeGroupEnum.CHEQUE);
        }
        objectValue.setIsUsed(true);
        objectValue.setIsSystem(false);
        objectValue.setSuperGroup(NTTypeInfo.getSuperGroup(objectValue.getGroup()));
        return objectValue;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        ClientVerifyHelper.verifyRequire((CoreUIObject)this);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDMultiLangBox)this.txtName);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("isSystem"));
        sic.add(new SelectorItemInfo("isUsed"));
        return sic;
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }
}

