/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.bot.BOTExtMappingInfo;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.botp.client.util.BotpConstant;
import com.kingdee.eas.base.botp.util.IBotpMetaData;
import com.kingdee.eas.base.dap.client.AbstractAccountRuleSegDefUI;
import com.kingdee.eas.base.dap.client.KAccountItemSelector;
import com.kingdee.eas.basedata.assistant.IKAccountItem;
import com.kingdee.eas.basedata.assistant.KAccountItemCollection;
import com.kingdee.eas.basedata.assistant.KAccountItemFactory;
import com.kingdee.eas.basedata.assistant.KAccountItemInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;

public class AccountRuleSegDefUI
extends AbstractAccountRuleSegDefUI {
    private static final int BWIDTH = 476;
    private static final int SWIDTH = 262;
    private static final Rectangle highRect = new Rectangle(270, 0, 204, 188);
    private static final Rectangle lowRect = new Rectangle(270, 0, 204, 160);
    private static final String KAC = "com.kingdee.eas.basedata.assistant.app.KAClassfication";
    private static final String ID = "id";
    private static final String ALIAS = "alias";
    private static final String NUMBER = "number";
    private static final String materialAlias = EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx", (String)"MATERIAL");
    private static final String customerAlias = EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx", (String)"CUSTOMER");
    private static final String supplierAlias = EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx", (String)"SUPPLIER");
    private static final String personAlias = EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx", (String)"PERSON");
    private static final String expenseAlias = EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx", (String)"EXPENSE");
    private int treeWidth;
    private List kaObjectTypeList;
    private List kaObjectBosTypeList;

    public void onLoad() throws Exception {
        super.onLoad();
        this.getAllKaObjectType();
        this.pnlTree.setLayout(null);
        this.treeView.setBounds(new Rectangle(0, 0, 476, 190));
        this.pnlTree.add((Component)this.treeView, null);
    }

    private void getAllKaObjectType() throws BOSException {
        this.kaObjectTypeList = new ArrayList();
        this.kaObjectTypeList.add("com.kingdee.eas.basedata.master.material.app.Material");
        this.kaObjectTypeList.add("com.kingdee.eas.basedata.master.cssp.app.Customer");
        this.kaObjectTypeList.add("com.kingdee.eas.basedata.master.cssp.app.Supplier");
        this.kaObjectTypeList.add("com.kingdee.eas.basedata.ncm.app.Expense");
        this.kaObjectBosTypeList = new ArrayList();
        this.kaObjectBosTypeList.add("4409E7F0");
        this.kaObjectBosTypeList.add("BF0C040E");
        this.kaObjectBosTypeList.add("37C67DFC");
        this.kaObjectBosTypeList.add("80EF7DED");
        this.kaObjectBosTypeList.add("4A255827");
    }

    private void setTreeWidth(int width, boolean isBtnFillShow) {
        if (this.treeWidth != width) {
            this.treeWidth = width;
            this.treeView.setBounds(new Rectangle(0, 0, width, 190));
            this.pnlTree.add((Component)this.treeView, null);
            if (this.tblKac.isVisible()) {
                this.tblKac.setVisible(false);
            } else {
                this.tblKac.setVisible(true);
            }
            this.pnlTree.validate();
        }
        if (this.actionFill.isEnabled() != isBtnFillShow) {
            if (isBtnFillShow) {
                this.tblKac.setBounds(lowRect);
                IColumn numberColumn = this.tblKac.getColumn(NUMBER);
                numberColumn.getStyleAttributes().setHided(false);
                numberColumn.getStyleAttributes().setLocked(false);
                numberColumn.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.initKacItemSelector((IUIObject)this)));
            } else {
                this.tblKac.setBounds(highRect);
                IColumn numberColumn = this.tblKac.getColumn(NUMBER);
                numberColumn.getStyleAttributes().setHided(true);
                numberColumn.getStyleAttributes().setLocked(true);
                numberColumn.setEditor((ICellEditor)new KDTDefaultCellEditor(new JTextField()));
            }
            this.actionFill.setEnabled(isBtnFillShow);
            this.btnFill.setVisible(isBtnFillShow);
        }
    }

    private KDPromptBox initKacItemSelector(final IUIObject owner) {
        KDPromptBox kacItemBox = new KDPromptBox();
        kacItemBox.setSelector((KDPromptSelector)new KAccountItemSelector((IUIObject)this));
        kacItemBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                KDPromptBox box = (KDPromptBox)e.getSource();
                int row = AccountRuleSegDefUI.this.tblKac.getEditManager().getEditRowIndex();
                KDPromptSelector selector = box.getSelector();
                if (selector == null || !(selector instanceof KAccountItemSelector)) {
                    selector = new KAccountItemSelector(owner);
                    box.setSelector(selector);
                }
                ((KAccountItemSelector)selector).setObjectType(AccountRuleSegDefUI.this.kaObjectBosTypeList.get(row).toString());
            }
        });
        return kacItemBox;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void tblKac_tableClicked(KDTMouseEvent e) throws Exception {
        KDTSelectBlock selectBlock;
        super.tblKac_tableClicked(e);
        if (!this.actionFill.isEnabled() && e.getClickCount() == 2 && (selectBlock = this.tblKac.getSelectManager().get()) != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblKac.getRow(rowIndex);
            DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
            IBotpMetaData srcBotpProperty = (IBotpMetaData)treeNode.getUserObject();
            String alias_zh_cn = srcBotpProperty.getFullDisplayName() + "." + row.getCell(ALIAS).getValue().toString();
            String alias_zh_hk = srcBotpProperty.getFullDisplayName(zh_hk) + "." + row.getCell(ALIAS).getValue().toString();
            String expression = null;
            if (srcBotpProperty.getEntity() != null && srcBotpProperty.getEntity().getFullName().equals(KAC)) {
                String accountItemId = row.getCell(ID).getValue().toString();
                expression = BotpConstant.getAccountViewByKac((String)accountItemId, (String)(srcBotpProperty.getLongName() + ".id"));
            } else if (this.kaObjectTypeList.contains(srcBotpProperty.getEntity().getFullName())) {
                String accountItemNumber = row.getCell(NUMBER).getValue().toString();
                expression = BotpConstant.getAccountViewFromKacByDataBase((String)("__src." + srcBotpProperty.getLongName()), (String)accountItemNumber);
            }
            if (expression != null) {
                this.buildRuleSegment(alias_zh_cn, alias_zh_hk, null, expression, this.getCurLocale());
            }
        }
    }

    @Override
    protected void tree_valueChanged(TreeSelectionEvent e) throws Exception {
        super.tree_valueChanged(e);
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (treeNode == null) {
            return;
        }
        IBotpMetaData srcBotpProperty = (IBotpMetaData)treeNode.getUserObject();
        if (srcBotpProperty.getEntity() != null && srcBotpProperty.getEntity().getFullName().equals(KAC)) {
            this.setTreeWidth(262, false);
            this.initTable(srcBotpProperty.getParent().getEntity().getType().toString());
        } else if (srcBotpProperty.getEntity() != null && this.kaObjectTypeList.contains(srcBotpProperty.getEntity().getFullName())) {
            this.setTreeWidth(262, false);
            this.initTable(srcBotpProperty.getEntity().getType().toString());
        } else if (srcBotpProperty.getProperty() instanceof OwnPropertyInfo && (((OwnPropertyInfo)srcBotpProperty.getProperty()).getDataType() == DataType.STRING || ((OwnPropertyInfo)srcBotpProperty.getProperty()).getDataType() == DataType.BOSUUID) && srcBotpProperty.getProperty().getExtendedProperty("ISACCTCUSSENT") != null && srcBotpProperty.getProperty().getExtendedProperty("ISACCTCUSSENT").equalsIgnoreCase("true")) {
            this.setTreeWidth(262, true);
            this.initTblKacItemSelector();
        } else {
            this.setTreeWidth(476, false);
        }
    }

    private void initTblKacItemSelector() {
        this.tblKac.removeRows();
        IRow materialRow = this.tblKac.addRow();
        materialRow.getCell(ALIAS).setValue((Object)materialAlias);
        IRow customerRow = this.tblKac.addRow();
        customerRow.getCell(ALIAS).setValue((Object)customerAlias);
        IRow supplierRow = this.tblKac.addRow();
        supplierRow.getCell(ALIAS).setValue((Object)supplierAlias);
        IRow personRow = this.tblKac.addRow();
        personRow.getCell(ALIAS).setValue((Object)personAlias);
        IRow expenseRow = this.tblKac.addRow();
        expenseRow.getCell(ALIAS).setValue((Object)expenseAlias);
    }

    private void initTable(String objectTypeId) throws BOSException {
        this.tblKac.removeRows();
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.getSelector().add(new SelectorItemInfo(ID));
        entityView.getSelector().add(new SelectorItemInfo(NUMBER));
        entityView.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("objectType.objectTypeID", (Object)objectTypeId));
        entityView.setFilter(filter);
        IKAccountItem kai = KAccountItemFactory.getRemoteInstance();
        KAccountItemCollection kaiCol = kai.getKAccountItemCollection(entityView);
        for (KAccountItemInfo kaiInfo : kaiCol) {
            IRow row = this.tblKac.addRow();
            ICell cellId = row.getCell(ID);
            cellId.setValue((Object)kaiInfo.getId().toString());
            ICell cellNumber = row.getCell(NUMBER);
            cellNumber.setValue((Object)kaiInfo.getNumber());
            ICell cellName = row.getCell(ALIAS);
            cellName.setValue((Object)kaiInfo.getName());
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.pnlList.setLayout((LayoutManager)new BorderLayout());
        this.pnlList.add((Component)this.tblList, (Object)"Center");
        this.setTreeWidth(476, false);
    }

    private CompanyOrgUnitInfo getCurDAPOrg() {
        BOTExtMappingInfo extInfo = this.mappingInfo.getExtRule();
        CompanyOrgUnitInfo curOrg = extInfo.getOrg();
        if (curOrg == null) {
            curOrg = SysContext.getSysContext().getCurrentFIUnit();
        }
        return curOrg;
    }

    private AccountTableInfo getCurAccountTable() {
        BOTExtMappingInfo extInfo = this.mappingInfo.getExtRule();
        CompanyOrgUnitInfo curOrg = extInfo.getOrg();
        if (curOrg == null || curOrg.getAccountTable() == null) {
            curOrg = SysContext.getSysContext().getCurrentFIUnit();
        }
        return curOrg.getAccountTable();
    }

    protected EntityViewInfo getEntityView() {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)true));
        AccountTableInfo account = this.getCurAccountTable();
        if (account != null) {
            filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)account.getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", null));
        }
        CompanyOrgUnitInfo curFI = this.getCurDAPOrg();
        if (curFI != null) {
            filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)curFI.getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("companyID.id", null));
        }
        return evi;
    }

    @Override
    public void actionFill_actionPerformed(ActionEvent e) throws Exception {
        String personNumber;
        String materialNumber = this.tblKac.getRow(0).getCell(NUMBER).getValue() == null ? "" : this.tblKac.getRow(0).getCell(NUMBER).getValue().toString();
        String customerNumber = this.tblKac.getRow(1).getCell(NUMBER).getValue() == null ? "" : this.tblKac.getRow(1).getCell(NUMBER).getValue().toString();
        String supplierNumber = this.tblKac.getRow(2).getCell(NUMBER).getValue() == null ? "" : this.tblKac.getRow(2).getCell(NUMBER).getValue().toString();
        String string = personNumber = this.tblKac.getRow(3).getCell(NUMBER).getValue() == null ? "" : this.tblKac.getRow(3).getCell(NUMBER).getValue().toString();
        if (materialNumber.length() + customerNumber.length() + supplierNumber.length() + personNumber.length() > 0) {
            DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
            IBotpMetaData srcBotpProperty = (IBotpMetaData)treeNode.getUserObject();
            String databaseId = srcBotpProperty.getLongName();
            StringBuffer alias_zh_cn = new StringBuffer(srcBotpProperty.getFullDisplayName(zh_cn));
            StringBuffer alias_zh_hk = new StringBuffer(srcBotpProperty.getFullDisplayName(zh_hk));
            alias_zh_cn.append(":(");
            alias_zh_hk.append(":(");
            if (materialNumber.length() > 0) {
                alias_zh_cn.append(ResourceBase.getString((String)"com.kingdee.eas.base.botp.BotpResx", (String)"MATERIAL", (Locale)zh_cn));
                alias_zh_hk.append(ResourceBase.getString((String)"com.kingdee.eas.base.botp.BotpResx", (String)"MATERIAL", (Locale)zh_hk));
                alias_zh_cn.append(":");
                alias_zh_hk.append(":");
                alias_zh_cn.append(materialNumber);
                alias_zh_hk.append(materialNumber);
                alias_zh_cn.append(";");
                alias_zh_hk.append(";");
            }
            if (customerNumber.length() > 0) {
                alias_zh_hk.append(ResourceBase.getString((String)"com.kingdee.eas.base.botp.BotpResx", (String)"CUSTOMER", (Locale)zh_hk));
                alias_zh_cn.append(ResourceBase.getString((String)"com.kingdee.eas.base.botp.BotpResx", (String)"CUSTOMER", (Locale)zh_cn));
                alias_zh_hk.append(":");
                alias_zh_cn.append(":");
                alias_zh_hk.append(customerNumber);
                alias_zh_cn.append(customerNumber);
                alias_zh_hk.append(";");
                alias_zh_cn.append(";");
            }
            if (supplierNumber.length() > 0) {
                alias_zh_cn.append(ResourceBase.getString((String)"com.kingdee.eas.base.botp.BotpResx", (String)"SUPPLIER", (Locale)zh_cn));
                alias_zh_hk.append(ResourceBase.getString((String)"com.kingdee.eas.base.botp.BotpResx", (String)"SUPPLIER", (Locale)zh_hk));
                alias_zh_cn.append(":");
                alias_zh_hk.append(":");
                alias_zh_cn.append(supplierNumber);
                alias_zh_hk.append(supplierNumber);
                alias_zh_cn.append(";");
                alias_zh_hk.append(";");
            }
            if (personNumber.length() > 0) {
                alias_zh_cn.append(ResourceBase.getString((String)"com.kingdee.eas.base.botp.BotpResx", (String)"PERSON", (Locale)zh_cn));
                alias_zh_hk.append(ResourceBase.getString((String)"com.kingdee.eas.base.botp.BotpResx", (String)"PERSON", (Locale)zh_hk));
                alias_zh_cn.append(":");
                alias_zh_hk.append(":");
                alias_zh_cn.append(personNumber);
                alias_zh_hk.append(personNumber);
                alias_zh_cn.append(";");
                alias_zh_hk.append(";");
            }
            alias_zh_cn.append(")");
            alias_zh_hk.append(")");
            String expression = BotpConstant.getAccountViewFromKacByDataBaseId((String)databaseId, (String)materialNumber, (String)customerNumber, (String)supplierNumber, (String)personNumber);
            this.buildRuleSegment(alias_zh_cn.toString(), alias_zh_hk.toString(), null, expression, this.getCurLocale());
        }
    }
}

