/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPUtil;
import com.kingdee.eas.base.dap.AbstractDAPVoucherStrategy;
import com.kingdee.eas.base.dap.DAPException;
import com.kingdee.eas.base.dap.client.AbstractDAPMakeFromMultiBillListUI;
import com.kingdee.eas.base.dap.client.DAPMappingSelectUI;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.BillBaseException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.util.StringUtility;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;

public class DAPMakeFromMultiBillListUI
extends AbstractDAPMakeFromMultiBillListUI {
    private boolean isCancel = false;
    private CoreBillBaseCollection srcBillCollection;
    private static final Logger logger = CoreUIObject.getLogger(DAPMakeFromMultiBillListUI.class);
    private Map bosTypeToEntity = new HashMap();
    private List bosTypeList = new ArrayList();
    protected CoreBillListUI currentBillListUI;
    private List srcBillColsList;
    protected KDTable kDTable1 = new KDTable();
    private String billName = null;
    private String billIds = null;
    private String entryids = null;
    private EntityViewInfo orgmainQuery = null;
    private boolean noEntries = false;
    private static final String TRANSMITCU = "TRANSMITCU";
    private BOTMappingInfo curMappingInfo = null;
    private String initRuleName = null;
    private boolean hasFinished = false;
    private String entityDisplayName = null;
    private static final String VOUCHERFLAG = "fiVouchered";
    private EntityViewInfo orgEnv = null;
    private String keyFieldName = null;
    private String entriesPKName = null;

    public DAPMakeFromMultiBillListUI() throws Exception {
        this.kDTable1.setName("kDTable1");
        this.kDTable1.getSelectManager().setSelectMode(10);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionConfirm.setEnabled(true);
        this.actionRuleChoose.setEnabled(true);
        this.actionQuery.setEnabled(true);
        this.actionView.setEnabled(true);
        this.actionRefresh.setEnabled(true);
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnWholeSelected.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnWholeRemove.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(final ChangeEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        KDTabbedPane tabpane = (KDTabbedPane)e.getSource();
                        if (tabpane.getSelectedComponent() == null) {
                            int index = tabpane.getSelectedIndex();
                            if (index > -1) {
                                String bosType = (String)DAPMakeFromMultiBillListUI.this.bosTypeList.get(index);
                                EntityObjectInfo srcEntity = (EntityObjectInfo)DAPMakeFromMultiBillListUI.this.bosTypeToEntity.get(bosType);
                                try {
                                    CoreBillListUI billListUI = DAPMakeFromMultiBillListUI.this.newTab(srcEntity);
                                    tabpane.setComponentAt(index, (Component)billListUI);
                                    DAPMakeFromMultiBillListUI.this.currentBillListUI = billListUI;
                                }
                                catch (Exception ex) {
                                    DAPMakeFromMultiBillListUI.this.handleException(ex);
                                }
                            }
                        } else if (tabpane.getSelectedComponent() instanceof IUIObject) {
                            DAPMakeFromMultiBillListUI.this.currentBillListUI = (CoreBillListUI)tabpane.getSelectedComponent();
                        }
                        DAPMakeFromMultiBillListUI.this.kDTabbedPane1.addTab(DAPMakeFromMultiBillListUI.this.billName, (Component)DAPMakeFromMultiBillListUI.this.kDTable1);
                        DAPMakeFromMultiBillListUI.this.kDTabbedPane1.setVisible(true);
                        int width = 695;
                        int height = 440;
                        DAPMakeFromMultiBillListUI.this.kDTable1.setBounds(5, 5, width - 5, height - 5);
                        DAPMakeFromMultiBillListUI.this.copyTable(DAPMakeFromMultiBillListUI.this.currentBillListUI);
                        DAPMakeFromMultiBillListUI.this.kDTable1.setEditable(false);
                        DAPMakeFromMultiBillListUI.this.kDTable1.checkParsed();
                        DAPMakeFromMultiBillListUI.this.kDTable1.refresh();
                        DAPMakeFromMultiBillListUI.this.kDTable1.addKDTMouseListener(new KDTMouseListener(){

                            public void tableClicked(KDTMouseEvent e) {
                                if (e.getClickCount() == 2) {
                                    try {
                                        DAPMakeFromMultiBillListUI.this.actionConfirm_actionPerformed(null);
                                    }
                                    catch (Exception e1) {
                                        DAPMakeFromMultiBillListUI.this.handUIException(e1);
                                    }
                                }
                            }
                        });
                        KDTable tblMain = DAPMakeFromMultiBillListUI.this.currentBillListUI.getTableForBOTP();
                        EventListenerList listeners = tblMain.getListenerList();
                        final EventListener[] mouse = listeners.getListeners(KDTMouseListener.class);
                        for (int i = 0; i < mouse.length; ++i) {
                            tblMain.removeKDTMouseListener((KDTMouseListener)mouse[i]);
                        }
                        tblMain.addKDTMouseListener(new KDTMouseListener(){

                            public void tableClicked(KDTMouseEvent e) {
                                if (e.getClickCount() == 2) {
                                    try {
                                        DAPMakeFromMultiBillListUI.this.wholeSelectedData();
                                        DAPMakeFromMultiBillListUI.this.actionRefresh_actionPerformed(null);
                                        DAPMakeFromMultiBillListUI.this.syncSrcBillCollection();
                                    }
                                    catch (Exception e1) {
                                        DAPMakeFromMultiBillListUI.this.handUIException(e1);
                                    }
                                } else {
                                    for (int i = 0; i < mouse.length; ++i) {
                                        ((KDTMouseListener)mouse[i]).tableClicked(e);
                                    }
                                }
                            }
                        });
                        DAPMakeFromMultiBillListUI.this.orgmainQuery = (EntityViewInfo)DAPMakeFromMultiBillListUI.this.currentBillListUI.getMainQuery().clone();
                        FilterInfo mainFilter = null;
                        if (DAPMakeFromMultiBillListUI.this.orgmainQuery.getFilter() != null) {
                            mainFilter = (FilterInfo)DAPMakeFromMultiBillListUI.this.orgmainQuery.getFilter().clone();
                        }
                        if (mainFilter == null) {
                            mainFilter = new FilterInfo();
                        }
                        FilterInfo noVoucherFilterInfo = new FilterInfo();
                        noVoucherFilterInfo.getFilterItems().add(new FilterItemInfo(DAPMakeFromMultiBillListUI.VOUCHERFLAG, (Object)Boolean.TRUE, CompareType.NOTEQUALS));
                        try {
                            mainFilter.mergeFilter(noVoucherFilterInfo, "And");
                        }
                        catch (BOSException e1) {
                            logger.error((Object)e1.getMessage());
                        }
                        DAPMakeFromMultiBillListUI.this.orgmainQuery.setFilter(mainFilter);
                    }
                });
            }
        });
        this.btnWholeSelected.setEnabled(true);
        this.btnWholeSelected.setVisible(true);
        this.btnWholeRemove.setEnabled(true);
        this.btnWholeRemove.setVisible(true);
        this.initRuleName = this.curRuleNameLabel.getText();
        this.orgEnv = (EntityViewInfo)this.getUIContext().get("BOTPFilter");
        this.curMappingInfo = (BOTMappingInfo)this.getUIContext().get("botMappingInfo");
        this.curRuleNameLabel.setText(this.curMappingInfo.getAlias());
    }

    private void checkIsNoEntries() {
        ICell idcell;
        Throwable throwable = null;
        CoreBillListUI billListUI = this.currentBillListUI;
        if (billListUI == null) {
            return;
        }
        String ListUIName = billListUI.getName();
        String entriesPKName = billListUI.getEntriesPKName();
        KDTable tabletmp = billListUI.getTableForBOTP();
        if (tabletmp == null || tabletmp.getRow(0) == null) {
            return;
        }
        ICell entryidcell = tabletmp.getRow(0).getCell(entriesPKName);
        if (entryidcell == null) {
            throwable = new Throwable();
            logger.warn((Object)("The field of entriesPK [" + entriesPKName + "] isn't binding on ListUI [" + ListUIName + "]!"), throwable);
            this.setNoEntries(true);
        }
        if ((idcell = tabletmp.getRow(0).getCell(this.keyFieldName)) == null) {
            throwable = new Throwable();
            logger.error((Object)("The field of PK [" + this.keyFieldName + "] isn't binding on ListUI [" + ListUIName + "]!"), throwable);
        }
    }

    public void onShow() throws Exception {
        this.actionRefresh_actionPerformed(null);
        super.onShow();
    }

    protected CoreBillListUI newTab(EntityObjectInfo srcEntity) throws UIException {
        String f7ListUIName = srcEntity.getExtendedProperty("listUI");
        if (f7ListUIName == null || f7ListUIName.equals("")) {
            MsgBox.showError((String)"f7ListUIName is null");
            SysUtil.abort();
        }
        HashMap uiCtx = new HashMap();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null) {
            uiCtx.put("BTPEDITPARAMETER", this.getUIContext().get("BTPEDITPARAMETER"));
        }
        if (this.getUIContext().get("BOTMappingInfo_ID") != null) {
            uiCtx.put("BOTMappingInfo_ID", this.getUIContext().get("BOTMappingInfo_ID"));
        }
        if (f7ListUIName.endsWith("CostAdjustBillListUI")) {
            uiCtx.put("BOTPViewStatus", 0);
            if (this.getUIContext().get("BTPCreateMode") == null) {
                uiCtx.put("BTPCreateMode", 1);
            } else {
                uiCtx.put("BTPCreateMode", 0);
            }
        } else {
            uiCtx.put("BOTPViewStatus", 1);
            if (this.getUIContext().get("BTPCreateMode") == null) {
                uiCtx.put("BTPCreateMode", 1);
            } else {
                uiCtx.put("BTPCreateMode", 0);
            }
        }
        if (this.getUIContext().get("BOTPFilter") != null) {
            uiCtx.put("BOTPFilter", this.getUIContext().get("BOTPFilter"));
        }
        if (this.getUIWindow() == null) {
            uiCtx.put("Owner", this.getUIContext().get("Owner"));
        } else {
            uiCtx.put("Owner", this);
        }
        CoreBillListUI uiObj = (CoreBillListUI)UIFactoryHelper.initUIObject((String)f7ListUIName, uiCtx, null, (String)"FINDVIEW");
        this.keyFieldName = this.queryNameToKDTableName(uiObj.getMainTable(), uiObj.getKeyFieldNameForWF());
        this.entriesPKName = this.queryNameToKDTableName(uiObj.getMainTable(), uiObj.getEntriesPKName());
        if (this.entriesPKName == null || this.entriesPKName.equals("")) {
            this.entriesPKName = uiObj.getEntriesName() + ".id";
        }
        int width = 695;
        int height = 440;
        uiObj.getUIContentPane().setSize(new Dimension(width, height));
        uiObj.getMainTable().setBounds(5, 5, width - 5, height - 5);
        return uiObj;
    }

    private String queryNameToKDTableName(KDTable topTable, String queryFieldName) {
        String str = "";
        KDTColumns cols = topTable.getColumns();
        for (int i = 0; i <= topTable.getColumnCount() - 1; ++i) {
            KDTColumn col = cols.getColumn(i);
            if (col.getFieldName() == null || !col.getFieldName().equalsIgnoreCase(queryFieldName)) continue;
            str = col.getKey();
            break;
        }
        return str;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        int count = this.tblPanel.getTabCount();
        for (int i = 0; i < count; ++i) {
            CoreBillListUI billListUI = (CoreBillListUI)this.tblPanel.getComponentAt(i);
            if (billListUI == null) {
                throw new DAPException(DAPException.BILLHASNOSELECT, new Object[]{((EntityObjectInfo)this.bosTypeToEntity.get(this.bosTypeList.get(i))).getAlias()});
            }
            if (this.srcBillCollection == null) {
                this.srcBillCollection = new CoreBillBaseCollection();
            }
            if (this.srcBillColsList == null) {
                this.srcBillColsList = new ArrayList();
            }
            CoreBillBaseCollection cols = this.getBillCollectionForSubmit(this.kDTable1);
            this.srcBillCollection.addCollection(cols);
            this.srcBillColsList.add(cols);
        }
        if (this.srcBillCollection != null && this.srcBillCollection.size() > 0) {
            this.setCancel(false);
        } else {
            this.srcBillCollection = null;
            this.setCancel(true);
        }
    }

    private void syncSrcBillCollection() throws Exception {
        if (this.srcBillCollection == null) {
            this.srcBillCollection = new CoreBillBaseCollection();
        } else {
            this.srcBillCollection.clear();
        }
        int count = this.tblPanel.getTabCount();
        for (int i = 0; i < count; ++i) {
            CoreBillListUI billListUI = (CoreBillListUI)this.tblPanel.getComponentAt(i);
            if (billListUI == null) {
                throw new DAPException(DAPException.BILLHASNOSELECT, new Object[]{((EntityObjectInfo)this.bosTypeToEntity.get(this.bosTypeList.get(i))).getAlias()});
            }
            if (this.srcBillCollection == null) {
                this.srcBillCollection = new CoreBillBaseCollection();
            }
            if (this.srcBillColsList == null) {
                this.srcBillColsList = new ArrayList();
            }
            CoreBillBaseCollection cols = this.getBillCollectionForSubmit(this.kDTable1);
            this.srcBillCollection.addCollection(cols);
            this.srcBillColsList.add(cols);
        }
        if (this.srcBillCollection != null && this.srcBillCollection.size() > 0) {
            this.setCancel(false);
        } else {
            this.srcBillCollection = null;
            this.setCancel(true);
        }
    }

    public void verifyBillList(CoreBillBaseCollection sourceBillCollection) throws Exception {
        if (sourceBillCollection == null || sourceBillCollection.size() == 0) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < sourceBillCollection.size(); ++i) {
            CoreBillBaseInfo info = sourceBillCollection.get(i);
            list.add(info.getId().toString());
        }
        String strIdLists = StringUtils.arrayToString((Object[])list.toArray(), (String)",");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo(VOUCHERFLAG, (Object)Boolean.TRUE));
        StringBuffer maskString = new StringBuffer();
        maskString.append("#0 AND #1");
        filterInfo.setMaskString(maskString.toString());
        boolean isExist = ((ICoreBillBase)this.currentBillListUI.getBillInterface()).exists(filterInfo);
        if (isExist) {
            throw new BillBaseException(BillBaseException.FIVOUCHERED);
        }
    }

    @Override
    public void actionRuleChoose_actionPerformed(ActionEvent e) throws Exception {
        BOTMappingInfo botMappingInfo;
        CoreBillListUI billList = null;
        IBOTMapping botMapping = BOTMappingFactory.getRemoteInstance();
        String voucherBosType = AbstractDAPVoucherStrategy.getInstanceof("fi").getVoucherInfo().getBOSType().toString();
        IObjectValue sourceBill = this.srcBillCollection.getObject(0);
        String sourceBillType = sourceBill.getBOSType().toString();
        HashMap ctx = new HashMap();
        Object transmitCU = ctx.get(TRANSMITCU);
        if (transmitCU == null || !(transmitCU instanceof CtrlUnitInfo)) {
            if (this.currentBillListUI != null) {
                billList = this.currentBillListUI;
                transmitCU = billList.getMainOrgInfo();
            }
            if (transmitCU != null) {
                transmitCU = ((OrgUnitInfo)transmitCU).getCU();
                ctx.put(TRANSMITCU, transmitCU);
            }
        }
        BOTMappingCollection botMappingCollection = botMapping.getMappingCollectionForSelect(sourceBillType, voucherBosType, DefineSysEnum.DAP, ctx);
        if ((botMappingCollection = this.acceptMapping(this.srcBillCollection, botMappingCollection)).size() > 0 && billList != null && billList.isNeedShowBOTPRule()) {
            HashMap<String, Object> uiContext = new HashMap<String, Object>();
            if (billList != null) {
                uiContext.put("Owner", billList);
            }
            uiContext.put("BOTMappings", botMappingCollection);
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow window = uiFactory.create(DAPMappingSelectUI.class.getName(), uiContext, null);
            window.show();
            if (((DAPMappingSelectUI)window.getUIObject()).isCanceled() || ((DAPMappingSelectUI)window.getUIObject()).getSelectBotMappingInfo() == null) {
                return;
            }
            botMappingInfo = ((DAPMappingSelectUI)window.getUIObject()).getSelectBotMappingInfo();
        } else {
            botMappingInfo = botMappingCollection.get(0);
        }
        if (botMappingInfo != null) {
            this.curMappingInfo = (BOTMappingInfo)this.getUIContext().get("botMappingInfo");
            this.curRuleNameLabel.setText(this.curMappingInfo.getAlias());
        }
    }

    private BOTMappingCollection acceptMapping(CoreBillBaseCollection srcBillInfos, BOTMappingCollection botMappingCollection) throws BOTPException, BOSException {
        BOTMappingCollection botMappingCols = new BOTMappingCollection();
        Iterator iter = botMappingCollection.iterator();
        ArrayList<BOTMappingInfo> companyMappings = new ArrayList<BOTMappingInfo>();
        while (iter.hasNext()) {
            String currentOrgId;
            BOTMappingInfo mappingInfo = (BOTMappingInfo)iter.next();
            String string = currentOrgId = SysContext.getSysContext().getCurrentFIUnit() == null ? "" : SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            if (mappingInfo.getExtRule() != null && mappingInfo.getExtRule().getOrg() != null && !mappingInfo.getExtRule().getOrg().getId().toString().equals(currentOrgId)) continue;
            companyMappings.add(mappingInfo);
        }
        if (companyMappings.size() == 0) {
            throw new BOTPException(BOTPException.NOCOMPANYMAPPING);
        }
        for (BOTMappingInfo mappingInfo : companyMappings) {
            try {
                BTPUtil.acceptMapping((IObjectCollection)srcBillInfos, (BOTMappingInfo)mappingInfo);
            }
            catch (BOTPException ex) {
                continue;
            }
            botMappingCols.add(mappingInfo);
        }
        if (botMappingCols.size() == 0) {
            throw new BOTPException(BOTPException.MAPPINGNUMZERO);
        }
        return botMappingCols;
    }

    private String getTableBindInfo(CoreBillListUI currentBillListUI) throws Exception {
        StringBuffer sb = new StringBuffer();
        KDTable tabletmp = currentBillListUI.getTableForBOTP();
        KDTColumns columns = tabletmp.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            KDTColumn column = columns.getColumn(i);
            sb.append("column[" + i + "]=" + column.getKey() + " ");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.currentBillListUI != null) {
            EntityViewInfo view = (EntityViewInfo)this.orgEnv.clone();
            Map ctx = this.currentBillListUI.getUIContext();
            if (ctx != null) {
                ctx.put("BOTPFilter", view);
            }
            this.currentBillListUI.setDoRequestData(false);
            try {
                this.currentBillListUI.actionQuery_actionPerformed(e);
                this.orgmainQuery = (EntityViewInfo)this.currentBillListUI.getMainQuery().clone();
            }
            finally {
                this.currentBillListUI.setDoRequestData(true);
            }
            this.actionRefresh_actionPerformed(e);
            this.checkIsNoEntries();
        }
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
        if (this.currentBillListUI != null) {
            this.currentBillListUI.actionView_actionPerformed(e);
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        if (this.currentBillListUI != null) {
            this.dynFilter(this.currentBillListUI, this.billIds, this.entryids);
            this.currentBillListUI.refreshList();
        }
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public CoreBillBaseCollection getSrcBillCollection() throws Exception {
        this.syncSrcBillCollection();
        this.verifyBillList(this.srcBillCollection);
        return this.srcBillCollection;
    }

    public List getSrcBillColsList() {
        return this.srcBillColsList;
    }

    public CoreBillListUI getSrcListUI() {
        return this.currentBillListUI;
    }

    public void setSrcBosType(String bosType) throws BOSException {
        IMetaDataLoader metadataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo srcEntity = metadataLoader.getEntity(BOSObjectType.create((String)bosType));
        CoreBillListUI srcBillListUI = this.newTab(srcEntity);
        try {
            srcBillListUI.onLoad();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (srcBillListUI instanceof CoreBillListUI) {
            this.entityDisplayName = this.billName = srcEntity.getAlias();
            this.tblPanel.addTab(srcEntity.getAlias(), (Component)srcBillListUI);
        }
    }

    public void setSrcBosTypeList(List bosTypeList) {
        this.bosTypeList = bosTypeList;
        IMetaDataLoader metadataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        for (String bosType : bosTypeList) {
            EntityObjectInfo srcEntity = metadataLoader.getEntity(BOSObjectType.create((String)bosType));
            this.bosTypeToEntity.put(bosType, srcEntity);
            String alias = srcEntity.getAlias();
            this.tblPanel.addTab(alias, null);
            if (this.tblPanel.getTabCount() <= 0 || this.tblPanel.getSelectedIndex() >= 0) continue;
            this.tblPanel.setSelectedIndex(0);
        }
    }

    public boolean destroyWindow() {
        int count = this.tblPanel.getTabCount();
        for (int i = 0; i < count; ++i) {
            Component obj = this.tblPanel.getComponentAt(i);
            if (obj == null || !(obj instanceof ListUI)) continue;
            ((ListUI)obj).destroyWindow();
        }
        return super.destroyWindow();
    }

    private void dynFilter(CoreBillListUI billListUI, String billIds, String entryids) throws BOSException {
        String billPKName = billListUI.getKeyFieldNameForWF();
        if (billPKName.equals("entry.billID")) {
            billPKName = "id";
        }
        String entriesPKName = billListUI.getEntriesPKName();
        if (this.noEntries) {
            FilterInfo mainFilter = null;
            if (this.orgmainQuery.getFilter() != null) {
                mainFilter = (FilterInfo)this.orgmainQuery.getFilter().clone();
            }
            if (mainFilter == null) {
                mainFilter = new FilterInfo();
            }
            if (!StringUtils.isEmpty((String)billIds)) {
                FilterInfo curFilterInfo = new FilterInfo();
                FilterItemInfo filteritem2 = new FilterItemInfo(billPKName, (Object)billIds, CompareType.NOTINCLUDE);
                curFilterInfo.getFilterItems().add(filteritem2);
                mainFilter.mergeFilter(curFilterInfo, "And");
            }
            EntityViewInfo mainQuery = billListUI.getMainQuery();
            mainQuery.setFilter(mainFilter);
        } else {
            FilterInfo mainFilter = null;
            if (this.orgmainQuery.getFilter() != null) {
                mainFilter = (FilterInfo)this.orgmainQuery.getFilter().clone();
            }
            if (mainFilter == null) {
                mainFilter = new FilterInfo();
            }
            if (!StringUtils.isEmpty((String)entryids)) {
                FilterInfo curFilterInfo = new FilterInfo();
                FilterItemInfo filteritem2 = new FilterItemInfo(entriesPKName, (Object)entryids, CompareType.NOTINCLUDE);
                curFilterInfo.getFilterItems().add(filteritem2);
                mainFilter.mergeFilter(curFilterInfo, "And");
            }
            EntityViewInfo mainQuery = billListUI.getMainQuery();
            mainQuery.setFilter(mainFilter);
        }
    }

    @Override
    public void actionWholeRemove_actionPerformed(ActionEvent e) throws Exception {
        this.wholeRemoveData();
        this.actionRefresh_actionPerformed(e);
        this.syncSrcBillCollection();
    }

    @Override
    public void actionWholeSelected_actionPerformed(ActionEvent e) throws Exception {
        this.wholeSelectedData();
        this.actionRefresh_actionPerformed(e);
        this.syncSrcBillCollection();
    }

    private Set findBillByEntry(KDTable tabletmp, int index, String billID) {
        ICell idcell;
        CoreBillListUI billListUI = this.currentBillListUI;
        String keyFieldName = billListUI.getKeyFieldNameForWF();
        if (keyFieldName.equals("entry.billID")) {
            keyFieldName = "id";
        }
        HashSet<Integer> rowIndexList = new HashSet<Integer>();
        int top = 0;
        int bottom = tabletmp.getRowCount() - 1;
        for (int i = index; i >= top; --i) {
            idcell = tabletmp.getRow(i).getCell(keyFieldName);
            if (idcell.getValue() == null) continue;
            if (!idcell.getValue().toString().equalsIgnoreCase(billID)) break;
            rowIndexList.add(i);
        }
        for (int j = index; j <= bottom; ++j) {
            idcell = tabletmp.getRow(j).getCell(keyFieldName);
            if (idcell.getValue() == null) continue;
            if (!idcell.getValue().toString().equalsIgnoreCase(billID)) break;
            rowIndexList.add(j);
        }
        rowIndexList.add(index);
        return rowIndexList;
    }

    private void wholeSelectedData() throws Exception {
        CoreBillListUI billListUI = this.currentBillListUI;
        KDTable tabletmp = billListUI.getTableForBOTP();
        int[] selectRows = this.getSelectedRows(tabletmp, billListUI);
        String keyFieldName = billListUI.getKeyFieldNameForWF();
        if (keyFieldName.equals("entry.billID")) {
            keyFieldName = "id";
        }
        String entriesPKName = billListUI.getEntriesPKName();
        HashMap<String, String> ids = new HashMap<String, String>();
        HashSet<String> idValueList = new HashSet<String>();
        for (int rowIndex = 0; rowIndex < selectRows.length; ++rowIndex) {
            ICell idcell = tabletmp.getRow(selectRows[rowIndex]).getCell(keyFieldName);
            ICell encell = tabletmp.getRow(selectRows[rowIndex]).getCell(entriesPKName);
            if (encell != null && encell.getValue() != null) {
                ids.put(encell.getValue().toString(), idcell.getValue().toString());
                continue;
            }
            this.setNoEntries(true);
            ids.put(idcell.getValue().toString(), "entries.id");
        }
        for (String key : ids.keySet()) {
            if (ids.get(key).toString().equals("entries.id")) {
                idValueList.add(key);
                continue;
            }
            idValueList.add((String)ids.get(key));
        }
        ArrayList rowIndexList = new ArrayList();
        for (int rowIndex = 0; rowIndex < selectRows.length; ++rowIndex) {
            ICell idcell = tabletmp.getRow(selectRows[rowIndex]).getCell(keyFieldName);
            String billID = idcell.getValue().toString();
            rowIndexList.addAll(this.findBillByEntry(tabletmp, selectRows[rowIndex], billID));
        }
        int size = tabletmp.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            tabletmp.getSelectManager().remove(i);
        }
        int[] rowIndex = new int[rowIndexList.size()];
        ArrayList list = new ArrayList();
        for (int i = 0; i < rowIndexList.size(); ++i) {
            if (list.contains(rowIndexList.get(i))) continue;
            list.add(rowIndexList.get(i));
        }
        int count = tabletmp.getColumnCount();
        for (int i = 0; i < list.size(); ++i) {
            Integer index = (Integer)list.get(i);
            KDTSelectBlock sb = new KDTSelectBlock(index.intValue(), 0, index.intValue(), count, 10);
            tabletmp.getSelectManager().add(sb, false);
        }
        this.copySelectedRowDataAdd();
    }

    public void removeAllBills() throws Exception {
        this.kDTable1.removeRows();
        this.actionRefresh_actionPerformed(null);
        this.syncSrcBillCollection();
    }

    private void wholeRemoveData() throws Exception {
        int i;
        CoreBillListUI billListUI = this.currentBillListUI;
        int[] selectRows = this.getSelectedRows(this.kDTable1, billListUI);
        String keyFieldName = billListUI.getKeyFieldNameForWF();
        if (keyFieldName.equals("entry.billID")) {
            keyFieldName = "id";
        }
        String entriesPKName = billListUI.getEntriesPKName();
        HashMap<String, String> ids = new HashMap<String, String>();
        HashSet<String> idValueList = new HashSet<String>();
        for (int rowIndex = 0; rowIndex < selectRows.length; ++rowIndex) {
            ICell idcell = this.kDTable1.getRow(selectRows[rowIndex]).getCell(keyFieldName);
            ICell encell = this.kDTable1.getRow(selectRows[rowIndex]).getCell(entriesPKName);
            if (encell != null && encell.getValue() != null) {
                ids.put(encell.getValue().toString(), idcell.getValue().toString());
                continue;
            }
            this.setNoEntries(true);
            ids.put(idcell.getValue().toString(), "entries.id");
        }
        for (String key : ids.keySet()) {
            if (ids.get(key).toString().equals("entries.id")) {
                idValueList.add(key);
                continue;
            }
            idValueList.add((String)ids.get(key));
        }
        ArrayList rowIndexList = new ArrayList();
        for (int rowIndex = 0; rowIndex < selectRows.length; ++rowIndex) {
            ICell idcell = this.kDTable1.getRow(selectRows[rowIndex]).getCell(keyFieldName);
            String billID = idcell.getValue().toString();
            rowIndexList.addAll(this.findBillByEntry(this.kDTable1, selectRows[rowIndex], billID));
        }
        int size = this.kDTable1.getSelectManager().size();
        for (int i2 = 0; i2 < size; ++i2) {
            this.kDTable1.getSelectManager().remove(i2);
        }
        int[] rowIndex = new int[rowIndexList.size()];
        for (i = 0; i < rowIndexList.size(); ++i) {
            rowIndex[i] = (Integer)rowIndexList.get(i);
        }
        for (i = 0; i < rowIndex.length; ++i) {
            this.kDTable1.getSelectManager().add(rowIndex[i], 0, rowIndex[i], this.kDTable1.getColumnCount(), 10);
        }
        this.copySelectedRowDataDel();
    }

    private void getBillIdList(KDTable tblMain, List idList, List entriesList, String keyFieldName, String entriesPKName) {
        int bottom = tblMain.getRowCount() - 1;
        if (tblMain.getRowCount() == 0) {
            return;
        }
        for (int rowIndex = 0; rowIndex <= bottom; ++rowIndex) {
            ICell cell = tblMain.getRow(rowIndex).getCell(keyFieldName);
            if (tblMain.getRow(rowIndex).getCell(entriesPKName) != null && tblMain.getRow(rowIndex).getCell(entriesPKName).getValue() != null) {
                entriesList.add(tblMain.getRow(rowIndex).getCell(entriesPKName).getValue().toString());
            } else {
                this.setNoEntries(true);
            }
            if (idList.contains(cell.getValue())) continue;
            idList.add(cell.getValue());
        }
    }

    private int[] getSelectedRows(KDTable tabletmp, CoreBillListUI billListUI) {
        String billPKName;
        if (tabletmp.getRowCount() == 0 || tabletmp.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if ((billPKName = billListUI.getKeyFieldNameForWF()).equals("entry.billID")) {
            billPKName = "id";
        }
        String entriesPKName = billListUI.getEntriesPKName();
        ArrayList<Object> idList = new ArrayList<Object>();
        ArrayList<String> entriesKey = new ArrayList<String>();
        HashSet<Integer> tempSet = new HashSet<Integer>();
        ArrayList blocks = tabletmp.getSelectManager().getBlocks();
        for (KDTSelectBlock block : blocks) {
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
                ICell cell = tabletmp.getRow(rowIndex).getCell(billPKName);
                tempSet.add(rowIndex);
                if (tabletmp.getRow(rowIndex).getCell(entriesPKName) != null && tabletmp.getRow(rowIndex).getCell(entriesPKName).getValue() != null) {
                    entriesKey.add(tabletmp.getRow(rowIndex).getCell(entriesPKName).getValue().toString());
                }
                if (idList.contains(cell.getValue())) continue;
                idList.add(cell.getValue());
            }
        }
        int[] rows = new int[tempSet.size()];
        Iterator itera = tempSet.iterator();
        int k = 0;
        while (itera.hasNext()) {
            rows[k] = Integer.valueOf(itera.next().toString());
            ++k;
        }
        return rows;
    }

    protected CoreBillBaseCollection getBillCollectionForSubmit(KDTable tabletmp) throws Exception {
        CoreBillListUI billListUI = this.currentBillListUI;
        String billPKName = billListUI.getKeyFieldNameForWF();
        ArrayList<Object> idList = new ArrayList<Object>();
        ArrayList<String> entriesKey = new ArrayList<String>();
        if (billPKName.equals("entry.billID")) {
            billPKName = "id";
            ICoreBase coreBase = (ICoreBase)BusinessProcessUtil.getBizInteface((Context)this.getMainOrgContext(), (BOSObjectType)new BOSObjectType("B84FB1E2"));
            String entriesPKName = billListUI.getEntriesPKName();
            for (int rowIndex = 0; rowIndex <= tabletmp.getRowCount() - 1; ++rowIndex) {
                ICell cell = tabletmp.getRow(rowIndex).getCell(billPKName);
                if (tabletmp.getRow(rowIndex).getCell(entriesPKName) != null && tabletmp.getRow(rowIndex).getCell(entriesPKName).getValue() != null) {
                    entriesKey.add(tabletmp.getRow(rowIndex).getCell(entriesPKName).getValue().toString());
                }
                if (idList.contains(cell.getValue())) continue;
                idList.add(cell.getValue());
            }
            if (idList.size() == 0) {
                return new CoreBillBaseCollection();
            }
            if (idList.size() == 1) {
                String id = idList.get(0).toString();
                CoreBillBaseInfo sourceBillInfo = (CoreBillBaseInfo)coreBase.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
                sourceBillCollection.add(sourceBillInfo);
                if (entriesKey.size() > 0) {
                    this.removeUnSelect(entriesKey, sourceBillCollection);
                }
                return sourceBillCollection;
            }
            Object[] filterObj = new Object[idList.size()];
            FilterInfo filterInfo = new FilterInfo();
            Iterator idIter = idList.iterator();
            int index = 0;
            StringBuffer sbMaskString = new StringBuffer();
            while (idIter.hasNext()) {
                String id = idIter.next().toString();
                filterObj[index] = id;
                ++index;
            }
            String strIdLists = StringUtils.arrayToString((Object[])idList.toArray(), (String)",");
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
            sbMaskString.append("#0");
            filterInfo.setMaskString(sbMaskString.toString());
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(filterInfo);
            CoreBillBaseCollection sourceBillCollection = ((ICoreBillBase)coreBase).getCoreBillBaseCollection(entityViewInfo);
            if (entriesKey.size() > 0) {
                this.removeUnSelect(entriesKey, sourceBillCollection);
            }
            return sourceBillCollection;
        }
        String entriesPKName = billListUI.getEntriesPKName();
        for (int rowIndex = 0; rowIndex <= tabletmp.getRowCount() - 1; ++rowIndex) {
            ICell cell = tabletmp.getRow(rowIndex).getCell(billPKName);
            if (tabletmp.getRow(rowIndex).getCell(entriesPKName) != null && tabletmp.getRow(rowIndex).getCell(entriesPKName).getValue() != null) {
                entriesKey.add(tabletmp.getRow(rowIndex).getCell(entriesPKName).getValue().toString());
            }
            if (idList.contains(cell.getValue())) continue;
            String tmpID = (String)cell.getValue();
            try {
                BOSUuid idIter = BOSUuid.read((String)tmpID);
            }
            catch (Exception e) {
                throw new BOSException(e.getMessage() + ", billListUI=" + billListUI + ", billPKName=" + billPKName + ", entriesPKName=" + entriesPKName, (Throwable)e);
            }
            idList.add(tmpID);
        }
        if (idList.size() == 0) {
            return new CoreBillBaseCollection();
        }
        if (idList.size() == 1) {
            String id = idList.get(0).toString();
            CoreBillBaseInfo sourceBillInfo = billListUI.getBOTPSelectors() == null ? (CoreBillBaseInfo)billListUI.getBillInterface().getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id))) : (CoreBillBaseInfo)billListUI.getBillInterface().getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), billListUI.getBOTPSelectors());
            CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
            sourceBillCollection.add(sourceBillInfo);
            if (entriesKey.size() > 0) {
                this.removeUnSelect(entriesKey, sourceBillCollection);
            }
            return sourceBillCollection;
        }
        Object[] filterObj = new Object[idList.size()];
        FilterInfo filterInfo = new FilterInfo();
        Iterator idIter = idList.iterator();
        int index = 0;
        StringBuffer sbMaskString = new StringBuffer();
        while (idIter.hasNext()) {
            String id = idIter.next().toString();
            filterObj[index] = id;
            ++index;
        }
        String strIdLists = StringUtils.arrayToString((Object[])idList.toArray(), (String)",");
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        sbMaskString.append("#0");
        filterInfo.setMaskString(sbMaskString.toString());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        if (billListUI.getBOTPSelectors() != null) {
            entityViewInfo.put("selector", (Object)billListUI.getBOTPSelectors());
        }
        CoreBillBaseCollection sourceBillCollection = ((ICoreBillBase)billListUI.getBillInterface()).getCoreBillBaseCollection(entityViewInfo);
        if (entriesKey.size() > 0) {
            this.removeUnSelect(entriesKey, sourceBillCollection);
        }
        return sourceBillCollection;
    }

    private void removeUnSelect(List entriesKey, CoreBillBaseCollection sourceBillCollection) {
        CoreBillListUI billListUI = this.currentBillListUI;
        for (int i = 0; i < sourceBillCollection.size(); ++i) {
            CoreBillBaseInfo bills = sourceBillCollection.get(i);
            boolean isHasSelect = false;
            IObjectCollection entries = (IObjectCollection)bills.get(billListUI.getEntriesName());
            if (entries == null) {
                return;
            }
            Iterator iters = entries.iterator();
            while (iters.hasNext()) {
                CoreBaseInfo cInfo = (CoreBaseInfo)iters.next();
                isHasSelect = false;
                for (int k = 0; k < entriesKey.size(); ++k) {
                    if (!cInfo.get("id").toString().equals(entriesKey.get(k).toString())) continue;
                    isHasSelect = true;
                    break;
                }
                if (isHasSelect) continue;
                iters.remove();
            }
        }
    }

    private void copySelectedRowDataAdd() throws Exception {
        CoreBillListUI billListUI = this.currentBillListUI;
        KDTable tabletmp = billListUI.getTableForBOTP();
        int[] selectRows = this.getSelectedRows(tabletmp, billListUI);
        int[] colIndex = this.recordColumnIndex(billListUI);
        for (int i = 0; i < selectRows.length; ++i) {
            IRow row = tabletmp.getRow(selectRows[i]);
            IRow rowkDTable1 = this.kDTable1.addRow();
            this.copyRow(row, rowkDTable1, colIndex);
        }
        this.bottomTableRowChanged(billListUI);
        ArrayList idlist = new ArrayList();
        ArrayList entriesIdList = new ArrayList();
        String billPK = billListUI.getKeyFieldNameForWF();
        if (billPK.equals("entry.billID")) {
            billPK = "id";
        }
        this.getBillIdList(this.kDTable1, idlist, entriesIdList, billPK, billListUI.getEntriesPKName());
        this.billIds = idlist.size() > 0 ? StringUtils.arrayToString((Object[])idlist.toArray(), (String)",") : "";
        if (entriesIdList.size() > 0) {
            this.entryids = StringUtils.arrayToString((Object[])entriesIdList.toArray(), (String)",");
        }
        if (entriesIdList.size() == 0) {
            this.entryids = null;
        }
        this.appendFootRow(billListUI);
    }

    private void bottomTableRowChanged(CoreBillListUI billListUI) {
        IRow row;
        String billPK = billListUI.getKeyFieldNameForWF();
        if (billPK.equals("entry.billID")) {
            billPK = "id";
        }
        final String billPKName = billPK;
        ArrayList<IRow> rows = new ArrayList<IRow>();
        int bottom = this.kDTable1.getRowCount() - 1;
        for (int rowIndex = 0; rowIndex <= bottom; ++rowIndex) {
            row = this.kDTable1.getRow(rowIndex);
            rows.add(row);
        }
        class BillIdComparator
        implements Comparator {
            BillIdComparator() {
            }

            public int compare(Object o1, Object o2) {
                IRow row1 = (IRow)o1;
                IRow row2 = (IRow)o2;
                ICell cell1 = row1.getCell(billPKName);
                ICell cell2 = row2.getCell(billPKName);
                String id1 = cell1.getValue().toString();
                String id2 = cell2.getValue().toString();
                return id1.compareTo(id2);
            }
        }
        Collections.sort(rows, new BillIdComparator());
        this.kDTable1.removeRows();
        if (rows.size() > 0) {
            for (int i = 0; i < rows.size(); ++i) {
                row = (IRow)rows.get(i);
                IRow rowkDTable1 = this.kDTable1.addRow();
                this.copyRow(row, rowkDTable1);
            }
        }
        this.kDTable1.getMergeManager().setMergeMode(5);
        String[] mergeColumnKeys = billListUI.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.kDTable1.getGroupManager().setGroup(true);
            this.kDTable1.getGroupManager().group();
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                if (this.kDTable1.getColumn(mergeColumnKeys[i]) == null) continue;
                this.kDTable1.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.kDTable1.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    private boolean notInThis(int index, int[] range) {
        for (int i = 0; i < range.length; ++i) {
            if (index != range[i]) continue;
            return false;
        }
        return true;
    }

    private void copySelectedRowDataDel() throws Exception {
        IRow row;
        CoreBillListUI billListUI = this.currentBillListUI;
        if (this.kDTable1.getRowCount() == 0 || this.kDTable1.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        int[] selectRows = this.getSelectedRows(this.kDTable1, billListUI);
        ArrayList<IRow> rows = new ArrayList<IRow>();
        int bottom = this.kDTable1.getRowCount() - 1;
        for (int rowIndex = 0; rowIndex <= bottom; ++rowIndex) {
            if (!this.notInThis(rowIndex, selectRows)) continue;
            row = this.kDTable1.getRow(rowIndex);
            rows.add(row);
        }
        this.kDTable1.removeRows(false);
        if (rows.size() > 0) {
            for (int i = 0; i < rows.size(); ++i) {
                row = (IRow)rows.get(i);
                IRow rowkDTable1 = this.kDTable1.addRow();
                this.copyRow(row, rowkDTable1);
            }
        }
        this.bottomTableRowChanged(billListUI);
        ArrayList idlist = new ArrayList();
        ArrayList entriesIdList = new ArrayList();
        String billPK = billListUI.getKeyFieldNameForWF();
        if (billPK.equals("entry.billID")) {
            billPK = "id";
        }
        this.getBillIdList(this.kDTable1, idlist, entriesIdList, billPK, billListUI.getEntriesPKName());
        this.billIds = idlist.size() > 0 ? StringUtils.arrayToString((Object[])idlist.toArray(), (String)",") : "";
        if (entriesIdList.size() > 0) {
            this.entryids = StringUtils.arrayToString((Object[])entriesIdList.toArray(), (String)",");
        }
        if (entriesIdList.size() == 0) {
            this.entryids = null;
        }
        this.appendFootRow(billListUI);
    }

    private int[] recordColumnIndex(CoreBillListUI billListUI) {
        KDTable tabletmp = billListUI.getTableForBOTP();
        int colCount = tabletmp.getColumnCount();
        int[] columnIndex = new int[colCount];
        for (int n = 0; n < colCount; ++n) {
            int colIndex;
            String key = tabletmp.getColumnKey(n);
            columnIndex[n] = colIndex = this.kDTable1.getColumnIndex(key);
        }
        return columnIndex;
    }

    private void copyRow(IRow row, IRow rowkDTable1) {
        int colCount = this.kDTable1.getColumnCount();
        for (int n = 0; n < colCount; ++n) {
            Object cellValue = row.getCell(n).getValue();
            rowkDTable1.getCell(n).setValue(cellValue);
            rowkDTable1.getCell(n).setStyleAttributes(row.getCell(n).getStyleAttributes());
        }
        logger.debug((Object)("colCount=" + colCount));
    }

    private void copyRow(IRow row, IRow rowkDTable1, int[] colIndex) {
        KDTable tabletmp = this.currentBillListUI.getTableForBOTP();
        int colCount = this.kDTable1.getColumnCount();
        for (int n = 0; n < colCount; ++n) {
            String key = tabletmp.getColumnKey(n);
            Object cellValue = row.getCell(key).getValue();
            rowkDTable1.getCell(colIndex[n]).setValue(cellValue);
            rowkDTable1.getCell(colIndex[n]).setStyleAttributes(row.getCell(colIndex[n]).getStyleAttributes());
        }
    }

    private void copyTable(CoreBillListUI billListUI) {
        KDTable tabletmp = billListUI.getTableForBOTP();
        this.consKDtableHeader(tabletmp);
        this.copyHeaderValue(tabletmp);
    }

    private void consKDtableHeader(KDTable tabletmp) {
        int columnCount = tabletmp.getColumnCount();
        this.kDTable1.checkParsed();
        this.kDTable1.getGroupManager().setGroup(true);
        String str = "";
        for (int i = 0; i < columnCount; ++i) {
            IColumn columnTmp = tabletmp.getColumn(i);
            str = columnTmp.getKey();
            IColumn colTMp = this.kDTable1.addColumn();
            colTMp.setKey(str);
            colTMp.getStyleAttributes().setHided(columnTmp.getStyleAttributes().isHided());
            colTMp.setGroup(columnTmp.isGroup());
            colTMp.setMergeable(columnTmp.isMergeable());
        }
    }

    private void copyHeaderValue(KDTable tabletmp) {
        IRow headRowTable1 = this.kDTable1.addHeadRow();
        IRow headRowtabletmp = tabletmp.getHeadRow(0);
        int columnCount = tabletmp.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            ICell cellTmp = headRowtabletmp.getCell(i);
            headRowTable1.getCell(i).setValue(cellTmp.getValue());
            headRowTable1.getCell(i).setStyleAttributes(cellTmp.getStyleAttributes());
        }
    }

    private void appendFootRow(CoreBillListUI billListUI) {
        HashMap<String, String> columnMap = new HashMap<String, String>();
        List fieldInfos = billListUI.getFieldSumList();
        if (fieldInfos != null && fieldInfos.size() > 0) {
            for (String field : fieldInfos) {
                BigDecimal dbSum = new BigDecimal("0");
                String key = this.queryNameToKDTableName(billListUI.getTableForBOTP(), field);
                String[] mergeStr = billListUI.getMergeColumnKeys();
                boolean isMergeStr = false;
                if (mergeStr != null) {
                    for (int kk = 0; kk < mergeStr.length; ++kk) {
                        if (!key.equals(mergeStr[kk])) continue;
                        isMergeStr = true;
                        break;
                    }
                }
                HashSet<String> idsSet = new HashSet<String>();
                for (int r = 0; r <= this.kDTable1.getRowCount() - 1; ++r) {
                    String cellValue;
                    ICell cell = this.kDTable1.getRow(r).getCell(key);
                    if (cell == null) continue;
                    if (isMergeStr) {
                        String billID = this.kDTable1.getCellDisplayText(this.kDTable1.getRow(r).getCell("id"));
                        if (idsSet.contains(billID)) continue;
                        idsSet.add(billID);
                    }
                    if ((cellValue = this.kDTable1.getCellDisplayText(cell)) != null) {
                        cellValue = cellValue.toString().replaceAll(",", "");
                    }
                    if (!StringUtility.isNumber((String)cellValue)) {
                        Object cellObj = cell.getValue();
                        if (cellObj != null) {
                            cellValue = cellObj.toString();
                        }
                        if (!StringUtility.isNumber((String)cellValue)) continue;
                    }
                    BigDecimal bigdem = new BigDecimal(String.valueOf(cellValue).trim());
                    dbSum = dbSum.add(bigdem);
                }
                String strSum = dbSum.toString();
                columnMap.put(key, strSum);
            }
            IRow footRow = null;
            KDTFootManager footRowManager = this.kDTable1.getFootManager();
            if (footRowManager == null) {
                footRowManager = new KDTFootManager(this.kDTable1);
                footRowManager.addFootView();
                this.kDTable1.setFootManager(footRowManager);
            }
            if ((footRow = footRowManager.getFootRow(0)) == null) {
                footRow = footRowManager.addFootRow(0);
            }
            String colFormat = "%{0.##########}f";
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            this.kDTable1.getIndexColumn().setWidthAdjustMode((short)1);
            this.kDTable1.getIndexColumn().setWidth(30);
            footRowManager.addIndexText(0, total);
            footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
            for (Map.Entry colEntry : columnMap.entrySet()) {
                if (colEntry.getKey() == null) continue;
                String strColName = String.valueOf(colEntry.getKey());
                String strColValue = (String)colEntry.getValue();
                if (footRow.getCell(strColName) == null) continue;
                footRow.getCell(strColName).setValue((Object)strColValue);
                footRow.getCell(strColName).getStyleAttributes().setNumberFormat(colFormat);
                footRow.getCell(strColName).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                footRow.getCell(strColName).getStyleAttributes().setFontColor(Color.BLACK);
            }
        }
    }

    public boolean isNoEntries() {
        return this.noEntries;
    }

    public void setNoEntries(boolean noEntries) {
        this.noEntries = noEntries;
    }

    public IUIObject getCurrentBillListUI() {
        return this.currentBillListUI;
    }

    public boolean isHasFinished() {
        return this.hasFinished;
    }

    public void setHasFinished(boolean hasFinished) {
        this.hasFinished = hasFinished;
    }

    public BOTMappingInfo getCurMappingInfo() {
        return this.curMappingInfo;
    }

    public String getEntityDisplayName() {
        return this.entityDisplayName;
    }
}

