/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.dap.client.AbstractKAccountItemDialog;
import com.kingdee.eas.basedata.assistant.IKAccountItem;
import com.kingdee.eas.basedata.assistant.KAccountItemCollection;
import com.kingdee.eas.basedata.assistant.KAccountItemFactory;
import com.kingdee.eas.basedata.assistant.KAccountItemInfo;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class KAccountItemDialog
extends AbstractKAccountItemDialog {
    private static final Logger logger = CoreUIObject.getLogger(KAccountItemDialog.class);
    private String kaccountItemNumber = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionConfirm.setEnabled(true);
        this.actionCancel.setEnabled(true);
        this.kdtAccountItem.getSelectManager().setSelectMode(2);
        this.kdtAccountItem.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    KAccountItemDialog.this.kdtAccountItem_tableClicked(e);
                }
                catch (Exception exc) {
                    KAccountItemDialog.this.handUIException(exc);
                }
            }
        });
        this.kdtAccountItem.checkParsed();
    }

    protected void kdtAccountItem_tableClicked(KDTMouseEvent e) {
        if (e.getClickCount() == 2) {
            this.confirmKaccountItemNumber();
        }
    }

    private void confirmKaccountItemNumber() {
        KDTSelectBlock selectBlock = this.kdtAccountItem.getSelectManager().get();
        if (selectBlock != null) {
            int topIndex = selectBlock.getTop();
            IRow row = this.kdtAccountItem.getRow(topIndex);
            this.setKaccountItemNumber(row.getCell("number").getValue().toString());
            this.getUIWindow().close();
        }
    }

    public void setObjectTypeId(String objectBosType) {
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.getSelector().add(new SelectorItemInfo("id"));
        entityView.getSelector().add(new SelectorItemInfo("number"));
        entityView.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("objectType.objectTypeID", (Object)objectBosType));
        entityView.setFilter(filter);
        try {
            IKAccountItem kai = KAccountItemFactory.getRemoteInstance();
            KAccountItemCollection kaiCol = kai.getKAccountItemCollection(entityView);
            for (KAccountItemInfo kaiInfo : kaiCol) {
                IRow row = this.kdtAccountItem.addRow();
                ICell cellId = row.getCell("id");
                cellId.setValue((Object)kaiInfo.getId().toString());
                ICell cellNumber = row.getCell("number");
                cellNumber.setValue((Object)kaiInfo.getNumber());
                ICell cellName = row.getCell("alias");
                cellName.setValue((Object)kaiInfo.getName());
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
            this.handUIException(e);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.confirmKaccountItemNumber();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setKaccountItemNumber(null);
        this.getUIWindow().close();
    }

    public String getKaccountItemNumber() {
        return this.kaccountItemNumber;
    }

    public void setKaccountItemNumber(String kaccountItemNumber) {
        this.kaccountItemNumber = kaccountItemNumber;
    }
}

