/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.fme.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.fme.appext.FMEServerFactory;
import com.kingdee.eas.base.fme.appext.IConsoleServer;
import com.kingdee.eas.base.fme.bo.DocumentBO;
import com.kingdee.eas.base.fme.dao.FMEDaoFactory;
import com.kingdee.eas.base.fme.dao.IFMEDao;
import com.kingdee.eas.base.fme.ftp.FMEFtpFactory;
import com.kingdee.eas.base.fme.ftp.FtpConfig;
import com.kingdee.eas.base.fme.ftp.IFMEFtp;
import com.kingdee.eas.base.fme.getResult.ComparatorByOperDateStr;
import com.kingdee.eas.base.fme.model.CategoryMap;
import com.kingdee.eas.base.fme.model.OperLog;
import com.kingdee.eas.base.fme.model.SavePath;
import com.kingdee.eas.base.fme.service.FtpDocumentInfo;
import com.kingdee.eas.base.fme.service.GCDocumentInfo;
import com.kingdee.eas.base.fme.service.IFMEConsoleService;
import com.kingdee.eas.base.fme.service.WebFMEServiceImpl;
import com.kingdee.eas.base.fme.util.FMEUIUtils;
import com.kingdee.eas.base.fme.util.FMEUtils;
import java.net.ConnectException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FMEConsoleServiceImpl
implements IFMEConsoleService {
    protected IFMEDao dao;
    protected IFMEFtp ftp;
    protected IConsoleServer consoleServer;
    private static final Log log = LogFactory.getLog(WebFMEServiceImpl.class);
    private Context ctx = null;

    public FMEConsoleServiceImpl(Context ctx) {
        if (log.isInfoEnabled()) {
            log.info((Object)"\u521b\u5efaWeb FMEConsoleServiceImpl");
        }
        this.ctx = ctx;
        this.initServiceInterface();
    }

    public void initServiceInterface() {
        if (log.isInfoEnabled()) {
            log.info((Object)("\u521b\u5efa\u7684Context is======================================:" + this.ctx));
        }
        this.dao = FMEDaoFactory.getFMEDaoInstance(this.ctx);
        this.ftp = FMEFtpFactory.getFMEFtpInstance(this.dao);
        this.consoleServer = FMEServerFactory.getConsoleServerInstance(this.ctx);
    }

    public FMEConsoleServiceImpl() {
    }

    @Override
    public List getAvailablePathList() throws BOSException {
        ArrayList pathList = new ArrayList();
        try {
            List savePathList = this.dao.querySavePath();
            for (int i = 0; i < savePathList.size(); ++i) {
                SavePath oneSavePath = (SavePath)savePathList.get(i);
                HashMap<String, String> oneMap = new HashMap<String, String>();
                oneMap.put("pathID", oneSavePath.getPathID());
                oneMap.put("pathName", oneSavePath.getPathDisplayName());
                pathList.add(oneMap);
            }
        }
        catch (Exception sex) {
            System.out.println("getAvailablePathList\u629b\u51fa\u5f02\u5e38\uff1a" + sex.getMessage());
            throw new BOSException("getAvailablePathList\u629b\u51fa\u5f02\u5e38\uff1a" + sex.getMessage(), (Throwable)sex);
        }
        return pathList;
    }

    @Override
    public String[] checkFtpLinksByServerID(String serverID) throws BOSException {
        String[] checkResultArray = new String[]{"1", ""};
        try {
            FtpConfig oneConfig = this.dao.queryFtpServerByServerID(serverID);
            IFMEFtp ftp = FMEFtpFactory.getFMEFtpInstanceWithFtpConfig(oneConfig);
            List checkResult = ftp.checkFtpLink();
            boolean checkBool = (Boolean)checkResult.get(0);
            String checkInfo = checkResult.get(1).toString();
            if (checkBool) {
                checkResultArray[0] = "0";
            } else {
                checkResultArray[0] = "1";
                checkResultArray[1] = checkInfo;
            }
        }
        catch (Exception sex) {
            System.out.println("getAvailablePathList\u629b\u51fa\u5f02\u5e38\uff1a" + sex.getMessage());
            checkResultArray[0] = "1";
            checkResultArray[1] = sex.getMessage();
        }
        return checkResultArray;
    }

    @Override
    public String[] checkFtpLinks(String pathID) throws BOSException {
        String[] checkResultArray = new String[]{"1", ""};
        try {
            SavePath sp = this.dao.querySavePathByPathID(pathID);
            String serverID = sp.getServerID();
            checkResultArray = this.checkFtpLinksByServerID(serverID);
        }
        catch (Exception sex) {
            System.out.println("checkFtpLinks\u629b\u51fa\u5f02\u5e38\uff1a" + sex.getMessage());
            checkResultArray[0] = "1";
            checkResultArray[1] = sex.getMessage();
        }
        return checkResultArray;
    }

    @Override
    public List getBusinessDocumentInfo(String busiID) throws BOSException {
        ArrayList documentInfo = new ArrayList();
        try {
            DocumentBO[] documentArray = this.dao.query(busiID);
            if (documentArray != null) {
                Arrays.sort(documentArray, new ComparatorByOperDateStr());
                for (int i = 0; i < documentArray.length; ++i) {
                    HashMap<String, Object> docMap = new HashMap<String, Object>();
                    docMap.put("docId", documentArray[i].getDocumentID());
                    String documentName = documentArray[i].getDisplayName();
                    String documentExtName = FMEUtils.getFileExtName(documentName);
                    docMap.put("docName", documentName);
                    docMap.put("extName", documentExtName);
                    docMap.put("docSize", new Integer(documentArray[i].getSize()));
                    documentInfo.add(docMap);
                }
            } else if (log.isWarnEnabled()) {
                log.warn((Object)("getBusinessDocumentInfo \u4f20\u5165\u7684:" + busiID + " \u6ca1\u6709\u76f8\u5e94\u7684\u8bb0\u5f55"));
            }
        }
        catch (Exception queryEx) {
            System.out.println("getBusinessDocumentInfo\u629b\u51fa\u5f02\u5e38\uff1a" + queryEx.getMessage());
            throw new BOSException("getBusinessDocumentInfo\u629b\u51fa\u5f02\u5e38\uff1a" + queryEx.getMessage(), (Throwable)queryEx);
        }
        return documentInfo;
    }

    @Override
    public List getDocumentDownloadInfo(String busiID) throws BOSException {
        ArrayList documentDownloadInfo = new ArrayList();
        try {
            DocumentBO[] documentArray = this.dao.query(busiID);
            for (int i = 0; i < documentArray.length; ++i) {
                HashMap<String, Object> oneDMap = new HashMap<String, Object>();
                String documentID = documentArray[i].getDocumentID();
                List operLogList = this.dao.queryOperLog(documentID, 1);
                ArrayList<String> downloadUserList = new ArrayList<String>();
                ArrayList<Date> downloadTimeList = new ArrayList<Date>();
                int downloadAcount = 0;
                for (int j = 0; j < operLogList.size(); ++j) {
                    OperLog oneOper = (OperLog)operLogList.get(j);
                    downloadUserList.add(oneOper.getStaffID());
                    downloadTimeList.add(oneOper.getOperDate());
                    ++downloadAcount;
                }
                oneDMap.put("documentID", documentID);
                oneDMap.put("downloadAcount", new Integer(downloadAcount));
                oneDMap.put("downloadUser", downloadUserList);
                oneDMap.put("downloadTime", downloadTimeList);
                documentDownloadInfo.add(oneDMap);
            }
        }
        catch (Exception queryEx) {
            System.out.println("getDocumentDownloadInfo\uff1a" + queryEx.getMessage());
            throw new BOSException("getDocumentDownloadInfo\uff1a" + queryEx.getMessage(), (Throwable)queryEx);
        }
        return documentDownloadInfo;
    }

    public static Date getDateByString(String tempDate) {
        return Calendar.getInstance().getTime();
    }

    @Override
    public String[] moveBusinessCategoryFile(String[] moveBusiIDs, String sourcePathID, String sourceCategoryInfo, String targetPathID, String targetCategoryInfo) throws BOSException {
        String[] moveResult = new String[]{"1", ""};
        try {
            List categoryMap = this.dao.queryCategoryMapByBusiCID(targetCategoryInfo);
            CategoryMap oneCategoryMap = (CategoryMap)categoryMap.get(0);
            String fcID = oneCategoryMap.getFCID();
            for (int i = 0; i < moveBusiIDs.length; ++i) {
                String oneBusiID = moveBusiIDs[i];
                DocumentBO[] documentArray = this.dao.query(oneBusiID);
                for (int j = 0; j < documentArray.length; ++j) {
                    documentArray[j].setTypeID(fcID);
                }
                String[] stringArray = this.dao.updateDocumentTypeID(documentArray);
            }
            moveResult[0] = "0";
        }
        catch (Exception ext) {
            System.out.println("moveBusinessCategoryFile\u629b\u51fa\u5f02\u5e38\uff1a" + ext.getMessage());
            moveResult[0] = "1";
            moveResult[1] = ext.getMessage();
        }
        return moveResult;
    }

    @Override
    public String[] moveBusinessCategoryFileBySameServer(String[] moveBusiIDs, String sourcePathID, String sourceCategoryInfo, String targetPathID, String targetCategoryInfo) throws BOSException {
        String[] moveResult = new String[]{"1", ""};
        try {
            List categoryMap = this.dao.queryCategoryMapByBusiCID(targetCategoryInfo);
            CategoryMap oneCategoryMap = (CategoryMap)categoryMap.get(0);
            String fcID = oneCategoryMap.getFCID();
            String ROOT_DIR = "/";
            String oldName = null;
            String newName = null;
            String newPath = this.dao.getSavePathServerCategoryInfo(targetPathID, targetCategoryInfo)[0];
            this.ftp.createSavePath(ROOT_DIR, newPath);
            this.ftp.connect();
            for (int i = 0; i < moveBusiIDs.length; ++i) {
                String oneBusiID = moveBusiIDs[i];
                DocumentBO[] documentArray = this.dao.query(oneBusiID);
                for (int j = 0; j < documentArray.length; ++j) {
                    documentArray[j].setTypeID(fcID);
                    oldName = documentArray[j].getPath() + documentArray[j].getName();
                    newName = newPath + documentArray[j].getName();
                    documentArray[j].setPath(newPath);
                    this.ftp.changeDir(ROOT_DIR);
                    this.ftp.rename(oldName, newName);
                }
                String[] stringArray = this.dao.updateDocumentTypeIDBySameServer(documentArray);
            }
            this.ftp.disconnect();
            moveResult[0] = "0";
        }
        catch (Exception ext) {
            System.out.println("moveBusinessCategoryFile\u629b\u51fa\u5f02\u5e38\uff1a" + ext.getMessage());
            moveResult[0] = "1";
            moveResult[1] = ext.getMessage();
        }
        return moveResult;
    }

    @Override
    public String[] moveBusinessCategory(String sourcePathID, String sourceCategoryInfo, String targetPathID, String targetCategoryInfo) throws BOSException {
        String[] moveResult = new String[]{"1", ""};
        try {
            boolean moveBoolResult = this.consoleServer.moveBusinessCategory(sourcePathID, sourceCategoryInfo, targetPathID, targetCategoryInfo);
            if (moveBoolResult) {
                moveResult[0] = "0";
            } else {
                moveResult[0] = "1";
                moveResult[1] = "\u79fb\u52a8\u680f\u76ee\u629b\u51fa\u5f02\u5e38\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002";
            }
        }
        catch (Exception ext) {
            System.out.println("moveBusinessCategoryFile\u629b\u51fa\u5f02\u5e38\uff1a" + ext.getMessage());
            moveResult[0] = "1";
            moveResult[1] = ext.getMessage();
        }
        return moveResult;
    }

    private boolean repairFtpRootPath(String sourceFtpID, String targetFtpID, String sourceFtpRootPath, String targetFtpRootPath) throws BOSException {
        boolean repairResult = false;
        boolean repairInOnFtp = true;
        try {
            repairInOnFtp = FMEUIUtils.isBlankString(targetFtpID) || sourceFtpID.equals(targetFtpID);
            FtpConfig config = this.dao.queryFtpServerByServerID(sourceFtpID);
            IFMEFtp ftp = FMEFtpFactory.getFMEFtpInstanceWithFtpConfig(config);
            System.out.println("repairOneFtpRootPath=============sourceFtpID=:" + sourceFtpID + "-targetFtpID:" + targetFtpID + "--sourceFtpRootPath:" + sourceFtpRootPath + "---targetFtpRootPath:" + targetFtpRootPath);
            if (repairInOnFtp) {
                boolean renameRootPath = ftp.renameRootPath(sourceFtpRootPath, targetFtpRootPath);
                if (renameRootPath) {
                    boolean updateDocRootPath = this.consoleServer.updateFMEDocumentRootPath(sourceFtpID, targetFtpID, sourceFtpRootPath, targetFtpRootPath);
                    if (updateDocRootPath) {
                        repairResult = true;
                    } else {
                        renameRootPath = ftp.renameRootPath(targetFtpRootPath, sourceFtpRootPath);
                    }
                }
            } else {
                boolean updateDocRootPath = this.consoleServer.updateFMEDocumentRootPath(sourceFtpID, targetFtpID, sourceFtpRootPath, targetFtpRootPath);
                if (updateDocRootPath) {
                    repairResult = true;
                }
            }
        }
        catch (Exception ext) {
            System.out.println("repairOneFtpRootPath \u629b\u51fa\u5f02\u5e38\uff1a" + ext.getMessage());
            if (repairInOnFtp) {
                this.ftp.renameRootPath(targetFtpRootPath, sourceFtpRootPath);
            }
            repairResult = false;
            throw new BOSException("repairOneFtpRootPath \u629b\u51fa\u5f02\u5e38\uff1a" + ext.getMessage(), (Throwable)ext);
        }
        return repairResult;
    }

    @Override
    public boolean repairOneFtpRootPath(String sourceFtpID, String sourceFtpRootPath, String targetFtpRootPath) throws BOSException {
        return this.repairFtpRootPath(sourceFtpID, null, sourceFtpRootPath, targetFtpRootPath);
    }

    private boolean repairFtpSavePath(String sourceFtpID, String targetFtpID, String sourcePathID, String targetPathID) throws BOSException {
        boolean repairResult = false;
        try {
            repairResult = this.consoleServer.updateDocumentPathName(sourceFtpID, targetFtpID, sourcePathID, targetPathID);
            repairResult = true;
        }
        catch (Exception ext) {
            System.out.println("repairOneFtpSavePath \u629b\u51fa\u5f02\u5e38\uff1a" + ext.getMessage());
            repairResult = false;
            throw new BOSException("repairOneFtpSavePath \u629b\u51fa\u5f02\u5e38\uff1a" + ext.getMessage(), (Throwable)ext);
        }
        return repairResult;
    }

    @Override
    public boolean repairOneFtpSavePath(String sourceFtpID, String sourcePathID, String targetPathID) throws BOSException {
        return this.repairFtpSavePath(sourceFtpID, null, sourcePathID, targetPathID);
    }

    private boolean repairFileCategory(String sourceFtpID, String targetFtpID, String sourceCategoryID, String targetCategoryID) throws BOSException {
        boolean repairResult = false;
        try {
            repairResult = this.consoleServer.updateDocumentFileCategory(sourceFtpID, targetFtpID, sourceCategoryID, targetCategoryID);
            repairResult = true;
        }
        catch (Exception ext) {
            System.out.println("updateDocumentFileCategory \u629b\u51fa\u5f02\u5e38\uff1a" + ext.getMessage());
            repairResult = false;
            throw new BOSException("updateDocumentFileCategory \u629b\u51fa\u5f02\u5e38\uff1a" + ext.getMessage(), (Throwable)ext);
        }
        return repairResult;
    }

    @Override
    public boolean repairOneFtpFileCategory(String sourceFtpID, String sourceCategoryID, String targetCategoryID) throws BOSException {
        return this.repairFileCategory(sourceFtpID, null, sourceCategoryID, targetCategoryID);
    }

    @Override
    public boolean repairOneFtpSingleDocument(String sourceFtpID, String sourceDocumentID, String targetDocumentSavePathID, String targetDocumentCategoryID) throws BOSException {
        boolean repairResult = false;
        try {
            String targetFtpFileName;
            boolean transfefDocResult;
            FtpConfig config = this.dao.queryFtpServerByServerID(sourceFtpID);
            IFMEFtp ftp = FMEFtpFactory.getFMEFtpInstanceWithFtpConfig(config);
            System.out.println("repairOneFtpSingleDocument==============:" + sourceFtpID + "---sourceDocumentID:" + sourceDocumentID + "---targetDocumentSavePathID:" + targetDocumentSavePathID + "--targetDocumentCategoryID:" + targetDocumentCategoryID);
            String[] docPathInfo = this.consoleServer.getDocumentPath(sourceDocumentID);
            String sourceFtpPath = docPathInfo[0];
            String sourceFtpFileName = docPathInfo[0] + docPathInfo[1];
            String targetFtpPath = config.getRootPath() + "/" + this.consoleServer.getCategorySavePathDir(targetDocumentCategoryID);
            if (!targetFtpPath.endsWith("/")) {
                targetFtpPath = targetFtpPath + "/";
            }
            if (transfefDocResult = ftp.transferOneDocument(sourceFtpFileName, targetFtpFileName = targetFtpPath + docPathInfo[1])) {
                boolean updateDocRootPath = this.consoleServer.updateOneDocumentPath(sourceFtpID, null, sourceFtpPath, targetFtpPath, sourceDocumentID);
                if (updateDocRootPath) {
                    repairResult = true;
                    ftp.delete(sourceFtpPath);
                } else {
                    repairResult = false;
                    System.out.println("\u79fb\u52a8\u5355\u4e2a\u6587\u4ef6\u540e\uff0c\u66f4\u65b0\u6587\u4ef6\u5b58\u50a8\u8def\u5f84\u5931\u8d25\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
                }
            }
        }
        catch (Exception ext) {
            System.out.println("repairOneFtpSingleDocument \u629b\u51fa\u5f02\u5e38\uff1a" + ext.getMessage());
            repairResult = false;
            throw new BOSException("repairOneFtpSingleDocument \u629b\u51fa\u5f02\u5e38\uff1a" + ext.getMessage(), (Throwable)ext);
        }
        return repairResult;
    }

    @Override
    public boolean repairMultiFtpRootPath(String sourceFtpID, String targetFtpID, String sourceFtpRootPath, String targetFtpRootPath) throws BOSException {
        return this.repairFtpRootPath(sourceFtpID, targetFtpID, sourceFtpRootPath, targetFtpRootPath);
    }

    @Override
    public boolean repairMultiFtpSavePath(String sourceFtpID, String targetFtpID, String sourcePathID, String targetPathID) throws BOSException {
        return this.repairFtpSavePath(sourceFtpID, targetFtpID, sourcePathID, targetPathID);
    }

    @Override
    public boolean repairMultiFtpFileCategory(String sourceFtpID, String targetFtpID, String sourceCategoryID, String targetCategoryID) throws BOSException {
        return this.repairFileCategory(sourceFtpID, targetFtpID, sourceCategoryID, targetCategoryID);
    }

    @Override
    public boolean repairMultiFtpSingleDocument(String sourceFtpID, String targetFtpID, String sourceDocumentID, String targetDocumentSavePathID, String targetDocumentCategoryID) throws BOSException {
        boolean repairResult = false;
        try {
            String targetFtpFileName;
            boolean transfefDocResult;
            FtpConfig config = this.dao.queryFtpServerByServerID(sourceFtpID);
            IFMEFtp ftp = FMEFtpFactory.getFMEFtpInstanceWithFtpConfig(config);
            FtpConfig targetConfig = this.dao.queryFtpServerByServerID(targetFtpID);
            IFMEFtp targetftp = FMEFtpFactory.getFMEFtpInstanceWithFtpConfig(targetConfig);
            System.out.println("repairOneFtpSingleDocument==============sourceFtpID:" + sourceFtpID + "-targetFtpID:" + targetFtpID + "--sourceDocumentID:" + sourceDocumentID + "---targetDocumentSavePathID:" + targetDocumentSavePathID + "--targetDocumentCategoryID:" + targetDocumentCategoryID);
            String[] docPathInfo = this.consoleServer.getDocumentPath(sourceDocumentID);
            String sourceFtpPath = docPathInfo[0];
            String sourceFtpFileName = docPathInfo[0] + docPathInfo[1];
            String targetFtpPath = targetConfig.getRootPath() + "/" + this.consoleServer.getCategorySavePathDir(targetDocumentCategoryID) + "/" + docPathInfo[1];
            if (!targetFtpPath.endsWith("/")) {
                targetFtpPath = targetFtpPath + "/";
            }
            if (transfefDocResult = ftp.transferOneDocumentWithMutilFtp(sourceFtpFileName, targetFtpFileName = targetFtpPath + docPathInfo[1], targetConfig)) {
                boolean updateDocRootPath = this.consoleServer.updateOneDocumentPath(sourceFtpID, targetFtpID, sourceFtpPath, targetFtpPath, sourceDocumentID);
                if (updateDocRootPath) {
                    repairResult = true;
                    targetftp.delete(sourceFtpPath);
                } else {
                    repairResult = false;
                    System.out.println("\u79fb\u52a8\u5355\u4e2a\u6587\u4ef6\u540e\uff0c\u66f4\u65b0\u6587\u4ef6\u5b58\u50a8\u8def\u5f84\u5931\u8d25\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
                }
            }
            targetftp.disconnect();
        }
        catch (Exception ext) {
            System.out.println("repairMultiFtpSingleDocument \u629b\u51fa\u5f02\u5e38\uff1a" + ext.getMessage());
            repairResult = false;
            throw new BOSException("repairMultiFtpSingleDocument \u629b\u51fa\u5f02\u5e38\uff1a" + ext.getMessage(), (Throwable)ext);
        }
        return repairResult;
    }

    @Override
    public String addBusinessDocumentCategory(String busiCategoryID, String parentBCategoryID, String pathID) throws BOSException {
        String newFMECategoryID = "";
        try {
            boolean hasExistCategoryMap = this.consoleServer.existCategoryMap(busiCategoryID, parentBCategoryID, pathID);
            if (hasExistCategoryMap) {
                System.out.println("\u5df2\u7ecf\u5b58\u5728\u4e86\u76f8\u5e94\u7684\u4e1a\u52a1\u5206\u7c7b" + busiCategoryID + "\u6620\u5c04\uff0c\u4e0d\u9700\u8981\u91cd\u73b0\u521b\u5efa\u3002\u3002\u3002");
                newFMECategoryID = "exist CateogryID";
            } else if (FMEUtils.isBlankString(parentBCategoryID)) {
                List insertCategoryResult = this.dao.insertFileCategory(null, busiCategoryID, "0", "", pathID);
                String categoryId = (String)insertCategoryResult.get(0);
                newFMECategoryID = this.dao.insertCategoryMap(busiCategoryID, categoryId, busiCategoryID, 1);
            } else {
                List categoryMapList = this.dao.queryCategoryMapByBusiCID(parentBCategoryID);
                CategoryMap oneMap = (CategoryMap)categoryMapList.get(0);
                int parentLevel = oneMap.getLevel();
                String parentCategoryID = oneMap.getFCID();
                String mapName = oneMap.getMapName();
                String newMapName = mapName + "#/#/" + busiCategoryID;
                List insertCategoryResult = this.dao.insertFileCategory(null, busiCategoryID, "0", parentCategoryID, "");
                String newCategoryID = (String)insertCategoryResult.get(0);
                newFMECategoryID = this.dao.insertCategoryMap(busiCategoryID, newCategoryID, newMapName, parentLevel + 1);
            }
        }
        catch (Exception ext) {
            ext.printStackTrace(System.out);
            throw new BOSException("addBusinessDocumentCategory \u629b\u51fa\u5f02\u5e38\uff1a" + ext.getMessage(), (Throwable)ext);
        }
        return newFMECategoryID;
    }

    @Override
    public boolean deleteBusinessDocumentCategory(String busiCategoryID) throws BOSException {
        boolean deleteResult = false;
        try {
            boolean existDoc = this.consoleServer.existDocumentInCategory(busiCategoryID);
            if (existDoc) {
                deleteResult = false;
                System.out.println("=====================\u4e25\u91cd\u8b66\u544a\uff0c\u8be5\u5206\u7c7b\u4e0b\u5df2\u7ecf\u5177\u6709\u6587\u4ef6\uff0c\u4e0d\u80fd\u591f\u5220\u9664\u8be5\u5206\u7c7b");
            } else {
                deleteResult = this.consoleServer.deleteCategoryMap(busiCategoryID);
            }
        }
        catch (Exception ext) {
            ext.printStackTrace(System.out);
            throw new BOSException("deleteBusinessDocumentCategory \u629b\u51fa\u5f02\u5e38\uff1a" + ext.getMessage(), (Throwable)ext);
        }
        return deleteResult;
    }

    @Override
    public boolean existDocumentInCategory(String busiCategoryId) throws BOSException {
        boolean existDoc = false;
        try {
            existDoc = this.consoleServer.existDocumentInCategory(busiCategoryId);
        }
        catch (Exception ext) {
            System.out.println("existDocumentInCategory\u629b\u51fa\u5f02\u5e38\uff1a" + ext.getMessage());
            throw new BOSException("existDocumentInCategory\u629b\u51fa\u5f02\u5e38 \u629b\u51fa\u5f02\u5e38\uff1a" + ext.getMessage(), (Throwable)ext);
        }
        return existDoc;
    }

    @Override
    public boolean modifyBusinessDocumentCategory(String categoryId, String newParentCID, String newPathID) throws BOSException {
        boolean modifyResult = false;
        try {
            boolean existDoc = this.consoleServer.existDocumentInCategory(categoryId);
            if (existDoc) {
                modifyResult = false;
                System.out.println("=====================\u4e25\u91cd\u8b66\u544a\uff0c\u8be5\u5206\u7c7b\u4e0b\u5df2\u7ecf\u5177\u6709\u6587\u4ef6\uff0c\u4e0d\u80fd\u591f\u79fb\u52a8\u8be5\u5206\u7c7b\u7684\u7236\u8282\u70b9");
            } else {
                modifyResult = this.consoleServer.modifyCategoryMapParentBCID(categoryId, newParentCID, newPathID);
            }
        }
        catch (Exception ext) {
            ext.printStackTrace(System.out);
            throw new BOSException("modifyBusinessDocumentCategory \u629b\u51fa\u5f02\u5e38\uff1a" + ext.getMessage(), (Throwable)ext);
        }
        return modifyResult;
    }

    @Override
    public List analyzeFtpGarbage(String ftpServerID) throws BOSException {
        ArrayList<List> gcFileList = new ArrayList<List>();
        try {
            List type1GCList = this.consoleServer.getGCType1Info(ftpServerID);
            gcFileList.add(type1GCList);
            List type2GCList = this.consoleServer.getGCType2Info(ftpServerID);
            gcFileList.add(type2GCList);
            FtpConfig config = this.dao.queryFtpServerByServerID(ftpServerID);
            IFMEFtp ftp = FMEFtpFactory.getFMEFtpInstanceWithFtpConfig(config);
            String rootPath = config.getRootPath();
            FtpDocumentInfo ftpDocInfo = ftp.getFtpDocumentInfo(ftpServerID, rootPath);
            List type3GCList = this.consoleServer.getGCType3Info(ftpDocInfo);
            gcFileList.add(type3GCList);
        }
        catch (ConnectException e) {
            System.out.println("\u8fde\u63a5FTP\u670d\u52a1\u5668\u5931\u8d25\uff01" + e.getMessage());
            throw new BOSException("\u8fde\u63a5FTP\u670d\u52a1\u5668\u5931\u8d25\uff01");
        }
        catch (Exception ext) {
            System.out.println("\u5206\u6790\u5783\u573e\u4fe1\u606f\uff0c\u629b\u51fa\u5f02\u5e38\uff1a" + ext.getMessage());
            throw new BOSException("\u5206\u6790\u5783\u573e\u4fe1\u606f\u65f6\u629b\u51fa\u5f02\u5e38\uff01", (Throwable)ext);
        }
        return gcFileList;
    }

    @Override
    public List makeGarbageCollection(String ftpServerID) throws BOSException {
        ArrayList<List> gcFileList = new ArrayList<List>();
        try {
            String documentID;
            FtpConfig config = this.dao.queryFtpServerByServerID(ftpServerID);
            IFMEFtp ftp = FMEFtpFactory.getFMEFtpInstanceWithFtpConfig(config);
            List type1GCList = this.consoleServer.getGCType1Info(ftpServerID);
            for (int i = 0; i < type1GCList.size(); ++i) {
                GCDocumentInfo oneGCDoc = (GCDocumentInfo)type1GCList.get(i);
                String ftpFileName = oneGCDoc.getDocumentPath() + oneGCDoc.getDocumentRealName();
                long fileSize = ftp.getFileSize(ftpFileName);
                documentID = oneGCDoc.getDocumentID();
                if (fileSize == oneGCDoc.getDocumentSize()) {
                    this.consoleServer.clearGCType1Info(documentID, 0);
                    continue;
                }
                this.consoleServer.clearGCType1Info(documentID, 1);
            }
            gcFileList.add(type1GCList);
            List type2GCList = this.consoleServer.getGCType2Info(ftpServerID);
            for (int j = 0; j < type2GCList.size(); ++j) {
                GCDocumentInfo oneGCDoc = (GCDocumentInfo)type2GCList.get(j);
                String ftpFileName = oneGCDoc.getDocumentPath() + oneGCDoc.getDocumentRealName();
                boolean deleteStatus = ftp.delete(ftpFileName);
                documentID = oneGCDoc.getDocumentID();
                if (deleteStatus) {
                    this.consoleServer.clearGCType2Info(documentID);
                    continue;
                }
                System.out.println("\u4eceFTP\u670d\u52a1\u5668:" + ftpServerID + "\u6e05\u9664\u5783\u573e\u7c7b\u578b\u4e3a2\u7684\u6587\u4ef6" + ftpFileName + "\u6587\u4ef6\u5931\u8d25");
            }
            gcFileList.add(type2GCList);
            String rootPath = config.getRootPath();
            FtpDocumentInfo ftpDocInfo = ftp.getFtpDocumentInfo(ftpServerID, rootPath);
            List type3GCList = this.consoleServer.getGCType3Info(ftpDocInfo);
            for (int k = 0; k < type3GCList.size(); ++k) {
                GCDocumentInfo oneGCDoc = (GCDocumentInfo)type3GCList.get(k);
                String ftpFileName = oneGCDoc.getDocumentPath() + oneGCDoc.getDocumentRealName();
                System.out.println("\u6e05\u7406GC3\u7c7b\u578b\u6587\u4ef6\uff1a" + ftpFileName);
                try {
                    boolean deleteStatus = ftp.delete(ftpFileName);
                    if (deleteStatus) continue;
                    System.out.println("\u4eceFTP\u670d\u52a1\u5668:" + ftpServerID + "\u6e05\u9664\u5783\u573e\u7c7b\u578b\u4e3a3\u7684\u6587\u4ef6" + ftpFileName + "\u6587\u4ef6\u5931\u8d25");
                    continue;
                }
                catch (Exception ext2) {
                    System.out.println("\u6e05\u7406\u5783\u573e\u6587\u6863" + ftpFileName + "\u629b\u51fa\u5f02\u5e38" + ext2.getMessage());
                }
            }
            gcFileList.add(type3GCList);
        }
        catch (ConnectException e) {
            System.out.println("\u8fde\u63a5FTP\u670d\u52a1\u5668\u5931\u8d25\uff01" + e.getMessage());
            throw new BOSException("\u8fde\u63a5FTP\u670d\u52a1\u5668\u5931\u8d25\uff01");
        }
        catch (Exception ext) {
            System.out.println("makeGarbageCollection\u629b\u51fa\u5f02\u5e38\uff1a" + ext.getMessage());
            throw new BOSException("\u5904\u7406\u5783\u573e\u65f6\u629b\u51fa\u5f02\u5e38\uff01", (Throwable)ext);
        }
        return gcFileList;
    }

    @Override
    public boolean existDocumentInSavePath(String pathID) throws BOSException {
        boolean existDocument = false;
        try {
            existDocument = this.consoleServer.existDocumentInSavePath(pathID);
        }
        catch (Exception ext) {
            throw new BOSException("existDocumentInSavePath \u629b\u51fa\u5f02\u5e38\uff1a" + ext.getMessage(), (Throwable)ext);
        }
        return existDocument;
    }

    @Override
    public boolean dispatchDocument(String oldBusinessId, String[] newBusinessIds) throws BOSException {
        boolean dispatchResult = false;
        try {
            DocumentBO[] docBOS = this.dao.query(oldBusinessId);
            if (null == docBOS) {
                return false;
            }
            int docSize = docBOS == null ? -1 : docBOS.length;
            String[] docIds = new String[docSize];
            String[] docDisplayNames = new String[docSize];
            for (int i = 0; i < docSize; ++i) {
                DocumentBO oneDocBO = docBOS[i];
                docDisplayNames[i] = oneDocBO.getDisplayName();
                docIds[i] = oneDocBO.getDocumentID();
            }
            for (int j = 0; j < newBusinessIds.length; ++j) {
                this.dao.insertBusiDoc(newBusinessIds[j], docIds, docDisplayNames);
            }
            dispatchResult = true;
        }
        catch (Exception ext) {
            throw new BOSException("dispatchDocument throw Exception" + ext.getMessage(), (Throwable)ext);
        }
        return dispatchResult;
    }

    @Override
    public List getTopNumDownloadDocumentInfo(int topNum) throws BOSException, SQLException {
        IConsoleServer server = FMEServerFactory.getConsoleServerInstance(this.ctx);
        return server.getTopNDownloadDocumentInfo(topNum);
    }
}

