/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.fme.ui;

import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;

public class FMECustomLabel
extends JLabel {
    public static final String CUSTOM_FONT_NAME = "Dialog";
    public static final int CUSTOM_FONT_STYLE_SIMPLE = 0;
    public static final int CUSTOM_FONT_STYLE_BOLD = 1;
    public static final int CUSTOM_FONT_SIZE = 12;
    protected boolean htmlStyle = false;
    protected String labelName = "";
    protected boolean enabled = true;
    protected String innerIndex = "";

    public FMECustomLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.setFont(this.getCustomFont());
    }

    public FMECustomLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.setFont(this.getCustomFont());
    }

    public FMECustomLabel(String text) {
        super(text);
        this.setFont(this.getCustomFont());
    }

    public FMECustomLabel(String text, boolean htmlStyle) {
        super(text);
        this.labelName = text;
        this.setText(htmlStyle ? "<html><a href='#'>" + text + "</a></html>" : text);
        this.setFont(this.getCustomFont());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                FMECustomLabel.this.setCursor(Cursor.getPredefinedCursor(12));
            }
        });
    }

    public FMECustomLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.setFont(this.getCustomFont());
    }

    public FMECustomLabel(Icon image) {
        super(image);
        this.setFont(this.getCustomFont());
    }

    public FMECustomLabel() {
        this.setFont(this.getCustomFont());
    }

    protected Font getCustomFont() {
        return new Font(CUSTOM_FONT_NAME, 0, 12);
    }

    protected void setDisabled() {
        this.setText(this.labelName);
        this.enabled = false;
        super.disableEvents(500L);
    }

    protected void setEnabled() {
        this.setText(this.labelName);
        this.enabled = true;
        super.enableEvents(500L);
    }

    public String getInnerIndex() {
        return this.innerIndex;
    }

    public void setInnerIndex(String innerIndex) {
        this.innerIndex = innerIndex;
    }

    @Override
    public void setToolTipText(String toolTipText) {
        this.setInnerIndex(toolTipText);
        super.setToolTipText(this.labelName);
    }

    @Override
    public String getToolTipText() {
        return this.innerIndex;
    }
}

