/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.model.bill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.Form;
import com.kingdee.eas.base.form.model.AbstractDynamicFormPlugin;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.IDynamicFormModel;
import com.kingdee.eas.base.form.model.IDynamicFormView;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.bill.BillEventsProxy;
import com.kingdee.eas.base.form.model.bill.BillModel;
import com.kingdee.eas.base.form.model.bill.IBillAction;
import com.kingdee.eas.base.form.model.bill.IBillModel;
import com.kingdee.eas.base.form.model.bill.IBillView;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.base.form.web.DynamicWebFormPanel;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class BillApplication
extends DynamicFormApplication
implements IBillAction,
IFormApplication {
    private static final Logger logger = Logger.getLogger(BillApplication.class);
    public BillEventsProxy eventsProxy;
    private IBillModel billModel;
    private IBillView billView;

    public BillApplication(IDynamicFormView dynamicFormView, IDynamicFormModel dynamicFormModel) {
        super(dynamicFormView, dynamicFormModel);
        this.init(dynamicFormView, dynamicFormModel);
    }

    private void init(IDynamicFormView dynamicFormView, IDynamicFormModel dynamicFormModel) {
        this.billModel = (IBillModel)dynamicFormModel;
        this.billView = (IBillView)dynamicFormView;
        this.eventsProxy = new BillEventsProxy();
        this.billView.setEventsProxy(this.eventsProxy.getViewEventsProxy());
        this.billModel.setEventsProxy(this.eventsProxy.getModelEventsProxy());
    }

    public void registPlugIn(AbstractDynamicFormPlugin plugin) {
        ((AbstractBillPlugin)plugin).attachApplication(this);
        this.eventsProxy.addListener((AbstractBillPlugin)plugin);
    }

    public void lockElement(String key, boolean isLock) {
        this.billView.setEnabled(key, !isLock);
    }

    public String getCustomWorkFlowID() throws EASBizException, BOSException {
        return this.eventsProxy.getViewEventsProxy().fireGetCustomWorkFlowID();
    }

    public void lockElement(String key, int row, boolean isLock) {
        this.billView.setEnabled(key, !isLock, row);
    }

    public void lockAttachmentOperation(String operationKey) {
        this.billView.lockAttachmentOperation(operationKey);
    }

    public BillApplication(Context context, IDynamicFormView dynamicFormView, IDynamicFormModel dynamicFormModel) {
        super(context, dynamicFormView, dynamicFormModel);
        this.init(dynamicFormView, dynamicFormModel);
    }

    public void hideElement(String key, boolean isHide) {
        this.billView.setVisible(key, !isHide);
    }

    public void setMustInput(String key, boolean mustInput) {
        if (this.billView instanceof DynamicWebFormPanel) {
            ((DynamicWebFormPanel)this.billView).setMustInput(key, mustInput);
        }
    }

    public IBillModel getBillModel() {
        return this.billModel;
    }

    public IBillView getBillView() {
        return this.billView;
    }

    @Override
    public void copyData() throws BOSException, EASBizException {
        this.billView.copyData();
    }

    @Override
    public void createNewData() throws BOSException, EASBizException {
        this.billView.createNewData();
    }

    @Override
    public void save() throws BOSException, EASBizException {
        this.billView.save();
    }

    @Override
    public void close() throws BOSException, EASBizException {
        this.billView.close();
    }

    public void addError(String key, String msg) {
        this.billView.addError(key, msg);
    }

    public OrgUnitInfo getMainOrgUnit() {
        return this.billModel.getMainOrgUnit();
    }

    @Override
    public void submit() throws BOSException, EASBizException {
        this.billView.submit();
    }

    @Override
    public void createNewEntryRow(String entityKey) throws BOSException, EASBizException {
        this.billView.createNewEntryRow(entityKey);
    }

    @Override
    public void delete() throws BOSException, EASBizException {
        this.billView.delete();
    }

    @Override
    public void deleteEntryRow(String entityKey) throws BOSException, EASBizException {
        this.billView.deleteEntryRow(entityKey);
    }

    @Override
    public void edit() throws EASBizException, BOSException {
        this.billView.edit();
    }

    @Override
    public void load(String pk) throws BOSException, EASBizException {
        this.billView.load(pk);
    }

    @Override
    public void print() throws EASBizException, BOSException {
        this.billView.print();
    }

    @Override
    public void createFrom() throws BOSException, EASBizException {
        this.billView.createFrom();
    }

    @Override
    public void createTo() throws BOSException, EASBizException {
        this.billView.createTo();
    }

    @Override
    public void insertEntryRow(String entityKey) throws BOSException, EASBizException {
        this.billView.insertEntryRow(entityKey);
    }

    public String getMainOrgId() {
        OrgUnitInfo mainOrg = this.getMainOrgUnit();
        return mainOrg == null ? null : mainOrg.getId().toString();
    }

    @Override
    public void importEntryRow(String entityKey) throws BOSException, EASBizException {
        this.billView.importEntryRow(entityKey);
    }

    @Override
    public void handleEntry(String entityKey, String function) throws BOSException, EASBizException {
        this.billView.handleEntry(entityKey, function);
    }

    @Override
    public void navigate(String operation) throws BOSException, EASBizException {
        this.billView.navigate(operation);
    }

    public void doCustomOperation(String operation) throws EASBizException, BOSException {
        this.eventsProxy.getViewEventsProxy().doCustomOperation(operation);
    }

    public IDynamicFormView getView() {
        return this.billView;
    }

    public Object searchValue(String key, int row) throws BOSException {
        return this.billModel.searchValue(key, row);
    }

    public Object getSelectedRowData(String entityKey, String property) throws BOSException {
        if (StringUtils.isEmpty((String)entityKey)) {
            return this.getBillModel().getPKValue();
        }
        int row = this.getBillView().getSelectedRow(entityKey);
        if (row == -1) {
            return null;
        }
        Entity entity = this.getBillModel().getBusinessInfo().getEntity(entityKey);
        if (entity.getEntityType() != 1) {
            return null;
        }
        IObjectCollection collection = (IObjectCollection)this.getBillModel().getBillValue().get(entity.getEntryName());
        if (collection == null || collection.size() == 0 || row > collection.size()) {
            return null;
        }
        IObjectValue objValue = collection.getObject(row);
        if (property == null) {
            return objValue;
        }
        return objValue.get(property);
    }

    public void uploadAttachment(String key) throws BOSException {
        this.billView.uploadAttachment(key);
    }

    public void relateBill(String key) throws BOSException, EASBizException {
        this.billView.relateBill(key);
    }

    public Form getForm() {
        return this.billModel.getBusinessInfo().getForm();
    }

    public void setValue(String key, Object value, Object source, int row) throws EASBizException, BOSException {
        ((BillModel)this.billModel).setValue(key, value, source, row);
        this.billView.updateView(key, value, row);
    }

    public void editOfficeDocument(String billId, String docName) {
    }

    public IObjectValue getBillValue() {
        return this.billModel.getBillValue();
    }
}

