/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.model.bill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.form.BOTPHelper;
import com.kingdee.eas.base.form.app.BusinessSeviceUtil;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.FormMetaData;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.IDynamicFormView;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.bill.BillModel;
import com.kingdee.eas.base.form.model.bill.IBillModel;
import com.kingdee.eas.base.form.model.bill.IDList;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.model.list.IListView;
import com.kingdee.eas.base.form.web.FormMetaCacheManager;
import com.kingdee.eas.base.form.web.WebBillEditPanel;
import com.kingdee.eas.base.form.web.WfState;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.List;

public final class BillApplicationHelper {
    private Context context;
    private OpenBillParameter param;
    private BillApplication application;
    private WebBillEditPanel billView;
    private IBillModel billModel;
    private IDynamicFormView parent;
    private FormMetaData formMetaData;

    public static BillApplicationHelper getInstance(Context context, OpenBillParameter param, IDynamicFormView parent) {
        return new BillApplicationHelper(context, param, parent);
    }

    private BillApplicationHelper(Context context, OpenBillParameter param, IDynamicFormView parent) {
        this.context = context;
        this.param = param;
        this.parent = parent;
    }

    public BillApplication newBillApplication() throws Exception {
        if (this.param.formMeta == null) {
            if (this.param.getFormId() != null) {
                this.param.formMeta = FormMetaCacheManager.getFormMeta((Context)this.context, (String)this.param.getFormId(), null);
            } else if (this.param.billPk != null) {
                this.param.formMeta = FormMetaCacheManager.getFormMeta((Context)this.context, null, (String)new ObjectUuidPK(this.param.billPk).getObjectType().toString());
            }
        }
        this.formMetaData = this.param.formMeta;
        BusinessInfo bInfo = this.formMetaData.getBusinessInfo();
        this.billView = new WebBillEditPanel(this.formMetaData.getLayoutInfo(), this.formMetaData.getBusinessInfo(), this.formMetaData.getBarDataManager());
        this.billModel = new BillModel(bInfo);
        this.application = new BillApplication(this.context, this.billView, this.billModel);
        this.application.setCustomParameters(this.param.getCustomParams());
        if (this.application.getCustomParameter("flowTempId") == null || this.application.getCustomParameter("flowTempId") != null && this.application.getCustomParameter("flowTempId").toString().trim().length() <= 0) {
            try {
                String formID = this.formMetaData.getFormId();
                String flowTempId = this.getTemplateID(formID);
                if (flowTempId != null) {
                    this.application.setCustomParameter("flowTempId", flowTempId);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.billView.setApplication(this.application);
        if (this.param.billOperation == OperationStatus.VIEWTEMPLATE) {
            this.billView.lockUI();
            return this.application;
        }
        this.billView.setParentFormView(this.parent);
        this.registerPlugins(this.application, this.formMetaData);
        this.billView.onInitialize(this.param);
        this.billView.setViewFromList(this.param.viewFromList);
        WfState wfState = this.param.wfState;
        if (wfState == null) {
            wfState = new WfState();
        }
        this.billView.setWfState(wfState);
        return this.application;
    }

    public void loadData(String[] createToBillIds) throws Exception {
        if (this.application == null) {
            this.newBillApplication();
        }
        if (this.param.viewFromList) {
            IListView listView = (IListView)this.parent;
            this.billView.setIdList(new IDList(listView.getCurrentPageIdList(), this.param.billPk));
        }
        if (this.param.botpFunc != null && this.param.botpFunc.equalsIgnoreCase("CreateTo") && createToBillIds != null) {
            this.billView.billModel = this.billModel;
            this.param.billOperation = this.billView.handleBotpCreate(this.param.srcBosType, this.param.ruleId, createToBillIds);
        } else if (this.param.billPk != null && !OperationStatus.ADDNEW.equals(this.param.billOperation)) {
            this.billModel.load(this.param.billPk);
        } else {
            FormOperation fo;
            if (this.formMetaData.getBusinessInfo().getMainOrgField() == null && (fo = this.formMetaData.getBusinessInfo().getForm().getOperation("New")) != null) {
                BusinessSeviceUtil.checkFunctionPermission((Context)this.context, (String)this.application.getMainOrgId(), (String)fo.getPermissionItem());
            }
            this.billModel.createNewData();
        }
        this.billView.setOperationStatus(this.param.billOperation);
        try {
            this.billView.onLoad();
            this.billView.bindData(this.billModel);
        }
        catch (Exception e) {
            if (OperationStatus.EDIT.equals(this.param.billOperation)) {
                this.param.billOperation.canTransfer(OperationStatus.VIEW, (DynamicFormApplication)this.application);
            }
            throw e;
        }
    }

    private void handleBotpCreate(String srcBosType, String ruleId, String[] selectedBillIds) throws EASBizException, BOSException {
        BOTPHelper botpHelper = new BOTPHelper(this.context, srcBosType, this.application.getDynamicFormModel().getBusinessInfo().getForm().getBosType(), ruleId);
        if (selectedBillIds == null) {
            return;
        }
        BTPTransformResult btpResult = botpHelper.transformTo(selectedBillIds);
        IObjectCollection destBillCols = btpResult.getBills();
        if (destBillCols == null || destBillCols.size() == 0) {
            return;
        }
        IObjectValue objValue = destBillCols.getObject(0);
        this.billModel.setBillValue(objValue);
        ((BillModel)this.billModel).setMakeRelations(btpResult.getBOTRelationCollection());
        if (objValue.get(objValue.getPKField()) != null) {
            this.param.billOperation = OperationStatus.EDIT;
        }
    }

    public BillApplication getApplication() {
        return this.application;
    }

    private void registerPlugins(BillApplication application, FormMetaData formMetaData) throws BOSException {
        List plugins = formMetaData.getBusinessInfo().getForm().getBillPlugins();
        application.registPlugIn(plugins);
    }

    private String getTemplateID(String formID) {
        String retStr = null;
        String sql = "select fid from t_bas_template where fformid='" + formID + "' and fControlUnitID = 'eThjryu4wEKoEK1veu3ZzDUlqpQ=' and FUsedState = 2";
        String cuSql = "select fid from t_bas_template where fformid='" + formID + "' and fControlUnitID = '" + ContextUtil.getCurrentCtrlUnit((Context)this.application.getContext()).getId().toString() + "' and FUsedState = 2";
        try {
            IRowSet result = DBUtil.executeQuery((Context)this.context, (String)sql, null);
            if (result.next()) {
                retStr = result.getString(1);
            } else {
                result = DBUtil.executeQuery((Context)this.context, (String)cuSql, null);
                if (result.next()) {
                    retStr = result.getString(1);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retStr;
    }
}

