/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.model.bill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.form.metadata.Action;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.IFormBusiness;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.bill.RequiredCheckHandler;
import com.kingdee.eas.base.form.model.command.ActionArgs;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBusinessBatchHandle;
import com.kingdee.eas.dynbusiness.app.DynamicBusinessProcessHelper;
import com.kingdee.eas.dynbusiness.condition.ObjectValueSearcher;
import com.kingdee.eas.dynbusiness.config.PropertyCheckConfigItems;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.log4j.Logger;

public final class BillBusinessUtil {
    private static final Logger logger = Logger.getLogger(BillBusinessUtil.class);

    public static void invokeActions(IFormApplication application, Object source, List actions, Object value, int actionType) throws BOSException, EASBizException {
        if (actions == null) {
            return;
        }
        for (int i = 0; i < actions.size(); ++i) {
            Action action = (Action)actions.get(i);
            if (actionType != action.getType()) continue;
            BillBusinessUtil.invokeActions(application, source, action, value);
        }
    }

    public static void invokeActions(IFormApplication application, Object source, List actions, Object value, int actionType, int row) throws BOSException, EASBizException {
        if (actions == null) {
            return;
        }
        for (int i = 0; i < actions.size(); ++i) {
            Action action = (Action)actions.get(i);
            if (actionType != action.getType()) continue;
            BillBusinessUtil.invokeActions(application, source, action, value, row);
        }
    }

    public static void invokeActions(IFormApplication application, Object source, Action action, Object value) throws BOSException, EASBizException {
        ActionArgs args = new ActionArgs(source, action, 0, value);
        BillBusinessUtil.invokeActions(application, args);
    }

    public static void invokeActions(IFormApplication application, Object source, Action action, Object value, int row) throws BOSException, EASBizException {
        ActionArgs args = new ActionArgs(source, action, row, value);
        BillBusinessUtil.invokeActions(application, args);
    }

    public static void invokeActions(IFormApplication application, ActionArgs args) throws BOSException, EASBizException {
        try {
            Class<?> clz = Class.forName(args.getAction().getClassName());
            Constructor<?> constructor = clz.getConstructor(IFormApplication.class);
            IFormBusiness iBillBusiness = (IFormBusiness)constructor.newInstance(application);
            iBillBusiness.doAction(args);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static Object searchValue(DynamicFormApplication application, IObjectValue value, String key, int row) throws BOSException {
        if (application instanceof BillApplication) {
            return application.searchValue(key, row);
        }
        String property = null;
        property = application.getDynamicFormModel().getBusinessInfo().getFullPropertyName(key);
        if (property != null && value != null) {
            return ObjectValueSearcher.searchValue((Object)value, (String)property, (int)0, null, null, (int)row);
        }
        return null;
    }

    public static String createBillNumberAtSave(Context ctx, IObjectValue objValue, String mainOrgId) throws BOSException, EASBizException {
        RuleStatus ruleStatus = BillBusinessUtil.getBillNumberRuleStatus(ctx, objValue, mainOrgId);
        if (ruleStatus.isExist() && !ruleStatus.isAddView()) {
            ICodingRuleManager iCodingRuleManager = (ICodingRuleManager)BusinessProcessUtil.getBizInterface((Context)ctx, CodingRuleManagerFactory.class);
            return iCodingRuleManager.getNumber(objValue, mainOrgId);
        }
        return null;
    }

    public static RuleStatus getBillNumberRuleStatus(Context ctx, IObjectValue objValue, String mainOrgId) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = (ICodingRuleManager)BusinessProcessUtil.getBizInterface((Context)ctx, CodingRuleManagerFactory.class);
        RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus(objValue, mainOrgId);
        return ruleStatus;
    }

    public static void validateAtSave(PropertyCheckConfigItems checkItems, String bosType, DynamicFormApplication application, IObjectValue objValue) throws EASBizException, BOSException {
        if (checkItems == null) {
            return;
        }
        RequiredCheckHandler handler = new RequiredCheckHandler(checkItems, BOSObjectType.create((String)bosType), null, null, application);
        DynamicBusinessProcessHelper.batchHandle((Context)application.getContext(), (String)bosType, (IBusinessBatchHandle)handler, (Object[])new Object[]{objValue});
    }

    public static boolean isEnabledState(IFormApplication application, FormOperation fo, int row) throws BOSException {
        if (StringUtils.isEmpty((String)fo.getPreStateValue())) {
            return true;
        }
        String[] states = fo.getPreStateValue().split("\\s*,\\s*");
        if (states.length == 0) {
            return true;
        }
        String fieldKey = fo.getStateField();
        Object oldState = BillBusinessUtil.searchValue((DynamicFormApplication)application, application.getBillValue(), fieldKey, row);
        String oldStateString = oldState == null ? "NULL" : oldState.toString();
        for (int i = 0; i < states.length; ++i) {
            if (!states[i].equalsIgnoreCase(oldStateString)) continue;
            return true;
        }
        return false;
    }
}

