/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.bill.IOperationRoundExtend;
import com.kingdee.eas.base.form.model.command.ActionArgs;
import com.kingdee.eas.base.form.plugin.AbstractFormBusiness;
import com.kingdee.eas.base.form.plugin.OperationHelper;
import com.kingdee.eas.base.form.web.WebBillEditPanel;
import com.kingdee.eas.common.EASBizException;
import java.util.HashSet;
import java.util.Set;

public abstract class CommonActionService
extends AbstractFormBusiness {
    protected OperationHelper helper;
    protected static Set checkChangeOperations = new HashSet(7);
    protected static Set checkWfOperations = new HashSet(7);
    protected static Set transactionOperations = new HashSet(4);
    protected static Set mutexOperations = new HashSet(5);

    public CommonActionService(IFormApplication application) {
        super(application);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction(ActionArgs e) throws BOSException, EASBizException {
        String[] parameters = e.getParamenter();
        if (parameters.length == 0) {
            return;
        }
        String operation = parameters[0];
        ((DynamicFormApplication)this.application).setE(e);
        FormOperation fo = ((DynamicFormApplication)this.application).getDynamicFormModel().getBusinessInfo().getForm().getOperation(operation);
        if (fo != null && fo.getCheckWfState() == -1 && checkWfOperations.contains(operation)) {
            fo.setCheckWfState(1);
        }
        this.helper = new OperationHelper(this.application, fo);
        if (this.helper.isAfterConfirmCancel(e)) {
            return;
        }
        this.helper.checkRight();
        if (checkChangeOperations.contains(fo.getOperation())) {
            boolean needCheck = true;
            if (this.application.getView() instanceof WebBillEditPanel) {
                boolean bl = needCheck = !OperationStatus.VIEW.equals(((WebBillEditPanel)this.application.getView()).getOperationStatus());
            }
            if (needCheck && this.helper.confirmModelChanged(e)) {
                return;
            }
        }
        if (!this.helper.doConfirmation(e)) {
            return;
        }
        IObjectPK logPk = null;
        if (checkWfOperations.contains(operation)) {
            logPk = this.helper.beforeLogSevice();
        }
        if (!this.beforeOperation(fo)) {
            return;
        }
        this.doOperation(e, parameters.length > 1 ? parameters[1] : null);
        this.afterOperation(fo);
        this.helper.afterLogSevice(logPk);
    }

    protected void afterOperation(FormOperation fo) throws EASBizException, BOSException {
        this.helper.afterOperation(fo);
        if (this.application instanceof BillApplication) {
            ((BillApplication)this.application).getBillView().setParentRefresh(true);
        }
    }

    protected abstract void doOperation(ActionArgs var1, String var2) throws BOSException, EASBizException;

    private boolean beforeOperation(FormOperation fo) throws EASBizException, BOSException {
        if (!((IOperationRoundExtend)this.application.getView()).beforeOperation(fo)) {
            return false;
        }
        if (fo.getCheckWfState() == 1 || fo.getCheckWfState() == -1 && checkWfOperations.contains(fo.getOperation())) {
            this.helper.checkWfState();
        }
        this.helper.invokeBeforeAction(fo);
        return true;
    }

    static {
        checkChangeOperations.add("Audit");
        checkChangeOperations.add("UnAudit");
        checkChangeOperations.add("Copy");
        checkChangeOperations.add("New");
        checkChangeOperations.add("Print");
        checkChangeOperations.add("Close");
        checkChangeOperations.add("Refresh");
        checkWfOperations.add("Audit");
        checkWfOperations.add("UnAudit");
        checkWfOperations.add("Delete");
        checkWfOperations.add("Save");
        checkWfOperations.add("Submit");
        checkWfOperations.add("Disable");
        checkWfOperations.add("Enable");
        transactionOperations.add("Audit");
        transactionOperations.add("UnAudit");
        transactionOperations.add("Disable");
        transactionOperations.add("Enable");
        mutexOperations.add("Audit");
        mutexOperations.add("UnAudit");
        mutexOperations.add("Disable");
        mutexOperations.add("Enable");
        mutexOperations.add("Delete");
    }
}

