/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.form.DAOHelper;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.IFormBusiness;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.BillBusinessUtil;
import com.kingdee.eas.base.form.model.command.ActionArgs;
import com.kingdee.eas.base.form.model.list.IListModel;
import com.kingdee.eas.base.form.model.list.ListApplication;
import com.kingdee.eas.base.form.plugin.AbstractFormBusiness;
import com.kingdee.eas.base.form.plugin.CommonActionService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.TransactionInvokeUtil;
import java.lang.reflect.Constructor;
import java.util.List;
import org.apache.log4j.Logger;

public class ListAction
extends CommonActionService {
    private ListApplication application;
    Logger log = Logger.getLogger((String)"com.kingdee.eas.base.form.plugin.ListAction");

    public ListAction(IFormApplication application) {
        super(application);
        this.application = (ListApplication)application;
    }

    @Override
    protected void doOperation(ActionArgs e, String operatedKey) throws BOSException, EASBizException {
        FormOperation fo = this.helper.getFo();
        String operation = fo.getOperation();
        List selectedSeqList = (List)e.getValue();
        IListModel listModel = this.application.getListModel();
        String pk = null;
        if (selectedSeqList.size() == 1) {
            pk = listModel.getBillIdBySeq((Integer)selectedSeqList.get(0), true);
        }
        if (operation.equalsIgnoreCase("New")) {
            this.application.operateBill(OperationStatus.ADDNEW, null);
        } else if (operation.equalsIgnoreCase("View")) {
            this.application.operateBill(OperationStatus.VIEW, pk);
        } else if (operation.equalsIgnoreCase("Edit")) {
            this.application.operateBill(OperationStatus.EDIT, pk);
        } else if (operation.equalsIgnoreCase("Delete")) {
            this.application.delete(selectedSeqList);
        } else if (operation.equalsIgnoreCase("CreateFrom")) {
            this.application.getListView().handleCreateFrom();
        } else if (operation.equalsIgnoreCase("CreateTo")) {
            this.application.getListView().handleCreateTo(fo);
        } else if (operation.equalsIgnoreCase("ShowApproveResult")) {
            this.application.getListView().showApproveResult();
        } else if (operation.equalsIgnoreCase("ShowFlowChart")) {
            this.application.getListView().showFlowChart();
        } else if (operation.equalsIgnoreCase("Print")) {
            this.application.getListView().print();
        } else if (operation.equalsIgnoreCase("Refresh")) {
            this.application.getListView().refresh();
        } else if (operation.equalsIgnoreCase("Export")) {
            this.application.getListView().export();
        } else if (operation.equalsIgnoreCase("ShowAdvancedFilter")) {
            this.application.getListView().popupAdvancedFilterDialog();
        } else if (operation.equalsIgnoreCase("Submit")) {
            IObjectValue objValue = this.application.getBillValue();
            if (objValue == null) {
                this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff01");
                return;
            }
            BillBusinessUtil.validateAtSave(this.application.getListModel().getBusinessInfo().getCheckItems(), objValue.getBOSType().toString(), this.application, objValue);
            DAOHelper.getDAO().update(this.application.getContext(), objValue);
            boolean isUpdate = this.helper.updateBillState(fo, e.getRow());
            if (checkWfOperations.contains(fo.getOperation())) {
                TransactionInvokeUtil.invokeRequired((Object)this, (String)"doUpdate", (Object[])new Object[]{objValue}, (Class[])new Class[]{IObjectValue.class});
                this.helper.showSuccessMsg();
            }
        } else if ("Archive".equalsIgnoreCase(operation) || "TraceUp".equalsIgnoreCase(operation) || "TraceDown".equalsIgnoreCase(operation)) {
            String className = fo.getRunClassName();
            try {
                Constructor<?> constructor = Class.forName(className).getConstructor(IFormApplication.class);
                Object o = constructor.newInstance(new Object[]{this.application});
                if (!(o instanceof AbstractFormBusiness)) {
                    throw new BOSException("\u81ea\u5b9a\u4e49action\u5fc5\u987b\u7ee7\u627f\u81eaAbstractFormBusiness!");
                }
                IFormBusiness fornBusiness = (IFormBusiness)constructor.newInstance(new Object[]{this.application});
                fornBusiness.doAction(e);
            }
            catch (NoSuchMethodException e1) {
                this.log.error((Object)e1);
                throw new BOSException("\u81ea\u5b9a\u4e49action\u5fc5\u987b\u6709\u4e00\u4e2a\u53c2\u6570\u7c7b\u578b\u4e3aIFormApplication\u7684\u6784\u9020\u65b9\u6cd5!");
            }
            catch (Exception e2) {
                this.log.error((Object)e2);
                throw new BOSException((Throwable)e2);
            }
        }
    }

    public void doUpdate(IObjectValue objValue) throws EASBizException, BOSException {
        DAOHelper.getDAO().update(this.application.getContext(), objValue);
    }

    @Override
    protected void afterOperation(FormOperation fo) throws EASBizException, BOSException {
        super.afterOperation(fo);
        if (checkWfOperations.contains(fo.getOperation())) {
            this.application.getListView().refresh();
        }
    }
}

