/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.json.JSONArray;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.EnumItem;
import com.kingdee.eas.base.form.metadata.EnumObject;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FormMetaData;
import com.kingdee.eas.base.form.model.BarDataManager;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.f7.PromptBoxModel;
import com.kingdee.eas.base.form.model.list.ListApplication;
import com.kingdee.eas.base.form.web.ExtUIBuilder;
import com.kingdee.eas.base.form.web.WebBarBuilder;
import com.kingdee.jdbc.rowset.IRowSet;

public class WebPromptBoxPanel {
    private PromptBoxModel model = null;
    protected ExtUIBuilder uiBuilder;
    private JSONArray actionList = null;
    private String pageId;

    public WebPromptBoxPanel(PromptBoxModel model) throws Exception {
        this.model = model;
        this.pageId = BOSUuid.create((String)"BEPI").toString();
    }

    public JSONObject getMainMenu() throws JSONException {
        BarDataManager menuData = this.createToolBar();
        WebBarBuilder barBuilder = new WebBarBuilder(menuData);
        barBuilder.loadBarItems();
        JSONArray items = new JSONArray();
        JSONObject mainMenu = new JSONObject();
        mainMenu.put("items", (Object)items);
        mainMenu.put("imagepath", (Object)"IMAGES/ToolBar/chs/");
        items.put(barBuilder.getToolbar());
        return mainMenu;
    }

    private EnumObject getEnumObject(String enumKey) {
        EnumObject objEnum = new EnumObject(enumKey);
        PromptBoxModel.FieldItem[] items = this.model.getFieldItems();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].isFilterField()) continue;
            EnumItem enumItem = new EnumItem();
            enumItem.setValue(i);
            enumItem.setDisplayValueValue(items[i].getDisplayName());
            objEnum.addItem(enumItem);
        }
        return objEnum;
    }

    public JSONObject getQuickFilterPanel() throws JSONException {
        FormMetaData formMetaData = this.model.getFormMetaData();
        BusinessInfo bizInfo = formMetaData.getBusinessInfo();
        Field field = bizInfo.getField("COMBOBOX");
        field.setDataScope(field.getKey());
        EnumObject objEnum = this.getEnumObject(field.getKey());
        bizInfo.getEnumInfo().add(objEnum);
        this.uiBuilder = new ExtUIBuilder(formMetaData.getLayoutInfo(), formMetaData.getBusinessInfo());
        this.uiBuilder.addControls();
        JSONObject panel = this.uiBuilder.getPanel();
        return panel;
    }

    public JSONArray getColumns() throws JSONException {
        PromptBoxModel.FieldItem[] fieldItems = this.model.getFieldItems();
        JSONArray cols = new JSONArray();
        for (int i = 0; i < fieldItems.length; ++i) {
            if (!fieldItems[i].isSeletorField()) continue;
            JSONObject col = new JSONObject();
            col.put("dataIndex", (Object)fieldItems[i].getName());
            col.put("header", (Object)fieldItems[i].getDisplayName());
            col.put("width", 100);
            cols.put((Object)col);
        }
        return cols;
    }

    public void quickFilterQuery(Object conditions) throws Exception {
        JSONArray jsConditions = new JSONArray((String)conditions);
        this.model.setSetting(jsConditions);
        this.createAction("refresh");
    }

    private JSONObject createAction(String actionName, String actionConfig) throws JSONException {
        this.actionList = new JSONArray();
        JSONObject action = null;
        action = actionConfig == null ? new JSONObject() : new JSONObject(actionConfig);
        action.put("actionname", (Object)actionName);
        this.actionList.put((Object)action);
        return action;
    }

    private JSONObject createAction(String actionName) throws JSONException {
        return this.createAction(actionName, null);
    }

    public JSONArray getActions() throws JSONException {
        return this.actionList;
    }

    public String getData(int start, int rowCount) throws Exception {
        IRowSet rs = this.model.getData(start, rowCount);
        JSONObject data = new JSONObject();
        JSONArray rows = new JSONArray();
        data.put("rowcount", this.model.getRowCount());
        data.put("rows", (Object)rows);
        if (rs != null) {
            rs.beforeFirst();
            while (rs.next()) {
                JSONArray row = new JSONArray();
                for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                    Object fieldValue = rs.getObject(i);
                    row.put(fieldValue != null ? fieldValue : "");
                }
                rows.put((Object)row);
            }
        }
        return data.toString();
    }

    private BarDataManager createToolBar() {
        BarDataManager toolBarData = new BarDataManager(this.model.getFormMetaData().getBarKeysCache());
        return toolBarData;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void operateBill(OperationStatus status) throws BOSException {
    }

    public void setApplication(ListApplication application) {
    }

    public void operateBill(OperationStatus status, String pk) throws BOSException {
    }

    public void delete(JSONArray rowList) throws BOSException {
    }
}

