/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.extend.flow.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.eas.base.form.extend.flow.TemplateInfo;
import com.kingdee.eas.base.form.json.JSONArray;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.metadata.Action;
import com.kingdee.eas.base.form.metadata.EnumSringItem;
import com.kingdee.eas.base.form.metadata.FormCondition;
import com.kingdee.eas.base.form.metadata.FormMetaData;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.model.command.CommandArg;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.base.form.util.FormActionUtil;
import com.kingdee.eas.base.form.util.ResourceUtil;
import com.kingdee.eas.base.form.util.WorkFlowUtil;
import com.kingdee.eas.base.form.web.FormMetaCacheManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FlowTemplate
extends AbstractBillPlugin {
    private Map flowMap = new HashMap();

    public void fireButtonClick(CommandArg commandArg) throws EASBizException, BOSException {
        super.fireButtonClick(commandArg);
        if (commandArg.getKey().equalsIgnoreCase("FbtnFlowControl")) {
            String flowid = this.getSelectedFlowId();
            if (flowid == null) {
                return;
            }
            this.showNodeCtrlForm(flowid);
        } else {
            if (commandArg.getKey().equalsIgnoreCase("BTNBILLSTYLE1")) {
                String formId = (String)this.application.getValue("FFormID", 0);
                String layoutId = (String)this.application.getValue("FLayoutID", 0);
                try {
                    this.application.getBillView().operateBill(OperationStatus.VIEWTEMPLATE, formId, layoutId, null);
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable e) {
                    throw new BOSException(e);
                }
            }
            if (commandArg.getKey().equalsIgnoreCase("FDraftConrol")) {
                this.showNodeCtrlForm("DRAFT");
            } else if (commandArg.getKey().equalsIgnoreCase("FViewFlowChart")) {
                String flowid = this.getSelectedFlowId();
                if (flowid == null) {
                    return;
                }
                JSONObject urlParam = new JSONObject();
                JSONObject winParam = new JSONObject();
                try {
                    urlParam.put("proInstId", (Object)flowid);
                    winParam.put("name", (Object)"WF");
                    winParam.put("title", (Object)"\u6d41\u7a0b\u56fe");
                    winParam.put("x", 800);
                    winParam.put("y", 600);
                }
                catch (JSONException e) {
                    // empty catch block
                }
                String url = "../../easweb/webviews/workflow/viewProcessDiagram.jsp";
                JSONArray jsa = new JSONArray();
                jsa.put((Object)"Custom");
                jsa.put((Object)"openNewWindow");
                jsa.put((Object)url);
                jsa.put((Object)urlParam.toString());
                jsa.put((Object)winParam.toString());
                Action action = new Action("com.kingdee.eas.base.form.plugin.ShowPopupAction", jsa.toString());
                FormActionUtil.invokeAction((IFormApplication)this.application, (Object)commandArg.getKey(), (Action)action, null);
            } else if (commandArg.getKey().equalsIgnoreCase("FBtnSignValid")) {
                this.authenticateSign();
            }
        }
    }

    private void authenticateSign() throws BOSException {
        String formIdOfTargetBill = (String)this.application.getValue("FFormID", 0);
        FormMetaData formMeta = FormMetaCacheManager.getFormMeta((Context)this.application.getContext(), (String)formIdOfTargetBill, null);
        List signControls = formMeta.getLayoutInfo().getSignControls();
        if (signControls == null || signControls.size() == 0) {
            this.application.showMessage("\u5355\u636e\u6a21\u677f\u6ca1\u6709\u914d\u7f6e\u7535\u5b50\u7b7e\u7ae0\u63a7\u4ef6\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u7535\u5b50\u7b7e\u7ae0\u5b89\u5168\u8ba4\u8bc1\u64cd\u4f5c!");
        } else {
            String layoutID = (String)this.application.getValue("FLayoutID", 0);
            TemplateInfo template = (TemplateInfo)this.application.getBillModel().getBillValue();
            JSONObject para = new JSONObject();
            try {
                para.put("formID", (Object)"ROEs+HwOTfefEqnRHP/54Zp+rpI=");
                para.put("tempLayoutID", (Object)layoutID);
                para.put("tempformID", (Object)formIdOfTargetBill);
                para.put("templateId", (Object)template.getId().toString());
                para.put("status", (Object)this.application.getBillView().getOperationStatus().getStatus());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            String url = ResourceUtil.buildUrlEncodeParam((String)"BillServlet", (String)para.toString());
            this.application.popupWindow(url, "openDialog", "signctl", "\u7b7e\u7ae0\u5b89\u5168\u8ba4\u8bc1", 620, 600);
        }
    }

    private String getSelectedFlowId() throws BOSException {
        int row = this.application.getBillView().getSelectedRow("FWorkFlowEntry");
        if (row < 0) {
            this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u6761\u6d41\u7a0b");
            return null;
        }
        String flowid = (String)this.application.getValue("FWorkFlow", row);
        if (flowid == null || !this.flowMap.containsKey(flowid)) {
            this.application.showMessage("\u672a\u5173\u8054\u6d41\u7a0b\u6216\u5173\u8054\u7684\u6d41\u7a0b\u4e0d\u5b58\u5728\uff01");
            return null;
        }
        return flowid;
    }

    private void showNodeCtrlForm(String flowid) throws BOSException {
        String formID = (String)this.application.getValue("FFormID", 0);
        String layoutID = (String)this.application.getValue("FLayoutID", 0);
        TemplateInfo template = (TemplateInfo)this.application.getBillModel().getBillValue();
        JSONObject para = new JSONObject();
        try {
            para.put("formID", (Object)"4HgmSnntT469pSZXGVfekJp+rpI=");
            para.put("flowID", (Object)flowid);
            para.put("flowName", this.flowMap.get(flowid));
            para.put("tempLayoutID", (Object)layoutID);
            para.put("tempformID", (Object)formID);
            para.put("status", (Object)this.application.getBillView().getOperationStatus().getStatus());
            para.put("templateId", (Object)template.getId().toString());
        }
        catch (JSONException e) {
            // empty catch block
        }
        String url = ResourceUtil.buildUrlEncodeParam((String)"BillServlet", (String)para.toString());
        this.application.popupWindow(url, "openDialog", "flowctl", "\u6d41\u7a0b\u8282\u70b9\u63a7\u5236", 887, 700);
    }

    public boolean onInitialize(OpenBillParameter param) throws EASBizException, BOSException {
        this.application.bindDynamicField("FWorkFlow", "flowId");
        this.application.bindDynamicField("FStartCondition", "startConditionID");
        this.application.getBillModel().getBusinessInfo().getCheckItems().addRequiredProperty("entries");
        return super.onInitialize(param);
    }

    public void onLoad() {
        ArrayList<EnumSringItem> items = new ArrayList<EnumSringItem>();
        EnumSringItem item = new EnumSringItem();
        try {
            TemplateInfo template = (TemplateInfo)this.application.getBillModel().getBillValue();
            String dir = template.getFlowDirStr();
            if (StringUtils.isEmpty((String)dir)) {
                dir = "com.kingdee.eas.cp.wfm";
            }
            ProcessDefInfo[] result = WorkFlowUtil.getAllProcessDef((Context)this.application.getContext(), (String)dir);
            for (int i = 0; i < result.length; ++i) {
                item = new EnumSringItem();
                item.setValue(result[i].getProcDefId());
                item.setDisplayValueValue(result[i].getProcDefName(this.application.getContext().getLocale()));
                items.add(item);
                this.flowMap.put(item.getValue(), item.getDisplayValue());
            }
            this.application.getView().setComboItems("FWorkFlow", items);
        }
        catch (EASBizException e) {
        }
        catch (BOSException e1) {
            // empty catch block
        }
        String formId = (String)this.application.getValue("FFormID", 0);
        try {
            FormMetaData formMeta = FormMetaCacheManager.getFormMeta((Context)this.application.getContext(), (String)formId, null);
            if (formMeta == null) {
                return;
            }
            items = new ArrayList();
            item = new EnumSringItem();
            item.setValue("");
            item.setDisplayValueValue("\u7a7a");
            items.add(item);
            for (Map.Entry entry : formMeta.getBusinessInfo().getForm().getConditionMap().entrySet()) {
                FormCondition fc = (FormCondition)entry.getValue();
                item = new EnumSringItem();
                item.setValue(entry.getKey().toString());
                item.setDisplayValueValue(fc.getName());
                items.add(item);
            }
            this.application.getView().setComboItems("FStartCondition", items);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        super.onLoad();
    }
}

