/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.extend.plugins;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractBaseObjectCollection;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.extend.flow.DocumentInfoInfo;
import com.kingdee.eas.base.form.extend.plugins.DocumentInfoHelper;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.metadata.Appearance;
import com.kingdee.eas.base.form.metadata.ControlAppearance;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.command.ActionArgs;
import com.kingdee.eas.base.form.plugin.AbstractFormBusiness;
import com.kingdee.eas.base.form.web.DynamicWebFormState;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import java.sql.Connection;
import java.sql.SQLException;

public class ElectronicSignatureAction
extends AbstractFormBusiness {
    private ControlAppearance ctrl2sign;
    public DynamicWebFormState comState;

    public ElectronicSignatureAction(IFormApplication application) {
        super(application);
    }

    public void doAction(ActionArgs arg) throws BOSException, EASBizException {
        try {
            BillApplication ba = (BillApplication)this.getApplication();
            String src = (String)arg.getSource();
            this.ctrl2sign = (ControlAppearance)ba.getBillView().getLayoutInfo().getAppearance(src);
            try {
                if (ba.getBillModel().getPKValue() == null) {
                    ba.showMessage("\u7b7e\u7ae0\u524d\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\uff01");
                    return;
                }
                DocumentInfoInfo documentInfo = null;
                try {
                    documentInfo = DocumentInfoHelper.getDocumentInfoByBillId(ba.getContext(), ba.getBillModel().getPKValue());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (documentInfo == null) {
                    ba.showMessage("\u7b7e\u7ae0\u524d\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\uff01");
                    return;
                }
                ba.getView().setControlProperty(src, "electronicSignSetting", (Object)this.getSignData(ba, src, (Boolean)arg.getValue()));
            }
            catch (SQLException e1) {
                throw new BOSException((Throwable)e1);
            }
        }
        catch (JSONException e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    private boolean isSignOffice() {
        return this.ctrl2sign.getControlType() == 1018;
    }

    private boolean isPrivate() {
        if (this.isSignOffice()) {
            return this.ctrl2sign.getSealType() == 2;
        }
        return this.ctrl2sign.getSealType() == 1;
    }

    private JSONObject getSignData(BillApplication ba, String ctrlKey, Boolean isDeleting) throws JSONException, SQLException, EASBizException, BOSException {
        boolean isAdding;
        JSONObject signData = new JSONObject();
        boolean bl = isAdding = isDeleting == false;
        if (isAdding && !this.isSignOffice()) {
            IObjectValue vo = this.getSignValidationConfig(ba, ctrlKey);
            if (vo != null) {
                signData.put("webSignInfo", (Object)this.getWebSignInfo(vo, ctrlKey, ba));
                signData.put("pwdRequired", vo.get("passwordRequired"));
                UserInfo user = (UserInfo)ba.getBillModel().getDefaultValueCalculator().evaluateFunction("getUser(@CONTEXT)");
                signData.put("userName", (Object)user.getName());
            } else {
                signData.put("webSignInfo", (Object)"");
                signData.put("pwdRequired", true);
            }
        }
        signData.put("billTitle", (Object)this.getTitle4Log());
        signData.put("bosType", (Object)this.getBosType());
        signData.put("isPrivate", (Object)(this.ctrl2sign.getSealType() == 3 ? "3" : (this.isPrivate() ? "true" : "false")));
        signData.put("isSigning", isAdding);
        return signData;
    }

    private String getWebSignInfo(IObjectValue signValidConfig, String ctrlKey, BillApplication ba) throws SQLException, DataAccessException {
        StringBuffer sb = new StringBuffer();
        IObjectValue vo = this.getSignValidationConfig(ba, ctrlKey);
        if (vo != null) {
            IObjectCollection fields = (IObjectCollection)vo.get("fields");
            for (int i = 0; i < fields.size(); ++i) {
                IObjectValue voField = fields.getObject(i);
                if (!voField.getBoolean("selected")) continue;
                String key = voField.getString("key");
                sb.append(this.getCaptionAndKeyPair(ba, key.toUpperCase()));
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectValue getSignValidationConfig(BillApplication ba, String key) throws SQLException, DataAccessException {
        String oql = "Select passwordRequired, fields.key, fields.selected where layoutId ='" + ba.getBillView().getLayoutInfo().getId() + "' and elecSign='" + key + "' order by fields.seq ";
        Connection cn = null;
        IObjectValue vo = null;
        try {
            cn = EJBFactory.getConnection((Context)this.getApplication().getContext());
            IORMappingDAO ormdao = ORMappingDAO.getInstance((BOSObjectType)BOSObjectType.create((String)"CBA28788"), (Context)this.getApplication().getContext(), (Connection)cn);
            AbstractBaseObjectCollection datas = (AbstractBaseObjectCollection)ormdao.getCollection(oql);
            if (datas != null && !datas.isEmpty()) {
                vo = datas.getObject(0);
            }
        }
        finally {
            if (cn != null) {
                cn.close();
            }
        }
        return vo;
    }

    private String getCaptionAndKeyPair(BillApplication ba, String key) {
        Appearance ca = ba.getBillView().getLayoutInfo().getAppearance(key);
        return ca.getCaption() + "=" + key + "_;";
    }

    private String getTitle4Log() throws EASBizException, BOSException {
        BillApplication ba = (BillApplication)this.getApplication();
        if (ba.getBillModel().getPKValue() != null) {
            DocumentInfoInfo documentInfo = DocumentInfoHelper.getDocumentInfoByBillId(ba.getContext(), ba.getBillModel().getPKValue());
            StringBuffer title = new StringBuffer();
            title.append(ba.getForm().getName()).append("_");
            title.append(documentInfo.getTitle() == null ? "" : documentInfo.getTitle().trim());
            title.append("(");
            title.append(documentInfo.getDocNumber() == null ? "" : documentInfo.getDocNumber().trim());
            title.append(")");
            return title.toString();
        }
        return "";
    }

    private String getBosType() {
        BillApplication ba = (BillApplication)this.getApplication();
        return ba.getBillModel().getBusinessInfo().getForm().getBosType();
    }
}

