/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.bs.ml.LanguageInfo;
import com.kingdee.eas.bs.ml.MLFacadeFactory;
import com.kingdee.eas.bs.ml.MetaDataTypeEnum;
import com.kingdee.eas.bs.ml.PresetDataResInfo;
import com.kingdee.eas.bs.ml.client.AbstractMetaDataResourceImportUI;
import com.kingdee.eas.bs.ml.client.MetaDataResourceImportUI;
import com.kingdee.eas.bs.ml.client.ResourceExcelHelper;
import com.kingdee.eas.bs.ml.util.IProgTask;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.bs.ml.util.ProgDialog;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.FilesPathInfo;
import com.kingdee.eas.tools.datatask.ImportModeEnum;
import com.kingdee.eas.tools.datatask.client.FileSelector;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelDataReader;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class BizDataResourceImportUI
extends AbstractMetaDataResourceImportUI {
    private static final Logger logger = CoreUIObject.getLogger(MetaDataResourceImportUI.class);
    private boolean cancel = true;
    private HSSFWorkbook workbook;
    private int headRowNum = 2;
    LanguageInfo language = null;
    MetaDataTypeEnum metaType = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        if (this.getUIContext().get("language") != null && this.getUIContext().get("language") instanceof LanguageInfo) {
            this.language = (LanguageInfo)this.getUIContext().get("language");
        }
        this.prmpLanguage.setData((Object)this.language);
        this.kDLabelContainer3.hide();
        this.kDLabelContainer4.hide();
        this.prmpLanguage.setMyCommonUseEnabled(false);
        if (this.getUIContext().get("metaType") != null && this.getUIContext().get("metaType") instanceof MetaDataTypeEnum) {
            this.metaType = (MetaDataTypeEnum)((Object)this.getUIContext().get("metaType"));
        }
        this.combMetaType.setSelectedItem((Object)this.metaType);
        this.combImpType.addItem((Object)ImportModeEnum.ADDNEW);
        this.combImpType.addItem((Object)ImportModeEnum.OVERWRITE);
    }

    private void initUI() throws Exception {
        this.comboError.removeAllItems();
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnRightnow);
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenFinish);
        this.comboError.setSelectedIndex(0);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRefreshSheet.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        int sheetNum;
        HSSFSheet sheet;
        int rowNum;
        if (this.workbook == null) {
            return;
        }
        if (!this.checkFile()) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"12_ResourceImportUI"));
            this.txtFile.setText("");
            this.comboLabel.removeAllItems();
            SysUtil.abort();
        }
        if ((rowNum = (sheet = this.workbook.getSheetAt(sheetNum = this.comboLabel.getSelectedIndex())).getPhysicalNumberOfRows()) < 2) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"13_ResourceImportUI"));
            return;
        }
        boolean isUpdateAllWords = this.chkUpdate.isSelected();
        ErrorHandleModeEnum erorrHandleMode = (ErrorHandleModeEnum)this.comboError.getSelectedItem();
        HSSFRow headNumberRow = sheet.getRow(2);
        int cellCount = 0;
        if (headNumberRow != null) {
            cellCount = headNumberRow.getPhysicalNumberOfCells();
        }
        HSSFRow row = null;
        ArrayList<PresetDataResInfo> list = new ArrayList<PresetDataResInfo>();
        String cn = null;
        String zh_tw = null;
        String en_US = null;
        String CNMD5 = null;
        String id = null;
        for (int i = this.headRowNum; i < rowNum; ++i) {
            cn = null;
            zh_tw = null;
            en_US = null;
            CNMD5 = null;
            id = null;
            row = sheet.getRow(i);
            if (row == null || row.getPhysicalNumberOfCells() <= 0) continue;
            try {
                cn = ExcelUtil.getCellValue((HSSFCell)row.getCell(0));
                if (cn == null || cn.trim().length() == 0) continue;
                zh_tw = ExcelUtil.getCellValue((HSSFCell)row.getCell(1));
                en_US = ExcelUtil.getCellValue((HSSFCell)row.getCell(2));
                id = ExcelUtil.getCellValue((HSSFCell)row.getCell(3));
                CNMD5 = MLUtils.md5HashCode(cn);
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
                logger.error((Object)("reader excel on " + (i + 1) + " error!"));
                continue;
            }
            PresetDataResInfo info = new PresetDataResInfo();
            info.setText_zh_CN(cn);
            info.setText_zh_TW(zh_tw);
            info.setText_en_US(en_US);
            info.setMD5(CNMD5);
            info.setString("id", id);
            list.add(info);
        }
        LanguageInfo lo = (LanguageInfo)this.prmpLanguage.getData();
        if (lo == null) {
            return;
        }
        String lan = lo.getNumber();
        MetaDataTypeEnum type = (MetaDataTypeEnum)((Object)this.combMetaType.getSelectedItem());
        ImportModeEnum importMode = ImportModeEnum.OVERWRITE;
        boolean hasError = false;
        Map map = null;
        try {
            MyProgTask pt = new MyProgTask(list, isUpdateAllWords, erorrHandleMode.getValue(), lan, type, importMode);
            pt.show();
            map = pt.getResult();
            if (map != null && map.containsKey("hasError")) {
                hasError = (Boolean)map.get("hasError");
            }
        }
        catch (Exception e1) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"36_AttendanceDataImportUI"), (String)e1.getMessage(), (int)2);
            SysUtil.abort();
        }
        if (hasError) {
            if (map != null && map.containsKey("errorStr")) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"12_ResourceImportUI"), (String)map.get("errorStr").toString(), (int)2);
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"14_ResourceImportUI"));
        }
        this.getUIWindow().close();
    }

    public void actionOpen_actionPerformed(ActionEvent e) throws Exception {
        super.actionOpen_actionPerformed(e);
        String filePath = this.txtFile.getText();
        if (filePath == null || filePath.trim().length() <= 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"15_ResourceImportUI"));
            return;
        }
        if (this.tblMain.getRowCount() >= 0) {
            String str = filePath.substring(filePath.lastIndexOf("."));
            if (".xls".equals(str)) {
                this.initSheet();
                int sheetNum = this.comboLabel.getSelectedIndex();
                HSSFSheet sheet = this.workbook.getSheetAt(sheetNum);
                int rowNum = sheet.getPhysicalNumberOfRows();
                if (rowNum < 1) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"16_ResourceImportUI"));
                    this.txtFile.setText("");
                    this.comboLabel.removeAllItems();
                    SysUtil.abort();
                }
            } else {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"17_ResourceImportUI"));
                this.txtFile.setText("");
                this.comboLabel.removeAllItems();
                SysUtil.abort();
            }
        }
    }

    public void actionNo_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void btnExportTemplate_actionPerformed(ActionEvent e) throws Exception {
        FileSelector fselector = new FileSelector((Component)((Object)this), "SAVE");
        fselector.setDefFileName("bizDataResource.xls");
        fselector.show();
        if (fselector.isCanceled()) {
            return;
        }
        String expFilePath = fselector.getData().toString();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(expFilePath);
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFCellStyle nameCellStyle = ResourceExcelHelper.createNameCellStyle(wb);
            HSSFCellStyle codeCellStyle = ResourceExcelHelper.createCodeCellStyle(wb);
            HSSFSheet sheet = wb.createSheet();
            HSSFRow headRow = sheet.createRow(0);
            HSSFRow headRow2 = sheet.createRow(1);
            ResourceExcelHelper.createHeadCell(headRow, codeCellStyle, 0, "zh_CN");
            ResourceExcelHelper.createHeadCell(headRow2, nameCellStyle, 0, EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"5_MLClientUtils"));
            ResourceExcelHelper.createHeadCell(headRow, codeCellStyle, 1, "simplifiedForm");
            ResourceExcelHelper.createHeadCell(headRow2, nameCellStyle, 1, "\u7e41\u4f53");
            ResourceExcelHelper.createHeadCell(headRow, codeCellStyle, 2, "english");
            ResourceExcelHelper.createHeadCell(headRow2, nameCellStyle, 2, "\u82f1\u6587");
            ResourceExcelHelper.createHeadCell(headRow, codeCellStyle, 3, "id");
            ResourceExcelHelper.createHeadCell(headRow2, nameCellStyle, 3, "ID");
            sheet.setDefaultColumnWidth(20);
            wb.setSheetName(0, "bizDataRespurce");
            wb.write((OutputStream)out);
            out.flush();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"18_ResourceImportUI"));
        }
        catch (FileNotFoundException ex) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"10_ResourceExportUtil"));
            SysUtil.abort();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private boolean checkTemplate(String filePath) {
        String str = filePath.substring(filePath.lastIndexOf("."));
        if (!".xls".equals(str)) {
            return false;
        }
        try {
            this.initSheet();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        int sheetNum = this.comboLabel.getSelectedIndex();
        HSSFSheet sheet = this.workbook.getSheetAt(sheetNum);
        int rowNum = sheet.getPhysicalNumberOfRows();
        return rowNum >= 1;
    }

    private boolean checkFile() {
        int sheetNum = this.comboLabel.getSelectedIndex();
        if (sheetNum < 0) {
            return false;
        }
        if (this.workbook == null) {
            try {
                this.initSheet();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        HSSFSheet sheet = this.workbook.getSheetAt(sheetNum);
        return true;
    }

    private void initSheet() throws Exception {
        this.comboLabel.removeAllItems();
        FilesPathInfo paths = (FilesPathInfo)this.txtFile.getUserObject();
        String path = "";
        if (paths == null || paths.getFilePath() == null || paths.getFilePath().length <= 0) {
            return;
        }
        path = paths.getFilePath()[0];
        ExternalExcelDataReader reader = new ExternalExcelDataReader();
        ArrayList sheetNames = null;
        sheetNames = reader.getSheetNameCollection(path);
        KDTDefaultCellEditor itemEditor = null;
        KDComboBox comSheetNames = new KDComboBox();
        if (sheetNames != null) {
            int sheetCount = sheetNames.size();
            for (int i = 0; i < sheetCount; ++i) {
                comSheetNames.addItem(sheetNames.get(i));
                this.comboLabel.addItem(sheetNames.get(i));
            }
        }
        itemEditor = new KDTDefaultCellEditor((JComboBox)comSheetNames);
        this.tblMain.getColumn("excelTabName").setEditor((ICellEditor)itemEditor);
        this.comboLabel.addItemListener((ItemListener)new ItemListenerImpl());
        POIFSFileSystem pfs = new POIFSFileSystem((InputStream)new FileInputStream(path));
        this.workbook = new HSSFWorkbook(pfs);
        int size = this.workbook.getNumberOfSheets();
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }

    private class ItemListenerImpl
    implements ItemListener {
        private ItemListenerImpl() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object obj = BizDataResourceImportUI.this.comboLabel.getSelectedItem();
            if (obj != null) {
                ICell cell = BizDataResourceImportUI.this.tblMain.getCell(0, "excelTabName");
                cell.setValue((Object)obj.toString());
            }
        }
    }

    public class MyProgTask
    implements IProgTask {
        private List list;
        private boolean isUpdateAllWords;
        private int erorrHandleMode;
        private String language;
        private MetaDataTypeEnum type;
        private Map reuslt;
        private ImportModeEnum importMode;

        public MyProgTask(List list, boolean isUpdateAllWords, int erorrHandleMode, String language, MetaDataTypeEnum type, ImportModeEnum importMode) {
            this.list = list;
            this.isUpdateAllWords = isUpdateAllWords;
            this.erorrHandleMode = erorrHandleMode;
            this.language = language;
            this.type = type;
            this.importMode = importMode;
        }

        @Override
        public Object exec() throws Exception {
            this.reuslt = MLFacadeFactory.getRemoteInstance().importBizTableData(this.list, this.erorrHandleMode, this.importMode);
            return "";
        }

        @Override
        public void afterExec(Object result) throws Exception {
        }

        public void show() {
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)BizDataResourceImportUI.this));
            ProgDialog dialog = null;
            if (win instanceof Frame) {
                dialog = new ProgDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new ProgDialog((Dialog)win);
            }
            dialog.setLongTimeTask(this);
            dialog.show();
        }

        public Map getResult() {
            return this.reuslt;
        }
    }
}

