/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.ResourceListener;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.bs.ml.MLFacadeFactory;
import com.kingdee.eas.bs.ml.ResourceFacadeFactory;
import com.kingdee.eas.bs.ml.client.ResourceClientCache;
import com.kingdee.eas.bs.ml.util.EASResourceListenerHelper;
import com.kingdee.eas.bs.ml.util.MLConstonts;
import com.kingdee.eas.bs.ml.util.MLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class EASResourceListenerClient
implements ResourceListener {
    private static final Logger logger = Logger.getLogger(EASResourceListenerClient.class);
    private static final ResourceClientCache cache = ResourceClientCache.getInstance();
    private static final Map dc = new HashMap(10, 0.75f);
    private static final String CACHE_TIMESTAMP_FILE_NAME = "multiLanguageCacheTimestamp.properties";
    private static String multiLanguageServerCacheTimestamp = null;

    public void deploy(IMetaDataPK arg0, BOSObjectType arg1, LanguageInfo arg2, Map arg3) {
    }

    public void deploy(IMetaDataPK arg0, BOSObjectType arg1, LanguageInfo arg2, String arg3, String arg4, boolean arg5) {
    }

    public static boolean getDcList(String ais) {
        return (Boolean)dc.get(ais);
    }

    public static void clearDcList() {
        dc.clear();
    }

    public String getString(IMetaDataPK mdPK, BOSObjectType bosType, LanguageInfo lgInfo, String key, Context ctx) {
        String metaType;
        if (mdPK == null || key == null || lgInfo == null || ctx == null) {
            return null;
        }
        String lan = lgInfo.getLocaleString();
        String ais = ctx.getAIS();
        Boolean b = (Boolean)dc.get(ais);
        if (b == null) {
            try {
                b = new Boolean(ResourceFacadeFactory.getRemoteInstance().checkExistInitMLDB());
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), e.getCause());
                b = Boolean.FALSE;
            }
            dc.put(ais, b);
        }
        if (b != null && !b.booleanValue()) {
            return "";
        }
        String name = mdPK.getName();
        if (name == null) {
            return null;
        }
        String pkg = mdPK.getPackage();
        if (pkg != null) {
            pkg = pkg.replaceAll("\\.", "\\\\");
        }
        if ((metaType = EASResourceListenerHelper.getMetaDataType(bosType)) == null) {
            return null;
        }
        if ("entity".equals(metaType) || "query".equals(metaType)) {
            key = key.substring(key.indexOf("].") + 2, key.length());
        }
        if (("enum".equals(metaType) || "exception".equals(metaType) || "mdbview".equals(metaType)) && key.lastIndexOf(91) > 0 && key.lastIndexOf(93) > 0) {
            key = key.substring(key.lastIndexOf(91) + 1, key.lastIndexOf(93));
        }
        if ("ui".equals(metaType) && name.startsWith("Abstract")) {
            name = name.substring(8, name.length());
            if (key.endsWith(".formatXml") && !"ListUI".equals(name)) {
                return this.getFormatXml(ais, mdPK, pkg, name, metaType, lan, key);
            }
        }
        String ck = EASResourceListenerHelper.generateCacheKey(ais, name, pkg, metaType, lan);
        Map map = null;
        if (cache.contains(ck)) {
            map = (Map)cache.get(ck);
        } else {
            map = this.loadFromCacheFile(ais, pkg, name, lan, metaType);
            cache.put(ck, map);
        }
        if (map != null && map.containsKey(key)) {
            Object vl = map.get(key);
            if (vl != null) {
                return vl.toString();
            }
            return "";
        }
        return "";
    }

    private Map loadFromCacheFile(String ais, String pkg, String name, String lan, String metaType) {
        if (multiLanguageServerCacheTimestamp == null) {
            this.updateLocalCacheTime(ais, lan);
        }
        try {
            File file = this.getCachedFile(ais, pkg, name, lan, metaType);
            if (file != null && file.exists()) {
                return this.getResourceFromFile(file);
            }
            return this.loadFromServerAndRewriteFile(ais, pkg, name, lan, metaType);
        }
        catch (Exception e) {
            logger.error((Object)("Resource get Error :" + pkg + name + lan + metaType));
            logger.error((Object)e.getMessage());
            return null;
        }
    }

    private Map loadFromServerAndRewriteFile(String ais, String pkg, String name, String lan, String metaType) {
        Map result = null;
        try {
            result = this.loadFromServer(pkg, name, lan, metaType);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.rewriteCacheFile(ais, pkg, name, lan, metaType, result);
        return result;
    }

    private void rewriteCacheFile(String ais, String pkg, String name, String lan, String metaType, Map result) {
        if (result != null) {
            CacheResourceThread t = new CacheResourceThread(ais, pkg, name, lan, metaType, result);
            t.setDaemon(true);
            t.start();
        }
    }

    private Map loadFromServer(String pkg, String name, String lan, String metaType) throws BOSException {
        return ResourceFacadeFactory.getRemoteInstance().getFileResource(pkg, name, lan, metaType);
    }

    private void updateLocalCacheTime(String ais, String lan) {
        File cacheDirec = EASResourceListenerHelper.getCacheDictionary(ais, lan);
        if (cacheDirec != null && !cacheDirec.exists()) {
            return;
        }
        String fileName = cacheDirec.getPath() + File.separator + CACHE_TIMESTAMP_FILE_NAME;
        Properties prop = this.loadCacheTimeFile(fileName);
        String cacheTime = this.getLocalCacheTime(prop);
        this.initServerTimestamp();
        if (null == multiLanguageServerCacheTimestamp || multiLanguageServerCacheTimestamp != null && !cacheTime.equals(multiLanguageServerCacheTimestamp)) {
            this.setServerTimestampToCacheFile(fileName, prop);
            this.removeAllPropertyFiles(cacheDirec);
        }
    }

    private void removeAllPropertyFiles(File cacheDirec) {
        long time = System.currentTimeMillis();
        logger.info((Object)"removeAllPropertyFiles begin----------");
        if (!cacheDirec.exists() || !cacheDirec.isDirectory()) {
            return;
        }
        File[] tempList = cacheDirec.listFiles();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = tempList[i];
            if (temp.isFile() && !temp.getPath().endsWith(CACHE_TIMESTAMP_FILE_NAME)) {
                temp.delete();
                continue;
            }
            if (!temp.isDirectory()) continue;
            this.removeAllPropertyFiles(temp);
        }
        logger.info((Object)("removeAllPropertyFiles end----------cost:" + (System.currentTimeMillis() - time)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setServerTimestampToCacheFile(String fileName, Properties prop) {
        if (multiLanguageServerCacheTimestamp == null) {
            logger.warn((Object)"multiLanguageServerCacheTimestamp is null.");
            return;
        }
        prop.setProperty("multiLanguageCacheTimestamp", multiLanguageServerCacheTimestamp);
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fos = null;
        try {
            file.createNewFile();
            File file2 = file;
            synchronized (file2) {
                fos = new FileOutputStream(file);
                prop.store(fos, null);
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void initServerTimestamp() {
        try {
            multiLanguageServerCacheTimestamp = MLFacadeFactory.getRemoteInstance().getServerCacheTime();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private String getLocalCacheTime(Properties prop) {
        return prop.getProperty("multiLanguageCacheTimestamp") == null ? "" : prop.getProperty("multiLanguageCacheTimestamp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadCacheTimeFile(String fileName) {
        Properties prop = new Properties();
        FileInputStream inputStream = null;
        File cacheTimeFile = new File(fileName);
        try {
            if (!cacheTimeFile.exists()) {
                cacheTimeFile.createNewFile();
            }
            inputStream = new FileInputStream(cacheTimeFile);
            prop.load(inputStream);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return prop;
    }

    private String getFormatXml(String ais, IMetaDataPK mdPK, String pkg, String name, String metaType, String lan, String key) {
        String tabName = key.substring(0, key.lastIndexOf("."));
        String formatXml = MLUtils.getStringFromFile(mdPK.getPackage() + "." + mdPK.getName(), Locale.SIMPLIFIED_CHINESE, key);
        if (formatXml == null || formatXml.trim().length() <= 0) {
            return "";
        }
        if ("zh_CN".equals(lan)) {
            return formatXml;
        }
        if ("zh_TW".equals(lan)) {
            return MLUtils.getStringFromFile(mdPK.getPackage() + "." + mdPK.getName(), Locale.TRADITIONAL_CHINESE, key);
        }
        String tabXMLCk = lan + pkg + name + "_" + tabName + ".xml";
        if (cache.contains(tabXMLCk)) {
            return cache.get(tabXMLCk).toString();
        }
        String ck = EASResourceListenerHelper.generateCacheKey(ais, name, pkg, metaType, lan);
        Map map = null;
        try {
            if (cache.contains(ck)) {
                map = (Map)cache.get(ck);
            } else {
                File file = this.getCachedFile(ais, pkg, name, lan, metaType);
                if (file != null && file.exists()) {
                    map = this.getResourceFromFile(file);
                } else {
                    map = ResourceFacadeFactory.getRemoteInstance().getFileResource(pkg, name, lan, metaType);
                    if (map != null) {
                        CacheResourceThread t = new CacheResourceThread(ais, pkg, name, lan, metaType, map);
                        t.start();
                    }
                }
                cache.put(ck, map);
            }
            String parsedFormatXml = this.parseFormatXml(formatXml, map, tabName);
            if (parsedFormatXml != null) {
                formatXml = parsedFormatXml;
                cache.put(tabXMLCk, formatXml);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Resource get Error :" + pkg + name + lan + metaType));
            logger.error((Object)e.getMessage());
        }
        return formatXml;
    }

    private String parseFormatXml(String formatXml, Map uiResMap, String tabName) throws Exception {
        if (tabName == null || formatXml == null || uiResMap == null) {
            return null;
        }
        SAXReader reader = new SAXReader();
        StringReader in = new StringReader(formatXml);
        Document doc = reader.read((Reader)in);
        String colPath = "//*[name() = 'Table']/*[name() = 't:Sheet']/*[name() = 't:Table']/*[name() = 't:ColumnGroup']/*[name() = 't:Column']";
        List colList = doc.selectNodes(colPath);
        ArrayList<String> keyList = new ArrayList<String>();
        int j = colList.size();
        for (int i = 0; i < j; ++i) {
            Element el = (Element)colList.get(i);
            keyList.add(el.attribute("key").getValue());
        }
        String headRowPath = "//*[name() = 't:Head']/*[name() = 't:Row']";
        List rowList = doc.selectNodes(headRowPath);
        String prefix = tabName + ".";
        for (int i = 0; i < rowList.size(); ++i) {
            Element rowEl = (Element)rowList.get(i);
            List cells = rowEl.elements();
            if (cells.size() > keyList.size()) continue;
            int n = cells.size();
            for (int m = 0; m < n; ++m) {
                Element cellEl = (Element)cells.get(m);
                String colKey = keyList.get(m) + "";
                String resKey = prefix + keyList.get(m);
                if (i > 0) {
                    resKey = resKey + MLConstonts.TABLE_MULTI_HEADER + (i + 1);
                }
                if (uiResMap.containsKey(resKey)) {
                    Object obj = uiResMap.get(resKey);
                    if (obj != null && obj.toString().trim().length() > 0 && !MLUtils.containChinese(obj.toString())) {
                        cellEl.setText(uiResMap.get(resKey).toString());
                        continue;
                    }
                    cellEl.setText(colKey);
                    continue;
                }
                cellEl.setText(colKey);
            }
        }
        return doc.asXML();
    }

    private Map getResourceFromFile(File resFile) throws FileNotFoundException, IOException {
        if (resFile == null || !resFile.exists()) {
            return Collections.EMPTY_MAP;
        }
        Properties prop = new Properties();
        prop.load(new FileInputStream(resFile));
        Enumeration<Object> em = prop.keys();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        while (em.hasMoreElements()) {
            Object key = em.nextElement();
            if (key == null) continue;
            map.put(key, prop.get(key));
        }
        return map;
    }

    private File getCachedFile(String ais, String pkg, String name, String lan, String metaType) {
        if (ais == null || pkg == null || name == null || lan == null || metaType == null) {
            return null;
        }
        File resDic = EASResourceListenerHelper.getCacheDictionary(ais, lan);
        if (resDic == null || !resDic.exists()) {
            return null;
        }
        File resFile = EASResourceListenerHelper.getCacheFile(resDic.getPath(), pkg, name, metaType, lan);
        if (resFile != null && resFile.exists()) {
            return resFile;
        }
        logger.info((Object)("resFile path: " + resFile.getPath()));
        return null;
    }

    public Map getRemoteWebResource(String packageName, String resFileName, Locale lc) {
        try {
            return EASResourceListenerHelper.getWebResource(packageName, resFileName, lc);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return null;
        }
    }

    public String getDefaultAis() {
        return null;
    }

    public Map getRemoteWebPageResource(String packageName, String resFileName, Locale lc) {
        try {
            return EASResourceListenerHelper.getWebResource(packageName, resFileName, lc);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return null;
        }
    }

    private static class CacheResourceThread
    extends Thread {
        private String ais;
        private String pkg;
        private String name;
        private String lan;
        private String metaType;
        private Map map;

        public CacheResourceThread(String ais, String pkg, String name, String lan, String metaType, Map map) {
            this.ais = ais;
            this.pkg = pkg;
            this.name = name;
            this.lan = lan;
            this.metaType = metaType;
            this.map = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.ais == null || this.pkg == null || this.name == null || this.lan == null || this.metaType == null || this.map == null) {
                return;
            }
            OutputStream out = null;
            try {
                File resFile;
                File resDic = EASResourceListenerHelper.getCacheDictionary(this.ais, this.lan);
                if (!resDic.exists()) {
                    resDic.mkdirs();
                }
                if (!(resFile = EASResourceListenerHelper.getCacheFile(resDic.getPath(), this.pkg, this.name, this.metaType, this.lan)).exists()) {
                    resFile.createNewFile();
                }
                Properties prop = new Properties();
                Set set = this.map.entrySet();
                for (Map.Entry entry : set) {
                    if (entry.getKey() == null) continue;
                    if (entry.getValue() == null) {
                        prop.put(entry.getKey(), "");
                        continue;
                    }
                    prop.put(entry.getKey(), entry.getValue());
                }
                out = new FileOutputStream(resFile);
                prop.store(out, null);
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
            }
            finally {
                if (out != null) {
                    try {
                        out.flush();
                        ((FileOutputStream)out).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

