/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.bs.ml.MLToolsFacadeFactory;
import com.kingdee.eas.bs.ml.ResourceFacadeFactory;
import com.kingdee.eas.bs.ml.client.AbstractFetchMetasWordsUI;
import com.kingdee.eas.bs.ml.client.ResourceClientCache;
import com.kingdee.eas.bs.ml.client.tools.FetchDEPInfoUtil;
import com.kingdee.eas.bs.ml.client.tools.FetchWordsFromJarOrFileUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class FetchMetasWordsUI
extends AbstractFetchMetasWordsUI {
    private static final Logger logger = CoreUIObject.getLogger(FetchMetasWordsUI.class);
    private List suffixList = new ArrayList();

    public void onLoad() throws Exception {
        super.onLoad();
        this.suffixList.add("query");
        this.suffixList.add("entity");
        this.suffixList.add("resource");
        this.suffixList.add("ui");
        this.suffixList.add("enum");
        this.suffixList.add("exception");
        this.suffixList.add("permission");
        this.suffixList.add("jar");
        this.btnDep.setEnabled(true);
        this.btnRestore.setEnabled(true);
        this.btnMetas.addActionListener((ActionListener)new ActionItemListenerImpl());
        this.btnDep.addActionListener((ActionListener)new ActionItemListenerImpl());
        this.txtFile.setRequired(true);
        this.btnOpen.addActionListener((ActionListener)new ActionListenerImpl());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.btnMetas.isSelected()) {
            String file = this.txtFile.getText();
            this.verifyInput(file);
            FetchWordsFromJarOrFileUtil util = new FetchWordsFromJarOrFileUtil();
            util.setRootPath(this.txtFile.getText());
            try {
                util.start();
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"2_FetchMetasWordsUI"));
            }
            catch (Exception ex) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"3_FetchMetasWordsUI"), (String)ex.getMessage(), (int)0);
                logger.error((Object)ex);
            }
        } else {
            FetchDEPInfoUtil deputil = new FetchDEPInfoUtil();
            deputil.parseDepSegment("ui");
        }
        String ais = SysContext.getSysContext().getDCNumber();
        String fileSepa = System.getProperty("file.separator");
        String dic = System.getProperty("user.dir") + fileSepa + "cache" + fileSepa + "EASResourceCache" + fileSepa + ais;
        this.deleteResFile(new File(dic));
        ResourceClientCache.getInstance().clearCache();
        ResourceFacadeFactory.getRemoteInstance().clearResourceCache();
    }

    private void deleteResFile(File dir) {
        if (dir == null || !dir.exists()) {
            return;
        }
        File[] arr = dir.listFiles();
        for (int i = 0; i < arr.length; ++i) {
            File f = arr[i];
            if (f.isDirectory()) {
                this.deleteResFile(f);
                continue;
            }
            try {
                f.delete();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void actionRestore_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.btnRestore.setEnabled(false);
            MLToolsFacadeFactory.getRemoteInstance().updateResourceDaomin();
            this.btnRestore.setEnabled(true);
            MsgBox.showConfirm2((String)"update Domain success\uff01");
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
            this.btnRestore.setEnabled(true);
            MsgBox.showConfirm2((String)("update Domain failure\uff01" + ex.getMessage()));
        }
    }

    private void verifyInput(String file) {
        int idx;
        if (file == null || file.trim().length() <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"4_FetchMetasWordsUI"));
            this.txtFile.requestFocus();
            SysUtil.abort();
        }
        if ((idx = file.lastIndexOf(".")) >= 0) {
            if (!this.suffixList.contains(file.substring(idx + 1).toLowerCase())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"4_FetchMetasWordsUI"));
                this.txtFile.requestFocus();
                SysUtil.abort();
            }
        } else if (!new File(file).exists()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"4_FetchMetasWordsUI"));
            this.txtFile.requestFocus();
            SysUtil.abort();
        }
    }

    class LogFileFilter
    extends FileFilter {
        LogFileFilter() {
        }

        @Override
        public String getDescription() {
            return "*.log";
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return name.toLowerCase().endsWith(".log");
        }
    }

    class PermFileFilter
    extends FileFilter {
        PermFileFilter() {
        }

        @Override
        public String getDescription() {
            return "*.permission";
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return name.toLowerCase().endsWith(".permission");
        }
    }

    class TableFileFilter
    extends FileFilter {
        TableFileFilter() {
        }

        @Override
        public String getDescription() {
            return "*.table";
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return name.toLowerCase().endsWith(".table");
        }
    }

    class QueryFileFilter
    extends FileFilter {
        QueryFileFilter() {
        }

        @Override
        public String getDescription() {
            return "*.query";
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return name.toLowerCase().endsWith(".query");
        }
    }

    class EntityFileFilter
    extends FileFilter {
        EntityFileFilter() {
        }

        @Override
        public String getDescription() {
            return "*.entity";
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return name.toLowerCase().endsWith(".entity");
        }
    }

    class ExceptionFileFilter
    extends FileFilter {
        ExceptionFileFilter() {
        }

        @Override
        public String getDescription() {
            return "*.exception";
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return name.toLowerCase().endsWith(".exception");
        }
    }

    class EnumFileFilter
    extends FileFilter {
        EnumFileFilter() {
        }

        @Override
        public String getDescription() {
            return "*.enum";
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return name.toLowerCase().endsWith(".enum");
        }
    }

    class ResFileFilter
    extends FileFilter {
        ResFileFilter() {
        }

        @Override
        public String getDescription() {
            return "*.Resource";
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return name.toLowerCase().endsWith(".resource");
        }
    }

    class UIFileFilter
    extends FileFilter {
        UIFileFilter() {
        }

        @Override
        public String getDescription() {
            return "*.UI";
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return name.toLowerCase().endsWith(".ui");
        }
    }

    private class ChooseFileImpl
    extends FileFilter {
        private ChooseFileImpl() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String str = file.getName();
            int idx = str.lastIndexOf(46);
            if (idx < 0) {
                return false;
            }
            String suffix = str.substring(idx + 1);
            return FetchMetasWordsUI.this.suffixList.contains(suffix);
        }

        @Override
        public String getDescription() {
            return "all";
        }
    }

    private class ActionItemListenerImpl
    implements ActionListener {
        private ActionItemListenerImpl() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!FetchMetasWordsUI.this.btnMetas.isSelected()) {
                FetchMetasWordsUI.this.contFile.setVisible(false);
                FetchMetasWordsUI.this.btnOpen.setVisible(false);
                FetchMetasWordsUI.this.labDesc.setVisible(false);
                FetchMetasWordsUI.this.kDSeparator2.setVisible(false);
                FetchMetasWordsUI.this.btnRestore.setBounds(new Rectangle(95, 80, 92, 21));
                FetchMetasWordsUI.this.add((Component)FetchMetasWordsUI.this.btnRestore, null);
                FetchMetasWordsUI.this.btConfirm.setBounds(new Rectangle(207, 80, 73, 21));
                FetchMetasWordsUI.this.add((Component)FetchMetasWordsUI.this.btConfirm, null);
                FetchMetasWordsUI.this.btnCancel.setBounds(new Rectangle(303, 80, 73, 21));
                FetchMetasWordsUI.this.add((Component)FetchMetasWordsUI.this.btnCancel, null);
            } else {
                FetchMetasWordsUI.this.contFile.setVisible(true);
                FetchMetasWordsUI.this.btnOpen.setVisible(true);
                FetchMetasWordsUI.this.labDesc.setVisible(true);
                FetchMetasWordsUI.this.kDSeparator2.setVisible(true);
                FetchMetasWordsUI.this.btnRestore.setBounds(new Rectangle(95, 143, 92, 21));
                FetchMetasWordsUI.this.add((Component)FetchMetasWordsUI.this.btnRestore, null);
                FetchMetasWordsUI.this.btConfirm.setBounds(new Rectangle(207, 143, 73, 21));
                FetchMetasWordsUI.this.add((Component)FetchMetasWordsUI.this.btConfirm, null);
                FetchMetasWordsUI.this.btnCancel.setBounds(new Rectangle(303, 143, 73, 21));
                FetchMetasWordsUI.this.add((Component)FetchMetasWordsUI.this.btnCancel, null);
            }
        }
    }

    private class ActionListenerImpl
    implements ActionListener {
        private ActionListenerImpl() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KDFileChooser fc = new KDFileChooser(".");
            fc.setFileSelectionMode(2);
            fc.setAcceptAllFileFilterUsed(false);
            fc.addChoosableFileFilter((FileFilter)new UIFileFilter());
            fc.addChoosableFileFilter((FileFilter)new ResFileFilter());
            fc.addChoosableFileFilter((FileFilter)new EnumFileFilter());
            fc.addChoosableFileFilter((FileFilter)new ExceptionFileFilter());
            fc.addChoosableFileFilter((FileFilter)new EntityFileFilter());
            fc.addChoosableFileFilter((FileFilter)new QueryFileFilter());
            fc.addChoosableFileFilter((FileFilter)new PermFileFilter());
            fc.setFileFilter((FileFilter)new ChooseFileImpl());
            int returnVal = fc.showOpenDialog((Component)((Object)FetchMetasWordsUI.this));
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                String path = file.getPath().trim();
                FetchMetasWordsUI.this.txtFile.setText(path);
            }
        }
    }
}

