/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.bs.ml.EASResourceDomainCollection;
import com.kingdee.eas.bs.ml.MLToolsFacadeFactory;
import com.kingdee.eas.bs.ml.client.AbstractFetchResourceUI;
import com.kingdee.eas.bs.ml.client.tools.FetchDEPInfoUtil;
import com.kingdee.eas.bs.ml.client.tools.FetchWordsFromJarOrFileUtil;
import com.kingdee.eas.bs.ml.util.SelectBizF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class FetchResourceUI
extends AbstractFetchResourceUI {
    private static final Logger logger = CoreUIObject.getLogger(FetchResourceUI.class);
    private List suffixList = new ArrayList();

    public void onLoad() throws Exception {
        super.onLoad();
        this.suffixList.add("query");
        this.suffixList.add("entity");
        this.suffixList.add("resource");
        this.suffixList.add("ui");
        this.suffixList.add("enum");
        this.suffixList.add("exception");
        this.suffixList.add("permission");
        this.suffixList.add("jar");
        this.prmtDomainF7.setSelector((KDPromptSelector)new SelectBizF7((Component)((Object)this)));
        this.prmtDomainF7.setEditable(false);
        this.prmtDomainF7.setEnabled(true);
        this.txtFile.setEditable(false);
        this.btnSelectFile.setEnabled(false);
        this.chkMenu.setEnabled(false);
        this.chkPresetData.setEnabled(false);
        this.chkWorkFlow.setEnabled(false);
        this.chkPrintTemplate.setEnabled(false);
        this.btnFetchDataConf.setEnabled(false);
        Locale locale = SysContext.getSysContext().getOriginLocale();
        if (locale != null && !"zh_CN".equalsIgnoreCase(locale.toString())) {
            this.rbtnDomain.setSelected(false);
            this.rbtnDomain.setEnabled(false);
            this.prmtDomainF7.setEnabled(false);
            this.rbtnMetaData.setSelected(true);
            this.txtFile.setEditable(true);
            this.btnSelectFile.setEnabled(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnSelectFile_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectFile_actionPerformed(e);
        KDFileChooser fc = new KDFileChooser(".");
        fc.setFileSelectionMode(2);
        fc.setAcceptAllFileFilterUsed(false);
        fc.addChoosableFileFilter((FileFilter)new UIFileFilter());
        fc.addChoosableFileFilter((FileFilter)new ResFileFilter());
        fc.addChoosableFileFilter((FileFilter)new EnumFileFilter());
        fc.addChoosableFileFilter((FileFilter)new ExceptionFileFilter());
        fc.addChoosableFileFilter((FileFilter)new EntityFileFilter());
        fc.addChoosableFileFilter((FileFilter)new QueryFileFilter());
        fc.addChoosableFileFilter((FileFilter)new PermFileFilter());
        fc.setFileFilter((FileFilter)new ChooseFileImpl());
        int returnVal = fc.showOpenDialog((Component)((Object)this));
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            String path = file.getPath().trim();
            this.txtFile.setText(path);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        try {
            if (this.rbtnMetaData.isSelected()) {
                String file = this.txtFile.getText();
                this.verifyInput(file);
                FetchWordsFromJarOrFileUtil util = new FetchWordsFromJarOrFileUtil();
                util.setRootPath(this.txtFile.getText());
                util.start();
            } else if (this.rbtnDep.isSelected()) {
                FetchDEPInfoUtil deputil = new FetchDEPInfoUtil();
                deputil.parseDepSegment("ui");
            } else if (this.rbtnDomain.isSelected()) {
                EASResourceDomainCollection domainCollection = null;
                if (this.prmtDomainF7.getData() == null || !(this.prmtDomainF7.getData() instanceof EASResourceDomainCollection) || ((EASResourceDomainCollection)((Object)this.prmtDomainF7.getData())).size() == 0) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.EASResourceResource", (String)"SELECT_MODEL"));
                    SysUtil.abort();
                }
                domainCollection = (EASResourceDomainCollection)((Object)this.prmtDomainF7.getData());
                MLToolsFacadeFactory.getRemoteInstance().fetchDomainResource(domainCollection);
                if (this.prmtDomainF7.getData() != null && !(this.prmtDomainF7.getData() instanceof EASResourceDomainCollection)) {
                    // empty if block
                }
            } else if (this.rbtnData.isSelected()) {
                boolean isFetchMenuResource = this.chkMenu.isSelected();
                boolean isFetchPresetDataResource = this.chkPresetData.isSelected();
                boolean isFetchWorkFlowResource = this.chkWorkFlow.isSelected();
                boolean isFetchPrintTemplateResource = this.chkPrintTemplate.isSelected();
                if (!(isFetchMenuResource || isFetchPresetDataResource || isFetchWorkFlowResource || isFetchPrintTemplateResource)) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"SelectFetchDataType"));
                    SysUtil.abort();
                }
                MLToolsFacadeFactory.getRemoteInstance().fetchDataResource(isFetchMenuResource, isFetchPresetDataResource, isFetchWorkFlowResource, isFetchPrintTemplateResource);
            }
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"2_FetchMetasWordsUI"));
            return;
        }
        catch (AbortException isFetchMenuResource) {
            return;
        }
        catch (Exception ex) {
            if (this.rbtnData.isSelected() && this.chkPresetData.isSelected()) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"fetchResourcePartFailed"), (String)ex.getMessage(), (int)0);
                logger.error((Object)ex);
                return;
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"3_FetchMetasWordsUI"), (String)ex.getMessage(), (int)0);
            logger.error((Object)ex);
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void rbtnMetaData_actionPerformed(ActionEvent e) throws Exception {
        super.rbtnMetaData_actionPerformed(e);
        this.prmtDomainF7.setEnabled(false);
        this.txtFile.setEditable(true);
        this.btnSelectFile.setEnabled(true);
        this.chkMenu.setSelected(false);
        this.chkMenu.setEnabled(false);
        this.chkPresetData.setSelected(false);
        this.chkPresetData.setEnabled(false);
        this.chkWorkFlow.setSelected(false);
        this.chkWorkFlow.setEnabled(false);
        this.chkPrintTemplate.setSelected(false);
        this.chkPrintTemplate.setEnabled(false);
        this.btnFetchDataConf.setEnabled(false);
    }

    @Override
    protected void rbtnDep_actionPerformed(ActionEvent e) throws Exception {
        super.rbtnDep_actionPerformed(e);
        this.prmtDomainF7.setEnabled(false);
        this.txtFile.setEditable(false);
        this.btnSelectFile.setEnabled(false);
        this.chkMenu.setSelected(false);
        this.chkMenu.setEnabled(false);
        this.chkPresetData.setSelected(false);
        this.chkPresetData.setEnabled(false);
        this.chkWorkFlow.setSelected(false);
        this.chkWorkFlow.setEnabled(false);
        this.chkPrintTemplate.setSelected(false);
        this.chkPrintTemplate.setEnabled(false);
        this.btnFetchDataConf.setEnabled(false);
    }

    @Override
    protected void rbtnData_actionPerformed(ActionEvent e) throws Exception {
        super.rbtnData_actionPerformed(e);
        this.prmtDomainF7.setEnabled(false);
        this.txtFile.setEditable(false);
        this.btnSelectFile.setEnabled(false);
        this.chkMenu.setEnabled(true);
        this.chkPresetData.setEnabled(true);
        this.chkWorkFlow.setEnabled(true);
        this.chkPrintTemplate.setEnabled(true);
        this.btnFetchDataConf.setEnabled(true);
    }

    @Override
    protected void rbtnDomain_actionPerformed(ActionEvent e) throws Exception {
        super.rbtnDomain_actionPerformed(e);
        this.prmtDomainF7.setEnabled(true);
        this.txtFile.setEditable(false);
        this.btnSelectFile.setEnabled(false);
        this.chkMenu.setSelected(false);
        this.chkMenu.setEnabled(false);
        this.chkPresetData.setSelected(false);
        this.chkPresetData.setEnabled(false);
        this.chkWorkFlow.setSelected(false);
        this.chkWorkFlow.setEnabled(false);
        this.chkPrintTemplate.setSelected(false);
        this.chkPrintTemplate.setEnabled(false);
        this.btnFetchDataConf.setEnabled(false);
    }

    @Override
    protected void btnFetchDataConf_actionPerformed(ActionEvent e) throws Exception {
        super.btnFetchDataConf_actionPerformed(e);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
        UIContext uiCtx = new UIContext((Object)this);
        IUIWindow uiWin = uiFactory.create("com.kingdee.eas.bs.ml.client.MultiFieldMetaListUI", (Map)uiCtx);
        uiWin.show();
    }

    private void verifyInput(String file) {
        int idx;
        if (file == null || file.trim().length() <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"4_FetchMetasWordsUI"));
            this.txtFile.requestFocus();
            SysUtil.abort();
        }
        if ((idx = file.lastIndexOf(".")) >= 0) {
            if (!this.suffixList.contains(file.substring(idx + 1).toLowerCase())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"4_FetchMetasWordsUI"));
                this.txtFile.requestFocus();
                SysUtil.abort();
            }
        } else if (!new File(file).exists()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"4_FetchMetasWordsUI"));
            this.txtFile.requestFocus();
            SysUtil.abort();
        }
    }

    class LogFileFilter
    extends FileFilter {
        LogFileFilter() {
        }

        @Override
        public String getDescription() {
            return "*.log";
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return name.toLowerCase().endsWith(".log");
        }
    }

    class PermFileFilter
    extends FileFilter {
        PermFileFilter() {
        }

        @Override
        public String getDescription() {
            return "*.permission";
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return name.toLowerCase().endsWith(".permission");
        }
    }

    class TableFileFilter
    extends FileFilter {
        TableFileFilter() {
        }

        @Override
        public String getDescription() {
            return "*.table";
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return name.toLowerCase().endsWith(".table");
        }
    }

    class QueryFileFilter
    extends FileFilter {
        QueryFileFilter() {
        }

        @Override
        public String getDescription() {
            return "*.query";
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return name.toLowerCase().endsWith(".query");
        }
    }

    class EntityFileFilter
    extends FileFilter {
        EntityFileFilter() {
        }

        @Override
        public String getDescription() {
            return "*.entity";
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return name.toLowerCase().endsWith(".entity");
        }
    }

    class ExceptionFileFilter
    extends FileFilter {
        ExceptionFileFilter() {
        }

        @Override
        public String getDescription() {
            return "*.exception";
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return name.toLowerCase().endsWith(".exception");
        }
    }

    class EnumFileFilter
    extends FileFilter {
        EnumFileFilter() {
        }

        @Override
        public String getDescription() {
            return "*.enum";
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return name.toLowerCase().endsWith(".enum");
        }
    }

    class ResFileFilter
    extends FileFilter {
        ResFileFilter() {
        }

        @Override
        public String getDescription() {
            return "*.Resource";
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return name.toLowerCase().endsWith(".resource");
        }
    }

    class UIFileFilter
    extends FileFilter {
        UIFileFilter() {
        }

        @Override
        public String getDescription() {
            return "*.UI";
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return name.toLowerCase().endsWith(".ui");
        }
    }

    private class ChooseFileImpl
    extends FileFilter {
        private ChooseFileImpl() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String str = file.getName();
            int idx = str.lastIndexOf(46);
            if (idx < 0) {
                return false;
            }
            String suffix = str.substring(idx + 1);
            return FetchResourceUI.this.suffixList.contains(suffix);
        }

        @Override
        public String getDescription() {
            return "all";
        }
    }
}

