/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.bs.ml.ILanguage;
import com.kingdee.eas.bs.ml.LanguageCollection;
import com.kingdee.eas.bs.ml.LanguageFactory;
import com.kingdee.eas.bs.ml.LanguageInfo;
import com.kingdee.eas.bs.ml.MLFacadeFactory;
import com.kingdee.eas.bs.ml.MdbviewMultiLanCollection;
import com.kingdee.eas.bs.ml.MdbviewMultiLanInfo;
import com.kingdee.eas.bs.ml.MdbviewResourceFactory;
import com.kingdee.eas.bs.ml.MdbviewResourceInfo;
import com.kingdee.eas.bs.ml.client.AbstractMDBViewMultiLanEditUI;
import com.kingdee.eas.bs.ml.client.MLClientUtils;
import com.kingdee.eas.bs.ml.client.TextPaneHelper;
import com.kingdee.eas.bs.ml.util.EASResourceListenerHelper;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;

public class MDBViewMultiLanEditUI
extends AbstractMDBViewMultiLanEditUI {
    private static final Logger logger = CoreUIObject.getLogger(MDBViewMultiLanEditUI.class);
    private ActionHandler listener = new ActionHandler();
    private String lang;
    private String languageNumber = "";

    public void onLoad() throws Exception {
        TextPaneHelper.setTextPaneMaxLength(this.tpChinese, 500);
        TextPaneHelper.setTextPaneMaxLength(this.tpTransContent, 2000);
        this.tpChinese.setBorder((Border)new LineBorder(Color.gray));
        this.tpTransContent.setBorder((Border)new LineBorder(Color.gray));
        this.prmpLanguage.addDataChangeListener((DataChangeListener)this.listener);
        super.onLoad();
        this.prmpLanguage.setQueryInfo("com.kingdee.eas.bs.ml.app.LanguageQuery");
        this.prmpLanguage.setDisplayFormat("$lanName$");
        this.prmpLanguage.setEditFormat("$number$");
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddNew.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        this.btnRemove.setVisible(false);
        this.menuItemRemove.setVisible(false);
        this.btnSave.setVisible(false);
        this.menuItemSave.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.menuItemCancelCancel.setVisible(false);
        this.btnPrint.setVisible(false);
        this.menuItemPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.menuItemPrintPreview.setVisible(false);
        this.btnCancel.setVisible(false);
        this.menuItemCancel.setVisible(false);
        this.btnPre.setVisible(true);
        this.btnPre.setEnabled(true);
        this.btnNext.setVisible(true);
        this.btnNext.setEnabled(true);
    }

    @Override
    public void storeFields() {
        MdbviewMultiLanCollection multiLanRess = this.editData.getMultiLang();
        MdbviewMultiLanInfo info = null;
        if (multiLanRess != null) {
            boolean exist = false;
            String newMLRes = this.tpTransContent.getText();
            for (int i = 0; i < multiLanRess.size(); ++i) {
                info = multiLanRess.get(i);
                if (info.getLanguage() == null || this.prmpLanguage.getData() == null || !info.getLanguage().equals(((LanguageInfo)this.prmpLanguage.getData()).getNumber())) continue;
                String oldMLRes = info.getMlRes2();
                if (newMLRes == null || !newMLRes.equals(oldMLRes)) {
                    info.setForbidSysUpd(true);
                }
                info.setMlRes2(newMLRes);
                exist = true;
            }
            if (!exist) {
                info = new MdbviewMultiLanInfo();
                info.setParent(this.editData);
                info.setMlRes2(newMLRes);
                info.setLanguage(((LanguageInfo)this.prmpLanguage.getData()).getNumber());
                this.editData.getMultiLang().add(info);
            }
        }
        super.storeFields();
    }

    public SelectorItemCollection getMergedSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("multiLang.*"));
        sic.add(new SelectorItemInfo("multiLang.language.*"));
        return sic;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        IObjectValue ov = dataObject;
        super.setDataObject(ov);
        this.editData = (MdbviewResourceInfo)ov;
    }

    private void languageChanged() {
        MdbviewMultiLanCollection multiLanRess = this.editData.getMultiLang();
        if (multiLanRess != null && multiLanRess.get(0) != null) {
            boolean flag = false;
            for (int i = 0; i < multiLanRess.size(); ++i) {
                MdbviewMultiLanInfo info = multiLanRess.get(i);
                if (info.getLanguage() == null || this.prmpLanguage.getData() == null || !info.getLanguage().equals(((LanguageInfo)this.prmpLanguage.getData()).getNumber())) continue;
                this.tpTransContent.setText(info.getMlRes2());
                this.lang = ((LanguageInfo)this.prmpLanguage.getData()).getNumber();
                flag = true;
            }
            if (!flag) {
                this.tpTransContent.setText(null);
            }
        }
    }

    @Override
    public void loadFields() {
        try {
            super.loadFields();
            if (this.languageNumber == null || this.languageNumber.length() <= 0) {
                this.languageNumber = (String)this.getUIContext().get("languageNumber");
            }
            this.prmpLanguage.setEnabled(true);
            this.prmpLanguage.setEditable(false);
            if (this.getOprtState().equals(OprtState.ADDNEW)) {
                this.tpTransContent.setText(null);
            }
            this.prmpLanguage.removeDataChangeListener((DataChangeListener)this.listener);
            MdbviewMultiLanCollection multiLanRess = this.editData.getMultiLang();
            if (multiLanRess != null && multiLanRess.get(0) != null) {
                boolean flag = false;
                for (int i = 0; i < multiLanRess.size(); ++i) {
                    MdbviewMultiLanInfo mulInfo = multiLanRess.get(i);
                    if (!mulInfo.getLanguage().equals(this.languageNumber)) continue;
                    this.prmpLanguage.setData((Object)this.getLanguageByNumber(mulInfo.getLanguage()));
                    this.lang = mulInfo.getLanguage();
                    flag = true;
                    break;
                }
                flag = false;
                if (false) {
                    this.prmpLanguage.setData((Object)this.getLanguageByNumber(multiLanRess.get(0).getLanguage()));
                    this.lang = multiLanRess.get(0).getLanguage();
                }
            } else if (multiLanRess != null && multiLanRess.get(0) == null) {
                try {
                    this.prmpLanguage.setData((Object)this.getLanguageByNumber(this.languageNumber));
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
            this.languageChanged();
            this.prmpLanguage.addDataChangeListener((DataChangeListener)this.listener);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public LanguageInfo getLanguageByNumber(String number) throws Exception {
        ILanguage iLanguage = LanguageFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        viewInfo.setFilter(filter);
        LanguageCollection languages = iLanguage.getLanguageCollection(viewInfo);
        LanguageInfo info = null;
        if (languages != null && languages.size() > 0) {
            info = new LanguageInfo();
            info.setId(languages.get(0).getId());
            info.setNumber(number);
            info.setLanName(languages.get(0).getLanName());
        }
        return info;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.prmpLanguage.setEnabled(true);
        this.prmpLanguage.setEditable(false);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.languageNumber = ((LanguageInfo)this.prmpLanguage.getData()).getNumber();
        this.editData.setLanguage(this.languageNumber);
        if (this.cbResourceDomain.isSelected()) {
            this.editData.setResourceDomainSign("true");
        } else {
            this.editData.setResourceDomainSign("false");
        }
        super.actionSubmit_actionPerformed(e);
        String ais = SysContext.getSysContext().getDCNumber();
        String fileName = this.editData.getFileName();
        String pkg = this.editData.getPackageName();
        Object obj = this.getUIContext().get("metaDataType");
        if (obj == null) {
            return;
        }
        MLClientUtils.clearClientResCache(ais, fileName, pkg, obj.toString(), "zh_CN");
        MLClientUtils.clearClientResCache(ais, fileName, pkg, obj.toString(), this.lang);
        ArrayList<String> keyList = new ArrayList<String>();
        keyList.add(EASResourceListenerHelper.generateCacheKey(ais, fileName, pkg, obj.toString(), this.lang));
        MLFacadeFactory.getRemoteInstance().updateServerCacheByKeyList(keyList);
    }

    protected IObjectValue createNewData() {
        return new MdbviewResourceInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MdbviewResourceFactory.getRemoteInstance();
    }

    class ActionHandler
    implements DataChangeListener {
        ActionHandler() {
        }

        public void dataChanged(DataChangeEvent eventObj) {
            if (eventObj.getSource() == MDBViewMultiLanEditUI.this.prmpLanguage) {
                MDBViewMultiLanEditUI.this.languageChanged();
            }
        }
    }
}

