/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.bs.ml.LanguageCollection;
import com.kingdee.eas.bs.ml.LanguageFactory;
import com.kingdee.eas.bs.ml.LanguageInfo;
import com.kingdee.eas.bs.ml.client.LanguageObject;
import com.kingdee.eas.bs.ml.client.ResourceClientCache;
import com.kingdee.eas.bs.ml.util.EASResourceListenerHelper;
import com.kingdee.eas.util.client.EASResource;
import java.io.File;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;

public class MLClientUtils {
    public static void clearClientResCache(String ais, String fileName, String pkg, String metaType, String lang) {
        ResourceClientCache resCache = ResourceClientCache.getInstance();
        String ck = EASResourceListenerHelper.generateCacheKey(ais, fileName, pkg, metaType, lang);
        resCache.clearCache(ck);
        File resDic = EASResourceListenerHelper.getCacheDictionary(ais, lang);
        if (!resDic.exists()) {
            return;
        }
        File resFile = EASResourceListenerHelper.getCacheFile(resDic.getPath(), pkg, fileName, metaType, lang);
        if (resFile.exists()) {
            try {
                resFile.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static DefaultComboBoxModel getLanguageComboModel(boolean isIncludeSC) throws BOSException {
        LanguageCollection coll = LanguageFactory.getRemoteInstance().getLanguageCollection(null);
        Vector<LanguageObject> v = new Vector<LanguageObject>();
        if (isIncludeSC) {
            v.add(new LanguageObject("zh_CN", EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"5_MLClientUtils")));
        }
        for (int i = 0; i < coll.size(); ++i) {
            LanguageInfo li = coll.get(i);
            v.add(new LanguageObject(li.getNumber(), li.getLanName()));
        }
        return new DefaultComboBoxModel(v);
    }

    public static DefaultComboBoxModel getLanguageComboModelForEnTW() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"en_US"));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"zh_TW"));
        filter.setMaskString("#0 or #1 ");
        view.setFilter(filter);
        LanguageCollection coll = LanguageFactory.getRemoteInstance().getLanguageCollection(view);
        Vector<LanguageObject> v = new Vector<LanguageObject>();
        for (int i = 0; i < coll.size(); ++i) {
            LanguageInfo li = coll.get(i);
            v.add(new LanguageObject(li.getNumber(), li.getLanName()));
        }
        return new DefaultComboBoxModel(v);
    }
}

