/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client;

import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.bs.ml.EASResourceDomainCollection;
import com.kingdee.eas.bs.ml.EASResourceDomainInfo;
import com.kingdee.eas.bs.ml.client.AbstractNewSelectBizUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class NewSelectBizUI
extends AbstractNewSelectBizUI {
    private static final Logger logger = CoreUIObject.getLogger(NewSelectBizUI.class);
    private static final String RESOURCE = "com.kingdee.eas.bs.ml.EASResourceResource";
    private DefaultKingdeeTreeNode rootNode = null;
    private EASResourceDomainCollection resourceDomainColl = new EASResourceDomainCollection();
    private boolean isConfirm = false;

    public NewSelectBizUI() throws Exception {
        this.btnCancel.setEnabled(true);
        this.btnConfirm.setEnabled(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public boolean isConfirm() {
        return this.isConfirm;
    }

    public EASResourceDomainCollection getResourceDomainCollection() {
        return this.resourceDomainColl;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.rootNode = (DefaultKingdeeTreeNode)this.getUIContext().get("rootNode");
        if (this.rootNode != null) {
            this.bizDataTree.setModel((TreeModel)new DefaultTreeModel((TreeNode)this.rootNode));
            this.bizDataTree.setShowCheckBox(true);
            this.bizDataTree.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

                public void nodeStateChange(TreeNodeStateChangeEvent event) {
                    NewSelectBizUI.this.doTreeNodeStateChange(event);
                    NewSelectBizUI.this.doTreeNodeStateChangeParent(event);
                }
            });
        } else {
            this.bizDataTree.setModel(null);
        }
    }

    private void doTreeNodeStateChange(TreeNodeStateChangeEvent event) {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)event.getNode();
        boolean selected = node.isChecked();
        this.selectAllChildrenOfTheSelectedNode(node, selected);
        this.bizDataTree.repaint();
    }

    private void selectAllChildrenOfTheSelectedNode(DefaultKingdeeTreeNode node, boolean selected) {
        DefaultKingdeeTreeNode subNode = null;
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            subNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            if (this.canTheNodeBeSelected(subNode)) {
                subNode.setChecked(selected);
            }
            this.selectAllChildrenOfTheSelectedNode(subNode, selected);
        }
    }

    private void doTreeNodeStateChangeParent(TreeNodeStateChangeEvent event) {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)event.getNode();
        boolean isSelected = node.isChecked();
        DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)node.getParent();
        this.selectAllParentOfTheSelectNode(parentNode, isSelected);
    }

    private void selectAllParentOfTheSelectNode(DefaultKingdeeTreeNode parentNode, boolean isSelected) {
        if (parentNode != null) {
            if (parentNode.isChecked() == isSelected) {
                return;
            }
            boolean isChangeCheck = false;
            for (int i = 0; i < parentNode.getChildCount(); ++i) {
                DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
                isChangeCheck = isSelected;
                if (childNode.isChecked() == isSelected) continue;
                isChangeCheck = false;
                break;
            }
            parentNode.setChecked(isChangeCheck);
            DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)parentNode.getParent();
            if (parentNode.getParent() != null) {
                this.selectAllParentOfTheSelectNode(treeNode, isSelected);
            }
        }
    }

    private boolean canTheNodeBeSelected(DefaultKingdeeTreeNode node) {
        return node.isCheckBoxVisible() && node.isCheckBoxEnabled();
    }

    private void selectOneEntity() {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.bizDataTree.getModel();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        if (root.isChecked()) {
            this.resourceDomainColl.add((EASResourceDomainInfo)root.getUserObject());
        } else {
            this.getSelectNodeTree(root);
        }
        if (this.resourceDomainColl == null || this.resourceDomainColl.size() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"SELECT_MODEL"));
            return;
        }
        this.isConfirm = true;
        this.getUIWindow().hide();
    }

    private void getSelectNodeTree(DefaultKingdeeTreeNode root) {
        if (root == null) {
            return;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node.isChecked()) {
                this.resourceDomainColl.add((EASResourceDomainInfo)node.getUserObject());
            }
            if (node.isLeaf()) continue;
            this.getSelectNodeTree(node);
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.selectOneEntity();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isConfirm = false;
        this.getUIWindow().hide();
    }
}

