/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client;

import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.bs.ml.util.SoftMap;
import java.util.Map;

public final class ResourceClientCache {
    private static final Map cache = Collections.synchronizedMap((Map)new SoftMap(400, 0.75f));
    private static ResourceClientCache instance;

    private ResourceClientCache() {
    }

    public static synchronized ResourceClientCache getInstance() {
        if (instance == null) {
            instance = new ResourceClientCache();
        }
        return instance;
    }

    public void clearCache() {
        cache.clear();
    }

    public void clearCache(String key) {
        cache.remove(key);
    }

    public Object get(String key) {
        if (key == null || key.trim().length() <= 0) {
            return null;
        }
        return cache.get(key);
    }

    public void put(String key, Object value) {
        cache.put(key, value);
    }

    public boolean contains(String key) {
        return cache.containsKey(key);
    }

    public void remove(String key) {
        cache.remove(key);
    }

    public int size() {
        return cache.size();
    }
}

