/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.bs.ml.EASMultiLanResCollection;
import com.kingdee.eas.bs.ml.EASMultiLanResFactory;
import com.kingdee.eas.bs.ml.EASMultiLanResInfo;
import com.kingdee.eas.bs.ml.EASResourceInfo;
import com.kingdee.eas.bs.ml.MenuTypeEnum;
import com.kingdee.eas.bs.ml.TranslateStatusEnum;
import com.kingdee.eas.bs.ml.client.AbstractResourceEditUI;
import com.kingdee.eas.bs.ml.client.LanguageObject;
import com.kingdee.eas.bs.ml.client.MLClientUtils;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import org.apache.log4j.Logger;

public class ResourceEditUI
extends AbstractResourceEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ResourceEditUI.class);
    private TranslateStatusEnum tsEnum = TranslateStatusEnum.save;
    private String parentId;
    private String md5 = null;
    private MenuTypeEnum menuType = MenuTypeEnum.NOT_MENU;

    public void onLoad() throws Exception {
        this.comboLang.setModel((ComboBoxModel)MLClientUtils.getLanguageComboModel(false));
        super.onLoad();
        this.txtState.setEnabled(false);
        this.txtTranslator.setEnabled(false);
        this.pkTransTime.setEnabled(false);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            this.tpChinese.setEditable(false);
        }
        this.btnAddNew.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        this.comboLang.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceEditUI.this.ComboLang_changed(e);
            }
        });
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemSubmit2.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnSubmit2.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
    }

    private void ComboLang_changed(ActionEvent e) {
        LanguageObject lo = (LanguageObject)this.comboLang.getSelectedItem();
        if (lo == null) {
            return;
        }
        String lan = lo.getNumber();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("parent.id", (Object)this.parentId));
        fi.getFilterItems().add(new FilterItemInfo("language", (Object)lan));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.res"));
        evi.setSelector(sic);
        evi.setFilter(fi);
        try {
            EASMultiLanResCollection coll = EASMultiLanResFactory.getRemoteInstance().getEASMultiLanResCollection(evi);
            if (coll == null || coll.size() <= 0) {
                super.actionAddNew_actionPerformed(e);
            } else {
                this.editData = coll.get(0);
                this.setDataObject((IObjectValue)this.editData);
                this.loadFields();
            }
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tpTransContent.requestFocusInWindow();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.editData.setLanguage(this.getLanguage());
            this.editData.setCN(MLUtils.myTrim(this.tpChinese.getText()));
        }
        this.editData.setIsTranslated(this.tsEnum);
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            String lang = this.editData.getLanguage();
            if (this.editData.getParent() != null) {
                this.parentId = this.editData.getParent().getId().toString();
                this.md5 = this.editData.getParent().getMd5Code();
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("parent.id", (Object)this.parentId));
                evi.setFilter(fi);
                try {
                    EASMultiLanResCollection coll = EASMultiLanResFactory.getRemoteInstance().getEASMultiLanResCollection(evi);
                    if (coll != null && coll.size() > 0) {
                        EASMultiLanResInfo resInfo = coll.get(0);
                        this.menuType = resInfo.getIsMenuType();
                    }
                }
                catch (BOSException e) {
                    logger.info((Object)e.getMessage());
                    super.handleException((Exception)((Object)e));
                }
                catch (Exception e) {
                    logger.info((Object)e.getMessage());
                    super.handleException(e);
                }
            }
            this.comboLang.getItemCount();
            for (int i = 0; i < this.comboLang.getItemCount(); ++i) {
                LanguageObject lo = (LanguageObject)this.comboLang.getItemAt(i);
                if (lo == null || !lang.equals(lo.getNumber())) continue;
                this.comboLang.setSelectedIndex(i);
                break;
            }
            this.tpChinese.setText(this.editData.getParent().getRes());
            if (this.editData.getTranslator() != null) {
                this.txtTranslator.setText(this.editData.getTranslator().getName());
            }
            if (this.editData.getIsTranslated() != null) {
                this.txtState.setText(this.editData.getIsTranslated().getAlias());
            }
        }
        if (this.editData.getIsMenuType() == MenuTypeEnum.NOT_MENU) {
            this.remove((Component)this.lbMenuTransContent);
            this.remove((Component)this.spMenuTransContent);
            this.setBounds(10, 10, 600, 400);
            this.lblRemarks.setBounds(18, 291, 100, 19);
            this.spRemarks.setBounds(17, 310, 565, 50);
            this.contTranslator.setBounds(19, 366, 180, 19);
            this.contTransTime.setBounds(210, 366, 180, 19);
            this.contStatus.setBounds(402, 366, 180, 19);
        }
    }

    protected void lockUIAndAction() {
        super.lockUIAndAction();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.tpChinese.setEditable(true);
        } else {
            this.tpChinese.setEditable(false);
        }
        this.txtState.setEnabled(false);
        this.txtTranslator.setEnabled(false);
        this.pkTransTime.setEnabled(false);
    }

    protected void unLockUIAndAction() {
        super.unLockUIAndAction();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.tpChinese.setEditable(true);
        } else {
            this.tpChinese.setEditable(false);
        }
        this.txtState.setEnabled(false);
        this.txtTranslator.setEnabled(false);
        this.pkTransTime.setEnabled(false);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            this.tpChinese.setEditable(false);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    private String getLanguage() {
        LanguageObject lo = (LanguageObject)this.comboLang.getSelectedItem();
        if (lo == null) {
            return null;
        }
        return lo.getNumber();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.tpChinese.isEnabled() && this.tpChinese.getText() == null || this.tpChinese.getText().trim().length() <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"7_ResourceEditUI"));
            this.tpChinese.requestFocusInWindow();
            SysUtil.abort();
        }
        if (this.comboLang.getSelectedItem() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"8_ResourceEditUI"));
            this.comboLang.requestFocusInWindow();
            SysUtil.abort();
        }
    }

    @Override
    public void actionSubmit2_actionPerformed(ActionEvent e) throws Exception {
        String txt = this.tpTransContent.getText();
        if (txt == null || txt.trim().length() <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"9_ResourceEditUI"));
            return;
        }
        this.tsEnum = TranslateStatusEnum.submit;
        this.actionSave_actionPerformed(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("language"));
        sic.add(new SelectorItemInfo("isTranslated"));
        sic.add(new SelectorItemInfo("parent.res"));
        sic.add(new SelectorItemInfo("translator.name"));
        sic.add(new SelectorItemInfo("isMenuType"));
        sic.add(new SelectorItemInfo("parent.md5Code"));
        return sic;
    }

    protected IObjectValue createNewData() {
        EASMultiLanResInfo mlInfo = new EASMultiLanResInfo();
        EASResourceInfo resInfo = new EASResourceInfo();
        resInfo.setId(BOSUuid.read((String)this.parentId));
        mlInfo.setParent(resInfo);
        if (this.md5 != null && this.md5.length() > 0) {
            mlInfo.setCnMd5Code(this.md5);
        }
        mlInfo.setIsMenuType(this.menuType);
        return mlInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EASMultiLanResFactory.getRemoteInstance();
    }
}

