/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.eas.bs.ml.client.EntityMultiLanListUI;
import com.kingdee.eas.bs.ml.client.PresetDataMultiLanListUI;
import com.kingdee.eas.bs.ml.client.ResourceExcelHelper;
import com.kingdee.eas.bs.ml.client.ResourceListUI;
import com.kingdee.eas.bs.ml.util.IProgTask;
import com.kingdee.eas.bs.ml.util.ProgDialog;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.SwingUtilities;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;

public class ResourceExportUtil {
    public static void exportResource(Component aparentUI, KDTable tblMain) throws Exception {
        KDFileChooser fc = new KDFileChooser();
        fc.setSelectedFile(new File("BizResource.xls"));
        int result = fc.showSaveDialog(aparentUI);
        if (result != 0) {
            return;
        }
        File f = fc.getSelectedFile();
        MyProgTask task = new MyProgTask(aparentUI, tblMain, f);
        task.show();
        if (task.isSucess) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"37_ResourceExportUtil"));
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"21_ResourceListUI"));
        }
    }

    private static void exportResourceData(Component parentUI, KDTable tblMain, File f) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(f);
        }
        catch (FileNotFoundException ex) {
            MsgBox.showError((Component)parentUI, (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"10_ResourceExportUtil"));
            SysUtil.abort();
        }
        int rowCount = tblMain.getRowCount();
        int pageNum = rowCount / 30000;
        if (pageNum * 30000 < rowCount) {
            ++pageNum;
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCellStyle nameCellStyle = ResourceExcelHelper.createNameCellStyle(wb);
        HSSFCellStyle codeCellStyle = ResourceExcelHelper.createCodeCellStyle(wb);
        for (int k = 0; k < pageNum; ++k) {
            HSSFSheet sheet = wb.createSheet();
            HSSFRow headRow = sheet.createRow(0);
            HSSFRow headRow2 = sheet.createRow(1);
            ResourceExcelHelper.createHeadCell(headRow, codeCellStyle, 0, "zh_CN");
            ResourceExcelHelper.createHeadCell(headRow2, nameCellStyle, 0, EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"5_MLClientUtils"));
            ResourceExcelHelper.createHeadCell(headRow, codeCellStyle, 1, "content");
            ResourceExcelHelper.createHeadCell(headRow2, nameCellStyle, 1, EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"11_ResourceExportUtil"));
            ResourceExcelHelper.createHeadCell(headRow, codeCellStyle, 2, "packageName");
            ResourceExcelHelper.createHeadCell(headRow2, nameCellStyle, 2, EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"packageName"));
            ResourceExcelHelper.createHeadCell(headRow, codeCellStyle, 3, "fileName");
            ResourceExcelHelper.createHeadCell(headRow2, nameCellStyle, 3, EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"fileName"));
            ResourceExcelHelper.createHeadCell(headRow, codeCellStyle, 4, "key");
            ResourceExcelHelper.createHeadCell(headRow2, nameCellStyle, 4, EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"key"));
            int currPageMaxRow = (k + 1) * 30000;
            int rowIdx = 2;
            for (int i = k * 30000; i < rowCount && i < currPageMaxRow; ++i) {
                HSSFRow row = sheet.createRow(rowIdx);
                String zh = (String)tblMain.getRow(i).getCell("res").getValue();
                HSSFCell cell = row.createCell(0);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(zh);
                String ts = (String)tblMain.getRow(i).getCell("multiLang.mlRes").getValue();
                cell = row.createCell(1);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(ts);
                String packageName = (String)tblMain.getRow(i).getCell("packageName").getValue();
                cell = row.createCell(2);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(packageName);
                String fileName = (String)tblMain.getRow(i).getCell("fileName").getValue();
                cell = row.createCell(3);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(fileName);
                String key = (String)tblMain.getRow(i).getCell("key").getValue();
                cell = row.createCell(4);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(key);
                ++rowIdx;
            }
            sheet.setDefaultColumnWidth(65);
        }
        wb.write((OutputStream)out);
        out.flush();
        out.close();
    }

    private static void exportPresetData(Component parentUI, KDTable tblMain, File f) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(f);
        }
        catch (FileNotFoundException ex) {
            MsgBox.showError((Component)parentUI, (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"10_ResourceExportUtil"));
            SysUtil.abort();
        }
        int rowCount = tblMain.getRowCount();
        int pageNum = rowCount / 30000;
        if (pageNum * 30000 < rowCount) {
            ++pageNum;
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCellStyle nameCellStyle = ResourceExcelHelper.createNameCellStyle(wb);
        HSSFCellStyle codeCellStyle = ResourceExcelHelper.createCodeCellStyle(wb);
        for (int k = 0; k < pageNum; ++k) {
            HSSFSheet sheet = wb.createSheet();
            HSSFRow headRow = sheet.createRow(0);
            HSSFRow headRow2 = sheet.createRow(1);
            ResourceExcelHelper.createHeadCell(headRow, codeCellStyle, 0, "zh_CN");
            ResourceExcelHelper.createHeadCell(headRow2, nameCellStyle, 0, EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"5_MLClientUtils"));
            ResourceExcelHelper.createHeadCell(headRow, codeCellStyle, 1, "simplifiedForm");
            ResourceExcelHelper.createHeadCell(headRow2, nameCellStyle, 1, "\u7e41\u4f53");
            ResourceExcelHelper.createHeadCell(headRow, codeCellStyle, 2, "english");
            ResourceExcelHelper.createHeadCell(headRow2, nameCellStyle, 2, "\u82f1\u6587");
            ResourceExcelHelper.createHeadCell(headRow, codeCellStyle, 3, "id");
            ResourceExcelHelper.createHeadCell(headRow2, nameCellStyle, 3, "ID");
            int currPageMaxRow = (k + 1) * 30000;
            int rowIdx = 2;
            for (int i = k * 30000; i < rowCount && i < currPageMaxRow; ++i) {
                HSSFRow row = sheet.createRow(rowIdx);
                String zh = (String)tblMain.getRow(i).getCell("text_zh_CN").getValue();
                HSSFCell cell = row.createCell(0);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(zh);
                String ts = (String)tblMain.getRow(i).getCell("text_zh_TW").getValue();
                cell = row.createCell(1);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(ts);
                String packageName = (String)tblMain.getRow(i).getCell("text_en_US").getValue();
                cell = row.createCell(2);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(packageName);
                String id = (String)tblMain.getRow(i).getCell("id").getValue();
                cell = row.createCell(3);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(id);
                ++rowIdx;
            }
            sheet.setDefaultColumnWidth(65);
        }
        wb.write((OutputStream)out);
        out.flush();
        out.close();
    }

    private static void exportTranslationData(Component parentUI, KDTable tblMain, File f) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(f);
        }
        catch (FileNotFoundException ex) {
            MsgBox.showError((Component)parentUI, (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"10_ResourceExportUtil"));
            SysUtil.abort();
        }
        int rowCount = tblMain.getRowCount();
        int pageNum = rowCount / 30000;
        if (pageNum * 30000 < rowCount) {
            ++pageNum;
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCellStyle nameCellStyle = ResourceExcelHelper.createNameCellStyle(wb);
        HSSFCellStyle codeCellStyle = ResourceExcelHelper.createCodeCellStyle(wb);
        for (int k = 0; k < pageNum; ++k) {
            HSSFSheet sheet = wb.createSheet();
            HSSFRow headRow = sheet.createRow(0);
            HSSFRow headRow2 = sheet.createRow(1);
            ResourceExcelHelper.createHeadCell(headRow, codeCellStyle, 0, "zh_CN");
            ResourceExcelHelper.createHeadCell(headRow2, nameCellStyle, 0, EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"5_MLClientUtils"));
            ResourceExcelHelper.createHeadCell(headRow, codeCellStyle, 1, "content");
            ResourceExcelHelper.createHeadCell(headRow2, nameCellStyle, 1, EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"11_ResourceExportUtil"));
            ResourceExcelHelper.createHeadCell(headRow, codeCellStyle, 2, "description");
            ResourceExcelHelper.createHeadCell(headRow2, nameCellStyle, 2, EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"description_ResourceExportUtil"));
            int currPageMaxRow = (k + 1) * 30000;
            int rowIdx = 2;
            for (int i = k * 30000; i < rowCount && i < currPageMaxRow; ++i) {
                HSSFRow row = sheet.createRow(rowIdx);
                String zh = (String)tblMain.getRow(i).getCell("parent.res").getValue();
                String ts = (String)tblMain.getRow(i).getCell("content").getValue();
                String desc = (String)tblMain.getRow(i).getCell("remarks").getValue();
                HSSFCell cell = row.createCell(0);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(zh);
                cell = row.createCell(1);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(ts);
                cell = row.createCell(2);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(desc);
                ++rowIdx;
            }
            sheet.setDefaultColumnWidth(65);
        }
        wb.write((OutputStream)out);
        out.flush();
        out.close();
    }

    private static class MyProgTask
    implements IProgTask {
        private File file;
        private Component parentUI;
        private KDTable tbl;
        private boolean isSucess = true;
        private String errStr;

        private MyProgTask() {
        }

        public MyProgTask(Component parentUI, KDTable tbl, File file) {
            this.parentUI = parentUI;
            this.tbl = tbl;
            this.file = file;
        }

        @Override
        public Object exec() throws Exception {
            try {
                if (this.parentUI instanceof ResourceListUI) {
                    ResourceExportUtil.exportTranslationData(this.parentUI, this.tbl, this.file);
                } else if (this.parentUI instanceof EntityMultiLanListUI) {
                    ResourceExportUtil.exportResourceData(this.parentUI, this.tbl, this.file);
                } else if (this.parentUI instanceof PresetDataMultiLanListUI) {
                    ResourceExportUtil.exportPresetData(this.parentUI, this.tbl, this.file);
                }
            }
            catch (Exception e) {
                this.isSucess = false;
                this.errStr = e.getMessage();
            }
            return "";
        }

        @Override
        public void afterExec(Object result) throws Exception {
        }

        public void show() {
            Window win = SwingUtilities.getWindowAncestor(this.parentUI);
            ProgDialog dialog = null;
            if (win instanceof Frame) {
                dialog = new ProgDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new ProgDialog((Dialog)win);
            }
            dialog.setLongTimeTask(this);
            dialog.show();
        }

        public boolean isSucess() {
            return this.isSucess;
        }

        public String getErrStr() {
            return this.errStr;
        }
    }
}

